import { Host, h, } from "@stencil/core";
import { DEVICE_SIZES, getCurrentDeviceSize, getThemeForegroundColor, getNavItemParentDetails, } from "../../utils/helpers";
import chevronIcon from "../../assets/chevron-icon.svg";
export class NavigationGroup {
    constructor() {
        this.allGroupedNavigationItems = [];
        this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS = 100;
        this.IC_NAVIGATION_ITEM = "ic-navigation-item";
        this.mouseGate = false;
        this.nodeName = "IC-NAVIGATION-GROUP";
        this.GROUPED_LINKS_WRAPPER_CLASS = ".grouped-links-wrapper";
        this.sideNavExpandHandler = (event) => {
            this.isSideNavExpanded = event.detail.sideNavExpanded;
            const linkWrapper = this.el.shadowRoot.querySelector(this.GROUPED_LINKS_WRAPPER_CLASS);
            if (!linkWrapper)
                return;
            if (this.isSideNavExpanded) {
                if (this.expanded && this.expandedNavItemsHeight) {
                    this.setGroupedLinksElementHeight(linkWrapper, this.expandedNavItemsHeight);
                }
                else if (this.expanded) {
                    setTimeout(() => {
                        this.expandedNavItemsHeight = this.getNavigationChildItemsHeight();
                        this.setGroupedLinksElementHeight(linkWrapper, this.expandedNavItemsHeight);
                    }, this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS);
                }
            }
            else {
                if (this.expanded && this.collapsedNavItemsHeight) {
                    this.setGroupedLinksElementHeight(linkWrapper, this.collapsedNavItemsHeight);
                }
                else if (this.expanded) {
                    setTimeout(() => {
                        this.collapsedNavItemsHeight = this.getNavigationChildItemsHeight();
                        this.setGroupedLinksElementHeight(linkWrapper, this.collapsedNavItemsHeight);
                    }, this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS);
                }
            }
        };
        this.topNavResizedHandler = ({ detail, }) => {
            var _a;
            const { size } = detail;
            if (size !== this.deviceSize) {
                this.deviceSize = size;
                this.inTopNavSideMenu =
                    size <=
                        (((_a = this.parentEl) === null || _a === void 0 ? void 0 : _a.customMobileBreakpoint) || DEVICE_SIZES.L);
            }
        };
        this.setGroupedNavItemTabIndex = (tabIndexValue) => {
            this.el
                .querySelectorAll(this.IC_NAVIGATION_ITEM)
                .forEach((navigationItem) => {
                const navItem = navigationItem.shadowRoot.querySelector("a") ||
                    navigationItem.querySelector("a");
                if (navItem) {
                    navItem.setAttribute("tabindex", tabIndexValue);
                }
            });
        };
        this.toggleGroupedLinkWrapperHeight = (wrapper, expanded) => {
            if (!wrapper)
                return;
            if (expanded) {
                if (this.isSideNavExpanded) {
                    this.setGroupedLinksElementHeight(wrapper, this.expandedNavItemsHeight);
                }
                else {
                    this.setGroupedLinksElementHeight(wrapper, this.collapsedNavItemsHeight);
                }
                this.setGroupedNavItemTabIndex("0");
            }
            else {
                wrapper.style.setProperty("--navigation-child-items-height", "0");
                this.setGroupedNavItemTabIndex("-1");
            }
        };
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
            const linkWrapper = this.el.shadowRoot.querySelector(this.GROUPED_LINKS_WRAPPER_CLASS);
            this.toggleGroupedLinkWrapperHeight(linkWrapper, this.expanded);
        };
        this.handleClick = (ev) => {
            if (this.navigationType === "top" && ev.detail) {
                this.toggleDropdown();
            }
            else {
                this.toggleExpanded();
            }
        };
        this.handleBlur = (ev) => {
            const target = ev.relatedTarget;
            if (!this.el.contains(target)) {
                this.hideDropdown();
            }
        };
        this.handleTopNavKeydown = (ev) => {
            if (ev.key === " " || ev.key === "Enter") {
                this.toggleDropdown();
            }
            else if (!this.inTopNavSideMenu && ev.key === "Escape") {
                this.hideDropdown();
            }
        };
        this.handleKeydown = (ev) => {
            if (ev.key === "Enter" || ev.key === " " || ev.key === "Escape") {
                switch (this.navigationType) {
                    case "top":
                        this.handleTopNavKeydown(ev);
                        break;
                    case "side":
                        this.toggleExpanded();
                        ev.preventDefault();
                        break;
                    default:
                        this.toggleExpanded();
                        break;
                }
            }
        };
        this.handleMouseLeave = (ev) => {
            const relTarget = ev.relatedTarget;
            this.mouseGate = false;
            if (!this.el.contains(relTarget) &&
                relTarget !== this.dropdown &&
                document.activeElement !== this.el &&
                !this.el.contains(document.activeElement) &&
                (relTarget === null || relTarget === void 0 ? void 0 : relTarget.nodeName) === this.nodeName &&
                this.dropdownOpen === true) {
                this.mouseGate = true;
                this.hideDropdown();
            }
            else if (!this.el.contains(relTarget) &&
                relTarget !== this.dropdown &&
                !this.el.contains(document.activeElement)) {
                this.mouseGate = false;
                setTimeout(() => {
                    this.dropdownOpen ? this.hideDropdown() : null;
                }, 500);
            }
        };
        this.handleMouseEnter = (ev) => {
            const relTarget = ev.relatedTarget;
            document.addEventListener("keydown", this.handleKeydown);
            if ((relTarget === null || relTarget === void 0 ? void 0 : relTarget.nodeName) === this.nodeName && this.mouseGate === true) {
                this.showDropdown();
            }
            else if (this.dropdownOpen === false &&
                relTarget !== null &&
                this.mouseGate === false) {
                this.mouseGate = true;
                setTimeout(() => {
                    this.mouseGate && this.showDropdown();
                }, 500);
            }
        };
        this.renderDropdownGroupedLinks = () => (h("div", { class: {
                ["navigation-group-dropdown"]: !this.inTopNavSideMenu,
                ["navigation-group-dropdown-side-menu"]: this.inTopNavSideMenu,
                ["selected"]: this.dropdownOpen && !this.inTopNavSideMenu,
            }, onMouseLeave: !this.inTopNavSideMenu ? this.handleMouseLeave : null, ref: (el) => (this.dropdown = el) }, h("nav", { class: {
                ["navigation-group-dropdown-items"]: !this.inTopNavSideMenu,
            } }, h("ul", null, h("slot", null)))));
        this.renderGroupedLinks = () => (h("ul", { class: "grouped-links-wrapper" }, h("slot", null)));
        /**
         * Gets the total height of navigation links to improve
         * smoothness of expand/collapse animations
         */
        this.getNavigationChildItemsHeight = () => {
            let navigationChildItemsHeight = 0;
            this.allGroupedNavigationItems.forEach((navItem) => {
                navigationChildItemsHeight += navItem.offsetHeight;
            });
            return `${navigationChildItemsHeight}px`;
        };
        this.setInitialGroupedLinksWrapperHeight = () => {
            const linkWrapper = this.el.shadowRoot.querySelector(this.GROUPED_LINKS_WRAPPER_CLASS);
            if (!linkWrapper)
                return;
            if (!this.isSideNavExpanded &&
                !this.collapsedNavItemsHeight &&
                this.expanded) {
                this.collapsedNavItemsHeight = this.getNavigationChildItemsHeight();
                this.setGroupedLinksElementHeight(linkWrapper, this.collapsedNavItemsHeight);
            }
            if (this.isSideNavExpanded && this.expanded) {
                this.expandedNavItemsHeight = this.getNavigationChildItemsHeight();
                this.setGroupedLinksElementHeight(linkWrapper, this.expandedNavItemsHeight);
            }
        };
        this.renderNavigationItems = () => {
            if (this.dropdownOpen || (this.inTopNavSideMenu && !this.expandable)) {
                return this.renderDropdownGroupedLinks();
            }
            if (this.navigationType !== "top") {
                return this.renderGroupedLinks();
            }
            return null;
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.dropdownOpen = false;
        this.expanded = true;
        this.focusStyle = getThemeForegroundColor();
        this.inTopNavSideMenu = false;
        this.navigationType = undefined;
        this.parentEl = undefined;
        this.expandable = false;
        this.label = undefined;
    }
    disconnectedCallback() {
        if (this.navigationType === "side") {
            this.parentEl.removeEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.removeEventListener("topNavResized", this.topNavResizedHandler);
        }
    }
    componentWillLoad() {
        this.deviceSize = getCurrentDeviceSize();
        const { navType, parent } = getNavItemParentDetails(this.el);
        this.navigationType = navType;
        this.parentEl = parent;
        if (this.navigationType === "side") {
            this.parentEl.addEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.addEventListener("topNavResized", this.topNavResizedHandler);
            if (this.deviceSize <=
                this.parentEl.customMobileBreakpoint)
                this.inTopNavSideMenu = true;
        }
    }
    componentDidLoad() {
        this.allGroupedNavigationItems = Array.from(this.el.querySelectorAll(this.IC_NAVIGATION_ITEM));
        /**
         * debounce is required as the incorrect height was retrieved instantly after
         * componentDidLoad is invoked.
         */
        setTimeout(() => this.setInitialGroupedLinksWrapperHeight(), this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS);
    }
    childBlurHandler() {
        this.hideDropdown();
    }
    navItemClickHandler() {
        this.hideDropdown();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.focusStyle = theme.mode;
    }
    /**
     * Sets focus on the nav item.
     */
    async setFocus() {
        if (this.groupEl) {
            this.groupEl.focus();
        }
    }
    toggleDropdown() {
        this.dropdownOpen = !this.dropdownOpen;
    }
    showDropdown() {
        if (!this.dropdownOpen) {
            this.toggleDropdown();
        }
    }
    hideDropdown() {
        document.removeEventListener("keydown", this.handleKeydown);
        if (this.dropdownOpen) {
            this.toggleDropdown();
        }
    }
    setGroupedLinksElementHeight(groupedNavItemWrapper, height) {
        groupedNavItemWrapper.style.setProperty("--navigation-child-items-height", height);
    }
    render() {
        const { label, dropdownOpen, inTopNavSideMenu, expandable } = this;
        return (h(Host, { class: {
                ["in-side-menu"]: inTopNavSideMenu,
                expanded: this.expanded,
                collapsed: !this.expanded,
                ["navigation-group-side-nav"]: this.navigationType === "side",
            }, role: "listitem" }, h("button", { onMouseEnter: !inTopNavSideMenu &&
                this.navigationType === "top" &&
                this.handleMouseEnter, onMouseLeave: this.navigationType === "top" && this.handleMouseLeave, tabindex: inTopNavSideMenu && !expandable ? "-1" : "0", onBlur: this.handleBlur, onClick: expandable ? this.handleClick : null, onKeyDown: this.handleKeydown, class: {
                ["navigation-group"]: true,
                [this.focusStyle]: !inTopNavSideMenu,
                ["navigation-group-side-menu"]: inTopNavSideMenu && !expandable,
                ["navigation-group-side-menu-collapsed"]: inTopNavSideMenu && expandable && !dropdownOpen,
                ["navigation-group-side-menu-expanded"]: inTopNavSideMenu && expandable && dropdownOpen,
                ["selected"]: dropdownOpen && !inTopNavSideMenu,
            }, ref: (el) => (this.groupEl = el), "aria-expanded": `${dropdownOpen || this.expanded}`, "aria-haspopup": `${!inTopNavSideMenu && this.navigationType === "top"}` }, h("ic-typography", { variant: this.navigationType === "side" ? "caption" : "label" }, label), this.navigationType === "side" && expandable && (h("div", { class: {
                "chevron-toggle-icon-wrapper": true,
                "chevron-toggle-icon-closed": this.expanded,
            }, innerHTML: chevronIcon }))), this.renderNavigationItems()));
    }
    static get is() { return "ic-navigation-group"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-navigation-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-navigation-group.css"]
        };
    }
    static get properties() {
        return {
            "expandable": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the group will be expandable in the side menu."
                },
                "attribute": "expandable",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label to display on the group."
                },
                "attribute": "label",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "deviceSize": {},
            "dropdownOpen": {},
            "expanded": {},
            "focusStyle": {},
            "inTopNavSideMenu": {},
            "navigationType": {},
            "parentEl": {}
        };
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the nav item.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "childBlur",
                "method": "childBlurHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "navItemClicked",
                "method": "navItemClickHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-navigation-group.js.map
