import { h, Host, } from "@stencil/core";
import { DEVICE_SIZES, getCurrentDeviceSize, getThemeForegroundColor, getNavItemParentDetails, isSlotUsed, } from "../../utils/helpers";
import chevronIcon from "../../assets/chevron-icon.svg";
import OpenInNew from "../../assets/OpenInNew.svg";
/**
 * @part link - The `<a>` within ic-navigation-item
 * @slot badge - Badge component overlaying the top right of the icon.
 * @slot icon - Content will be displayed to the left of the label for expanded navigation items, and in replacement of the label for collapsed navigation items.
 */
export class NavigationItem {
    constructor() {
        this.isInitialRender = true;
        this.displayDefaultNavigationItem = (href, hreflang, target, rel, referrerpolicy, download, label) => {
            const variant = this.isTopNavChild || this.inTopNavSideMenu ? "body" : "label";
            const ChevronIconComponent = this.expandable && (h("div", { class: { svg: true }, innerHTML: chevronIcon }));
            const IconComponent = this.el.querySelector('[slot="icon"]') && (h("div", { class: "icon" }, h("slot", { name: "icon" }), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" })));
            if (href !== "") {
                return (h("a", { href: href, target: target, rel: rel, hreflang: hreflang, referrerPolicy: referrerpolicy, download: download !== false ? download : null, class: "link", ref: (el) => (this.itemEl = el), part: "link" }, IconComponent, h("ic-typography", { variant: variant }, label), h("div", { class: "chevron-container" }, ChevronIconComponent), target === "_blank" && (h("span", { class: "open-in-new-icon", innerHTML: OpenInNew }))));
            }
            return (h("div", { tabindex: "0", class: "link", ref: (el) => (this.itemEl = el) }, IconComponent, h("ic-typography", { variant: variant }, label), ChevronIconComponent));
        };
        this.topNavResizedHandler = ({ detail, }) => {
            var _a;
            const { size } = detail;
            if (size !== this.deviceSize) {
                this.deviceSize = size;
                this.inTopNavSideMenu =
                    size <=
                        (((_a = this.parentEl) === null || _a === void 0 ? void 0 : _a.customMobileBreakpoint) || DEVICE_SIZES.L);
            }
        };
        this.sideNavExpandHandler = ({ detail, }) => {
            const { sideNavExpanded, sideNavMobile } = detail;
            this.sideNavExpanded = sideNavExpanded;
            this.isSideNavMobile = sideNavMobile;
        };
        this.handleBlur = ({ relatedTarget }) => {
            if (relatedTarget === null ||
                relatedTarget.tagName !== "IC-NAVIGATION-ITEM") {
                this.childBlur.emit();
            }
        };
        this.handleClick = () => {
            this.navItemClicked.emit();
        };
        this.generateTooltipLabel = () => {
            if (this.label) {
                return this.label;
            }
            if (this.navigationSlot) {
                return this.navigationSlot.textContent;
            }
            if (this.el.children[0]) {
                return this.el.children[0].textContent;
            }
            return "";
        };
        this.renderNavigationItemContent = () => {
            if (this.label) {
                return this.displayDefaultNavigationItem(this.href, this.hreflang, this.target, this.rel, this.referrerpolicy, this.download, this.label);
            }
            if (this.navigationSlot) {
                return h("slot", { name: "navigation-item" });
            }
            return h("slot", null);
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.focusStyle = getThemeForegroundColor();
        this.inTopNavSideMenu = false;
        this.isSideNavMobile = false;
        this.isTopNavChild = false;
        this.navigationType = undefined;
        this.parentEl = undefined;
        this.sideNavExpanded = false;
        this.collapsedIconLabel = false;
        this.displayNavigationTooltip = false;
        this.download = false;
        this.expandable = false;
        this.href = "";
        this.hreflang = undefined;
        this.label = undefined;
        this.rel = undefined;
        this.referrerpolicy = undefined;
        this.selected = false;
        this.target = undefined;
    }
    disconnectedCallback() {
        if (this.navigationType === "side") {
            this.parentEl.removeEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.removeEventListener("topNavResized", this.topNavResizedHandler);
        }
    }
    componentWillLoad() {
        const { navType, parent } = getNavItemParentDetails(this.el);
        this.navigationType = navType;
        this.parentEl = parent;
        this.deviceSize = getCurrentDeviceSize();
        if (this.navigationType === "side") {
            this.parentEl.addEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.addEventListener("topNavResized", this.topNavResizedHandler);
            if (this.el.parentElement.tagName === "IC-NAVIGATION-GROUP")
                this.isTopNavChild = true;
            if (this.deviceSize <=
                this.parentEl.customMobileBreakpoint)
                this.inTopNavSideMenu = true;
        }
        this.navigationSlot = this.el.querySelector('[slot="navigation-item"]');
        if (this.navigationSlot) {
            this.navigationSlot.ariaLabel = this.navigationSlot.textContent.trim();
        }
    }
    componentDidUpdate() {
        this.isInitialRender = false;
    }
    themeChangeHandler({ detail }) {
        this.focusStyle = detail.mode;
    }
    /**
     * Sets focus on the nav item.
     */
    async setFocus() {
        var _a;
        (_a = this.itemEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { inTopNavSideMenu, isTopNavChild, selected } = this;
        return (h(Host, { class: {
                ["navigation-item"]: true,
                ["navigation-item-top-nav"]: !inTopNavSideMenu && this.navigationType === "top",
                ["navigation-item-top-nav-child-selected"]: isTopNavChild && !inTopNavSideMenu && selected,
                [this.focusStyle]: (!inTopNavSideMenu && !isTopNavChild) ||
                    (this.navigationType === "side" && isTopNavChild),
                ["navigation-item-selected"]: !isTopNavChild && selected,
                ["navigation-item-side-menu"]: inTopNavSideMenu,
                ["navigation-item-side-menu-selected"]: inTopNavSideMenu && selected,
                ["navigation-item-top-nav-child"]: isTopNavChild && !inTopNavSideMenu,
                ["navigation-item-page-header"]: this.navigationType === "page-header",
                ["with-transition"]: !this.isInitialRender,
                ["navigation-item-side-nav"]: this.navigationType === "side",
                ["navigation-item-side-nav-collapsed"]: (!this.sideNavExpanded || this.displayNavigationTooltip) &&
                    this.navigationType === "side",
                ["navigation-item-side-nav-collapsed-with-label"]: !this.sideNavExpanded &&
                    this.navigationType === "side" &&
                    this.collapsedIconLabel &&
                    !this.isSideNavMobile,
                ["expandable"]: this.expandable,
            }, onBlur: isTopNavChild && !inTopNavSideMenu ? this.handleBlur : null, onClick: this.handleClick, "aria-current": selected ? "page" : null, role: "listitem" }, h("ic-tooltip", { label: this.generateTooltipLabel(), target: "navigation-item", placement: "right", class: {
                ["tooltip-navigation-item"]: true,
                ["tooltip-navigation-item-side-nav-collapsed"]: (!this.sideNavExpanded || this.displayNavigationTooltip) &&
                    this.navigationType === "side",
                ["tooltip-long-label-navigation-item-side-nav-expanded"]: this.el.hasAttribute("[display-navigation-tooltip = 'true']"),
            } }, this.renderNavigationItemContent())));
    }
    static get is() { return "ic-navigation-item"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-navigation-item.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-navigation-item.css"]
        };
    }
    static get properties() {
        return {
            "collapsedIconLabel": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the icon and label will be displayed when side navigation is collapsed."
                        }],
                    "text": ""
                },
                "attribute": "collapsed-icon-label",
                "reflect": false,
                "defaultValue": "false"
            },
            "displayNavigationTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the navigation item will be displayed within a tooltip."
                        }],
                    "text": ""
                },
                "attribute": "display-navigation-tooltip",
                "reflect": false,
                "defaultValue": "false"
            },
            "download": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | boolean",
                    "resolved": "boolean | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the user can save the linked URL instead of navigating to it."
                },
                "attribute": "download",
                "reflect": false,
                "defaultValue": "false"
            },
            "expandable": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the navigation item will be expandable."
                        }],
                    "text": ""
                },
                "attribute": "expandable",
                "reflect": false,
                "defaultValue": "false"
            },
            "href": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The destination of the navigation item."
                },
                "attribute": "href",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "hreflang": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The human language of the linked URL."
                },
                "attribute": "hreflang",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label of the navigation item."
                },
                "attribute": "label",
                "reflect": false
            },
            "rel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The relationship of the linked URL as space-separated link types."
                },
                "attribute": "rel",
                "reflect": false
            },
            "referrerpolicy": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ReferrerPolicy",
                    "resolved": "\"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\"",
                    "references": {
                        "ReferrerPolicy": {
                            "location": "global",
                            "id": "global::ReferrerPolicy"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "How much of the referrer to send when following the link."
                },
                "attribute": "referrerpolicy",
                "reflect": false
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the navigation item will be set in a selected state."
                },
                "attribute": "selected",
                "reflect": false,
                "defaultValue": "false"
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe)."
                },
                "attribute": "target",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "deviceSize": {},
            "focusStyle": {},
            "inTopNavSideMenu": {},
            "isSideNavMobile": {},
            "isTopNavChild": {},
            "navigationType": {},
            "parentEl": {},
            "sideNavExpanded": {}
        };
    }
    static get events() {
        return [{
                "method": "childBlur",
                "name": "childBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "- Emitted when item loses focus."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "navItemClicked",
                "name": "navItemClicked",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "- Emitted when navigation item clicked."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the nav item.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "themeChange",
                "method": "themeChangeHandler",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-navigation-item.js.map
