import { Host, h, } from "@stencil/core";
import { getSlot, getSlotContent, isSlotUsed } from "../../utils/helpers";
/**
 * @slot navigation - Content will be rendered at top of panel.
 * @slot buttons - Content will be rendered above version info and below navigation.
 */
export class NavigationMenu {
    constructor() {
        this.closeButton = null;
        this.hasButtons = false;
        this.hasNavigation = false;
        this.lastTabStop = null;
        this.navGroupFirst = false;
        this.navItemAboveButtons = false;
        this.closeMenu = () => {
            this.icNavigationMenuClose.emit();
        };
        this.focusCloseButton = () => {
            if (this.closeButton.focus) {
                this.closeButton.focus();
            }
        };
        this.focusLastTabStop = () => {
            let focusEl;
            if (this.lastTabStop !== null) {
                switch (this.lastTabStop.tagName) {
                    case "IC-NAVIGATION-BUTTON":
                    case "IC-NAVIGATION-ITEM":
                    case "IC-NAVIGATION-GROUP":
                        focusEl = this.lastTabStop;
                        focusEl.focus();
                        break;
                    case "A":
                        this.lastTabStop.focus();
                        break;
                }
            }
        };
        this.status = "";
        this.version = "";
    }
    componentWillLoad() {
        this.navBarEl = document.querySelector("ic-top-navigation");
        const navigationEls = getSlotContent(this.el, "navigation");
        if (navigationEls) {
            this.hasNavigation = true;
            const lastEl = navigationEls[navigationEls.length - 1];
            if (lastEl.tagName === "IC-NAVIGATION-ITEM") {
                this.navItemAboveButtons = true;
            }
            const firstEl = navigationEls[0];
            if (firstEl.tagName === "IC-NAVIGATION-GROUP") {
                this.navGroupFirst = true;
            }
        }
        const buttonContent = getSlotContent(this.el, "buttons");
        if (buttonContent !== null) {
            this.hasButtons = true;
            this.lastTabStop = buttonContent[buttonContent.length - 1];
        }
        else {
            if (this.hasNavigation) {
                const lastEl = navigationEls[navigationEls.length - 1];
                //check for slotted content i.e. react router link
                const slotContent = getSlot(lastEl, "navigation-item");
                if (slotContent !== null) {
                    this.lastTabStop = slotContent;
                }
                else {
                    this.lastTabStop = lastEl;
                }
            }
        }
    }
    componentDidLoad() {
        this.focusCloseButton();
    }
    componentWillRender() {
        this.hasNavigation = isSlotUsed(this.el, "navigation");
        this.hasButtons = isSlotUsed(this.el, "buttons");
    }
    navItemClickHandler() {
        this.closeMenu();
    }
    handleKeyDown(ev) {
        if (ev.key === "Tab") {
            if (ev.shiftKey) {
                if (document.activeElement === this.navBarEl) {
                    ev.preventDefault();
                    this.focusLastTabStop();
                }
            }
            else if (document.activeElement === this.lastTabStop ||
                this.lastTabStop === null) {
                ev.preventDefault();
                this.focusCloseButton();
            }
        }
        else if (ev.key === "Escape") {
            this.closeMenu();
        }
    }
    render() {
        return (h(Host, null, h("div", { class: "popout-modal", onClick: this.closeMenu }), h("div", { class: "popout-menu", role: "dialog", "aria-modal": "true", "aria-label": `${this.hasNavigation ? "Navigation" : "App"} menu` }, h("span", { "aria-hidden": "true", id: "navigation-landmark-text", class: "navigation-landmark-text" }, "Main navigation"), h("nav", { "aria-labelledby": "navigation-landmark-text", "aria-hidden": this.hasNavigation ? "false" : "true" }, h("div", { class: {
                ["menu-close-button-container"]: true,
                ["nav-group-first"]: this.navGroupFirst,
            } }, h("ic-button", { ref: (el) => (this.closeButton = el), id: "menu-close-button", class: "menu-close-button", variant: "icon", size: "large", "aria-label": `Close ${this.hasNavigation ? "navigation" : "app"} menu`, onClick: this.closeMenu }, h("svg", { slot: "icon", width: "14", height: "14", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg" }, h("path", { d: "M14 1.41L12.59 0L7 5.59L1.41 0L0 1.41L5.59 7L0 12.59L1.41 14L7 8.41L12.59 14L14 12.59L8.41 7L14 1.41Z", fill: "#1759BC" })))), this.hasNavigation && h("slot", { name: "navigation" })), this.hasButtons && (h("div", { class: {
                ["menu-buttons-container"]: true,
                ["menu-buttons-container-nav-item-above"]: this.navItemAboveButtons,
            } }, h("slot", { name: "buttons" }))), (this.status !== "" || this.version !== "") && (h("div", { class: {
                ["menu-status-version-container"]: true,
                ["status-version-no-buttons"]: !this.hasButtons,
            } }, this.status !== "" && (h("div", { class: "menu-status" }, h("ic-typography", { variant: "label-uppercase", "aria-label": "app tag", class: "menu-status-text" }, this.status))), this.version !== "" && (h("div", { class: "menu-version" }, h("ic-typography", { variant: "label", class: "menu-version-text", "aria-label": "app version" }, this.version))))))));
    }
    static get is() { return "ic-navigation-menu"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-navigation-menu.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-navigation-menu.css"]
        };
    }
    static get properties() {
        return {
            "status": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The status info to display."
                },
                "attribute": "status",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "version": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The version info to display."
                },
                "attribute": "version",
                "reflect": false,
                "defaultValue": "\"\""
            }
        };
    }
    static get events() {
        return [{
                "method": "icNavigationMenuClose",
                "name": "icNavigationMenuClose",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "- Emitted when the menu is closed."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "navItemClicked",
                "method": "navItemClickHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "keydown",
                "method": "handleKeyDown",
                "target": "document",
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-navigation-menu.js.map
