import { h, } from "@stencil/core";
import { removeDisabledFalse, capitalize } from "../../utils/helpers";
export class PaginationItem {
    constructor() {
        this.handleClick = () => {
            this.paginationItemClick.emit({ page: this.page });
        };
        this.capitalizedLabel = undefined;
        this.appearance = "default";
        this.disabled = false;
        this.label = "Page";
        this.page = undefined;
        this.selected = false;
        this.type = undefined;
    }
    watchLabelHandler() {
        this.capitalizedLabel = capitalize(this.label);
    }
    componentWillLoad() {
        this.watchLabelHandler();
        removeDisabledFalse(this.disabled, this.el);
    }
    render() {
        const { page, selected, type, disabled, appearance, label, capitalizedLabel, } = this;
        return (h("a", null, type === "ellipsis" ? (h("div", { class: {
                ["item-container"]: true,
                ["ellipsis"]: true,
                ["disabled"]: disabled,
            } }, h("ic-typography", { class: {
                [`${appearance}`]: true,
            }, variant: "label" }, "..."))) : type === "page" ? (h("button", { disabled: disabled, onClick: this.handleClick, tabindex: selected ? "-1" : "0", role: "button", "aria-current": selected && "page", "aria-label": selected ? `${label}: ${page}` : `Go to ${label} ${page}`, class: {
                ["selected"]: !disabled && selected,
                ["disabled"]: disabled,
                ["item-container"]: true,
                [`${appearance}`]: true,
                ["page"]: type === "page",
            } }, h("ic-typography", { variant: "label", class: {
                ["page-selected"]: selected,
                ["disabled"]: disabled,
                [`${appearance}`]: true,
            } }, page))) : (h("ic-typography", { "aria-live": "polite", class: {
                [`simple-current ${appearance}`]: true,
                ["disabled"]: disabled,
            }, variant: "label" }, capitalizedLabel, " ", page))));
    }
    static get is() { return "ic-pagination-item"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-pagination-item.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-pagination-item.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the pagination, e.g. dark, light or the default."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the pagination item will be disabled."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the pagination item (applicable when simple pagination is being used)."
                },
                "attribute": "label",
                "reflect": false,
                "defaultValue": "\"Page\""
            },
            "page": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number | null",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The current page number."
                },
                "attribute": "page",
                "reflect": false
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the pagination item will be selected."
                },
                "attribute": "selected",
                "reflect": false,
                "defaultValue": "false"
            },
            "type": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcPaginationItemType",
                    "resolved": "\"ellipsis\" | \"page\" | \"simple-current\"",
                    "references": {
                        "IcPaginationItemType": {
                            "location": "import",
                            "path": "./ic-pagination-item.types",
                            "id": "src/components/ic-pagination-item/ic-pagination-item.types.ts::IcPaginationItemType"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The type of pagination item - 'page' or 'ellipsis'."
                },
                "attribute": "type",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "capitalizedLabel": {}
        };
    }
    static get events() {
        return [{
                "method": "paginationItemClick",
                "name": "paginationItemClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "- Emitted when a pagination item is clicked."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "{ page: number }",
                    "resolved": "{ page: number; }",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "label",
                "methodName": "watchLabelHandler"
            }];
    }
}
//# sourceMappingURL=ic-pagination-item.js.map
