import { Host, h, } from "@stencil/core";
import paginationNextPrevious from "../../assets/pagination-next-previous.svg";
import paginationFirstLast from "../../assets/pagination-first-last.svg";
import { onComponentRequiredPropUndefined, removeDisabledFalse, } from "../../utils/helpers";
export class Pagination {
    constructor() {
        this.handleClickFirst = () => {
            this.currentPage = 1;
            this.icPageChange.emit({ value: this.currentPage });
        };
        this.handleClickPrevious = () => {
            this.currentPage--;
            this.icPageChange.emit({ value: this.currentPage });
        };
        this.handleClickNext = () => {
            this.currentPage++;
            this.icPageChange.emit({ value: this.currentPage });
        };
        this.handleClickLast = () => {
            this.currentPage = this.pages;
            this.icPageChange.emit({ value: this.currentPage });
        };
        // button rendering abstracted from component render methods for clarity
        this.firstButton = () => {
            return (h("ic-button", { id: "first-page-button", "aria-label": "Go to first page", appearance: this.appearance, onClick: this.handleClickFirst, class: "page-button first-last", disabled: this.currentPage === 1 || this.disabled, variant: "icon", innerHTML: paginationFirstLast }));
        };
        this.previousButton = () => {
            return (h("ic-button", { id: "previous-page-button", "aria-label": "Go to previous page", appearance: this.appearance, onClick: this.handleClickPrevious, class: "page-button next-previous flip", disabled: this.currentPage === 1 || this.disabled, variant: "icon", innerHTML: paginationNextPrevious }));
        };
        this.nextButton = () => {
            return (h("ic-button", { id: "next-page-button", "aria-label": "Go to next page", appearance: this.appearance, onClick: this.handleClickNext, class: "page-button next-previous", disabled: this.currentPage === this.pages || this.disabled, variant: "icon", innerHTML: paginationNextPrevious }));
        };
        this.lastButton = () => {
            return (h("ic-button", { id: "last-page-button", "aria-label": "Go to last page", appearance: this.appearance, onClick: this.handleClickLast, class: "page-button first-last flip", disabled: this.currentPage === this.pages || this.disabled, variant: "icon", innerHTML: paginationFirstLast }));
        };
        this.renderStartEllipsis = () => {
            return (h("ic-pagination-item", { appearance: this.appearance, type: "ellipsis", id: "start-ellipsis", disabled: this.disabled }));
        };
        this.renderEndEllipsis = () => {
            return (h("ic-pagination-item", { appearance: this.appearance, type: "ellipsis", id: "end-ellipsis", disabled: this.disabled }));
        };
        this.renderStartItems = () => {
            return this.startItems.map((page) => {
                return (h("ic-pagination-item", { appearance: this.appearance, selected: page === this.currentPage, id: `pagination-item-${page}`, type: "page", page: page, disabled: this.disabled }));
            });
        };
        this.renderEndItems = () => {
            return this.endItems.map((page) => {
                return (h("ic-pagination-item", { appearance: this.appearance, selected: page === this.currentPage, id: `pagination-item-${page}`, type: "page", page: page, disabled: this.disabled }));
            });
        };
        this.renderMiddleItems = () => {
            return this.midItems.map((page) => {
                return (h("ic-pagination-item", { appearance: this.appearance, selected: page === this.currentPage, id: `pagination-item-${page}`, type: "page", page: page, disabled: this.disabled }));
            });
        };
        this.endEllipsis = false;
        this.endItems = [];
        this.midItems = [];
        this.startEllipsis = false;
        this.startItems = [];
        this.adjacentCount = 1;
        this.appearance = "default";
        this.boundaryCount = 1;
        this.defaultPage = 1;
        this.disabled = false;
        this.hideCurrentPage = false;
        this.hideFirstAndLastPageButton = false;
        this.label = "Page";
        this.pages = undefined;
        this.type = "simple";
        this.currentPage = this.defaultPage;
    }
    watchAdjacentCountHandler() {
        if (this.adjacentCount > 2) {
            this.adjacentCount = 2;
        }
    }
    watchBoundaryCountHandler() {
        if (this.boundaryCount > 2) {
            this.boundaryCount = 2;
        }
    }
    watchNumberPagesHandler() {
        this.watchPageChangeHandler();
    }
    watchTypeHandler() {
        this.watchPageChangeHandler();
    }
    watchPageChangeHandler() {
        if (this.type === "simple") {
            return;
        }
        this.startEllipsis = false;
        this.endEllipsis = false;
        this.startItems = [];
        this.endItems = [];
        this.midItems = [];
        const startItems = [];
        let startItemCount = 0;
        const endItems = [];
        let endStart = this.pages;
        const midItems = [];
        let midStart;
        let midEnd;
        let startEllipsis = false;
        let endEllipsis = false;
        if (this.pages <= this.boundaryCount * 2 + this.adjacentCount * 2 + 3) {
            this.startEllipsis = false;
            this.endEllipsis = false;
            for (let i = 1; i <= this.pages; i++) {
                startItems.push(i);
            }
            this.startItems = startItems;
            return;
        }
        startItemCount = this.boundaryCount === 0 ? 1 : this.boundaryCount;
        endStart =
            this.boundaryCount === 0
                ? this.pages
                : this.pages - this.boundaryCount + 1;
        if (this.currentPage <= this.adjacentCount + this.boundaryCount + 2) {
            startEllipsis = false;
            endEllipsis = true;
            let numItems = 2 * this.adjacentCount + 1;
            if (this.boundaryCount === 0) {
                numItems--;
            }
            midStart = startItemCount + 1;
            midEnd = midStart + numItems;
        }
        else {
            startEllipsis = true;
            if (this.currentPage >
                this.pages - (this.adjacentCount + this.boundaryCount + 2)) {
                let numItems = 2 * this.adjacentCount + 1;
                if (this.boundaryCount === 0) {
                    numItems--;
                }
                midEnd =
                    this.boundaryCount === 0
                        ? this.pages - 1
                        : this.pages - this.boundaryCount;
                midStart = midEnd - numItems;
            }
            else {
                endEllipsis = true;
                midStart = this.currentPage - this.adjacentCount;
                midEnd = this.currentPage + this.adjacentCount;
            }
        }
        //create array of start items
        if (this.boundaryCount > 0 ||
            (this.boundaryCount === 0 && startEllipsis === false)) {
            for (let i = 1; i <= startItemCount; i++) {
                startItems.push(i);
            }
        }
        //create array of end items
        if (this.boundaryCount > 0 ||
            (this.boundaryCount === 0 && endEllipsis === false)) {
            for (let i = endStart; i <= this.pages; i++) {
                endItems.push(i);
            }
        }
        //create array of mid items
        for (let i = midStart; i <= midEnd; i++) {
            midItems.push(i);
        }
        this.startEllipsis = startEllipsis;
        this.endEllipsis = endEllipsis;
        this.startItems = startItems;
        this.endItems = endItems;
        this.midItems = midItems;
    }
    componentWillLoad() {
        this.watchPageChangeHandler();
        this.watchBoundaryCountHandler();
        this.watchAdjacentCountHandler();
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.pages, propName: "pages" }], "Pagination");
    }
    paginationItemClickHandler(ev) {
        const page = ev.detail.page;
        this.currentPage = page;
        this.icPageChange.emit({ value: this.currentPage });
    }
    /**
     * Sets the currently displayed page.
     * @param {number} page The page number to set as the current page
     */
    async setCurrentPage(page) {
        if (typeof page === "number" && page > 0 && page <= this.pages) {
            this.currentPage = page;
        }
        else {
            console.error("Current page must be a number greater than zero but less than or equal to the total number of pages");
        }
    }
    render() {
        const { type, currentPage, hideCurrentPage, disabled, hideFirstAndLastPageButton, label, } = this;
        return (h(Host, null, type === "simple" && (h("nav", { class: {
                ["disabled"]: disabled,
            }, role: "navigation", "aria-label": "Pagination Navigation" }, hideFirstAndLastPageButton ? null : this.firstButton(), this.previousButton(), h("ic-pagination-item", { appearance: this.appearance, type: "simple-current", page: currentPage, label: label, class: { ["hide-current-page"]: hideCurrentPage }, disabled: disabled }), this.nextButton(), hideFirstAndLastPageButton ? null : this.lastButton())), type === "complex" && (h("nav", { class: {
                ["disabled"]: disabled,
            }, role: "navigation", "aria-label": "Pagination Navigation" }, hideFirstAndLastPageButton ? null : this.firstButton(), this.previousButton(), this.renderStartItems(), this.startEllipsis && this.renderStartEllipsis(), this.renderMiddleItems(), this.endEllipsis && this.renderEndEllipsis(), this.renderEndItems(), this.nextButton(), hideFirstAndLastPageButton ? null : this.lastButton())), type === "complex" && (h("span", { class: "sr-only", "aria-live": "polite" }, "Page ", this.currentPage))));
    }
    static get is() { return "ic-pagination"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-pagination.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-pagination.css"]
        };
    }
    static get properties() {
        return {
            "adjacentCount": {
                "type": "number",
                "mutable": true,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The number of pages displayed adjacent to the current page when using 'complex' type pagination. Accepted values are 0, 1 & 2."
                },
                "attribute": "adjacent-count",
                "reflect": false,
                "defaultValue": "1"
            },
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the pagination, e.g. dark, light or the default."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "boundaryCount": {
                "type": "number",
                "mutable": true,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The number of pages displayed as boundary items to the current page when using 'complex' type pagination. Accepted values are 0, 1 & 2."
                },
                "attribute": "boundary-count",
                "reflect": false,
                "defaultValue": "1"
            },
            "defaultPage": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The default page to display."
                },
                "attribute": "default-page",
                "reflect": false,
                "defaultValue": "1"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the pagination will not allow interaction."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "hideCurrentPage": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the current page of the simple pagination will not be displayed."
                },
                "attribute": "hide-current-page",
                "reflect": false,
                "defaultValue": "false"
            },
            "hideFirstAndLastPageButton": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the first and last page buttons will not be displayed."
                },
                "attribute": "hide-first-and-last-page-button",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the pagination item (applicable when simple pagination is being used)."
                },
                "attribute": "label",
                "reflect": false,
                "defaultValue": "\"Page\""
            },
            "pages": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The total number of pages."
                },
                "attribute": "pages",
                "reflect": false
            },
            "type": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcPaginationTypes",
                    "resolved": "\"complex\" | \"simple\"",
                    "references": {
                        "IcPaginationTypes": {
                            "location": "import",
                            "path": "./ic-pagination.types",
                            "id": "src/components/ic-pagination/ic-pagination.types.ts::IcPaginationTypes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The type of pagination to be used."
                },
                "attribute": "type",
                "reflect": false,
                "defaultValue": "\"simple\""
            },
            "currentPage": {
                "type": "number",
                "mutable": true,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The current page displayed by the pagination."
                },
                "attribute": "current-page",
                "reflect": false,
                "defaultValue": "this.defaultPage"
            }
        };
    }
    static get states() {
        return {
            "endEllipsis": {},
            "endItems": {},
            "midItems": {},
            "startEllipsis": {},
            "startItems": {}
        };
    }
    static get events() {
        return [{
                "method": "icPageChange",
                "name": "icPageChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a page is selected."
                },
                "complexType": {
                    "original": "IcChangeEventDetail",
                    "resolved": "IcChangeEventDetail",
                    "references": {
                        "IcChangeEventDetail": {
                            "location": "import",
                            "path": "./ic-pagination.types",
                            "id": "src/components/ic-pagination/ic-pagination.types.ts::IcChangeEventDetail"
                        }
                    }
                }
            }];
    }
    static get methods() {
        return {
            "setCurrentPage": {
                "complexType": {
                    "signature": "(page: number) => Promise<void>",
                    "parameters": [{
                            "name": "page",
                            "type": "number",
                            "docs": "The page number to set as the current page"
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets the currently displayed page.",
                    "tags": [{
                            "name": "param",
                            "text": "page The page number to set as the current page"
                        }]
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "adjacentCount",
                "methodName": "watchAdjacentCountHandler"
            }, {
                "propName": "boundaryCount",
                "methodName": "watchBoundaryCountHandler"
            }, {
                "propName": "pages",
                "methodName": "watchNumberPagesHandler"
            }, {
                "propName": "type",
                "methodName": "watchTypeHandler"
            }, {
                "propName": "currentPage",
                "methodName": "watchPageChangeHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "paginationItemClick",
                "method": "paginationItemClickHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-pagination.js.map
