import { Host, h, } from "@stencil/core";
import { hasValidationStatus, isSlotUsed, onComponentRequiredPropUndefined, removeDisabledFalse, renderHiddenInput, checkResizeObserver, } from "../../utils/helpers";
export class RadioGroup {
    constructor() {
        this.resizeObserver = null;
        this.ADDITIONAL_FIELD = "additional-field";
        this.RADIO_HORIZONTAL = "horizontal";
        this.RADIO_VERTICAL = "vertical";
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                this.checkOrientation();
            });
            this.resizeObserver.observe(this.el);
        };
        this.handleKeyDown = (event) => {
            switch (event.key) {
                case "ArrowDown":
                case "ArrowRight":
                    this.radioOptions[this.getNextItemToSelect(this.selectedChild, true)].click();
                    event.preventDefault();
                    break;
                case "ArrowUp":
                case "ArrowLeft":
                    this.radioOptions[this.getNextItemToSelect(this.selectedChild, false)].click();
                    event.preventDefault();
            }
        };
        this.getNextItemToSelect = (currentItem, movingDown) => {
            const numRadios = this.radioOptions.length - 1;
            if (currentItem < 1) {
                currentItem = 0;
            }
            let nextItem = movingDown ? currentItem + 1 : currentItem - 1;
            //check if wrap around necessary
            if (nextItem < 0) {
                nextItem = numRadios;
            }
            else if (nextItem > numRadios) {
                nextItem = 0;
            }
            //if next item is disabled then find next
            if (this.radioOptions[nextItem].disabled) {
                nextItem = this.getNextItemToSelect(nextItem, movingDown);
            }
            return nextItem;
        };
        this.addSlotChangeListener = () => {
            this.radioContainer.addEventListener("slotchange", this.setRadioOptions);
        };
        this.setFirstRadioOptionTabIndex = (value) => {
            this.radioOptions[0].setTabIndex(value);
        };
        this.setRadioOptions = () => {
            this.selectedChild = -1;
            this.checkedValue = "";
            this.radioOptions = Array.from(this.el.querySelectorAll("ic-radio-option"));
            if (this.radioOptions.length > 0) {
                this.radioOptions.forEach((radioOption, index) => {
                    if (!radioOption.selected) {
                        radioOption.selected = this.checkedValue === radioOption.value;
                    }
                    radioOption.name = this.name;
                    radioOption.groupLabel = this.label;
                    if (radioOption.selected) {
                        this.selectedChild = index;
                        this.checkedValue = radioOption.value;
                    }
                    if (this.disabled) {
                        radioOption.disabled = true;
                    }
                });
                this.setFirstRadioOptionTabIndex(this.selectedChild > 0 ? -1 : 0);
                if (this.initialOrientation === this.RADIO_HORIZONTAL &&
                    this.radioOptions !== undefined &&
                    (this.radioOptions.length > 2 ||
                        (this.radioOptions.length === 2 &&
                            (isSlotUsed(this.radioOptions[0], this.ADDITIONAL_FIELD) ||
                                isSlotUsed(this.radioOptions[1], this.ADDITIONAL_FIELD))))) {
                    this.currentOrientation = this.RADIO_VERTICAL;
                }
            }
        };
        this.checkedValue = "";
        this.currentOrientation = undefined;
        this.initialOrientation = undefined;
        this.selectedChild = -1;
        this.disabled = false;
        this.helperText = undefined;
        this.hideLabel = false;
        this.label = undefined;
        this.name = undefined;
        this.orientation = "vertical";
        this.required = false;
        this.size = "default";
        this.small = false;
        this.validationStatus = "";
        this.validationText = "";
    }
    watchDisabledHandler(newValue) {
        this.radioOptions.forEach((radioOption) => (radioOption.disabled = newValue));
    }
    orientationChangeHandler() {
        this.initialOrientation = this.orientation;
        this.checkOrientation();
    }
    disconnectedCallback() {
        var _a, _b;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
        (_b = this.radioContainer) === null || _b === void 0 ? void 0 : _b.removeEventListener("slotchange", this.setRadioOptions);
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        this.orientationChangeHandler();
        this.currentOrientation = this.initialOrientation;
    }
    componentDidLoad() {
        this.setRadioOptions();
        checkResizeObserver(this.runResizeObserver);
        this.addSlotChangeListener();
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.name, propName: "name" },
        ], "Radio Group");
    }
    selectHandler({ detail, target }) {
        var _a;
        this.checkedValue = detail.value;
        const selectedOption = target;
        this.icChange.emit({
            value: this.checkedValue,
            selectedOption: {
                radio: selectedOption,
                textFieldValue: (_a = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.querySelector("ic-text-field")) === null || _a === void 0 ? void 0 : _a.value,
            },
        });
        if (this.radioOptions !== undefined) {
            this.radioOptions.forEach((radioOption, index) => {
                radioOption.selected = this.checkedValue === radioOption.value;
                if (radioOption.selected) {
                    this.selectedChild = index;
                }
            });
            this.setFirstRadioOptionTabIndex(this.selectedChild > 0 ? -1 : 0);
        }
    }
    changeHandler() {
        const selectedOption = this.radioOptions.findIndex((radioOption) => radioOption.selected);
        if (selectedOption < 0) {
            this.setFirstRadioOptionTabIndex(0);
            this.selectedChild = selectedOption;
        }
    }
    checkOrientation() {
        var _a, _b;
        if (this.initialOrientation === this.RADIO_HORIZONTAL) {
            let totalWidth = 0;
            if (Array.isArray(this.radioOptions) && this.radioOptions.length > 0) {
                this.radioOptions.forEach(({ clientWidth }, i, arr) => {
                    totalWidth += clientWidth;
                    if (i < arr.length - 1)
                        totalWidth += 40;
                });
            }
            else {
                totalWidth = 0;
            }
            if (this.initialOrientation == this.RADIO_HORIZONTAL) {
                if (this.radioOptions !== undefined &&
                    (this.radioOptions.length > 2 ||
                        (this.radioOptions.length === 2 &&
                            (isSlotUsed(this.radioOptions[0], this.ADDITIONAL_FIELD) ||
                                isSlotUsed(this.radioOptions[1], this.ADDITIONAL_FIELD))))) {
                    this.currentOrientation = this.RADIO_VERTICAL;
                }
                else {
                    if (totalWidth >= ((_a = this.radioContainer) === null || _a === void 0 ? void 0 : _a.clientWidth)) {
                        this.currentOrientation = this.RADIO_VERTICAL;
                    }
                    else if (totalWidth < ((_b = this.radioContainer) === null || _b === void 0 ? void 0 : _b.clientWidth)) {
                        this.currentOrientation = this.RADIO_HORIZONTAL;
                    }
                }
            }
        }
    }
    render() {
        renderHiddenInput(true, this.el, this.name, this.checkedValue, this.disabled);
        return (h(Host, { onKeyDown: this.handleKeyDown, class: { small: this.small || this.size === "small" } }, h("div", { role: "radiogroup", "aria-label": `${this.label}${this.required ? ", required" : ""}` }, !this.hideLabel && (h("ic-input-label", { class: { [`${this.validationStatus}`]: true }, label: this.label, helperText: this.helperText, required: this.required, disabled: this.disabled })), h("div", { class: {
                "radio-buttons-container": true,
                horizontal: this.currentOrientation === this.RADIO_HORIZONTAL,
            }, ref: (el) => (this.radioContainer = el) }, h("slot", null))), hasValidationStatus(this.validationStatus, this.disabled) && (h("ic-input-validation", { ariaLiveMode: "polite", status: this.validationStatus, message: this.validationText }))));
    }
    static get is() { return "ic-radio-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-radio-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-radio-group.css"]
        };
    }
    static get properties() {
        return {
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The helper text that will be displayed for additional field guidance."
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "hideLabel": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the label will be hidden and the required label value will be applied as an aria-label."
                },
                "attribute": "hide-label",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the radio group to be displayed."
                },
                "attribute": "label",
                "reflect": false
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name for the radio group to differentiate from other groups."
                },
                "attribute": "name",
                "reflect": false
            },
            "orientation": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcOrientation",
                    "resolved": "\"horizontal\" | \"vertical\"",
                    "references": {
                        "IcOrientation": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcOrientation"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The orientation of the radio buttons in the radio group. If there are more than two radio buttons in a radio group or either of the radio buttons use the `additional-field` slot, then the orientation will always be vertical."
                },
                "attribute": "orientation",
                "reflect": false,
                "defaultValue": "\"vertical\""
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the radio group will require a value."
                },
                "attribute": "required",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizesNoLarge",
                    "resolved": "\"default\" | \"small\"",
                    "references": {
                        "IcSizesNoLarge": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizesNoLarge"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the radio group component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "validationStatus": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcInformationStatusOrEmpty",
                    "resolved": "\"\" | \"error\" | \"success\" | \"warning\"",
                    "references": {
                        "IcInformationStatusOrEmpty": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcInformationStatusOrEmpty"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation status - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-status",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "validationText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation text - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-text",
                "reflect": false,
                "defaultValue": "\"\""
            }
        };
    }
    static get states() {
        return {
            "checkedValue": {},
            "currentOrientation": {},
            "initialOrientation": {},
            "selectedChild": {}
        };
    }
    static get events() {
        return [{
                "method": "icChange",
                "name": "icChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a user selects a radio."
                },
                "complexType": {
                    "original": "IcChangeEventDetail",
                    "resolved": "IcChangeEventDetail",
                    "references": {
                        "IcChangeEventDetail": {
                            "location": "import",
                            "path": "./ic-radio-group.types",
                            "id": "src/components/ic-radio-group/ic-radio-group.types.ts::IcChangeEventDetail"
                        }
                    }
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "disabled",
                "methodName": "watchDisabledHandler"
            }, {
                "propName": "orientation",
                "methodName": "orientationChangeHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "icCheck",
                "method": "selectHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "icSelectedChange",
                "method": "changeHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-radio-group.js.map
