import { Host, h, } from "@stencil/core";
import { onComponentRequiredPropUndefined, addFormResetListener, removeFormResetListener, removeDisabledFalse, isPropDefined, isSlotUsed, } from "../../utils/helpers";
const ADDITIONAL_FIELD = "additional-field";
const TEXT_FIELD_SELECTOR = "ic-text-field";
/**
 * @slot additional-field - Content to displayed alongside a radio option.
 */
export class RadioOption {
    constructor() {
        this.defaultRadioValue = "";
        this.hasAdditionalField = false;
        this.skipFocus = false;
        this.handleClick = () => {
            if (!this.disabled) {
                if (this.skipFocus === false) {
                    this.radioElement.focus();
                }
                this.skipFocus = false;
                if (this.hasAdditionalField) {
                    this.value =
                        this.el.querySelector(TEXT_FIELD_SELECTOR).value ||
                            this.defaultRadioValue;
                }
                this.icCheck.emit({
                    value: this.value,
                });
                this.radioOptionSelect.emit({
                    value: this.value,
                });
            }
        };
        this.swallowClick = (event) => {
            event.stopPropagation();
        };
        this.handleFormReset = () => {
            this.skipFocus = true;
            this.selected = this.initiallySelected;
        };
        this.additionalFieldDisplay = "static";
        this.disabled = false;
        this.dynamicText = "This selection requires additional answers";
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.groupLabel = undefined;
        this.label = undefined;
        this.name = undefined;
        this.value = undefined;
        this.selected = false;
        this.initiallySelected = this.selected;
    }
    watchSelectedHandler() {
        this.icSelectedChange.emit();
    }
    disconnectedCallback() {
        removeFormResetListener(this.el, this.handleFormReset);
    }
    componentWillLoad() {
        if (isSlotUsed(this.el, ADDITIONAL_FIELD)) {
            this.hasAdditionalField = true;
            const textField = this.el.querySelector(TEXT_FIELD_SELECTOR);
            if (textField)
                textField.hiddenInput = false;
        }
        this.defaultRadioValue = this.value;
        addFormResetListener(this.el, this.handleFormReset);
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.value, propName: "value" }], "Radio Option");
    }
    componentWillRender() {
        const hasSlot = isSlotUsed(this.el, ADDITIONAL_FIELD);
        if (hasSlot && !this.hasAdditionalField) {
            this.hasAdditionalField = true;
            const textField = this.el.querySelector(TEXT_FIELD_SELECTOR);
            if (textField)
                textField.hiddenInput = false;
        }
        else if (!hasSlot && this.hasAdditionalField) {
            this.hasAdditionalField = false;
        }
    }
    componentDidRender() {
        if (this.additionalFieldDisplay === "static") {
            const textfield = this.el.querySelector(TEXT_FIELD_SELECTOR);
            if (!this.selected || this.disabled) {
                textfield === null || textfield === void 0 ? void 0 : textfield.setAttribute("disabled", "");
            }
            else {
                textfield === null || textfield === void 0 ? void 0 : textfield.removeAttribute("disabled");
            }
        }
    }
    textfieldValueHandler(event) {
        if (this.selected) {
            this.value = event.detail.value || this.defaultRadioValue;
            this.icCheck.emit({
                value: this.value,
            });
            this.radioOptionSelect.emit({
                value: this.value,
            });
        }
        event.stopImmediatePropagation();
    }
    /**
     * Sets focus on the radio option.
     */
    async setFocus() {
        var _a;
        (_a = this.radioElement) === null || _a === void 0 ? void 0 : _a.focus();
    }
    /**
     * @internal Sets the tabIndex of the radio option.
     */
    async setTabIndex(value) {
        this.radioElement.tabIndex = value;
    }
    render() {
        const { additionalFieldDisplay, disabled, dynamicText, form, formaction, formenctype, formmethod, formnovalidate, formtarget, groupLabel, handleClick, hasAdditionalField, label, name, selected, swallowClick, value, } = this;
        const id = `ic-radio-option-${isPropDefined(label) || value}-${groupLabel}`;
        return (h(Host, { onClick: handleClick, class: { disabled } }, h("div", { class: { ["container"]: true, disabled } }, h("div", null, h("input", { role: "radio", tabindex: selected ? "0" : "-1", type: "radio", name: name, id: id, value: value, disabled: disabled ? true : null, checked: selected, ref: (el) => (this.radioElement = el), form: form, formaction: formaction, formenctype: formenctype, formmethod: formmethod, formnovalidate: formnovalidate, formtarget: formtarget }), h("span", { class: "checkmark" })), h("ic-typography", { class: "radio-label", variant: "body" }, h("label", { htmlFor: id }, label))), hasAdditionalField && (h("div", { onClick: swallowClick, class: {
                "dynamic-container": true,
                hidden: additionalFieldDisplay === "dynamic" && !selected,
            } }, additionalFieldDisplay === "dynamic" && (h("div", { class: "branch-corner" })), h("div", null, additionalFieldDisplay === "dynamic" && (h("ic-typography", { variant: "caption" }, h("p", { class: "dynamic-text" }, dynamicText))), h("div", { class: {
                "additional-field-wrapper": additionalFieldDisplay === "static",
            } }, h("slot", { name: ADDITIONAL_FIELD })))))));
    }
    static get is() { return "ic-radio-option"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-radio-option.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-radio-option.css"]
        };
    }
    static get properties() {
        return {
            "additionalFieldDisplay": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAdditionalFieldTypes",
                    "resolved": "\"dynamic\" | \"static\"",
                    "references": {
                        "IcAdditionalFieldTypes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAdditionalFieldTypes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The style of additionalField that will be displayed if used."
                },
                "attribute": "additional-field-display",
                "reflect": true,
                "defaultValue": "\"static\""
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "dynamicText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The text to be displayed when dynamic."
                },
                "attribute": "dynamic-text",
                "reflect": false,
                "defaultValue": "\"This selection requires additional answers\""
            },
            "form": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The <form> element to associate the radio with."
                },
                "attribute": "form",
                "reflect": false
            },
            "formaction": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The URL that processes the information submitted by the radio. It overrides the action attribute of the radio's form owner. Does nothing if there is no form owner."
                },
                "attribute": "formaction",
                "reflect": false
            },
            "formenctype": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The way the submitted form data is encoded."
                },
                "attribute": "formenctype",
                "reflect": false
            },
            "formmethod": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The HTTP method used to submit the form."
                },
                "attribute": "formmethod",
                "reflect": false
            },
            "formnovalidate": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the form will not be validated when submitted."
                },
                "attribute": "formnovalidate",
                "reflect": false
            },
            "formtarget": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The place to display the response from submitting the form. It overrides the target attribute of the radio's form owner."
                },
                "attribute": "formtarget",
                "reflect": false
            },
            "groupLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The group label for the radio option."
                },
                "attribute": "group-label",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label for the radio option."
                },
                "attribute": "label",
                "reflect": false
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name for the radio option."
                },
                "attribute": "name",
                "reflect": false
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value for the radio option."
                },
                "attribute": "value",
                "reflect": false
            },
            "selected": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the radio option will be displayed in a selected state."
                },
                "attribute": "selected",
                "reflect": true,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "initiallySelected": {}
        };
    }
    static get events() {
        return [{
                "method": "icCheck",
                "name": "icCheck",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the radio option is selected."
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "radioOptionSelect",
                "name": "radioOptionSelect",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This event should not be used anymore. Use icCheck instead."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "icSelectedChange",
                "name": "icSelectedChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the radio option is selected or deselected."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the radio option.",
                    "tags": []
                }
            },
            "setTabIndex": {
                "complexType": {
                    "signature": "(value: number) => Promise<void>",
                    "parameters": [{
                            "name": "value",
                            "type": "number",
                            "docs": ""
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": "Sets the tabIndex of the radio option."
                        }]
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "selected",
                "methodName": "watchSelectedHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "icChange",
                "method": "textfieldValueHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-radio-option.js.map
