import { Host, h } from "@stencil/core";
export class SectionContainer {
    constructor() {
        this.aligned = "left";
        this.fullHeight = false;
    }
    render() {
        const { aligned, fullHeight } = this;
        return (h(Host, { class: {
                ["aligned-left"]: aligned === "left" || aligned === null,
                ["aligned-center"]: aligned === "center",
                ["aligned-full-width"]: aligned === "full-width",
                ["no-vertical-padding"]: fullHeight,
            } }, h("slot", null)));
    }
    static get is() { return "ic-section-container"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-section-container.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-section-container.css"]
        };
    }
    static get properties() {
        return {
            "aligned": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAlignment",
                    "resolved": "\"center\" | \"full-width\" | \"left\"",
                    "references": {
                        "IcAlignment": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAlignment"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The alignment of the container."
                },
                "attribute": "aligned",
                "reflect": false,
                "defaultValue": "\"left\""
            },
            "fullHeight": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the standard vertical padding from the container will be removed."
                },
                "attribute": "full-height",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
//# sourceMappingURL=ic-section-container.js.map
