import { Host, h } from "@stencil/core";
const DEFAULT_HEIGHTS = {
    text: "1em",
    circle: "25px",
    rectangle: "93px",
};
export class Skeleton {
    constructor() {
        this.appearance = "default";
        this.light = false;
        this.variant = "rectangle";
    }
    render() {
        const { variant, light, appearance, el } = this;
        const style = !el.firstElementChild
            ? {
                height: el.style.height || DEFAULT_HEIGHTS[variant],
                width: el.style.width || (variant === "circle" ? "25px" : "260px"),
            }
            : undefined;
        return (h(Host, { class: {
                skeleton: true,
                circle: variant === "circle",
                light: light || appearance === "light",
            }, style: style, "aria-disabled": "true" }, h("slot", null)));
    }
    static get is() { return "ic-skeleton"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-skeleton.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-skeleton.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"light\" | \"default\"",
                    "resolved": "\"default\" | \"light\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the skeleton."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "light": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `appearance` to \"light\" instead."
                        }],
                    "text": ""
                },
                "attribute": "light",
                "reflect": false,
                "defaultValue": "false"
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSkeletonVariants",
                    "resolved": "\"circle\" | \"rectangle\" | \"text\"",
                    "references": {
                        "IcSkeletonVariants": {
                            "location": "import",
                            "path": "./ic-skeleton.types",
                            "id": "src/components/ic-skeleton/ic-skeleton.types.ts::IcSkeletonVariants"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The variant of the skeleton that will be displayed."
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "\"rectangle\""
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-skeleton.js.map
