import { Host, h } from "@stencil/core";
import { onComponentRequiredPropUndefined } from "../../utils/helpers";
export class StatusTag {
    constructor() {
        this.announced = false;
        this.appearance = undefined;
        this.label = undefined;
        this.size = "default";
        this.small = false;
        this.status = "neutral";
        this.variant = "filled";
    }
    componentWillLoad() {
        if (this.appearance === "outlined") {
            this.variant = "outlined";
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Status Tag");
    }
    render() {
        const { label, status, appearance, variant, small, size, announced } = this;
        return (h(Host, { role: announced ? "status" : null, "aria-label": "Status" }, h("strong", { class: {
                ["tag"]: true,
                [`${appearance}-${status}`]: appearance !== undefined,
                [`${variant}-${status}`]: true,
                ["outlined"]: variant === "outlined",
                ["small"]: small || size === "small",
                [`${size}`]: true,
            } }, h("ic-typography", { variant: "label-uppercase", "apply-vertical-margins": false }, h("span", null, label)))));
    }
    static get is() { return "ic-status-tag"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-status-tag.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-status-tag.css"]
        };
    }
    static get properties() {
        return {
            "announced": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, role='status' is added to the component and it will act as an 'aria-live' region.\nScreen readers will announce changes to the `label`, but not the initial value."
                },
                "attribute": "announced",
                "reflect": false,
                "defaultValue": "false"
            },
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStatusTagAppearance",
                    "resolved": "\"filled\" | \"outlined\"",
                    "references": {
                        "IcStatusTagAppearance": {
                            "location": "import",
                            "path": "./ic-status-tag.types",
                            "id": "src/components/ic-status-tag/ic-status-tag.types.ts::IcStatusTagAppearance"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Use variant prop instead."
                        }],
                    "text": ""
                },
                "attribute": "appearance",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The content rendered within the status tag."
                },
                "attribute": "label",
                "reflect": false
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the status tag component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "status": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStatusTagStatuses",
                    "resolved": "\"danger\" | \"neutral\" | \"success\" | \"warning\"",
                    "references": {
                        "IcStatusTagStatuses": {
                            "location": "import",
                            "path": "./ic-status-tag.types",
                            "id": "src/components/ic-status-tag/ic-status-tag.types.ts::IcStatusTagStatuses"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The colour of the status tag."
                },
                "attribute": "status",
                "reflect": false,
                "defaultValue": "\"neutral\""
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcEmphasisType",
                    "resolved": "\"filled\" | \"outlined\"",
                    "references": {
                        "IcEmphasisType": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcEmphasisType"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The emphasis of the status tag."
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "\"filled\""
            }
        };
    }
}
//# sourceMappingURL=ic-status-tag.js.map
