import { Host, h } from "@stencil/core";
import checkIcon from "../../assets/check-icon.svg";
import warningIcon from "../../assets/warning-icon-outline.svg";
import { isPropDefined } from "../../utils/helpers";
export class Step {
    constructor() {
        this.compactStepStyling = undefined;
        this.current = false;
        this.lastStep = undefined;
        this.lastStepNum = undefined;
        this.nextStepTitle = undefined;
        this.progress = undefined;
        this.stepNum = undefined;
        this.stepStatus = undefined;
        this.stepSubtitle = undefined;
        this.stepTitle = undefined;
        this.variant = undefined;
        this.stepType = "active";
    }
    stepTypeChangeHandler() {
        if (this.variant === "compact" && this.stepType === "current") {
            this.current = true;
        }
        else {
            this.current = false;
        }
    }
    render() {
        var _a;
        // ARIA LABEL
        let ariaLabel = "";
        if (this.stepType === "completed") {
            ariaLabel = ". Completed step";
        }
        else if (this.stepType === "disabled") {
            ariaLabel = ". Non-required step";
        }
        else if (this.stepStatus === "required") {
            ariaLabel = ". Required step";
        }
        else if (this.stepStatus === "optional") {
            ariaLabel = ". Optional step";
        }
        // STEP STATUS
        let stepStatus;
        if (isPropDefined(this.stepStatus)) {
            stepStatus = this.stepStatus[0].toUpperCase() + this.stepStatus.slice(1);
        }
        // STEP TYPE
        let stepType;
        if (this.stepType === "disabled" ||
            this.compactStepStyling === "disabled") {
            stepType = "Not required";
        }
        else if (this.compactStepStyling === "completed") {
            stepType = "Completed";
        }
        // STATUS ICON FOR COMPACT STEP
        let statusIcon;
        if (this.stepType === "completed" ||
            this.compactStepStyling === "completed") {
            statusIcon = (h("span", { class: "check-icon step-icon", "aria-hidden": "true", innerHTML: checkIcon }));
        }
        else if (this.stepType === "disabled" ||
            this.compactStepStyling === "disabled") {
            statusIcon = (h("span", { class: "warning-icon step-icon", "aria-hidden": "true", innerHTML: warningIcon }));
        }
        // COMPACT STEP COMPONENT
        const compactStep = (h("div", { class: {
                ["step"]: true,
                ["current"]: this.current,
                [`compact-step-${this.compactStepStyling}`]: !!this.compactStepStyling,
            } }, h("ic-loading-indicator", { class: {
                "compact-step-progress-indicator": true,
                "not-required": this.stepType === "disabled" ||
                    this.compactStepStyling === "disabled",
            }, "aria-hidden": "true", size: "small", "inner-label": this.stepNum, progress: this.progress }), h("div", { class: "step-title-area" }, h("ic-typography", { variant: "h4", class: "step-title" }, this.stepTitle), h("div", { class: "info-line" }, h("ic-typography", { variant: "caption", class: "step-num" }, `${this.stepNum} of ${this.lastStepNum}`, h("span", { class: "visually-hidden" }, " steps")), (this.stepSubtitle ||
            this.stepType === "completed" ||
            this.stepType === "disabled" ||
            (this.variant === "compact" &&
                !!this.compactStepStyling &&
                this.compactStepStyling !== "active") ||
            !!this.stepStatus) && (h("div", { class: "step-status" }, statusIcon !== undefined && statusIcon, (this.stepSubtitle || stepType) && (h("ic-typography", { variant: "caption" }, this.stepSubtitle !== null &&
            isPropDefined(this.stepSubtitle)
            ? this.stepSubtitle
            : this.stepType === "disabled" ||
                (this.variant === "compact" &&
                    this.compactStepStyling === "disabled") ||
                this.stepType === "completed" ||
                (this.variant === "compact" &&
                    this.compactStepStyling === "completed")
                ? stepType
                : this.stepStatus && stepStatus))))), this.lastStep ? (h("ic-typography", { variant: "subtitle-small", class: "next-step" }, "Last step")) : (isPropDefined(this.nextStepTitle) && (h("ic-typography", { variant: "subtitle-small", class: "next-step" }, "Next", h("span", { class: "visually-hidden" }, " step is"), ":", " ", this.nextStepTitle))))));
        // ICON FOR DEFAULT STEP
        let icon;
        if (this.stepType !== "completed") {
            icon = (h("ic-typography", { variant: "subtitle-small" }, h("span", { class: "step-icon-inner", "aria-hidden": "true" }, this.stepNum)));
        }
        else {
            icon = (h("div", { class: "step-icon-inner", "aria-hidden": "true" }, h("span", { class: "check-icon", innerHTML: checkIcon })));
        }
        // STEP CONNECT FOR DEFAULT STEP
        const partialBar = this.stepType === "current" && (h("div", { class: "step-connect-inner" }));
        const finalStep = !this.lastStep && (h("div", { class: {
                ["step-connect"]: true,
                ["aligned-full-width"]: this.el.parentElement.classList.contains("default") &&
                    !this.el.parentElement.classList.contains("aligned-left"),
            } }, partialBar));
        // DEFAULT STEP COMPONENT
        const defaultStep = (h("div", { class: {
                ["step"]: true,
                [`${this.stepType}`]: true,
            } }, h("div", { class: "step-top" }, h("div", { class: "step-icon" }, icon), finalStep), (this.stepTitle || this.stepSubtitle || this.stepStatus) && (h("div", { class: "step-title-area" }, this.stepTitle && (h("ic-typography", { variant: "subtitle-large", class: "step-title" }, this.stepTitle)), this.stepTitle && (this.stepSubtitle || this.stepStatus) && (h("ic-typography", { variant: "caption", class: "step-subtitle" }, this.stepSubtitle !== null && isPropDefined(this.stepSubtitle)
            ? this.stepSubtitle
            : stepStatus))))));
        return (h(Host, { role: "listitem", "aria-label": `Step ${this.stepNum}${ariaLabel}`, "aria-current": (this.current || this.stepType === "current") && "step", class: {
                ["aligned-full-width"]: this.el.parentElement.classList.contains("default") &&
                    !this.el.parentElement.classList.contains("aligned-left"),
                [`${this.variant}`]: true,
                ["light"]: ((_a = this.el.parentElement) === null || _a === void 0 ? void 0 : _a.appearance) ===
                    "light",
            } }, this.variant === "compact" ? compactStep : defaultStep));
    }
    static get is() { return "ic-step"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-step.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-step.css"]
        };
    }
    static get properties() {
        return {
            "compactStepStyling": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStepTypes",
                    "resolved": "\"active\" | \"completed\" | \"current\" | \"disabled\"",
                    "references": {
                        "IcStepTypes": {
                            "location": "import",
                            "path": "./ic-step.types",
                            "id": "src/components/ic-step/ic-step.types.ts::IcStepTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If a compact stepper is being used, this sets the styling of the step."
                        }],
                    "text": ""
                },
                "attribute": "compact-step-styling",
                "reflect": false
            },
            "current": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, and a compact stepper  is being used, the current step will be the only step in view."
                        }],
                    "text": ""
                },
                "attribute": "current",
                "reflect": false,
                "defaultValue": "false"
            },
            "lastStep": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the step will be marked as being the last one in the series. This is managed by ic-stepper."
                        }],
                    "text": ""
                },
                "attribute": "last-step",
                "reflect": false
            },
            "lastStepNum": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The step number of the final step. This is managed by ic-stepper."
                        }],
                    "text": ""
                },
                "attribute": "last-step-num",
                "reflect": false
            },
            "nextStepTitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The name of the next step. This is managed by ic-stepper."
                        }],
                    "text": ""
                },
                "attribute": "next-step-title",
                "reflect": false
            },
            "progress": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The progress of the next step, calculated by dividing the current step number by the total number of steps. This is managed by ic-stepper."
                        }],
                    "text": ""
                },
                "attribute": "progress",
                "reflect": false
            },
            "stepNum": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The step number, managed by ic-stepper."
                        }],
                    "text": ""
                },
                "attribute": "step-num",
                "reflect": false
            },
            "stepStatus": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStepStatuses",
                    "resolved": "\"optional\" | \"required\"",
                    "references": {
                        "IcStepStatuses": {
                            "location": "import",
                            "path": "./ic-step.types",
                            "id": "src/components/ic-step/ic-step.types.ts::IcStepStatuses"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The status of the step. Use this prop to display a status message on the step if it is required or optional."
                },
                "attribute": "step-status",
                "reflect": false
            },
            "stepSubtitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Additional information about the step. Use this prop to override the default step status messaging displayed when selecting a step type or step status."
                },
                "attribute": "step-subtitle",
                "reflect": false
            },
            "stepTitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The title of the step within the stepper."
                },
                "attribute": "step-title",
                "reflect": false
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStepVariants",
                    "resolved": "\"compact\" | \"default\"",
                    "references": {
                        "IcStepVariants": {
                            "location": "import",
                            "path": "./ic-step.types",
                            "id": "src/components/ic-step/ic-step.types.ts::IcStepVariants"
                        }
                    }
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The variant of the step. This is managed by ic-stepper."
                        }],
                    "text": ""
                },
                "attribute": "variant",
                "reflect": false
            },
            "stepType": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcStepTypes",
                    "resolved": "\"active\" | \"completed\" | \"current\" | \"disabled\"",
                    "references": {
                        "IcStepTypes": {
                            "location": "import",
                            "path": "./ic-step.types",
                            "id": "src/components/ic-step/ic-step.types.ts::IcStepTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The state of the step within the stepper."
                },
                "attribute": "step-type",
                "reflect": false,
                "defaultValue": "\"active\""
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "stepType",
                "methodName": "stepTypeChangeHandler"
            }];
    }
}
//# sourceMappingURL=ic-step.js.map
