import { Host, h, } from "@stencil/core";
import { getInputDescribedByText, onComponentRequiredPropUndefined, renderHiddenInput, addFormResetListener, removeFormResetListener, removeDisabledFalse, } from "../../utils/helpers";
let inputIds = 0;
/**
 * @slot right-adornment - Content is placed to the right of switch before state label.
 */
export class Switch {
    constructor() {
        this.inputId = `ic-switch-input-${inputIds++}`;
        this.handleChange = () => {
            this.checkedState = !this.checkedState;
            this.icChange.emit({
                checked: this.checkedState,
                value: this.value,
            });
        };
        this.onFocus = () => {
            this.icFocus.emit();
        };
        this.onBlur = () => {
            this.icBlur.emit();
        };
        this.handleFormReset = () => {
            this.checkedState = this.initiallyChecked;
        };
        this.checkedState = false;
        this.initiallyChecked = this.checked;
        this.checked = false;
        this.disabled = false;
        this.helperText = "";
        this.hideLabel = false;
        this.label = undefined;
        this.name = this.inputId;
        this.showState = false;
        this.size = "default";
        this.small = false;
        this.value = "on";
    }
    checkedChangeHandler() {
        this.checkedState = this.checked;
    }
    disconnectedCallback() {
        removeFormResetListener(this.el, this.handleFormReset);
    }
    componentWillLoad() {
        this.checkedState = this.checked;
        addFormResetListener(this.el, this.handleFormReset);
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Switch");
    }
    /**
     * Sets focus on the switch.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("input")) {
            this.el.shadowRoot.querySelector("input").focus();
        }
    }
    render() {
        const { label, checkedState, small, size, disabled, name, showState, value, hideLabel, helperText, inputId, } = this;
        renderHiddenInput(true, this.el, name, checkedState ? value : "", disabled);
        const describedBy = getInputDescribedByText(inputId, helperText !== "", false);
        return (h(Host, null, h("label", { class: {
                ["ic-switch-container"]: true,
                ["ic-switch-disabled"]: disabled,
                ["ic-switch-small"]: small || size === "small",
            }, htmlFor: inputId }, !hideLabel && (h("ic-input-label", { for: inputId, label: label, helperText: helperText, readonly: true, disabled: disabled, class: {
                ["ic-switch-label"]: true,
                ["ic-switch-label-small"]: small || size === "small",
            } })), !hideLabel && h("span", { class: "ic-switch-line-break" }), h("input", { checked: checkedState, disabled: disabled, "aria-label": label, "aria-checked": checkedState ? "true" : "false", "aria-describedby": describedBy, role: "switch", class: "ic-switch-input", type: "checkbox", name: "toggle", id: inputId, onFocus: this.onFocus, onBlur: this.onBlur, onChange: this.handleChange }), h("span", { class: "ic-switch-toggle" }, h("svg", { class: "ic-switch-icon", "aria-hidden": "true", focusable: "false", viewBox: "0 0 10 10", xmlns: "http://www.w3.org/2000/svg" }, h("line", { class: "ic-switch-icon-line", x1: "9", y1: small || size === "small" ? "2" : "1", x2: "9", y2: small || size === "small" ? "8" : "9" })), h("svg", { class: "ic-switch-icon", "aria-hidden": "true", focusable: "false", viewBox: "0 0 10 10", xmlns: "http://www.w3.org/2000/svg" }, h("circle", { class: "ic-switch-icon-circle", fill: "none", cx: "5", cy: "5", r: small || size === "small" ? "3.335" : "4.445" }))), h("slot", { name: "right-adornment" }), showState && (h("ic-typography", { "aria-hidden": "true", variant: "label", class: "ic-switch-checked-status" }, checkedState ? "On" : "Off")))));
    }
    static get is() { return "ic-switch"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-switch.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-switch.css"]
        };
    }
    static get properties() {
        return {
            "checked": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the switch will display as checked."
                },
                "attribute": "checked",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The helper text that will be displayed for additional field guidance."
                },
                "attribute": "helper-text",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "hideLabel": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the label will be hidden and the required label value will be applied as an aria-label."
                },
                "attribute": "hide-label",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The aria-label applied to the switch when no visual 'name' is provided."
                },
                "attribute": "label",
                "reflect": false
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The name of the control, which is submitted with the form data."
                },
                "attribute": "name",
                "reflect": false,
                "defaultValue": "this.inputId"
            },
            "showState": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the switch will render the On/Off state text."
                },
                "attribute": "show-state",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizesNoLarge",
                    "resolved": "\"default\" | \"small\"",
                    "references": {
                        "IcSizesNoLarge": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizesNoLarge"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the switch component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string | null",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The value of the toggle does not mean if it's checked or not, use the `checked`\nproperty for that.\n\nThe value of a toggle is analogous to the value of a `<input type=\"checkbox\">`,\nit's only used when the toggle participates in a native `<form>`."
                },
                "attribute": "value",
                "reflect": false,
                "defaultValue": "\"on\""
            }
        };
    }
    static get states() {
        return {
            "checkedState": {},
            "initiallyChecked": {}
        };
    }
    static get events() {
        return [{
                "method": "icBlur",
                "name": "icBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the toggle loses focus."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "icChange",
                "name": "icChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the value property has changed."
                },
                "complexType": {
                    "original": "IcSwitchChangeEventDetail",
                    "resolved": "IcSwitchChangeEventDetail",
                    "references": {
                        "IcSwitchChangeEventDetail": {
                            "location": "import",
                            "path": "./ic-switch.types",
                            "id": "src/components/ic-switch/ic-switch.types.ts::IcSwitchChangeEventDetail"
                        }
                    }
                }
            }, {
                "method": "icFocus",
                "name": "icFocus",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the toggle has focus."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the switch.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "checked",
                "methodName": "checkedChangeHandler"
            }];
    }
}
//# sourceMappingURL=ic-switch.js.map
