import { Host, h } from "@stencil/core";
import { onComponentRequiredPropUndefined } from "../../utils/helpers";
import { IcThemeForegroundEnum, } from "../../utils/types";
export class TabGroup {
    constructor() {
        this.appearance = "dark";
        this.contextId = "default";
        this.inline = false;
        this.label = undefined;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Tab Group");
    }
    render() {
        const { appearance, label } = this;
        return (h(Host, { role: "tablist", "aria-label": label, class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["inline"]: this.inline,
            } }, h("ic-horizontal-scroll", { appearance: appearance === IcThemeForegroundEnum.Dark
                ? IcThemeForegroundEnum.Default
                : appearance, "focus-trigger": "tabFocus" }, h("div", { class: "tabs-container" }, h("slot", null)))));
    }
    static get is() { return "ic-tab-group"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-tab-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-tab-group.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForegroundNoDefault",
                    "resolved": "\"dark\" | \"light\"",
                    "references": {
                        "IcThemeForegroundNoDefault": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForegroundNoDefault"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The appearance of the tab group, e.g dark, or light."
                        }],
                    "text": ""
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"dark\""
            },
            "contextId": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This is no longer required.\nThe context id is passed down from `ic-tab-context`"
                        }],
                    "text": ""
                },
                "attribute": "context-id",
                "reflect": true,
                "defaultValue": "\"default\""
            },
            "inline": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the tabs and tab panels will be positioned separately."
                },
                "attribute": "inline",
                "reflect": true,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label to describe the purpose of the set of tabs to screen reader users."
                },
                "attribute": "label",
                "reflect": false
            }
        };
    }
}
//# sourceMappingURL=ic-tab-group.js.map
