import { Host, h, } from "@stencil/core";
import { IcThemeForegroundEnum, } from "../../utils/types";
export class TabPanel {
    constructor() {
        this.appearance = "dark";
        this.contextId = "default";
    }
    connectedCallback() {
        this.tabPanelCreated.emit(this.el);
    }
    disconnectedCallback() {
        var _a;
        (_a = document
            .querySelector(`ic-tab-context[context-id=${this.contextId}]`)) === null || _a === void 0 ? void 0 : _a.tabRemovedHandler();
    }
    render() {
        return (h(Host, { class: {
                "ic-tab-panel-light": this.appearance === IcThemeForegroundEnum.Light,
            }, role: "tabpanel" }, h("div", null, h("slot", null))));
    }
    static get is() { return "ic-tab-panel"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-tab-panel.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-tab-panel.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForegroundNoDefault",
                    "resolved": "\"dark\" | \"light\"",
                    "references": {
                        "IcThemeForegroundNoDefault": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForegroundNoDefault"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The appearance of the tabs, e.g dark, or light."
                        }],
                    "text": ""
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"dark\""
            },
            "contextId": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This is no longer required.\nThe context id is passed down from `ic-tab-context`"
                        }],
                    "text": ""
                },
                "attribute": "context-id",
                "reflect": true,
                "defaultValue": "\"default\""
            }
        };
    }
    static get events() {
        return [{
                "method": "tabPanelCreated",
                "name": "tabPanelCreated",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab panel is dynamically created."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "HTMLIcTabPanelElement",
                    "resolved": "HTMLIcTabPanelElement",
                    "references": {
                        "HTMLIcTabPanelElement": {
                            "location": "global",
                            "id": "global::HTMLIcTabPanelElement"
                        }
                    }
                }
            }, {
                "method": "tabPanelRemoved",
                "name": "tabPanelRemoved",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab panel is unmounted."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-tab-panel.js.map
