import { Host, h, } from "@stencil/core";
import { IcThemeForegroundEnum, } from "../../utils/types";
import { isSlotUsed, removeDisabledFalse } from "../../utils/helpers";
/**
 * @slot icon - Content will be rendered next to the tab label.
 * @slot badge - Badge component displayed inline with the tab.
 */
export class Tab {
    constructor() {
        this.focusFromClick = false;
        this.isInitialRender = true;
        this.handleClick = () => {
            this.tabClick.emit({
                tabId: this.tabId,
                contextId: this.contextId,
                position: this.tabPosition,
            });
            if (this.focusFromClick) {
                this.tabFocus.emit({
                    tabId: this.tabId,
                    contextId: this.contextId,
                    position: this.tabPosition,
                });
                this.focusFromClick = false;
            }
        };
        this.handleFocus = () => {
            if (!this.focusFromClick) {
                this.focusTabId = this.tabId;
                this.tabFocus.emit({
                    tabId: this.tabId,
                    contextId: this.contextId,
                    position: this.tabPosition,
                });
            }
        };
        this.handleMouseDown = () => {
            //set flag so that focus gets handled after click
            //there is a timing issue where a long click only causes focus to happen & not the click
            //the focus does need to be a separate event though to handle focus from keyboard
            this.focusFromClick = true;
        };
        this.appearance = "dark";
        this.contextId = "default";
        this.disabled = false;
        this.selected = false;
        this.tabId = undefined;
        this.tabPosition = undefined;
    }
    disabledWatchHandler() {
        this.tabEnabled.emit();
    }
    connectedCallback() {
        this.tabCreated.emit(this.el);
    }
    disconnectedCallback() {
        var _a;
        (_a = document
            .querySelector(`ic-tab-context[context-id=${this.contextId}]`)) === null || _a === void 0 ? void 0 : _a.tabRemovedHandler(!!this.focusTabId);
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidUpdate() {
        this.isInitialRender = false;
    }
    /**
     * Sets focus on the tab.
     */
    async setFocus() {
        if (this.el) {
            this.el.focus();
        }
    }
    render() {
        const { disabled, selected, appearance, isInitialRender, handleClick, handleFocus, handleMouseDown, } = this;
        return (h(Host, { class: {
                "with-transition": !isInitialRender,
                "ic-tab-light": appearance === IcThemeForegroundEnum.Light,
                selected,
                disabled,
            }, role: "tab", "aria-selected": `${selected}`, onClick: handleClick, onFocus: handleFocus, onMouseDown: handleMouseDown, "aria-disabled": `${disabled}`, tabindex: selected ? 0 : -1 }, isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), h("ic-typography", { class: "ic-tab-label", variant: "label" }, h("span", null, h("slot", null))), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" })));
    }
    static get is() { return "ic-tab"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-tab.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-tab.css"]
        };
    }
    static get properties() {
        return {
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForegroundNoDefault",
                    "resolved": "\"dark\" | \"light\"",
                    "references": {
                        "IcThemeForegroundNoDefault": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForegroundNoDefault"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Determines whether the light or dark variant of the tabs should be displayed."
                        }],
                    "text": ""
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"dark\""
            },
            "contextId": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The unique context needed if using multiple tabs inside one another i.e. rendering another tabs inside a tab panel."
                        }],
                    "text": ""
                },
                "attribute": "context-id",
                "reflect": true,
                "defaultValue": "\"default\""
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the tab will display with a selected indicator and tabIndex will be set."
                        }],
                    "text": ""
                },
                "attribute": "selected",
                "reflect": true,
                "defaultValue": "false"
            },
            "tabId": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The shared ID between panel and tab."
                        }],
                    "text": ""
                },
                "attribute": "tab-id",
                "reflect": true
            },
            "tabPosition": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The position of the tab inside the tabs array in context."
                        }],
                    "text": ""
                },
                "attribute": "tab-position",
                "reflect": false
            }
        };
    }
    static get events() {
        return [{
                "method": "tabClick",
                "name": "tabClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab is selected."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcTabClickEventDetail",
                    "resolved": "IcTabClickEventDetail",
                    "references": {
                        "IcTabClickEventDetail": {
                            "location": "import",
                            "path": "./ic-tab.types",
                            "id": "src/components/ic-tab/ic-tab.types.ts::IcTabClickEventDetail"
                        }
                    }
                }
            }, {
                "method": "tabCreated",
                "name": "tabCreated",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab is dynamically created."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "HTMLIcTabElement",
                    "resolved": "HTMLIcTabElement",
                    "references": {
                        "HTMLIcTabElement": {
                            "location": "global",
                            "id": "global::HTMLIcTabElement"
                        }
                    }
                }
            }, {
                "method": "tabEnabled",
                "name": "tabEnabled",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab's disabled prop changes"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "tabFocus",
                "name": "tabFocus",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab is focussed."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcTabClickEventDetail",
                    "resolved": "IcTabClickEventDetail",
                    "references": {
                        "IcTabClickEventDetail": {
                            "location": "import",
                            "path": "./ic-tab.types",
                            "id": "src/components/ic-tab/ic-tab.types.ts::IcTabClickEventDetail"
                        }
                    }
                }
            }, {
                "method": "tabRemoved",
                "name": "tabRemoved",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when a tab is unmounted."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the tab.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "disabled",
                "methodName": "disabledWatchHandler"
            }];
    }
}
//# sourceMappingURL=ic-tab.js.map
