import { Host, h, forceUpdate, } from "@stencil/core";
import { IcInformationStatus, } from "../../utils/types";
import { inheritAttributes, debounceEvent, getInputDescribedByText, renderHiddenInput, isEmptyString, onComponentRequiredPropUndefined, addFormResetListener, removeFormResetListener, isSlotUsed, removeDisabledFalse, checkSlotInChildMutations, } from "../../utils/helpers";
import { IC_INHERITED_ARIA } from "../../utils/constants";
let inputIds = 0;
const MUTABLE_ATTRIBUTES = [...IC_INHERITED_ARIA, "title"];
/**
 * @slot icon - Content will be placed to the left of the text input.
 */
export class TextField {
    constructor() {
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        this.getMaxLengthExceeded = (value) => {
            this.numChars = value.length;
            if (this.type === "number") {
                this.minValueUnattained = value && Number(value) < Number(this.min);
                this.maxValueExceeded = Number(value) > Number(this.max);
            }
            if (this.maxLength > 0) {
                this.maxLengthExceeded = this.numChars > this.maxLength;
            }
        };
        this.getMaxCharactersReached = (value) => {
            this.numChars = value.length;
            this.maxCharactersReached =
                this.maxCharacters > 0 ? this.numChars >= this.maxCharacters : false;
            if (this.maxCharactersError && !this.maxCharactersReached) {
                this.maxCharactersError = false;
            }
        };
        this.onInput = (ev) => {
            this.value = ev.target.value;
            this.icInput.emit({ value: this.value });
        };
        this.onBlur = (ev) => {
            const value = ev.target.value;
            this.numChars = value.length;
            this.minCharactersUnattained =
                this.minCharacters > 0 ? this.numChars < this.minCharacters : false;
            this.icBlur.emit({ value: value });
        };
        this.onFocus = (ev) => {
            this.icFocus.emit({ value: ev.target.value });
        };
        this.hasStatus = (status) => status !== "" && !this.disabled;
        this.handleFormReset = () => {
            this.value = this.initialValue;
        };
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName, type, addedNodes, removedNodes }) => {
                if (MUTABLE_ATTRIBUTES.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
                else if (type === "childList") {
                    forceComponentUpdate = checkSlotInChildMutations(addedNodes, removedNodes, "icon");
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.numChars = 0;
        this.maxCharactersReached = false;
        this.maxCharactersError = false;
        this.minCharactersUnattained = false;
        this.maxLengthExceeded = false;
        this.maxValueExceeded = false;
        this.minValueUnattained = false;
        this.ariaActiveDescendant = undefined;
        this.ariaAutocomplete = undefined;
        this.ariaExpanded = undefined;
        this.ariaOwns = undefined;
        this.autocapitalize = "off";
        this.autocomplete = "off";
        this.autocorrect = "off";
        this.autoFocus = false;
        this.disabled = false;
        this.fullWidth = false;
        this.helperText = "";
        this.hideLabel = false;
        this.hiddenInput = true;
        this.inputId = `ic-text-field-input-${inputIds++}`;
        this.inputmode = "text";
        this.label = undefined;
        this.max = undefined;
        this.maxCharacters = 0;
        this.maxLength = 0;
        this.maxLengthMessage = "Maximum length exceeded";
        this.min = undefined;
        this.minCharacters = 0;
        this.name = this.inputId;
        this.placeholder = "";
        this.readonly = false;
        this.required = false;
        this.resize = false;
        this.role = undefined;
        this.rows = 1;
        this.size = "default";
        this.small = false;
        this.spellcheck = false;
        this.truncateValue = undefined;
        this.type = "text";
        this.validationInline = false;
        this.validationInlineInternal = false;
        this.validationStatus = "";
        this.validationText = "";
        this.debounce = 0;
        this.value = "";
        this.initialValue = this.value;
    }
    debounceChanged() {
        this.icChange = debounceEvent(this.icChange, this.debounce);
    }
    watchValueHandler(newValue) {
        if (this.inputEl && this.inputEl.value !== newValue) {
            this.inputEl.value = newValue;
        }
        this.getMaxLengthExceeded(newValue);
        this.getMaxCharactersReached(newValue);
        this.icChange.emit({ value: newValue });
    }
    connectedCallback() {
        this.debounceChanged();
    }
    disconnectedCallback() {
        var _a;
        removeFormResetListener(this.el, this.handleFormReset);
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        if (this.value !== this.initialValue) {
            this.watchValueHandler(this.value);
        }
        this.getMaxLengthExceeded(this.value);
        this.getMaxCharactersReached(this.value);
        this.inheritedAttributes = inheritAttributes(this.el, MUTABLE_ATTRIBUTES);
        if (this.readonly) {
            this.maxLengthExceeded = false;
            this.maxValueExceeded = false;
            this.minValueUnattained = false;
        }
        addFormResetListener(this.el, this.handleFormReset);
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Text Field");
        if (this.validationInlineInternal) {
            this.getValidationText.emit({ value: this.validationText });
        }
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
            childList: true,
        });
    }
    handleKeyDown(ev) {
        this.icKeydown.emit({ event: ev });
        this.maxCharactersError = this.maxCharactersReached;
    }
    /**
     * Sets focus on the native `input`.
     */
    async setFocus() {
        var _a;
        (_a = this.inputEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { inputId, name, label, required, size, small, placeholder, helperText, rows, resize, disabled, value, min, max, maxLength, numChars, readonly, maxLengthExceeded, maxCharacters, maxCharactersError, maxCharactersReached, minCharacters, minCharactersUnattained, minValueUnattained, maxValueExceeded, validationStatus, validationText, validationInline, validationInlineInternal, spellcheck, inputmode, fullWidth, truncateValue, hiddenInput, } = this;
        const disabledMode = readonly || disabled;
        const currentStatus = maxLengthExceeded ||
            maxValueExceeded ||
            minValueUnattained ||
            minCharactersUnattained ||
            maxCharactersError
            ? maxCharactersError
                ? IcInformationStatus.Warning
                : IcInformationStatus.Error
            : validationStatus;
        const currentValidationText = maxLengthExceeded
            ? this.maxLengthMessage
            : maxCharactersError
                ? `Maximum input is ${maxCharacters} characters`
                : maxValueExceeded
                    ? `Maximum value of ${max} exceeded`
                    : minValueUnattained
                        ? `Minimum value of ${min} not met`
                        : minCharactersUnattained
                            ? `Minimum input is ${minCharacters} characters`
                            : validationText;
        const maxNumChars = readonly ? 0 : maxLength;
        const messageAriaLive = maxLengthExceeded ||
            maxCharactersError ||
            maxValueExceeded ||
            minValueUnattained ||
            (maxLength === 0 && currentStatus === IcInformationStatus.Error)
            ? "assertive"
            : "polite";
        const showStatusText = this.hasStatus(currentStatus) &&
            !(currentStatus == IcInformationStatus.Success && validationInline) &&
            !validationInlineInternal;
        const multiline = rows > 1;
        const hiddenCharCountDescId = maxLength > 0 ? `${inputId}-charcount-desc` : "";
        const describedBy = `${hiddenCharCountDescId} ${getInputDescribedByText(inputId, helperText !== "", showStatusText)}`.trim();
        const disabledText = disabledMode && !readonly;
        const showLeftIcon = !!this.el.querySelector(`[slot="icon"]`) && !disabledText;
        const invalid = `${currentStatus === IcInformationStatus.Error}`;
        if (hiddenInput) {
            renderHiddenInput(true, this.el, name, value, disabledMode);
        }
        return (h(Host, { class: { ["fullwidth"]: fullWidth } }, h("ic-input-container", { readonly: readonly, disabled: disabledMode }, !this.hideLabel && (h("ic-input-label", { for: inputId, label: label, helperText: helperText, required: required, disabled: disabledText, readonly: readonly })), h("ic-input-component-container", { size: small ? "small" : size, validationStatus: currentStatus, multiLine: multiline, disabled: disabledMode, readonly: readonly, validationInline: validationInline, fullWidth: fullWidth }, showLeftIcon && (h("span", { class: {
                ["readonly"]: readonly,
                ["has-value"]: value.length > 0,
            }, slot: "left-icon" }, h("slot", { name: "icon" }))), !multiline ? (h("input", Object.assign({ id: inputId, name: name, ref: (el) => (this.inputEl = el), type: this.type, min: min, max: max, value: value, class: {
                ["no-left-pad"]: !showLeftIcon && readonly,
                ["readonly"]: readonly,
                ["truncate-value"]: truncateValue,
            }, placeholder: placeholder ? placeholder : "", required: required, disabled: disabledMode, readonly: readonly, onInput: this.onInput, onBlur: this.onBlur, onFocus: this.onFocus, "aria-label": label, "aria-describedby": describedBy, "aria-invalid": invalid, "aria-activedescendant": this.ariaActiveDescendant, "aria-expanded": this.ariaExpanded, "aria-owns": this.ariaOwns, autocomplete: this.autocomplete, autocapitalize: this.autocapitalize, autoFocus: this.autoFocus, spellcheck: spellcheck, inputmode: inputmode, role: this.role, maxlength: maxCharactersReached ? maxCharacters : null, minlength: minCharactersUnattained ? minCharacters : null }, this.inheritedAttributes))) : (h("textarea", Object.assign({ id: inputId, class: {
                ["no-resize"]: resize === false || readonly,
                ["no-left-pad"]: !showLeftIcon && readonly,
                ["readonly"]: readonly,
            }, name: name, ref: (el) => (this.inputEl = el), value: value, rows: rows, required: required, disabled: disabledMode, placeholder: placeholder ? placeholder : "", readonly: readonly, onInput: this.onInput, onBlur: this.onBlur, onFocus: this.onFocus, "aria-label": label, "aria-describedby": describedBy, "aria-invalid": invalid, autocapitalize: this.autocapitalize, autoFocus: this.autoFocus, spellcheck: spellcheck, inputmode: inputmode, maxlength: maxCharactersReached ? maxCharacters : null, minlength: minCharactersUnattained ? minCharacters : null }, this.inheritedAttributes))), isSlotUsed(this.el, "clear-button") && (h("slot", { name: "clear-button" })), isSlotUsed(this.el, "search-submit-button") && (h("slot", { name: "search-submit-button" }))), isSlotUsed(this.el, "menu") && h("slot", { name: "menu" }), (!isEmptyString(validationStatus) ||
            !isEmptyString(validationText) ||
            maxNumChars > 0 ||
            maxValueExceeded ||
            maxCharactersError ||
            minCharactersUnattained ||
            minValueUnattained) &&
            !validationInlineInternal && (h("ic-input-validation", { status: this.hasStatus(currentStatus) === false ||
                (currentStatus === IcInformationStatus.Success &&
                    validationInline) ||
                validationInlineInternal
                ? ""
                : currentStatus, message: showStatusText ? currentValidationText : "", ariaLiveMode: messageAriaLive, for: inputId, fullWidth: fullWidth }, !readonly && maxNumChars > 0 && (h("div", { slot: "validation-message-adornment" }, h("ic-typography", { variant: "caption", class: {
                ["maxlengthtext"]: true,
                ["error"]: maxLengthExceeded,
                ["disabled"]: disabledText,
            } }, h("span", { "aria-live": "polite", id: `${inputId}-charcount`, class: "charcount" }, numChars, "/", maxNumChars), h("span", { hidden: true, id: hiddenCharCountDescId }, "Field can contain a maximum of ", maxNumChars, " characters.")))))))));
    }
    static get is() { return "ic-text-field"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-text-field.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-text-field.css"]
        };
    }
    static get properties() {
        return {
            "ariaActiveDescendant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "The active element when focus is on the ic-menu items."
                        }],
                    "text": ""
                },
                "attribute": "aria-active-descendant",
                "reflect": false
            },
            "ariaAutocomplete": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAriaAutocompleteTypes",
                    "resolved": "\"inline\" | \"list\"",
                    "references": {
                        "IcAriaAutocompleteTypes": {
                            "location": "import",
                            "path": "./ic-text-field.types",
                            "id": "src/components/ic-text-field/ic-text-field.types.ts::IcAriaAutocompleteTypes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Used to identify whether inputting any text triggers more predictions"
                        }],
                    "text": ""
                },
                "attribute": "aria-autocomplete",
                "reflect": false,
                "defaultValue": "undefined"
            },
            "ariaExpanded": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Used to identify if the slotted menu is rendered"
                        }],
                    "text": ""
                },
                "attribute": "aria-expanded",
                "reflect": false
            },
            "ariaOwns": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Used to identify any related child component"
                        }],
                    "text": ""
                },
                "attribute": "aria-owns",
                "reflect": false
            },
            "autocapitalize": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The automatic capitalisation of the text value as it is entered/edited by the user.\nAvailable options: \"off\", \"none\", \"on\", \"sentences\", \"words\", \"characters\"."
                },
                "attribute": "autocapitalize",
                "reflect": false,
                "defaultValue": "\"off\""
            },
            "autocomplete": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAutocompleteTypes",
                    "resolved": "\"name\" | \"on\" | \"off\" | \"honorific-prefix\" | \"given-name\" | \"additional-name\" | \"family-name\" | \"honorific-suffix\" | \"nickname\" | \"email\" | \"username\" | \"new-password\" | \"current-password\" | \"one-time-code\" | \"organization-title\" | \"organization\" | \"street-address\" | \"address-line1\" | \"address-line2\" | \"address-line3\" | \"address-level4\" | \"address-level3\" | \"address-level2\" | \"address-level1\" | \"country\" | \"country-name\" | \"postal-code\" | \"cc-name\" | \"cc-given-name\" | \"cc-additional-name\" | \"cc-family-name\" | \"cc-number\" | \"cc-exp\" | \"cc-exp-month\" | \"cc-exp-year\" | \"cc-csc\" | \"cc-type\" | \"transaction-currency\" | \"transaction-amount\" | \"language\" | \"bday\" | \"bday-day\" | \"bday-month\" | \"bday-year\" | \"sex\" | \"tel\" | \"tel-country-code\" | \"tel-national\" | \"tel-area-code\" | \"tel-local\" | \"tel-extension\" | \"impp\" | \"url\" | \"photo\"",
                    "references": {
                        "IcAutocompleteTypes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAutocompleteTypes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The state of autocompletion the browser can apply on the text value."
                },
                "attribute": "autocomplete",
                "reflect": false,
                "defaultValue": "\"off\""
            },
            "autocorrect": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcAutocorrectStates",
                    "resolved": "\"off\" | \"on\"",
                    "references": {
                        "IcAutocorrectStates": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcAutocorrectStates"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The state of autocorrection the browser can apply when the user is entering/editing the text value."
                },
                "attribute": "autocorrect",
                "reflect": false,
                "defaultValue": "\"off\""
            },
            "autoFocus": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the form control will have input focus when the page loads."
                },
                "attribute": "auto-focus",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the disabled state will be set."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Specify whether the text field fills the full width of the container.\nIf `true`, this overrides the --input-width CSS variable."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The helper text that will be displayed for additional field guidance."
                },
                "attribute": "helper-text",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "hideLabel": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the label will be hidden and the required label value will be applied as an aria-label."
                },
                "attribute": "hide-label",
                "reflect": false,
                "defaultValue": "false"
            },
            "hiddenInput": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the hidden form input will stop rendering for form submission."
                        }],
                    "text": ""
                },
                "attribute": "hidden-input",
                "reflect": false,
                "defaultValue": "true"
            },
            "inputId": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The ID for the input."
                },
                "attribute": "input-id",
                "reflect": false,
                "defaultValue": "`ic-text-field-input-${inputIds++}`"
            },
            "inputmode": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcTextFieldInputModes",
                    "resolved": "\"decimal\" | \"email\" | \"none\" | \"numeric\" | \"search\" | \"tel\" | \"text\" | \"url\"",
                    "references": {
                        "IcTextFieldInputModes": {
                            "location": "import",
                            "path": "./ic-text-field.types",
                            "id": "src/components/ic-text-field/ic-text-field.types.ts::IcTextFieldInputModes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "A hint to the browser for which keyboard to display.\nPossible values: `\"none\"`, `\"text\"`, `\"tel\"`, `\"url\"`,\n`\"email\"`, `\"numeric\"`, `\"decimal\"`, and `\"search\"`."
                },
                "attribute": "inputmode",
                "reflect": false,
                "defaultValue": "\"text\""
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The label for the input."
                },
                "attribute": "label",
                "reflect": false
            },
            "max": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | number",
                    "resolved": "number | string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The maximum number that can be accepted as a value, when `type` is `number` and `rows` is `1`. (NOTE: Ensure to include visual indication of max value in `helperText` or `label`)"
                },
                "attribute": "max",
                "reflect": false,
                "defaultValue": "undefined"
            },
            "maxCharacters": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The maximum number of characters that can be entered in the field. Will display an error if too many characters are entered."
                },
                "attribute": "max-characters",
                "reflect": false,
                "defaultValue": "0"
            },
            "maxLength": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The count of characters in the field. Will display a warning if the bound is reached."
                },
                "attribute": "max-length",
                "reflect": false,
                "defaultValue": "0"
            },
            "maxLengthMessage": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The text to display as the validation message when the maximum length is exceeded."
                },
                "attribute": "max-length-message",
                "reflect": false,
                "defaultValue": "\"Maximum length exceeded\""
            },
            "min": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | number",
                    "resolved": "number | string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The minimum number that can be accepted as a value, when `type` is `number` and `rows` is `1`. (NOTE: Ensure to include visual indication of min value in `helperText` or `label`)"
                },
                "attribute": "min",
                "reflect": false,
                "defaultValue": "undefined"
            },
            "minCharacters": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The minimum number of characters that can be entered in the field."
                },
                "attribute": "min-characters",
                "reflect": false,
                "defaultValue": "0"
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The name of the control, which is submitted with the form data."
                },
                "attribute": "name",
                "reflect": false,
                "defaultValue": "this.inputId"
            },
            "placeholder": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The placeholder value to be displayed."
                },
                "attribute": "placeholder",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the read only state will be set."
                },
                "attribute": "readonly",
                "reflect": true,
                "defaultValue": "false"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the input will require a value."
                },
                "attribute": "required",
                "reflect": false,
                "defaultValue": "false"
            },
            "resize": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the multiline text area will be resizeable."
                },
                "attribute": "resize",
                "reflect": false,
                "defaultValue": "false"
            },
            "role": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Used to set the role if not default textbox;"
                        }],
                    "text": ""
                },
                "attribute": "role",
                "reflect": false
            },
            "rows": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The number of rows to transform the text field into a text area with a specific height."
                },
                "attribute": "rows",
                "reflect": false,
                "defaultValue": "1"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizesNoLarge",
                    "resolved": "\"default\" | \"small\"",
                    "references": {
                        "IcSizesNoLarge": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizesNoLarge"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the text field component."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "small": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "This prop should not be used anymore. Set prop `size` to \"small\" instead."
                        }],
                    "text": ""
                },
                "attribute": "small",
                "reflect": false,
                "defaultValue": "false"
            },
            "spellcheck": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the value of the text field will have its spelling and grammar checked."
                },
                "attribute": "spellcheck",
                "reflect": false,
                "defaultValue": "false"
            },
            "truncateValue": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, an ellipsis will be displayed at the end of the value if the value is longer than the container."
                        }],
                    "text": ""
                },
                "attribute": "truncate-value",
                "reflect": false
            },
            "type": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcTextFieldTypes",
                    "resolved": "\"email\" | \"number\" | \"password\" | \"search\" | \"tel\" | \"text\" | \"url\"",
                    "references": {
                        "IcTextFieldTypes": {
                            "location": "import",
                            "path": "./ic-text-field.types",
                            "id": "src/components/ic-text-field/ic-text-field.types.ts::IcTextFieldTypes"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The type of control to display. The default type is text."
                },
                "attribute": "type",
                "reflect": false,
                "defaultValue": "\"text\""
            },
            "validationInline": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the icon in input control will be displayed - only applies when validationStatus ='success'."
                },
                "attribute": "validation-inline",
                "reflect": false,
                "defaultValue": "false"
            },
            "validationInlineInternal": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the validation will display inline."
                        }],
                    "text": ""
                },
                "attribute": "validation-inline-internal",
                "reflect": false,
                "defaultValue": "false"
            },
            "validationStatus": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcInformationStatusOrEmpty",
                    "resolved": "\"\" | \"error\" | \"success\" | \"warning\"",
                    "references": {
                        "IcInformationStatusOrEmpty": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcInformationStatusOrEmpty"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation state - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-status",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "validationText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The validation state - e.g. 'error' | 'warning' | 'success'."
                },
                "attribute": "validation-text",
                "reflect": false,
                "defaultValue": "\"\""
            },
            "debounce": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The amount of time, in milliseconds, to wait to trigger the `icChange` event after each keystroke."
                },
                "attribute": "debounce",
                "reflect": false,
                "defaultValue": "0"
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value of the text field."
                },
                "attribute": "value",
                "reflect": true,
                "defaultValue": "\"\""
            }
        };
    }
    static get states() {
        return {
            "numChars": {},
            "maxCharactersReached": {},
            "maxCharactersError": {},
            "minCharactersUnattained": {},
            "maxLengthExceeded": {},
            "maxValueExceeded": {},
            "minValueUnattained": {},
            "initialValue": {}
        };
    }
    static get events() {
        return [{
                "method": "getValidationText",
                "name": "getValidationText",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the validationInlineInternal is `true`"
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "icBlur",
                "name": "icBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when input loses focus."
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "icChange",
                "name": "icChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the value has changed."
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "icFocus",
                "name": "icFocus",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when input gains focus."
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "icInput",
                "name": "icInput",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a keyboard input occurred."
                },
                "complexType": {
                    "original": "IcValueEventDetail",
                    "resolved": "IcValueEventDetail",
                    "references": {
                        "IcValueEventDetail": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcValueEventDetail"
                        }
                    }
                }
            }, {
                "method": "icKeydown",
                "name": "icKeydown",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a keydown event occurred."
                },
                "complexType": {
                    "original": "{ event: KeyboardEvent }",
                    "resolved": "{ event: KeyboardEvent; }",
                    "references": {
                        "KeyboardEvent": {
                            "location": "global",
                            "id": "global::KeyboardEvent"
                        }
                    }
                }
            }];
    }
    static get methods() {
        return {
            "setFocus": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Sets focus on the native `input`.",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "debounce",
                "methodName": "debounceChanged"
            }, {
                "propName": "value",
                "methodName": "watchValueHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "keydown",
                "method": "handleKeyDown",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-text-field.js.map
