import { Host, h, } from "@stencil/core";
import { convertToRGBA, getThemeForegroundColor } from "../../utils/helpers";
import { getThemeColorBrightness } from "../../utils/helpers";
import { BLACK_MIN_COLOR_BRIGHTNESS, WHITE_MAX_COLOR_BRIGHTNESS, } from "../../utils/constants";
export class Theme {
    constructor() {
        this.checkThemeColorContrast = () => {
            if (getThemeColorBrightness() < BLACK_MIN_COLOR_BRIGHTNESS &&
                getThemeColorBrightness() > WHITE_MAX_COLOR_BRIGHTNESS) {
                console.warn(`The theme colour does not provide enough contrast with either of the ICDS black or white foreground colours. Consider choosing a colour with a different brightness to achieve sufficient colour contrast for good visibility. See https://www.w3.org/TR/AERT/#color-contrast for more information about colour contrast.`);
            }
        };
        this.setThemeColor = () => {
            const colorRGBA = convertToRGBA(this.color);
            if (colorRGBA) {
                const { r, g, b, a } = colorRGBA;
                const { style } = document.documentElement;
                style.setProperty("--ic-theme-primary-r", `${r}`);
                style.setProperty("--ic-theme-primary-g", `${g}`);
                style.setProperty("--ic-theme-primary-b", `${b}`);
                style.setProperty("--ic-theme-primary-a", `${a}`);
                this.checkThemeColorContrast();
                this.themeChange.emit({
                    mode: getThemeForegroundColor(),
                    color: colorRGBA,
                });
            }
        };
        this.color = null;
    }
    watchColorPropHandler() {
        this.setThemeColor();
    }
    componentWillLoad() {
        this.setThemeColor();
    }
    render() {
        return h(Host, null);
    }
    static get is() { return "ic-theme"; }
    static get encapsulation() { return "shadow"; }
    static get properties() {
        return {
            "color": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcColor",
                    "resolved": "`#${string}` | `rgb(${string})` | `rgba(${string})`",
                    "references": {
                        "IcColor": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcColor"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The theme colour. Can be a hex value e.g. \"#ff0000\", RGB e.g. \"rgb(255, 0, 0)\", or RGBA e.g. \"rgba(255, 0, 0, 1)\"."
                },
                "attribute": "color",
                "reflect": false,
                "defaultValue": "null"
            }
        };
    }
    static get events() {
        return [{
                "method": "themeChange",
                "name": "themeChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Emitted when the theme is changed."
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "IcTheme",
                    "resolved": "{ mode: IcThemeForeground; color: IcColorRGB; }",
                    "references": {
                        "IcTheme": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcTheme"
                        }
                    }
                }
            }];
    }
    static get watchers() {
        return [{
                "propName": "color",
                "methodName": "watchColorPropHandler"
            }];
    }
}
//# sourceMappingURL=ic-theme.js.map
