import { h, } from "@stencil/core";
export class ToastRegion {
    constructor() {
        this.pendingVisibility = [];
        this.showToast = (toast) => {
            const visibleToasts = Array.from(document.querySelectorAll("ic-toast")).filter((el) => window.getComputedStyle(el).display !== "none");
            if (visibleToasts.indexOf(toast) === -1 && visibleToasts.length <= 0) {
                toast.setVisible().then((res) => (this.previouslyFocused = res));
            }
            if (visibleToasts.length > 0)
                this.pendingVisibility.push(toast);
        };
        this.openToast = undefined;
    }
    watchOpenToastHandler(newValue) {
        if (this.openToast !== undefined) {
            this.showToast(newValue);
            this.openToast = undefined;
        }
    }
    componentDidLoad() {
        if (this.openToast) {
            this.showToast(this.openToast);
            this.openToast = undefined;
        }
    }
    handleDismissedToast() {
        var _a;
        if (this.pendingVisibility.length > 0) {
            this.pendingVisibility[0]
                .setVisible()
                .then((res) => (this.previouslyFocused = res));
            this.pendingVisibility.shift();
        }
        else {
            if (this.previouslyFocused && "setFocus" in this.previouslyFocused) {
                this.previouslyFocused.setFocus();
            }
            else
                (_a = this.previouslyFocused) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    /**
     * @deprecated Use openToast prop to display toast instead.
     * @param {HTMLIcToastElement} toast The toast component to display
     */
    async setVisible(toast) {
        this.showToast(toast);
    }
    render() {
        return h("slot", null);
    }
    static get is() { return "ic-toast-region"; }
    static get properties() {
        return {
            "openToast": {
                "type": "unknown",
                "mutable": true,
                "complexType": {
                    "original": "HTMLIcToastElement",
                    "resolved": "HTMLIcToastElement",
                    "references": {
                        "HTMLIcToastElement": {
                            "location": "global",
                            "id": "global::HTMLIcToastElement"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The toast element to be displayed."
                }
            }
        };
    }
    static get methods() {
        return {
            "setVisible": {
                "complexType": {
                    "signature": "(toast: HTMLIcToastElement) => Promise<void>",
                    "parameters": [{
                            "name": "toast",
                            "type": "HTMLIcToastElement",
                            "docs": "The toast component to display"
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLIcToastElement": {
                            "location": "global",
                            "id": "global::HTMLIcToastElement"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "deprecated",
                            "text": "Use openToast prop to display toast instead."
                        }, {
                            "name": "param",
                            "text": "toast The toast component to display"
                        }]
                }
            }
        };
    }
    static get elementRef() { return "el"; }
    static get watchers() {
        return [{
                "propName": "openToast",
                "methodName": "watchOpenToastHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "icDismiss",
                "method": "handleDismissedToast",
                "target": undefined,
                "capture": true,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-toast-region.js.map
