import { Host, h, } from "@stencil/core";
const TOGGLE_GROUP = "IC-TOGGLE-BUTTON-GROUP";
export class ToggleButtonGroup {
    constructor() {
        this.keyListener = (ev) => {
            this.lastKeyPressed = {
                key: ev.key,
                shift: ev.shiftKey,
            };
        };
        this.setSlottedAria = (el) => {
            const btn = el.shadowRoot
                .querySelector("ic-button")
                .shadowRoot.querySelector("button");
            let aria = btn.getAttribute("aria-label");
            aria += ", ";
            aria += this.accessibleLabel;
            btn.setAttribute("aria-label", aria);
        };
        this.handleHostFocus = (ev) => {
            if (this.loading || this.disabled) {
                return null;
            }
            const el = ev.target;
            const relEl = ev.relatedTarget;
            const toggleButtons = Array.from(el.querySelectorAll("ic-toggle-button"));
            if (((toggleButtons.every((el) => !el.toggleChecked) ||
                this.selectType !== "single") &&
                this.lastKeyPressed.shift === false) ||
                (toggleButtons.every((el) => !el.toggleChecked) &&
                    this.lastKeyPressed.shift === true &&
                    relEl.tagName == TOGGLE_GROUP)) {
                toggleButtons[0].focus();
            }
            else if (this.lastKeyPressed.shift === false ||
                (this.lastKeyPressed.shift === true && relEl.tagName == TOGGLE_GROUP)) {
                // if toggleChecked is true and selectMethod is "single", focus that toggle
                const toggledButton = toggleButtons.filter((el) => el.toggleChecked);
                toggledButton[0].focus();
            }
        };
        this.handleKeyDown = (event) => {
            const toggleButtonOptions = this.getAllToggleButtons();
            const focussedChild = toggleButtonOptions.indexOf(toggleButtonOptions.filter((el) => el === document.activeElement)[0]);
            switch (event.key) {
                case "ArrowDown":
                case "ArrowRight":
                    this.selectMethod === "auto"
                        ? this.proxySelectHandler(toggleButtonOptions[this.getNextItemToSelect(focussedChild, true)])
                        : toggleButtonOptions[this.getNextItemToSelect(focussedChild, true)].focus();
                    break;
                case "ArrowUp":
                case "ArrowLeft":
                    this.selectMethod === "auto"
                        ? this.proxySelectHandler(toggleButtonOptions[this.getNextItemToSelect(focussedChild, false)])
                        : toggleButtonOptions[this.getNextItemToSelect(focussedChild, false)].focus();
                    break;
                case "Tab":
                    break;
            }
        };
        this.getNextItemToSelect = (currentItem, movingDown) => {
            const toggleButtonOptions = this.getAllToggleButtons();
            const numToggles = toggleButtonOptions.length - 1;
            if (currentItem < 1) {
                currentItem = 0;
            }
            let nextItem = movingDown ? currentItem + 1 : currentItem - 1;
            if (nextItem < 0) {
                nextItem = numToggles;
            }
            else if (nextItem > numToggles) {
                nextItem = 0;
            }
            if (toggleButtonOptions[nextItem].disabled) {
                nextItem = this.getNextItemToSelect(nextItem, movingDown);
            }
            return nextItem;
        };
        this.lastKeyPressed = {
            key: null,
            shift: false,
        };
        this.accessibleLabel = "Toggle button group";
        this.appearance = "default";
        this.disabled = false;
        this.fullWidth = false;
        this.iconPlacement = undefined;
        this.loading = false;
        this.selectMethod = "manual";
        this.selectType = "single";
        this.size = "default";
        this.variant = "default";
    }
    selectHandler(ev, tabTarget) {
        const allToggles = this.getAllToggleButtons();
        let clickedToggle = ev.target;
        // tabTarget used in proxySelectHandler
        tabTarget && tabTarget.focus();
        if (this.selectType === "single") {
            if (!clickedToggle) {
                clickedToggle = tabTarget;
            }
            allToggles.forEach((el) => {
                if (el.id !== clickedToggle.id && el.toggleChecked) {
                    el.toggleChecked = false;
                }
            });
            this.icChange.emit({
                toggleChecked: ev.detail.toggleChecked,
                selectedOption: clickedToggle,
            });
        }
        else {
            const toggledOptions = this.getAllToggleButtons().filter((el) => el.toggleChecked && !el.disabled);
            this.icChange.emit({
                toggleChecked: toggledOptions.map((opt) => opt.toggleChecked),
                toggledOptions: toggledOptions.map((opt) => ({
                    toggleButton: opt,
                })),
                selectedOption: clickedToggle,
            });
        }
    }
    componentWillLoad() {
        this.selectType === "multi" && (this.selectMethod = "manual");
        this.selectMethod === "auto" && this.selectType === "single";
        document.addEventListener("keydown", this.keyListener);
    }
    componentDidLoad() {
        this.getAllToggleButtons().forEach((el, i) => {
            this.setSlottedAria(el);
            el.size = this.size;
            el.loading = this.loading;
            el.iconPlacement = this.iconPlacement;
            el.disabled ? null : (el.disabled = this.disabled);
            el.appearance = this.appearance;
            el.variant = this.variant;
            el.fullWidth = this.fullWidth;
            el.id = i.toString();
            el.tabIndex = -1;
            el.addEventListener("keydown", (ev) => {
                this.handleKeyDown(ev);
            });
            el.classList.add("expand-toggle-group-child");
        });
    }
    disconnectedCallback() {
        document.removeEventListener("keydown", this.keyListener);
    }
    // trigger selectHandler when unable to add 'target'
    proxySelectHandler(toggle) {
        toggle.toggleChecked = true;
        const customEv = new CustomEvent("icToggleChecked", {
            detail: {
                toggleChecked: toggle.toggleChecked,
            },
        });
        this.selectHandler(customEv, toggle);
    }
    getAllToggleButtons() {
        return Array.from(this.el.querySelectorAll("ic-toggle-button"));
    }
    render() {
        return (h(Host, { role: "group", "aria-label": this.accessibleLabel, "aria-disabled": this.disabled ? "true" : "false", tabindex: 0, class: {
                ["full-width"]: this.fullWidth,
                ["loading"]: this.loading,
                ["disabled"]: this.disabled,
                [`${this.appearance}`]: true,
            }, onFocus: this.handleHostFocus }, h("slot", null)));
    }
    static get is() { return "ic-toggle-button-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-toggle-button-group.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-toggle-button-group.css"]
        };
    }
    static get properties() {
        return {
            "accessibleLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The accessible label of the toggle button group component to provide context for screen reader users."
                },
                "attribute": "accessible-label",
                "reflect": false,
                "defaultValue": "\"Toggle button group\""
            },
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the toggle button group, e.g dark, or light."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button group will be set to the disabled state."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button group will fill the width of the container."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "iconPlacement": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"left\" | \"right\" | \"top\"",
                    "resolved": "\"left\" | \"right\" | \"top\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The placement of the icons in relation to the toggle button labels."
                },
                "attribute": "icon-placement",
                "reflect": false
            },
            "loading": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button group will be in loading state."
                },
                "attribute": "loading",
                "reflect": false,
                "defaultValue": "false"
            },
            "selectMethod": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "IcSelectMethodTypes",
                    "resolved": "\"auto\" | \"manual\"",
                    "references": {
                        "IcSelectMethodTypes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSelectMethodTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `auto`, controls are toggled automatically when navigated to. If `manual`, the controls must be actioned to change their toggled state. The value of this prop is ignored if `selectType` is set to`multi`."
                },
                "attribute": "select-method",
                "reflect": false,
                "defaultValue": "\"manual\""
            },
            "selectType": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSelectTypes",
                    "resolved": "\"multi\" | \"single\"",
                    "references": {
                        "IcSelectTypes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSelectTypes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Sets whether single or multiple options can be toggled. If `multi`, then the `selectMethod` is always `manual`."
                },
                "attribute": "select-type",
                "reflect": false,
                "defaultValue": "\"single\""
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the toggle buttons to be displayed. This does not affect the font size of the accessible label."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"default\" | \"icon\"",
                    "resolved": "\"default\" | \"icon\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The variant of the toggle button."
                },
                "attribute": "variant",
                "reflect": true,
                "defaultValue": "\"default\""
            }
        };
    }
    static get states() {
        return {
            "lastKeyPressed": {}
        };
    }
    static get events() {
        return [{
                "method": "icChange",
                "name": "icChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when a toggle button is selected."
                },
                "complexType": {
                    "original": "IcChangeEventDetail",
                    "resolved": "IcChangeEventDetail",
                    "references": {
                        "IcChangeEventDetail": {
                            "location": "import",
                            "path": "./ic-toggle-button-group.types",
                            "id": "src/components/ic-toggle-button-group/ic-toggle-button-group.types.ts::IcChangeEventDetail"
                        }
                    }
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "icToggleChecked",
                "method": "selectHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-toggle-button-group.js.map
