import { Host, h, } from "@stencil/core";
import { isSlotUsed, onComponentRequiredPropUndefined, removeDisabledFalse, } from "../../utils/helpers";
/**
 * @slot icon - Content will be displayed alongside the toggle button label.
 * @slot badge - Badge component overlaying the top right of the toggle button.
 */
export class ToggleButton {
    constructor() {
        this.handleFocus = (ev) => {
            ev.stopImmediatePropagation();
        };
        this.handleClick = () => {
            !this.loading &&
                !this.disabled &&
                this.icToggleChecked.emit({
                    checked: this.toggleChecked,
                });
        };
        this.accessibleLabel = undefined;
        this.appearance = "default";
        this.disabled = false;
        this.fullWidth = false;
        this.iconPlacement = undefined;
        this.label = undefined;
        this.loading = false;
        this.size = "default";
        this.toggleChecked = false;
        this.variant = "default";
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        const parentIconPlacement = this.el.parentElement.iconPlacement;
        this.iconPosition = this.iconPlacement || parentIconPlacement;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            {
                prop: this.variant === "icon" ? this.accessibleLabel : this.label,
                propName: this.variant === "icon" ? "accessible-label" : "label",
            },
        ], "Toggle button");
    }
    handleHostClick(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
        else if (!this.loading) {
            this.toggleChecked = !this.toggleChecked;
        }
    }
    render() {
        return (h(Host, { class: {
                ["disabled"]: this.disabled,
                ["checked"]: this.toggleChecked,
                [`${this.appearance}`]: true,
                ["icon"]: this.variant === "icon",
                [`${this.size}`]: true,
                ["loading"]: this.loading,
            }, onFocus: this.handleFocus }, h("ic-button", { "aria-pressed": this.toggleChecked.toString(), variant: this.variant === "icon" ? "icon" : "secondary", onClick: this.handleClick, title: this.accessibleLabel, "aria-label": `${this.accessibleLabel ? this.accessibleLabel : this.label}, ${this.toggleChecked ? "ticked" : "unticked"}`, disabled: this.disabled, appearance: this.appearance, size: this.size, fullWidth: this.fullWidth, loading: this.loading, "aria-disabled": `${this.disabled}` }, this.variant !== "icon" && this.label, h("slot", null), isSlotUsed(this.el, "icon") && (h("slot", { name: "icon", slot: `${this.iconPosition ? `${this.iconPosition}-icon` : "icon"}` })), isSlotUsed(this.el, "badge") && (h("slot", { name: "badge", slot: "badge" })))));
    }
    static get is() { return "ic-toggle-button"; }
    static get encapsulation() { return "shadow"; }
    static get delegatesFocus() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-toggle-button.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-toggle-button.css"]
        };
    }
    static get properties() {
        return {
            "accessibleLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The accessible label that will be applied to the toggle button. This is required for the icon variant of toggle buttons."
                },
                "attribute": "accessible-label",
                "reflect": false
            },
            "appearance": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcThemeForeground",
                    "resolved": "\"dark\" | \"default\" | \"light\"",
                    "references": {
                        "IcThemeForeground": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcThemeForeground"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The appearance of the toggle button."
                },
                "attribute": "appearance",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button will be in disabled state."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "fullWidth": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button will fill the width of the container."
                },
                "attribute": "full-width",
                "reflect": false,
                "defaultValue": "false"
            },
            "iconPlacement": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"left\" | \"right\" | \"top\"",
                    "resolved": "\"left\" | \"right\" | \"top\"",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The placement of the icon in relation to the toggle button label."
                },
                "attribute": "icon-placement",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label to display in the toggle button. This is required for the default variant of toggle buttons."
                },
                "attribute": "label",
                "reflect": false
            },
            "loading": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button will be in loading state."
                },
                "attribute": "loading",
                "reflect": false,
                "defaultValue": "false"
            },
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "IcSizes",
                    "resolved": "\"default\" | \"large\" | \"small\"",
                    "references": {
                        "IcSizes": {
                            "location": "import",
                            "path": "../../utils/types",
                            "id": "src/utils/types.ts::IcSizes"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The size of the toggle button to be displayed."
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "\"default\""
            },
            "toggleChecked": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the toggle button will be in a checked state."
                },
                "attribute": "toggle-checked",
                "reflect": true,
                "defaultValue": "false"
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "\"default\" | \"icon\"",
                    "resolved": "\"default\" | \"icon\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The variant of the toggle button."
                },
                "attribute": "variant",
                "reflect": true,
                "defaultValue": "\"default\""
            }
        };
    }
    static get events() {
        return [{
                "method": "icToggleChecked",
                "name": "icToggleChecked",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Emitted when the user clicks a toggle button."
                },
                "complexType": {
                    "original": "{\n    checked: boolean;\n  }",
                    "resolved": "{ checked: boolean; }",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "el"; }
    static get listeners() {
        return [{
                "name": "click",
                "method": "handleHostClick",
                "target": undefined,
                "capture": true,
                "passive": false
            }];
    }
}
//# sourceMappingURL=ic-toggle-button.js.map
