import { Host, h, } from "@stencil/core";
import { createPopper } from "@popperjs/core";
import { onComponentRequiredPropUndefined } from "../../utils/helpers";
export class Tooltip {
    constructor() {
        this.delayedHideEvents = ["mouseleave"];
        this.dialogOverflow = false;
        this.instantHideEvents = ["focusout"];
        this.mouseOverTool = false;
        this.persistTooltip = false;
        this.onDialog = false;
        this.showEvents = [
            !this.disableHover && "mouseenter",
            !this.disableHover && "focusin",
            !this.disableClick && "click",
        ];
        this.getTooltipTranslate = (dialogEl) => {
            const child = this.el.children[0].getBoundingClientRect();
            let tooltipX;
            let tooltipY;
            switch (this.placement) {
                case "bottom":
                    tooltipX = child.left - dialogEl.left - 0.5 * child.width;
                    tooltipY = child.bottom - dialogEl.top;
                    break;
                case "bottom-start":
                    tooltipX = child.left - dialogEl.left;
                    tooltipY = child.bottom - dialogEl.top;
                    break;
                case "bottom-end":
                    tooltipX = child.right - dialogEl.right;
                    tooltipY = child.bottom - dialogEl.top;
                    break;
                case "top":
                    tooltipX = child.left - dialogEl.left - 0.5 * child.width;
                    tooltipY = child.top - dialogEl.bottom;
                    break;
                case "top-start":
                    tooltipX = child.left - dialogEl.left;
                    tooltipY = child.top - dialogEl.bottom;
                    break;
                case "top-end":
                    tooltipX = child.right - dialogEl.right;
                    tooltipY = child.top - dialogEl.bottom;
                    break;
                case "left":
                case "left-start":
                    tooltipX = child.right - dialogEl.right - child.width;
                    tooltipY = child.bottom - dialogEl.top - child.height;
                    break;
                case "left-end":
                    tooltipX = child.right - dialogEl.right - child.width;
                    tooltipY = child.top - dialogEl.bottom + child.height;
                    break;
                case "right":
                case "right-start":
                    tooltipX = child.left - dialogEl.left + child.width;
                    tooltipY = child.bottom - dialogEl.top - child.height;
                    break;
                case "right-end":
                    tooltipX = child.left - dialogEl.left + child.width;
                    tooltipY = child.top - dialogEl.bottom + child.height;
                    break;
            }
            if (this.dialogOverflow && tooltipX < 0) {
                if (this.placement.includes("top") || this.placement.includes("bottom")) {
                    this.toolTip.style.setProperty("--tooltip-arrow-translate", `${tooltipX}px`);
                    tooltipX = child.left - dialogEl.left;
                }
                if (this.placement.includes("left")) {
                    this.placement = "right";
                    tooltipX = child.left - dialogEl.left + child.width;
                }
            }
            this.toolTip.style.setProperty("--tooltip-translate-x", `${tooltipX}px`);
            this.toolTip.style.setProperty("--tooltip-translate-y", `${tooltipY}px`);
        };
        this.show = () => {
            if (this.label) {
                this.toolTip.setAttribute("data-show", "");
                if (this.onDialog) {
                    this.el.classList.add("on-dialog");
                    const dialogEl = this.icDialogEl.shadowRoot
                        .querySelector("dialog")
                        .getBoundingClientRect();
                    this.getTooltipTranslate(dialogEl);
                }
                this.popperInstance = createPopper(this.el, this.toolTip, Object.assign({ placement: this.placement, modifiers: [
                        {
                            name: "offset",
                            options: {
                                offset: [0, 10],
                            },
                        },
                        {
                            name: "arrow",
                            options: {
                                element: this.arrow,
                            },
                        },
                        {
                            name: "eventListeners",
                            options: { scroll: false, resize: false },
                        },
                    ] }, this.popperProps));
            }
            else {
                console.warn(`Tooltip can't display without prop 'label' set`);
            }
        };
        this.hide = () => {
            this.toolTip.removeAttribute("data-show");
            this.persistTooltip = false;
            if (this.popperInstance !== undefined) {
                this.popperInstance.destroy();
            }
        };
        this.checkCloseTooltip = () => {
            setTimeout(() => {
                if (!this.mouseOverTool && !this.persistTooltip) {
                    this.hide();
                }
            }, 100);
        };
        this.mouseEnterTooltip = () => {
            this.mouseOverTool = true;
        };
        this.mouseLeaveTooltip = () => {
            this.mouseOverTool = false;
            this.checkCloseTooltip();
        };
        this.handleKeyDown = (event) => {
            if (event.key === "Escape" && !this.persistTooltip) {
                this.hide();
            }
        };
        this.manageEventListeners = (action) => {
            const method = action === "add" ? "addEventListener" : "removeEventListener";
            this.showEvents.forEach((event) => {
                this.el[method](event, this.show);
                if (this.toolTip !== undefined) {
                    this.toolTip[method](event, this.mouseEnterTooltip);
                }
            });
            if (!this.persistTooltip) {
                this.instantHideEvents.forEach((event) => {
                    this.el[method](event, this.hide);
                });
            }
            this.delayedHideEvents.forEach((event) => {
                this.el[method](event, this.checkCloseTooltip);
                if (this.toolTip !== undefined) {
                    this.toolTip[method](event, this.mouseLeaveTooltip);
                }
            });
            document[method]("keydown", this.handleKeyDown);
        };
        this.disableClick = false;
        this.disableHover = false;
        this.maxLines = undefined;
        this.placement = "bottom";
        this.silent = false;
        this.target = undefined;
        this.label = undefined;
        this.popperProps = {};
    }
    /**
     * @internal This method allows props to be added to the PopperJS createPopper instance outside of tooltip
     * @param props object - createPopper props set externally
     */
    async setExternalPopperProps(props) {
        this.popperProps = props;
    }
    disconnectedCallback() {
        this.manageEventListeners("remove");
        if (this.popperInstance !== undefined) {
            this.popperInstance.destroy();
        }
    }
    componentDidLoad() {
        var _a;
        this.manageEventListeners("add");
        this.icDialogEl = this.el.closest("ic-dialog");
        this.dialogOverflow =
            ((_a = this.icDialogEl) === null || _a === void 0 ? void 0 : _a.getAttribute("data-overflow")) === "true";
        this.onDialog = this.icDialogEl !== null;
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Tooltip");
    }
    componentDidRender() {
        const typographyEl = this.el.shadowRoot.querySelector(".ic-tooltip-container > ic-typography");
        this.maxLines > 0 &&
            typographyEl.setAttribute("style", `--truncation-max-lines: ${this.maxLines}`);
    }
    /**
     * Method to programmatically show/hide the tooltip without needing to interact with an anchor element
     * @param show Whether to show or hide the tooltip
     * @param persistTooltip Whether the tooltip should stay on the screen when actions are performed that would previously dismiss the tooltip, such as on hover
     */
    async displayTooltip(show, persistTooltip) {
        this.persistTooltip = persistTooltip;
        show ? this.show() : this.hide();
    }
    /**
     * @internal Method to return if tooltip is currently visible.
     */
    async isTooltipVisible() {
        return Promise.resolve(this.toolTip.hasAttribute("data-show"));
    }
    render() {
        const { label, maxLines, silent } = this;
        return (h(Host, { class: { "ic-tooltip": true } }, h("div", { ref: (el) => (this.toolTip = el), role: "tooltip", class: "ic-tooltip-container", "aria-hidden": `${silent}` }, h("ic-typography", { maxLines: maxLines, variant: "caption" }, label), h("div", { ref: (el) => (this.arrow = el), class: "ic-tooltip-arrow" })), h("slot", null)));
    }
    static get is() { return "ic-tooltip"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["ic-tooltip.css"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["ic-tooltip.css"]
        };
    }
    static get properties() {
        return {
            "disableClick": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "If `true`, the tooltip will not be displayed on click, it will require hover or using the display method."
                        }],
                    "text": ""
                },
                "attribute": "disable-click",
                "reflect": false,
                "defaultValue": "false"
            },
            "disableHover": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "If `true`, the tooltip will not be displayed on hover, it will require a click."
                },
                "attribute": "disable-hover",
                "reflect": false,
                "defaultValue": "false"
            },
            "maxLines": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The number of lines to display before truncating the text."
                },
                "attribute": "max-lines",
                "reflect": false
            },
            "placement": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "IcTooltipPlacements",
                    "resolved": "\"bottom\" | \"bottom-end\" | \"bottom-start\" | \"left\" | \"left-end\" | \"left-start\" | \"right\" | \"right-end\" | \"right-start\" | \"top\" | \"top-end\" | \"top-start\"",
                    "references": {
                        "IcTooltipPlacements": {
                            "location": "import",
                            "path": "./ic-tooltip.types",
                            "id": "src/components/ic-tooltip/ic-tooltip.types.ts::IcTooltipPlacements"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The position of the tooltip in relation to the parent element."
                },
                "attribute": "placement",
                "reflect": false,
                "defaultValue": "\"bottom\""
            },
            "silent": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": "Sets the tooltip to aria-hidden, when used as part of components that are already announced."
                        }],
                    "text": ""
                },
                "attribute": "silent",
                "reflect": false,
                "defaultValue": "false"
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The ID of the element the tooltip is describing - for when aria-labelledby or aria-describedby is used."
                },
                "attribute": "target",
                "reflect": true
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The text to display on the tooltip."
                },
                "attribute": "label",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "popperProps": {}
        };
    }
    static get methods() {
        return {
            "setExternalPopperProps": {
                "complexType": {
                    "signature": "<T extends Partial<Options>>(props: T) => Promise<void>",
                    "parameters": [{
                            "name": "props",
                            "type": "T",
                            "docs": "object - createPopper props set externally"
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "Partial": {
                            "location": "global",
                            "id": "global::Partial"
                        },
                        "Options": {
                            "location": "import",
                            "path": "@popperjs/core",
                            "id": ""
                        },
                        "T": {
                            "location": "global",
                            "id": "global::T"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": "This method allows props to be added to the PopperJS createPopper instance outside of tooltip"
                        }, {
                            "name": "param",
                            "text": "props object - createPopper props set externally"
                        }]
                }
            },
            "displayTooltip": {
                "complexType": {
                    "signature": "(show: boolean, persistTooltip?: boolean) => Promise<void>",
                    "parameters": [{
                            "name": "show",
                            "type": "boolean",
                            "docs": "Whether to show or hide the tooltip"
                        }, {
                            "name": "persistTooltip",
                            "type": "boolean",
                            "docs": "Whether the tooltip should stay on the screen when actions are performed that would previously dismiss the tooltip, such as on hover"
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Method to programmatically show/hide the tooltip without needing to interact with an anchor element",
                    "tags": [{
                            "name": "param",
                            "text": "show Whether to show or hide the tooltip"
                        }, {
                            "name": "param",
                            "text": "persistTooltip Whether the tooltip should stay on the screen when actions are performed that would previously dismiss the tooltip, such as on hover"
                        }]
                }
            },
            "isTooltipVisible": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": "Method to return if tooltip is currently visible."
                        }]
                }
            }
        };
    }
    static get elementRef() { return "el"; }
}
//# sourceMappingURL=ic-tooltip.js.map
