import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { c as chevronIcon } from './chevron-icon.js';
import { i as isSlotUsed, e as isPropDefined } from './helpers.js';
import { d as defineCustomElement$1 } from './ic-link2.js';

const backIcon = `<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20 11H7.83L13.42 5.41L12 4L4 12L12 20L13.41 18.59L7.83 13H20V11Z" fill="currentColor"/>
</svg>
`;

const icBreadcrumbCss = ":host{display:block;margin:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs) 0}:host .breadcrumb{display:flex;align-items:center;white-space:nowrap;gap:var(--ic-space-xs);min-height:var(--ic-space-lg)}:host .chevron{width:var(--ic-space-lg);height:var(--ic-space-lg)}:host .chevron svg{color:var(--ic-architectural-400)}:host(:first-child) .chevron{display:none}.back-icon svg{color:currentcolor}:host(.back){display:flex;align-items:center}:host(.back) .chevron{display:none}ic-link{--breadcrumb-link-display:inline-flex;--breadcrumb-link-align-items:center;--breadcrumb-link-gap:var(--ic-space-xs)}:host([aria-current=\"page\"]) .current-page-container{display:flex;align-items:center;gap:var(--ic-space-xs)}:host([aria-current=\"page\"]) .current-page-container.dark{color:var(--ic-color-primary-text)}:host([aria-current=\"page\"]) .current-page-container.light{color:var(--ic-color-white-text)}:host(.collapsed-breadcrumb-wrapper){margin-right:var(--ic-space-xs) !important;display:flex;align-items:center;gap:var(--ic-space-xs)}:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb){border:none;background-color:transparent;color:var(--ic-hyperlink);text-decoration:underline;font-weight:var(--ic-font-weight-bold);cursor:pointer}:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:hover),:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:focus){outline:var(--ic-hc-focus-outline);border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}.hide,:host(.collapsed-breadcrumb-wrapper) ::slotted(.hide){display:none}@media (forced-colors: active){.back-icon svg{color:currentcolor}}@supports (text-underline-offset: 25%){ic-link{--breadcrumb-link-display:flex}:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:hover),:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:focus){text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:25%;border-bottom:0 !important;margin-bottom:0 !important}}";

const Breadcrumb = /*@__PURE__*/ proxyCustomElement(class Breadcrumb extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.renderDefaultBreadcrumb = (current, pageTitle, describedById, href) => {
            const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
            if (current && hasPageTitle) {
                return (h("span", { class: {
                        "current-page-container": current,
                        [this.appearance]: true,
                    } }, isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), pageTitle));
            }
            return (h("ic-link", { appearance: this.appearance, href: href, class: "breadcrumb-link", "aria-describedby": this.showBackIcon && describedById && describedById }, this.showBackIcon && (h("div", { class: "back-icon", innerHTML: backIcon })), isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), pageTitle));
        };
        this.setSlottedCurrentPageClass = () => {
            const icLink = this.el.querySelector("ic-link");
            const currentPage = "current-page";
            if (icLink) {
                icLink.classList.remove(currentPage);
                if (this.current) {
                    const hasCurrentPageClass = icLink.classList.contains(currentPage);
                    if (!hasCurrentPageClass) {
                        icLink.classList.add("breadcrumb-link", currentPage);
                    }
                }
            }
        };
        this.appearance = "default";
        this.current = false;
        this.href = undefined;
        this.pageTitle = undefined;
        this.showBackIcon = false;
    }
    componentWillRender() {
        this.setSlottedCurrentPageClass();
    }
    /**
     * Sets focus on the breadcrumb.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("ic-link")) {
            this.el.shadowRoot.querySelector("ic-link").focus();
        }
    }
    render() {
        const { current, href, pageTitle } = this;
        const describedById = `${pageTitle && pageTitle.toLowerCase().replace(" ", "-")}-describedby`;
        const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
        const hasHref = href !== null && isPropDefined(href) && href !== "";
        return (h(Host, { class: {
                back: this.showBackIcon,
            }, "aria-current": current && "page", role: "listitem" }, h("div", { class: "breadcrumb" }, h("span", { innerHTML: chevronIcon, class: "chevron", "aria-hidden": "true" }), this.showBackIcon && describedById && (h("span", { id: describedById, class: "hide" }, `Back to ${pageTitle}`)), hasPageTitle && hasHref ? (this.renderDefaultBreadcrumb(current, pageTitle, describedById, href)) : (h("slot", null)))));
    }
    static get delegatesFocus() { return true; }
    get el() { return this; }
    static get style() { return icBreadcrumbCss; }
}, [17, "ic-breadcrumb", {
        "appearance": [1],
        "current": [4],
        "href": [1],
        "pageTitle": [1, "page-title"],
        "showBackIcon": [516, "show-back-icon"],
        "setFocus": [64]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-breadcrumb", "ic-link"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-breadcrumb":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Breadcrumb);
            }
            break;
        case "ic-link":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { Breadcrumb as B, defineCustomElement as d };

//# sourceMappingURL=ic-breadcrumb2.js.map