import { proxyCustomElement, HTMLElement, createEvent, forceUpdate, h, Host } from '@stencil/core/internal/client';
import { I as IC_INHERITED_ARIA, r as removeDisabledFalse, b as inheritAttributes, d as renderFileHiddenInput, g as getThemeFromContext, i as isSlotUsed } from './helpers.js';
import { I as IcThemeForegroundEnum } from './types.js';
import { d as defineCustomElement$3 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$2 } from './ic-tooltip2.js';
import { d as defineCustomElement$1 } from './ic-typography2.js';

const arrowDropdown = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M7 9.5L12 14.5L17 9.5H7Z" fill="currentColor"/>
</svg>`;

const icButtonCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:inline-block;position:relative;--button-default:var(--ic-action-default);--button-default-hover:var(--ic-action-default-hover);--button-default-active:var(--ic-action-default-active);--button-default-background-hover:var(--ic-action-default-bg-hover);--button-default-background-active:var(--ic-action-default-bg-active);--icon-width:100%;--icon-height:100%}.button,::slotted(a){font-family:var(--ic-font-body-family);text-decoration:none;font-weight:600;font-size:0.875rem;transition:var(--ic-easing-transition-fast);border-radius:var(--ic-border-radius);min-width:var(--min-width, 6.25rem);display:inline-flex;flex-direction:row;justify-content:center;align-items:center;background:none;border:none;box-sizing:border-box;white-space:nowrap;vertical-align:middle}:host(.with-badge) .button{border-radius:0.2188rem}.button:hover,::slotted(a:hover){cursor:pointer}.button:focus,::slotted(a:focus){box-shadow:var(--ic-border-focus)}.button:focus-visible,::slotted(a:focus-visible){outline:var(--ic-hc-focus-outline)}:host(.dark) .button,:host(.dark) ::slotted(a){--button-default:var(--ic-action-dark);--button-default-hover:var(--ic-action-dark);--button-default-active:var(--ic-action-dark);--button-default-background-hover:var(--ic-action-dark-bg-hover);--button-default-background-active:var(--ic-action-dark-bg-active)}:host(.light) .button,:host(.light) ::slotted(a){--button-default:var(--ic-action-light);--button-default-hover:var(--ic-action-light);--button-default-active:var(--ic-action-light);--button-default-background-hover:var(--ic-action-light-bg-hover);--button-default-background-active:var(--ic-action-light-bg-active)}:host(.white-background) .button,:host(.white-background) ::slotted(a){--button-default-background-hover:var(--ic-action-default-bg-hover-no-alpha);--button-default-background-active:var(\n    --ic-action-default-bg-active-no-alpha\n  );background-color:var(--ic-architectural-white)}:host(.white-background.dark) .button,:host(.white-background.dark) ::slotted(a){--button-default-background-hover:var(--ic-action-dark-bg-hover-no-alpha);--button-default-background-active:var(--ic-action-dark-bg-active-no-alpha)}:host(.button-variant-primary.light) .button,:host(.button-variant-primary.light) ::slotted(a){color:var(--ic-color-primary-text);--button-default-hover:var(--ic-action-light-hover);--button-default-active:var(--ic-action-light-active)}:host(.button-variant-primary.dark) .button,:host(.button-variant-primary.dark) ::slotted(a){--button-default-hover:var(--ic-action-dark-hover);--button-default-active:var(--ic-action-dark-active)}:host(.disabled),:host(.disabled) .button,:host(.disabled) ::slotted(a),:host(.loading),:host(.loading) .button{pointer-events:none}:host(.top-icon) .button{flex-direction:column;--height:fit-content}:host(.top-icon) .button .icon-container{margin-right:0}:host(.button-variant-primary) .button,:host(.button-variant-primary) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--button-default)}:host(.button-variant-primary) .button:hover{background-color:var(--button-default-hover)}:host(.button-variant-primary.loading) .button,:host(.button-variant-primary) .button:active{background-color:var(--button-default-active)}:host(.button-variant-primary.disabled) .button,:host(.button-variant-primary.disabled) ::slotted(a){background:var(--ic-architectural-200);color:var(--ic-architectural-300)}:host(.button-variant-primary.light.disabled) .button,:host(.button-variant-primary.light.disabled) ::slotted(a){background:var(--ic-architectural-600);color:var(--ic-architectural-500)}:host(.button-variant-secondary) .button,:host(.button-variant-secondary) ::slotted(a){border:var(--ic-border-width) solid var(--button-default);color:var(--button-default)}:host(.button-variant-secondary) .button:hover,:host(.button-variant-secondary) ::slotted(a:hover){background-color:var(--button-default-background-hover);border-color:var(--button-default-hover);color:var(--button-default-hover)}:host(.button-variant-secondary) .button:active,:host(.button-variant-secondary) ::slotted(a:active),:host(.button-variant-secondary.loading) .button{border-color:var(--button-default-active);background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-secondary.disabled) .button,:host(.button-variant-secondary.disabled) ::slotted(a){border-color:var(--ic-architectural-300);color:var(--ic-architectural-300);background:none}:host(.button-variant-secondary.light.disabled) .button,:host(.button-variant-secondary.light.disabled) ::slotted(a){border-color:var(--ic-architectural-500);color:var(--ic-architectural-500)}:host(.button-variant-tertiary) .button,:host(.button-variant-tertiary) ::slotted(a){color:var(--button-default)}:host(.button-variant-tertiary) .button:hover,:host(.button-variant-tertiary) ::slotted(a:hover){background-color:var(--button-default-background-hover);color:var(--button-default-hover)}:host(.button-variant-tertiary) .button:active,:host(.button-variant-tertiary) ::slotted(a:active),:host(.button-variant-tertiary.loading) .button{background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-tertiary.disabled) .button,:host(.button-variant-tertiary.disabled) ::slotted(a){color:var(--ic-architectural-300);background:none}:host(.button-variant-tertiary.light.disabled) .button,:host(.button-variant-tertiary.light.disabled) ::slotted(a){color:var(--ic-architectural-500)}:host(.button-variant-destructive) .button,:host(.button-variant-destructive) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--ic-action-destructive);text-transform:uppercase}:host(.button-variant-destructive) .button:hover{background-color:var(--ic-action-destructive-hover)}:host(.button-variant-destructive) .button:active,:host(.button-variant-destructive.loading) .button{background-color:var(--ic-action-destructive-active)}:host(.button-variant-destructive.disabled) .button,:host(.button-variant-destructive.disabled) ::slotted(a){background:var(--ic-architectural-200);color:var(--ic-architectural-300)}:host(.button-variant-icon) .button,:host(.button-variant-icon) ::slotted(a){color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon) .button:hover,:host(.button-variant-icon) ::slotted(a:hover){background-color:var(--button-default-background-hover);color:var(--button-default-hover)}:host(.button-variant-icon) .button:active:not(:focus),:host(.button-variant-icon) ::slotted(a:active:not(:focus)),:host(.button-variant-icon.loading) .button{background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-icon.disabled) .button,:host(.button-variant-icon.disabled) ::slotted(a){color:var(--ic-architectural-300);background:none}:host(.button-variant-icon-primary) .button,:host(.button-variant-icon-primary) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-primary) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-primary) .button:hover,:host(.button-variant-icon-primary) ::slotted(a:hover){background-color:var(--button-default-hover)}:host(.button-variant-icon-primary) .button:active,:host(.button-variant-icon-primary) ::slotted(a:active),:host(.button-variant-icon-primary.loading) .button{background:var(--button-default-active)}:host(.button-variant-icon-primary.loading) .button ic-loading-indicator{--inner-color:var(--ic-architectural-white)}:host(.button-variant-icon-primary.disabled) .button,:host(.button-variant-icon-primary.disabled) ::slotted(a){color:var(--ic-architectural-300);background:var(--ic-architectural-200)}:host(.button-variant-icon-primary.light) .button,:host(.button-variant-icon-primary.light) ::slotted(a){color:var(--ic-color-primary-text)}:host(.button-variant-icon-primary.light) .button:hover,:host(.button-variant-icon-primary.light) ::slotted(a:hover){background:var(--ic-action-light-hover)}:host(.button-variant-icon-primary.light) .button:active,:host(.button-variant-icon-primary.light) ::slotted(a:active),:host(.button-variant-icon-primary.light.loading) .button,:host(.button-variant-icon-primary.light.loading) ::slotted(a){background:var(--ic-action-light-active)}:host(.button-variant-icon-primary.dark) .button:hover,:host(.button-variant-icon-primary.dark) ::slotted(a:hover){background:var(--ic-action-dark-hover)}:host(.button-variant-icon-primary.dark) .button:active,:host(.button-variant-icon-primary.dark) ::slotted(a:active),:host(.button-variant-icon-primary.dark.loading) .button,:host(.button-variant-icon-primary.dark.loading) ::slotted(a){background:var(--ic-action-dark-active)}:host(.button-variant-icon-secondary) .button,:host(.button-variant-icon-secondary) ::slotted(a){border:var(--ic-border-width) solid var(--button-default);color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-secondary) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-secondary) .button:hover,:host(.button-variant-icon-secondary) ::slotted(a:hover){background-color:var(--button-default-background-hover);border-color:var(--button-default-hover);color:var(--button-default-hover)}:host(.button-variant-icon-secondary) .button:active,:host(.button-variant-icon-secondary) ::slotted(a:active),:host(.button-variant-icon-secondary.loading) .button{border-color:var(--button-default-active);background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-icon-secondary.disabled) .button,:host(.button-variant-icon-secondary.disabled) .button:hover,:host(.button-variant-icon-secondary.disabled) .button:active,:host(.button-variant-icon-secondary.disabled) ::slotted(a),:host(.button-variant-icon-secondary.disabled) ::slotted(a:hover),:host(.button-variant-icon-secondary.disabled) ::slotted(a:active){border-color:var(--ic-architectural-300);color:var(--ic-architectural-300);background:none}:host(.button-variant-icon-secondary.light.disabled) .button,:host(.button-variant-icon-secondary.light.disabled) .button:hover,:host(.button-variant-icon-secondary.light.disabled) .button:active,:host(.button-variant-icon-secondary.light.disabled) ::slotted(a),:host(.button-variant-icon-secondary.light.disabled) ::slotted(a:hover),:host(.button-variant-icon-secondary.light.disabled) ::slotted(a:active){border-color:var(--ic-architectural-500);color:var(--ic-architectural-500)}:host(.button-variant-icon-tertiary) .button,:host(.button-variant-icon-tertiary) ::slotted(a){color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-tertiary) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-tertiary) .button:hover,:host(.button-variant-icon-tertiary) ::slotted(a:hover){background-color:var(--button-default-background-hover);color:var(--button-default-hover)}:host(.button-variant-icon-tertiary) .button:active,:host(.button-variant-icon-tertiary) ::slotted(a:active),:host(.button-variant-icon-tertiary.loading) .button{background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-icon-tertiary.disabled) .button,:host(.button-variant-icon-tertiary.disabled) .button:hover,:host(.button-variant-icon-tertiary.disabled) .button:active,:host(.button-variant-icon-tertiary.disabled) ::slotted(a),:host(.button-variant-icon-tertiary.disabled) ::slotted(a:hover),:host(.button-variant-icon-tertiary.disabled) ::slotted(a:active){color:var(--ic-architectural-300);background:none}:host(.button-variant-icon-destructive) .button,:host(.button-variant-icon-destructive) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--ic-action-destructive);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-destructive) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-destructive) .button:hover,:host(.button-variant-icon-destructive) ::slotted(a:hover){background-color:var(--ic-action-destructive-hover)}:host(.button-variant-icon-destructive) .button:active,:host(.button-variant-icon-destructive) ::slotted(a:active),:host(.button-variant-icon-destructive.loading) .button{background-color:var(--ic-action-destructive-active)}:host(.button-variant-icon-destructive.loading) .button ic-loading-indicator{--inner-color:var(--ic-architectural-white)}:host(.button-variant-icon-destructive.disabled) .button,:host(.button-variant-icon-destructive.disabled) .button:hover,:host(.button-variant-icon-destructive.disabled) .button:active,:host(.button-variant-icon-destructive.disabled) ::slotted(a),:host(.button-variant-icon-destructive.disabled) ::slotted(a:hover),:host(.button-variant-icon-destructive.disabled) ::slotted(a:active){background:var(--ic-architectural-200);color:var(--ic-architectural-300)}:host(.button-size-default) .button{height:var(--height, 2.5rem);padding:var(--ic-space-xs) var(--ic-space-md)}:host(.button-size-small) .button{height:var(--height, var(--ic-space-xl));padding:var(--ic-space-xxs) var(--ic-space-md)}:host(.button-size-large) .button{height:var(--height, var(--ic-space-xxl));padding:var(--ic-space-sm) var(--ic-space-md)}:host(.button-size-default.button-variant-icon) .button,:host(.button-size-default.button-variant-icon-primary) .button,:host(.button-size-default.button-variant-icon-secondary) .button,:host(.button-size-default.button-variant-icon-tertiary) .button,:host(.button-size-default.button-variant-icon-destructive) .button,:host(.button-size-default.button-variant-icon-primary) ::slotted(a),:host(.button-size-default.button-variant-icon-secondary) ::slotted(a),:host(.button-size-default.button-variant-icon-tertiary) ::slotted(a),:host(.button-size-default.button-variant-icon-destructive) ::slotted(a),:host(.button-size-default.button-variant-icon) ::slotted(a){height:var(--height, var(--ic-space-xl));width:var(--ic-space-xl);padding:0.375rem}:host(.button-size-small.button-variant-icon) .button,:host(.button-size-small.button-variant-icon-primary) .button,:host(.button-size-small.button-variant-icon-secondary) .button,:host(.button-size-small.button-variant-icon-tertiary) .button,:host(.button-size-small.button-variant-icon-destructive) .button,:host(.button-size-small.button-variant-icon-primary) ::slotted(a),:host(.button-size-small.button-variant-icon-secondary) ::slotted(a),:host(.button-size-small.button-variant-icon-tertiary) ::slotted(a),:host(.button-size-small.button-variant-icon-destructive) ::slotted(a),:host(.button-size-small.button-variant-icon) ::slotted(a){height:var(--height, var(--ic-space-lg));width:var(--ic-space-lg);padding:var(--ic-space-xxs)}:host(.button-size-large.button-variant-icon) .button,:host(.button-size-large.button-variant-icon-primary) .button,:host(.button-size-large.button-variant-icon-secondary) .button,:host(.button-size-large.button-variant-icon-tertiary) .button,:host(.button-size-large.button-variant-icon-destructive) .button,:host(.button-size-large.button-variant-icon-primary) ::slotted(a),:host(.button-size-large.button-variant-icon-secondary) ::slotted(a),:host(.button-size-large.button-variant-icon-tertiary) ::slotted(a),:host(.button-size-large.button-variant-icon-destructive) ::slotted(a),:host(.button-size-large.button-variant-icon) ::slotted(a){height:var(--height, 2.5rem);width:2.5rem;padding:var(--ic-space-xs)}:host(.full-width),:host(.full-width) .button,:host(.full-width) ::slotted(a){width:100%}div.loading-container{position:relative;align-items:center;width:100%}ic-loading-indicator{--outer-color:transparent}@keyframes loading-animation{0%{width:0%;left:0%}25%{width:0%;left:0%;opacity:0}50%{width:100%;left:0%;opacity:1}75%{width:0%;left:100%}100%{width:0%;left:100%;opacity:0}}div.icon-container{box-sizing:border-box;width:var(--ic-space-lg);height:var(--ic-space-lg);display:flex;justify-content:center;align-items:center;margin-right:var(--ic-space-xs)}div.right-icon{margin-right:auto;margin-left:var(--ic-space-xs)}:host(.full-width) .right-icon{margin-right:var(--ic-space-xs)}::slotted(:not(ic-badge)){width:var(--icon-width) !important;height:var(--icon-height) !important;fill:currentcolor !important;pointer-events:none}:host(.button-variant-icon) .button .icon-container{margin:0;pointer-events:none}:host(.search-submit-button) ::slotted(svg){--icon-height:1.25rem;--icon-width:1.25rem}:host(.search-submit-button-small) ::slotted(svg){--icon-height:1rem;--icon-width:1rem}:host(.clear-button){margin:0 var(--ic-space-xxs)}:host(.clear-button) .button:focus,:host(.calendar-button) .button:focus{box-shadow:none}:host(.search-submit-button) .button:focus{box-shadow:none}:host(.search-submit-button) .button:not(:active):focus{box-shadow:none;background-color:var(--ic-action-default-bg-hover)}:host(.search-submit-button){display:flex;align-items:center;margin:0 var(--ic-space-xxs)}:host(.menu-close-button) ::slotted(svg){--icon-height:0.875rem;--icon-width:0.875rem}:host(.popout-menu-button) .button{height:var(--height);justify-content:left;border-radius:0;white-space:pre-line;text-align:start}:host(.popout-menu-button) div.icon-container{flex:none}:host(.popout-menu-button) .button:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset)}.ic-button-describedby{display:none}:host .ic-tooltip{display:block}:host .arrow-dropdown{margin-top:auto}:host .dropdown-expanded{transform:rotate(180deg);margin-bottom:var(--ic-space-xxxs)}:host(.dropdown-no-icon) .button{padding-right:var(--ic-space-xs)}slot[name=\"router-item\"]::slotted(a){pointer-events:all}::slotted(a){font-size:0.875rem !important;border:none !important;vertical-align:middle !important}:host(.white-background) ::slotted(a){background-color:var(--ic-architectural-white) !important}:host(.button-variant-primary) ::slotted(a){background-color:var(--button-default) !important}:host(.button-variant-primary) ::slotted(a:hover){background-color:var(--button-default-hover) !important}:host(.button-variant-primary) ::slotted(a:active){background-color:var(--button-default-active) !important}:host(.button-variant-primary.disabled) ::slotted(a),:host(.button-variant-destructive.disabled) ::slotted(a){background:var(--ic-architectural-200) !important}:host(.button-variant-primary.light.disabled) ::slotted(a){background:var(--ic-architectural-600) !important}:host(.button-variant-secondary) ::slotted(a){border:var(--ic-border-width) solid var(--button-default) !important}:host(.button-variant-secondary) ::slotted(a:hover){background-color:var(--button-default-background-hover) !important;border-color:var(--button-default-hover) !important}:host(.button-variant-secondary) ::slotted(a:active){border-color:var(--button-default-active) !important;background-color:var(--button-default-background-active) !important}:host(.button-variant-secondary.disabled) ::slotted(a),:host(.button-variant-secondary.disabled) ::slotted(a:hover),:host(.button-variant-secondary.disabled) ::slotted(a:active),:host(.button-variant-tertiary.disabled) ::slotted(a),:host(.button-variant-tertiary.disabled) ::slotted(a:hover),:host(.button-variant-tertiary.disabled) ::slotted(a:active){border-color:var(--ic-architectural-300) !important;background:none !important}:host(.button-variant-secondary.light.disabled) ::slotted(a),:host(.button-variant-secondary.light.disabled) ::slotted(a:hover),:host(.button-variant-secondary.light.disabled) ::slotted(a:active),:host(.button-variant-tertiary.light.disabled) ::slotted(a),:host(.button-variant-tertiary.light.disabled) ::slotted(a:hover),:host(.button-variant-tertiary.light.disabled) ::slotted(a:active){border-color:var(--ic-architectural-500) !important}:host(.button-variant-tertiary) ::slotted(a:hover),:host(.button-variant-icon) ::slotted(a:hover){background-color:var(--button-default-background-hover) !important}:host(.button-variant-tertiary) ::slotted(a:active:not(:focus)),:host(.button-variant-tertiary) ::slotted(a:active:focus),:host(.button-variant-tertiary) ::slotted(a:active),:host(.button-variant-icon) ::slotted(a:active:not(:focus)){background-color:var(--button-default-background-active) !important}:host(.button-variant-icon.disabled) ::slotted(a),:host(.button-variant-icon.disabled) ::slotted(a:hover),:host(.button-variant-icon.disabled) ::slotted(a:active){background:none !important}:host(.button-variant-destructive) ::slotted(a){background-color:var(--ic-action-destructive) !important}:host(.button-variant-destructive) ::slotted(a:hover){background-color:var(--ic-action-destructive-hover) !important}:host(.button-variant-destructive) ::slotted(a:active){background-color:var(--ic-action-destructive-active) !important}:host(.button-size-default) ::slotted(a){height:var(--height, 2.5rem) !important;padding:var(--ic-space-xs) var(--ic-space-md) !important}:host(.button-size-small) ::slotted(a){height:var(--height, var(--ic-space-xl)) !important;padding:var(--ic-space-xxs) var(--ic-space-md) !important}:host(.button-size-large) ::slotted(a){height:var(--height, var(--ic-space-xxl)) !important;padding:var(--ic-space-sm) var(--ic-space-md) !important}:host(.button-size-default.button-variant-icon) ::slotted(a){height:var(--height, var(--ic-space-xl)) !important;padding:0.375rem !important}:host(.button-size-small.button-variant-icon) ::slotted(a){padding:var(--ic-space-xxs) !important}:host(.button-size-large.button-variant-icon) ::slotted(a){padding:var(--ic-space-xs) !important}@media (forced-colors: active){.button,::slotted(a){border:0.125rem solid transparent !important}}:host(.flip) ::slotted(svg){transform:scaleX(-1)}";

var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
let buttonIds = 0;
const Button = /*@__PURE__*/ proxyCustomElement(class Button extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.icBlur = createEvent(this, "icBlur", 7);
        this.icFileSelection = createEvent(this, "icFileSelection", 7);
        this.icFocus = createEvent(this, "icFocus", 7);
        this.buttonIdNum = buttonIds++;
        this.hasTooltip = false;
        this.inheritedAttributes = {};
        this.describedbyEl = null;
        this.describedById = null;
        this.mutationObserver = null;
        this.hostMutationObserver = null;
        this.handleClick = () => {
            if ((this.el.type === "submit" || this.el.type === "reset") &&
                !this.hasRouterSlot() &&
                !!this.el.closest("FORM")) {
                const hiddenFormButton = document.createElement("button");
                hiddenFormButton.setAttribute("type", this.el.type);
                hiddenFormButton.style.display = "none";
                this.el.closest("FORM").appendChild(hiddenFormButton);
                hiddenFormButton.click();
                hiddenFormButton.remove();
            }
        };
        this.handleKeyDown = (ev) => {
            if (ev.key === "Escape" && this.hasTooltip) {
                this.closeButtonTooltip(ev);
            }
        };
        this.onFocus = () => {
            this.icFocus.emit();
        };
        this.onBlur = () => {
            this.icBlur.emit();
        };
        // triggered when text content of sibling element in light DOM changes
        this.mutationCallback = () => {
            this.describedByContent = this.describedbyEl.innerText;
        };
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                const attribute = this.el.getAttribute(attributeName);
                if (attributeName === "title")
                    this.title = attribute;
                else if (attributeName === "aria-label")
                    this.ariaLabel = attribute;
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] = attribute;
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.setHasTooltip = () => {
            this.hasTooltip =
                !this.disableTooltip && (!!this.title || this.isIconVariant());
        };
        this.isIconVariant = () => {
            return this.variant.startsWith("icon");
        };
        this.ariaLabel = null;
        this.describedByContent = null;
        this.title = null;
        this.accept = "*";
        this.appearance = "default";
        this.ariaControlsId = undefined;
        this.ariaOwnsId = undefined;
        this.disabled = false;
        this.disableTooltip = false;
        this.download = false;
        this.dropdown = false;
        this.dropdownExpanded = false;
        this.fileUpload = false;
        this.fileInputName = `ic-button-file-upload-input-${buttonIds++}`;
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.fullWidth = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.loading = false;
        this.multiple = false;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.selectedFiles = undefined;
        this.size = "default";
        this.target = undefined;
        this.tooltipPlacement = "bottom";
        this.transparentBackground = true;
        this.type = "button";
        this.variant = "primary";
    }
    watchDisabledHandler() {
        removeDisabledFalse(this.disabled, this.el);
    }
    disconnectedCallback() {
        if (this.mutationObserver !== null && this.mutationObserver !== undefined) {
            this.mutationObserver.disconnect();
        }
        if (this.hostMutationObserver !== null &&
            this.hostMutationObserver !== undefined) {
            this.hostMutationObserver.disconnect();
        }
    }
    componentWillUpdate() {
        if (this.loading) {
            this.el.style.setProperty("--min-width", `${this.el.getBoundingClientRect().width}px`);
        }
        this.setHasTooltip();
    }
    componentWillLoad() {
        const _a = inheritAttributes(this.el, [...IC_INHERITED_ARIA, "title"]), { title, "aria-label": ariaLabel } = _a, restInheritedAttributes = __rest(_a, ["title", "aria-label"]);
        this.title = title;
        this.ariaLabel = ariaLabel;
        this.inheritedAttributes = restInheritedAttributes;
        removeDisabledFalse(this.disabled, this.el);
        this.el.setAttribute("exportparts", "button");
        this.id = this.el.id || null;
        this.setHasTooltip();
        if (!this.hasTooltip) {
            const describedById = this.inheritedAttributes["aria-describedby"];
            if (describedById !== undefined) {
                this.describedById = describedById;
                const el = this.el.parentElement.querySelector(`#${describedById}`);
                if (el) {
                    this.describedByContent = el.innerText;
                    this.describedbyEl = el;
                }
            }
        }
    }
    componentDidLoad() {
        this.updateTheme();
        if (typeof MutationObserver !== "undefined") {
            if (this.describedById) {
                this.mutationObserver = new MutationObserver(this.mutationCallback);
                this.mutationObserver.observe(this.describedbyEl, {
                    characterData: true,
                    childList: true,
                    subtree: true,
                });
            }
            this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
            this.hostMutationObserver.observe(this.el, {
                attributes: true,
            });
        }
    }
    componentWillRender() {
        const iconEl = this.hasIconSlot("left")
            ? this.el.querySelector(`[slot="left-icon"]`)
            : this.hasIconSlot("right")
                ? this.el.querySelector(`[slot="right-icon"]`)
                : null;
        iconEl === null || iconEl === void 0 ? void 0 : iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    handleHostClick(event) {
        if (!this.hasRouterSlot()) {
            if (this.fileUpload) {
                renderFileHiddenInput(this.icFileSelection, this.el, this.multiple, this.fileInputName, this.selectedFiles, this.disabled, this.accept);
            }
            if (this.disabled || this.loading) {
                event.stopImmediatePropagation();
            }
            if (this.dropdown) {
                this.dropdownExpanded = !this.dropdownExpanded;
            }
        }
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        var _a;
        (_a = this.buttonEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    async closeButtonTooltip(ev) {
        const tooltip = this.el.shadowRoot.querySelector("ic-tooltip");
        if (await tooltip.isTooltipVisible()) {
            tooltip.displayTooltip(false);
            ev.preventDefault();
            ev.stopImmediatePropagation();
        }
    }
    hasIconSlot(position) {
        const selectorPrefix = position ? `${position}-` : "";
        return this.el.querySelector(`[slot="${selectorPrefix}icon"]`) !== null;
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    updateTheme(newTheme = null) {
        const foregroundColor = getThemeFromContext(this.el, newTheme);
        if (foregroundColor !== IcThemeForegroundEnum.Default) {
            this.appearance = foregroundColor;
        }
    }
    render() {
        const TagType = (this.href && "a") || "button";
        const { title, ariaLabel, inheritedAttributes } = this;
        const buttonAttrs = TagType === "button"
            ? {
                type: this.type,
                disabled: this.disabled,
                form: this.form,
                formaction: this.formaction,
                formenctype: this.formenctype,
                formmethod: this.formmethod,
                formnovalidate: this.formnovalidate,
                formtarget: this.formtarget,
            }
            : {
                download: this.download !== false ? this.download : null,
                href: this.href,
                rel: this.rel,
                target: this.target,
                referrerpolicy: this.referrerpolicy,
                hreflang: this.hreflang,
            };
        let describedby = null;
        let buttonId = null;
        if (this.hasTooltip) {
            buttonId =
                this.id !== null
                    ? `ic-button-with-tooltip-${this.id}`
                    : `ic-button-with-tooltip-${this.buttonIdNum}`;
            describedby =
                this.variant === "icon" && !!ariaLabel
                    ? null
                    : `ic-tooltip-${buttonId}`;
        }
        else {
            describedby = this.describedById;
        }
        const ButtonContent = () => {
            return (h(TagType, Object.assign({ class: "button", "aria-disabled": this.loading || this.disabled ? "true" : null, "aria-label": this.loading ? "Loading" : ariaLabel, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, buttonAttrs, inheritedAttributes, { onFocus: this.onFocus, onBlur: this.onBlur, ref: (el) => (this.buttonEl = el), "aria-describedby": describedby, part: "button" }), this.hasIconSlot() && !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "icon" }))), this.hasIconSlot("left") && !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "left-icon" }))), this.hasIconSlot("top") &&
                !this.hasIconSlot("left") &&
                !this.hasIconSlot("right") &&
                !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "top-icon" }))), this.loading ? (h("div", { class: "loading-container" }, h("ic-loading-indicator", { type: "linear", appearance: this.variant === "primary" ||
                    this.variant === "destructive" ||
                    this.appearance === IcThemeForegroundEnum.Dark ||
                    this.appearance === IcThemeForegroundEnum.Light
                    ? "light"
                    : "dark" }))) : (h("slot", null)), this.hasIconSlot("right") && !this.loading && !this.dropdown && (h("div", { class: { "icon-container": true, "right-icon": true } }, h("slot", { name: "right-icon" }))), this.dropdown &&
                !this.loading &&
                this.variant !== "icon" &&
                this.variant !== "destructive" && (h("span", { class: {
                    ["arrow-dropdown"]: !this.dropdownExpanded,
                    ["dropdown-expanded"]: this.dropdownExpanded,
                }, innerHTML: arrowDropdown }))));
        };
        return (h(Host, { class: {
                ["disabled"]: this.disabled && !this.loading,
                [`button-variant-${this.variant}`]: true,
                [`button-size-${this.size}`]: true,
                ["loading"]: this.loading,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
                ["light"]: this.appearance === IcThemeForegroundEnum.Light,
                ["full-width"]: this.fullWidth,
                ["with-badge"]: isSlotUsed(this.el, "badge"),
                ["dropdown-no-icon"]: this.dropdown &&
                    !isSlotUsed(this.el, "icon") &&
                    !isSlotUsed(this.el, "left-icon"),
                ["top-icon"]: isSlotUsed(this.el, "top-icon"),
                ["white-background"]: this.variant === "secondary" &&
                    !this.transparentBackground &&
                    this.appearance !== "light",
            }, onClick: this.handleClick, onKeyDown: this.handleKeyDown, "aria-owns": this.ariaOwnsId, "aria-controls": this.ariaControlsId, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, this.hasTooltip && (h("ic-tooltip", { id: describedby, label: title || ariaLabel, target: buttonId, placement: this.tooltipPlacement, silent: this.isIconVariant() && !!ariaLabel }, this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h(ButtonContent, null)))), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" }), !this.hasTooltip &&
            (this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h(ButtonContent, null))), this.describedByContent && (h("span", { id: describedby, class: "ic-button-describedby" }, this.describedByContent))));
    }
    static get delegatesFocus() { return true; }
    get el() { return this; }
    static get watchers() { return {
        "disabled": ["watchDisabledHandler"]
    }; }
    static get style() { return icButtonCss; }
}, [17, "ic-button", {
        "accept": [1],
        "appearance": [1025],
        "ariaControlsId": [8, "aria-controls-id"],
        "ariaOwnsId": [8, "aria-owns-id"],
        "disabled": [4],
        "disableTooltip": [4, "disable-tooltip"],
        "download": [8],
        "dropdown": [4],
        "dropdownExpanded": [1540, "dropdown-expanded"],
        "fileUpload": [4, "file-upload"],
        "fileInputName": [1, "file-input-name"],
        "form": [1],
        "formaction": [1],
        "formenctype": [1],
        "formmethod": [1],
        "formnovalidate": [4],
        "formtarget": [1],
        "fullWidth": [4, "full-width"],
        "href": [1],
        "hreflang": [1],
        "loading": [4],
        "multiple": [4],
        "referrerpolicy": [1],
        "rel": [1],
        "selectedFiles": [16],
        "size": [1],
        "target": [1],
        "tooltipPlacement": [1, "tooltip-placement"],
        "transparentBackground": [4, "transparent-background"],
        "type": [1],
        "variant": [1],
        "ariaLabel": [32],
        "describedByContent": [32],
        "title": [32],
        "setFocus": [64]
    }, [[2, "click", "handleHostClick"], [4, "themeChange", "themeChangeHandler"]], {
        "disabled": ["watchDisabledHandler"]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-button", "ic-loading-indicator", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-button":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Button);
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { Button as B, defineCustomElement as d };

//# sourceMappingURL=ic-button2.js.map