import { proxyCustomElement, HTMLElement, forceUpdate, h } from '@stencil/core/internal/client';
import { f as checkSlotInChildMutations, r as removeDisabledFalse, i as isSlotUsed, o as onComponentRequiredPropUndefined, g as getThemeFromContext } from './helpers.js';
import { I as IcThemeForegroundEnum } from './types.js';
import { c as chevronIcon } from './chevron-icon.js';
import { d as defineCustomElement$3 } from './ic-tooltip2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icCardCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:flex}a{text-decoration:none !important;color:var(--ic-architechtural-black) !important}button{border:none;background-color:transparent;outline:var(--ic-hc-focus-outline)}.card,.card.clickable{display:flex;flex-direction:column;border:var(--ic-border-default);border-radius:var(--ic-border-radius);box-sizing:border-box;padding:var(--ic-space-md);text-align:left;color:var(--ic-architechtural-black);transition:var(--ic-easing-transition-fast);position:relative;width:inherit;min-width:-moz-fit-content;min-width:fit-content;height:-moz-fit-content;height:fit-content;min-height:100%}.dark.card,.dark.card.clickable{border:var(--ic-border-width) solid var(--ic-architectural-700)}.card.clickable:hover{background-color:var(--ic-action-default-bg-hover);border:var(--ic-border-hover);cursor:pointer}.card.clickable:focus,.card.clickable.focussed{background-color:var(--ic-action-default-bg-hover);box-shadow:var(--ic-border-focus);outline:var(--ic-hc-focus-outline);border:var(--ic-border-pressed)}.card.clickable:active{background-color:var(--ic-action-default-bg-active);box-shadow:var(--ic-border-focus)}.card.disabled{border:var(--ic-border-disabled)}.card.fullwidth{width:100%}.card-header{display:flex;align-items:center}.icon{display:flex;align-items:center;padding-right:var(--ic-space-xs)}.card.disabled ::slotted(svg){fill:var(--ic-color-tertiary-text)}.card.clickable .card-title{color:var(--ic-hyperlink);text-decoration:underline;text-decoration-thickness:var(--ic-space-1px)}.card.clickable:hover .card-title,.card.clickable:focus .card-title,.card.clickable.focussed .card-title{display:inline-block;border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}@supports (text-underline-offset: 25%){.card.clickable:hover .card-title,.card.clickable:focus .card-title,.card.clickable.focussed .card-title{text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:25%;border-bottom:0 !important;margin-bottom:0 !important}}.card.clickable:active .card-title{text-decoration:none}.card.disabled .card-title{text-decoration:underline;text-decoration-thickness:var(--ic-space-1px);text-decoration-color:var(--ic-color-tertiary-text);color:var(--ic-color-tertiary-text)}.subheading{margin-top:var(--ic-space-xxs)}.adornment{margin-top:var(--ic-space-xxs)}.card-message{margin-top:var(--ic-space-md);align-items:left}.card.disabled .card-message,.card.disabled .subheading{color:var(--ic-color-tertiary-text)}.interaction-button{margin-left:auto}.image-top{margin-bottom:var(--ic-space-md);display:flex;justify-content:center}.image-mid{margin-top:var(--ic-space-md);display:flex;justify-content:center}.interaction-area{display:flex;flex-grow:1;gap:var(--ic-space-md);margin-top:var(--ic-space-md);align-items:flex-end}.interaction-controls{display:flex;align-items:center;flex-wrap:wrap;gap:var(--ic-space-sm)}.toggle-button{color:var(--ic-action-default);width:2.5rem;height:2.5rem;padding:var(--ic-space-xs);margin:var(--ic-space-1px) 0;min-width:0;cursor:pointer;transition:var(--ic-easing-transition-fast);border-radius:var(--ic-border-radius);display:inline-flex;flex-direction:row;justify-content:center;align-items:center;background:none;border:none;box-sizing:border-box;white-space:nowrap;vertical-align:middle}#ic-tooltip-expand-button{margin-left:auto;position:relative}.toggle-button:hover,.toggle-button:hover:focus{background-color:var(--ic-action-default-bg-hover);color:var(--ic-action-default-hover)}.toggle-button:focus{box-shadow:var(--ic-border-focus)}.toggle-button:active:not(:focus){background-color:var(--ic-action-default-bg-active);color:var(--ic-action-default-active)}.toggle-button svg{pointer-events:none;width:100% !important;height:100% !important;fill:currentcolor !important}.toggle-button-closed svg{transform:rotate(90deg)}.toggle-button-expanded svg{transform:rotate(-90deg)}.expanded-content{margin-top:var(--ic-space-md)}@media (forced-colors: active){.card ::slotted(svg){fill:currentcolor}.card.disabled ::slotted(svg){fill:GrayText !important}.card.disabled{border-color:GrayText !important}.card.disabled .card-message,.card.disabled .subheading,.card.disabled .card-title{color:GrayText}}";

const Card = /*@__PURE__*/ proxyCustomElement(class Card extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.hostMutationObserver = null;
        this.parentFocussed = () => {
            this.isFocussed = true;
        };
        this.parentBlurred = () => {
            this.isFocussed = false;
        };
        this.toggleExpanded = () => {
            this.areaExpanded = !this.areaExpanded;
        };
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, [
                    "message",
                    "adornment",
                    "expanded-content",
                    "image-top",
                    "image-mid",
                    "icon",
                    "interaction-button",
                    "badge",
                    "interaction-controls",
                ])
                : false)) {
                forceUpdate(this);
            }
        };
        this.appearance = "default";
        this.areaExpanded = false;
        this.isFocussed = false;
        this.parentEl = null;
        this.parentIsAnchorTag = false;
        this.clickable = false;
        this.disabled = false;
        this.expandable = false;
        this.fullWidth = false;
        this.heading = undefined;
        this.href = undefined;
        this.hreflang = "";
        this.message = "";
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.subheading = undefined;
        this.target = undefined;
    }
    disconnectedCallback() {
        var _a;
        if (this.parentIsAnchorTag) {
            this.parentEl.removeEventListener("focus", this.parentFocussed);
            this.parentEl.removeEventListener("blur", this.parentBlurred);
        }
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        this.parentEl = this.el.parentElement;
        if (this.parentEl.tagName === "A") {
            this.clickable = true;
            this.parentIsAnchorTag = true;
            this.parentEl.classList.add("ic-card-wrapper-link");
            this.parentEl.addEventListener("focus", this.parentFocussed);
            this.parentEl.addEventListener("blur", this.parentBlurred);
        }
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Card");
        this.updateTheme();
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    handleHostClick(event) {
        if (this.disabled) {
            event.stopImmediatePropagation();
        }
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.updateTheme(theme.mode);
    }
    /**
     * Sets focus on the card.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("a")) {
            this.el.shadowRoot.querySelector("a").focus();
        }
        else if (this.el.shadowRoot.querySelector("button")) {
            this.el.shadowRoot.querySelector("button").focus();
        }
    }
    updateTheme(newTheme = null) {
        const foregroundColor = getThemeFromContext(this.el, newTheme || null);
        if (foregroundColor !== IcThemeForegroundEnum.Default) {
            this.appearance = foregroundColor;
        }
    }
    render() {
        const { clickable, disabled, expandable, heading, message, href, hreflang, referrerpolicy, rel, subheading, target, fullWidth, parentIsAnchorTag, isFocussed, } = this;
        const Component = parentIsAnchorTag
            ? "div"
            : clickable
                ? this.href === undefined
                    ? "button"
                    : "a"
                : "div";
        const attrs = Component == "a" && {
            href: href,
            hrefLang: hreflang,
            referrerPolicy: referrerpolicy,
            rel: rel,
            target: target,
        };
        return (h(Component, Object.assign({ class: {
                ["card"]: true,
                ["clickable"]: clickable && !disabled,
                ["disabled"]: disabled,
                ["fullwidth"]: fullWidth,
                ["focussed"]: isFocussed,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
            }, tabindex: clickable && !parentIsAnchorTag ? 0 : null, "aria-disabled": disabled ? "true" : null, disabled: disabled ? true : null }, attrs), isSlotUsed(this.el, "image-top") && (h("div", { class: "image-top" }, h("slot", { name: "image-top" }))), h("div", { class: "card-header" }, isSlotUsed(this.el, "icon") && (h("div", { class: "icon" }, h("slot", { name: "icon" }))), h("div", { class: "card-title" }, h("slot", { name: "heading" }, h("ic-typography", { variant: "h4" }, h("p", null, heading)))), isSlotUsed(this.el, "interaction-button") && (h("div", { class: "interaction-button" }, h("slot", { name: "interaction-button" })))), (subheading || isSlotUsed(this.el, "subheading")) && (h("div", { class: "subheading" }, h("slot", { name: "subheading" }, h("ic-typography", { variant: "subtitle-small" }, subheading)))), isSlotUsed(this.el, "adornment") && (h("div", { class: "adornment" }, h("slot", { name: "adornment" }))), isSlotUsed(this.el, "image-mid") && (h("div", { class: "image-mid" }, h("slot", { name: "image-mid" }))), (message || isSlotUsed(this.el, "message")) && (h("div", { class: {
                ["card-message"]: true,
            } }, message && h("ic-typography", { variant: "body" }, message), isSlotUsed(this.el, "message") && h("slot", { name: "message" }))), (isSlotUsed(this.el, "interaction-controls") || expandable) && (h("div", { class: "interaction-area" }, h("div", { class: "interaction-controls" }, h("slot", { name: "interaction-controls" })), expandable && (h("ic-tooltip", { id: "ic-tooltip-expand-button", label: "Toggle expandable area", silent: true }, h("button", { class: {
                ["toggle-button"]: true,
                [`toggle-button-${this.areaExpanded ? "expanded" : "closed"}`]: true,
            }, "aria-label": "Toggle expandable area", "aria-expanded": `${this.areaExpanded}`, "aria-controls": this.areaExpanded ? "expanded-content-area" : null, onClick: this.toggleExpanded, innerHTML: chevronIcon }))))), isSlotUsed(this.el, "expanded-content") && this.areaExpanded && (h("div", { class: "expanded-content", id: "expanded-content-area" }, h("slot", { name: "expanded-content" }))), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" })));
    }
    get el() { return this; }
    static get style() { return icCardCss; }
}, [1, "ic-card", {
        "clickable": [1028],
        "disabled": [4],
        "expandable": [4],
        "fullWidth": [4, "full-width"],
        "heading": [1],
        "href": [1],
        "hreflang": [1],
        "message": [1],
        "referrerpolicy": [1],
        "rel": [1],
        "subheading": [1],
        "target": [1],
        "appearance": [32],
        "areaExpanded": [32],
        "isFocussed": [32],
        "parentEl": [32],
        "parentIsAnchorTag": [32],
        "setFocus": [64]
    }, [[2, "click", "handleHostClick"], [4, "themeChange", "themeChangeHandler"]]]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-card", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-card":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Card);
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcCard = Card;
const defineCustomElement = defineCustomElement$1;

export { IcCard, defineCustomElement };

//# sourceMappingURL=ic-card.js.map