import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icClassificationBannerCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{position:fixed;left:0;bottom:0;width:100%;height:var(--ic-space-lg);z-index:var(--ic-z-index-classification-banner)}:host(.inline){position:static;left:auto;bottom:auto}.classification-banner{display:flex;flex-direction:row;justify-content:center;align-items:center;padding:var(--ic-space-xxxs) var(--ic-space-md)}.default{background-color:var(--ic-classification-not-set);color:var(--ic-classification-not-set-foreground)}.official,.official-sensitive{background-color:var(--ic-classification-official);color:var(--ic-classification-official-foreground)}.secret{background-color:var(--ic-classification-secret);color:var(--ic-classification-secret-foreground)}.top-secret{background-color:var(--ic-classification-top-secret);color:var(--ic-classification-top-secret-foreground)}.offscreen{position:absolute;left:-9999px;background-color:#fff;color:#000;text-transform:none}@media (forced-colors: active){.classification-banner{border:var(--ic-hc-border)}}";

const classificationText = {
    default: "protective marking not set",
    official: "official",
    "official-sensitive": "official sensitive",
    secret: "secret",
    "top-secret": "top secret",
};
const ClassificationBanner = /*@__PURE__*/ proxyCustomElement(class ClassificationBanner extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.additionalSelectors = "";
        this.classification = "default";
        this.country = "uk";
        this.inline = false;
        this.upTo = false;
    }
    render() {
        const { inline, upTo } = this;
        // In case of unrecognized props, fallback to default
        let { country, additionalSelectors, classification } = this;
        if (!country)
            country = "";
        if (!additionalSelectors)
            additionalSelectors = "";
        if (!classification ||
            (classification && !classificationText[classification]))
            classification = "default";
        return (h(Host, { class: { ["inline"]: inline } }, h("banner", { "aria-label": "Protective marking", class: {
                ["classification-banner"]: true,
                [`${classification}`]: classification,
            } }, classification !== "default" ? (h("span", { class: "offscreen" }, "The protective marking of this page is:", " ")) : null, h("ic-typography", { variant: "caption-uppercase" }, classification === "default"
            ? classificationText[classification]
            : `${upTo ? "up to" : ""} 
               ${country} 
               ${classificationText[classification]} 
               ${additionalSelectors}`))));
    }
    static get style() { return icClassificationBannerCss; }
}, [1, "ic-classification-banner", {
        "additionalSelectors": [1, "additional-selectors"],
        "classification": [1],
        "country": [1],
        "inline": [4],
        "upTo": [4, "up-to"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-classification-banner", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-classification-banner":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, ClassificationBanner);
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcClassificationBanner = ClassificationBanner;
const defineCustomElement = defineCustomElement$1;

export { IcClassificationBanner, defineCustomElement };

//# sourceMappingURL=ic-classification-banner.js.map