import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { c as closeIcon } from './close-icon.js';
import { c as checkResizeObserver, e as isPropDefined, i as isSlotUsed, o as onComponentRequiredPropUndefined } from './helpers.js';
import { d as defineCustomElement$6 } from './ic-alert2.js';
import { d as defineCustomElement$5 } from './ic-button2.js';
import { d as defineCustomElement$4 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$3 } from './ic-tooltip2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icDialogCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{position:fixed;inset:0;display:flex;align-items:center;justify-content:center;min-height:100% !important;background:rgb(0 0 0 / 60%);z-index:var(--ic-z-index-dialog);opacity:0}:host(.fade-in){opacity:1}:host(.disable-height-constraint){background:none;justify-content:unset;align-items:unset}.dialog.disable-height-constraint{max-height:none;position:relative}.dialog.disable-height-constraint .content-area{overflow-y:visible}@media (prefers-reduced-motion: no-preference){:host{transition:opacity var(--ic-easing-transition-slow)}.dialog{transform:translateY(-3rem);transition:transform 1000s}:host(.fade-in) .dialog{transform:translateY(0);transition:transform var(--ic-easing-transition-slow)}}:host(.hidden){display:none}.dialog{background-color:var(--ic-architectural-white);color:var(--ic-architectural-black);border:var(--ic-border-default);border-radius:var(--ic-border-radius);padding:var(--ic-space-xs) 0 var(--ic-space-md);display:flex;flex-direction:column;box-sizing:border-box;overflow-x:visible}.small{width:50%;max-width:25rem;min-height:11rem;max-height:70vh}.medium{width:70vw;max-width:44rem;min-height:12.5rem;max-height:70vh}.large{width:90vw;max-width:62.5rem;min-height:12.5rem;max-height:90vh}.heading-area{display:flex;margin-bottom:var(--ic-space-xs);padding:0 var(--ic-space-md)}.heading{overflow-wrap:break-word}.close-icon{margin-left:auto}.content-area{-ms-overflow-style:none;scrollbar-width:none;padding:0 var(--ic-space-md);margin:0;overflow-y:auto}.content-area::-webkit-scrollbar{display:none}#dialog-content{margin-bottom:var(--ic-space-sm)}#dialog-content ::slotted(ic-typography){overflow-wrap:break-word}#dialog-content ::slotted(*){position:relative}.status-alert{margin-bottom:var(--ic-space-xs)}.dialog-controls{margin-top:auto;padding:var(--ic-space-xs) var(--ic-space-md) 0;display:flex;justify-content:flex-end;gap:var(--ic-space-md)}.dialog-control-button{width:-moz-fit-content;width:fit-content}.backdrop{overflow-y:auto;position:fixed;inset:0;display:flex;align-items:center;justify-content:center;background:rgb(0 0 0 / 60%);z-index:var(--ic-z-index-dialog);padding-top:16px;padding-bottom:16px}@media (min-width: 800px){:host([size=\"large\"]) .dialog:not(.disable-width-constraint)>.content-area{width:75%}}@media (max-width: 576px){.dialog{width:100vw;height:100vh;transform:translateY(-5rem);max-width:none;max-height:none;box-sizing:border-box}.backdrop{padding:0}.dialog.disable-height-constraint{height:auto;min-height:100vh}}@media (max-width: 364px){.triple-button{flex-direction:column;gap:var(--ic-space-xs)}.dialog-control-button{width:unset}}";

const Dialog = /*@__PURE__*/ proxyCustomElement(class Dialog extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.icDialogCancelled = createEvent(this, "icDialogCancelled", 7);
        this.icDialogClosed = createEvent(this, "icDialogClosed", 7);
        this.icDialogConfirmed = createEvent(this, "icDialogConfirmed", 7);
        this.icDialogOpened = createEvent(this, "icDialogOpened", 7);
        this.DATA_GETS_FOCUS = "data-gets-focus";
        this.DATA_GETS_FOCUS_SELECTOR = "[data-gets-focus]";
        this.DIALOG_CONTROLS = "dialog-controls";
        this.dialogHeight = 0;
        this.focusedElementIndex = 0;
        this.IC_TEXT_FIELD = "IC-TEXT-FIELD";
        this.IC_ACCORDION = "IC-ACCORDION";
        this.IC_ACCORDION_GROUP = "IC-ACCORDION-GROUP";
        this.resizeObserver = null;
        this.dialogOpened = () => {
            var _a;
            this.dialogRendered = true;
            if (this.disableHeightConstraint) {
                this.dialogEl.show();
            }
            else {
                (_a = this.dialogEl) === null || _a === void 0 ? void 0 : _a.showModal();
            }
            setTimeout(() => {
                this.fadeIn = true;
                /**
                 * This is required to set scroll back to top if:
                 * - dialog content goes below the fold
                 * - is closed using cancel or confirm and reopened.
                 *
                 * Without this, the scroll bar will start from the dialog's last scroll-x coordinate.
                 */
                if (this.disableHeightConstraint && this.backdropEl.scrollTop !== 0) {
                    this.backdropEl.scrollTop = 0;
                }
            }, 10);
            setTimeout(() => {
                this.setInitialFocus();
                checkResizeObserver(this.runResizeObserver);
            }, 75);
            setTimeout(() => {
                this.getFocusedElementIndex();
                this.icDialogOpened.emit();
            }, 80);
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                clearTimeout(this.resizeTimeout);
                this.resizeTimeout = window.setTimeout(this.resizeObserverCallback, 80);
            });
            this.resizeObserver.observe(this.dialogEl);
        };
        this.resizeObserverCallback = () => {
            if (this.dialogEl.clientHeight !== this.dialogHeight) {
                this.dialogHeight = this.dialogEl.clientHeight;
            }
        };
        this.refreshInteractiveElementsOnSlotChange = () => {
            this.contentArea = this.el.shadowRoot.querySelector("#dialog-content slot");
            this.contentArea.addEventListener("slotchange", this.getInteractiveElements);
        };
        this.removeSlotChangeListener = () => {
            if (this.contentArea) {
                this.contentArea.removeEventListener("slotchange", this.getInteractiveElements);
            }
        };
        this.setInitialFocus = () => {
            this.sourceElement = document.activeElement;
            let focusedElement;
            if (this.el.querySelector(this.DATA_GETS_FOCUS_SELECTOR) !== null) {
                focusedElement = this.el.querySelector(this.DATA_GETS_FOCUS_SELECTOR);
            }
            else {
                focusedElement = this.el.shadowRoot.querySelector(this.DATA_GETS_FOCUS_SELECTOR);
            }
            if (focusedElement.tagName === this.IC_TEXT_FIELD) {
                focusedElement.setFocus();
            }
            else if (focusedElement.tagName === this.IC_ACCORDION_GROUP) {
                focusedElement.setFocus();
            }
            else if (focusedElement.tagName === this.IC_ACCORDION) {
                focusedElement.setFocus();
            }
            else {
                focusedElement.focus({
                    preventScroll: this.disableHeightConstraint ? true : false,
                });
            }
        };
        this.getFocusedElementIndex = () => {
            for (let i = 0; i < this.interactiveElementList.length; i++) {
                if (this.interactiveElementList[i] ===
                    (this.el.shadowRoot.activeElement || document.activeElement)) {
                    this.focusedElementIndex = i;
                }
            }
        };
        this.setAlertVariant = () => {
            if (isPropDefined(this.status) && this.status !== null) {
                const alert = this.el.shadowRoot.querySelector("ic-alert");
                alert.setAttribute("variant", this.status);
            }
        };
        this.closeIconClick = () => {
            this.open = false;
        };
        this.getInteractiveElements = () => {
            this.interactiveElementList = Array.from(this.el.shadowRoot.querySelectorAll("ic-button"));
            const slottedInteractiveElements = Array.from(this.el.querySelectorAll(`a[href], button, input:not(.ic-input), textarea, select, details, [tabindex]:not([tabindex="-1"]), 
          ic-button, ic-checkbox, ic-select, ic-search-bar, ic-tab-group, ic-radio-group, 
          ic-back-to-top, ic-breadcrumb, ic-chip[dismissible="true"], ic-footer-link, ic-link, ic-navigation-button, 
          ic-navigation-item, ic-switch, ic-text-field, ic-accordion-group, ic-accordion`));
            if (slottedInteractiveElements.length > 0) {
                if (slottedInteractiveElements[0].slot !== this.DIALOG_CONTROLS) {
                    slottedInteractiveElements[0].setAttribute(this.DATA_GETS_FOCUS, "");
                }
                else if (!this.destructive) {
                    slottedInteractiveElements[slottedInteractiveElements.length - 1].setAttribute(this.DATA_GETS_FOCUS, "");
                }
            }
            for (let i = 0; i < slottedInteractiveElements.length; i++) {
                this.interactiveElementList.splice(1 + i, 0, slottedInteractiveElements[i]);
            }
        };
        this.getNextFocusEl = (focusedElementIndex) => this.interactiveElementList[focusedElementIndex];
        this.focusNextInteractiveElement = (shiftKey) => {
            this.getFocusedElementIndex();
            this.setFocusIndexBasedOnShiftKey(shiftKey);
            this.loopNextFocusIndexIfLastElement();
            let nextFocusEl = this.getNextFocusEl(this.focusedElementIndex);
            const isHidden = getComputedStyle(nextFocusEl).visibility === "hidden" ||
                (nextFocusEl.tagName === this.IC_ACCORDION_GROUP &&
                    nextFocusEl.hasAttribute("single-expansion"));
            if (nextFocusEl.tagName === this.IC_TEXT_FIELD) {
                nextFocusEl.setFocus();
            }
            else {
                if (isHidden) {
                    this.setFocusIndexBasedOnShiftKey(shiftKey);
                    this.loopNextFocusIndexIfLastElement();
                    nextFocusEl = this.getNextFocusEl(this.focusedElementIndex);
                }
                if (nextFocusEl.tagName === this.IC_ACCORDION_GROUP) {
                    nextFocusEl.setFocus();
                }
                else if (nextFocusEl.tagName === this.IC_ACCORDION) {
                    nextFocusEl.setFocus();
                }
                else {
                    nextFocusEl.focus();
                }
            }
        };
        this.setButtonOnClick = () => {
            var _a, _b, _c;
            if (this.buttons) {
                this.buttonOnclick0 = new Function((_a = this.buttonProps[0]) === null || _a === void 0 ? void 0 : _a.onclick);
                this.buttonOnclick1 = new Function((_b = this.buttonProps[1]) === null || _b === void 0 ? void 0 : _b.onclick);
                this.buttonOnclick2 = new Function((_c = this.buttonProps[2]) === null || _c === void 0 ? void 0 : _c.onclick);
            }
        };
        this.getButtonOnclick = (index) => {
            if (index === 0) {
                return this.buttonOnclick0();
            }
            else if (index === 1) {
                return this.buttonOnclick1();
            }
            else {
                return this.buttonOnclick2();
            }
        };
        this.getButtonVariant = (index) => {
            const mainVariant = this.destructive ? "destructive" : "primary";
            if (this.buttonProps.length === 1) {
                return mainVariant;
            }
            else if (this.buttonProps.length === 2) {
                if (index === 0) {
                    return "tertiary";
                }
                else {
                    return mainVariant;
                }
            }
            else {
                if (index === 2) {
                    return mainVariant;
                }
                else {
                    return "secondary";
                }
            }
        };
        this.renderDialog = () => {
            const { alertHeading, alertMessage, buttons, buttonProps, size, heading, label, status, destructive, dismissLabel, hideCloseButton, } = this;
            return (h("dialog", { class: {
                    ["dialog"]: true,
                    [`${size}`]: true,
                    ["disable-height-constraint"]: this.disableHeightConstraint,
                    ["disable-width-constraint"]: this.disableWidthConstraint,
                }, "aria-labelledby": "dialog-label dialog-heading", "aria-describedby": "dialog-alert dialog-content", ref: (el) => (this.dialogEl = el) }, h("div", { class: "heading-area" }, h("div", { class: "heading-content" }, h("div", { class: "label" }, h("slot", { name: "label" }, h("ic-typography", { variant: "label", id: "dialog-label" }, label))), h("div", { class: "heading" }, h("slot", { name: "heading" }, h("ic-typography", { variant: "h4", id: "dialog-heading" }, heading)))), !hideCloseButton && (h("ic-button", { class: "close-icon", variant: "icon", innerHTML: closeIcon, "aria-label": dismissLabel, onClick: this.closeIconClick, "data-gets-focus": destructive || !buttons ? "" : null }))), h("div", { class: "content-area" }, isSlotUsed(this.el, "alert") ? (h("slot", { name: "alert" })) : (status && (h("ic-alert", { variant: status, heading: alertHeading, message: alertMessage, "title-above": true, class: "status-alert", id: "dialog-alert" }))), h("div", { id: "dialog-content" }, h("slot", null))), (buttons || isSlotUsed(this.el, this.DIALOG_CONTROLS)) && (h("div", { class: {
                    [this.DIALOG_CONTROLS]: true,
                    ["triple-button"]: buttonProps.length === 3,
                } }, h("slot", { name: this.DIALOG_CONTROLS }, !isSlotUsed(this.el, this.DIALOG_CONTROLS) &&
                buttonProps.map((props, index) => {
                    if (index > 2) {
                        return;
                    }
                    else {
                        return (h("ic-button", { variant: this.getButtonVariant(index), onClick: () => this.getButtonOnclick(index), class: "dialog-control-button", "full-width": buttonProps.length === 3, "data-gets-focus": this.getButtonVariant(index) === "primary" ? "" : null }, props.label));
                    }
                }))))));
        };
        this.dialogRendered = false;
        this.fadeIn = false;
        this.alertHeading = undefined;
        this.alertMessage = undefined;
        this.buttons = true;
        this.closeOnBackdropClick = true;
        this.destructive = false;
        this.dismissLabel = "Dismiss";
        this.disableHeightConstraint = false;
        this.disableWidthConstraint = false;
        this.hideCloseButton = false;
        this.heading = undefined;
        this.label = undefined;
        this.open = undefined;
        this.size = "small";
        this.status = undefined;
        this.buttonProps = [
            {
                label: "Cancel",
                onclick: "this.cancelDialog();",
            },
            { label: "Confirm", onclick: "this.confirmDialog();" },
        ];
    }
    watchOpenHandler() {
        if (this.open) {
            this.dialogOpened();
        }
        else {
            this.fadeIn = false;
            if (this.resizeObserver !== null) {
                this.resizeObserver.disconnect();
            }
            setTimeout(() => {
                var _a;
                this.dialogRendered = false;
                this.dialogEl.close();
                (_a = this.sourceElement) === null || _a === void 0 ? void 0 : _a.focus();
                this.dialogHeight = 0;
                this.icDialogClosed.emit();
            }, 80);
        }
    }
    watchPropHandler() {
        this.setButtonOnClick();
    }
    disconnectedCallback() {
        this.removeSlotChangeListener();
    }
    componentWillLoad() {
        if (this.buttonProps.length) {
            this.setButtonOnClick();
        }
    }
    componentDidLoad() {
        this.getInteractiveElements();
        this.setAlertVariant();
        this.refreshInteractiveElementsOnSlotChange();
        if (this.open) {
            this.dialogOpened();
        }
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Dialog");
    }
    componentDidRender() {
        if (getComputedStyle(this.el).display !== "none" &&
            this.disableHeightConstraint) {
            document.body.style.overflow = "hidden";
        }
        else {
            document.body.style.overflow = "auto";
        }
    }
    handleKeyboard(ev) {
        if (this.dialogRendered) {
            switch (ev.key) {
                case "Tab":
                    ev.preventDefault();
                    this.focusNextInteractiveElement(ev.shiftKey);
                    break;
                case "Escape":
                    if (!ev.repeat) {
                        this.open = false;
                    }
                    ev.stopImmediatePropagation();
                    break;
            }
        }
    }
    handleClick(ev) {
        const dialogElement = this.el.shadowRoot.querySelector("dialog");
        if (this.closeOnBackdropClick &&
            ev.composedPath().indexOf(dialogElement) <= 0) {
            const rect = this.dialogEl.getBoundingClientRect();
            const isInDialog = rect.top <= ev.clientY &&
                ev.clientY <= rect.top + rect.height &&
                rect.left <= ev.clientX &&
                ev.clientX <= rect.left + rect.width;
            if (!isInDialog) {
                this.open = false;
            }
        }
    }
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    async showDialog() {
        this.open = true;
    }
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    async hideDialog() {
        this.open = false;
    }
    /**
     * Cancels the dialog. Used by the default 'Cancel' button or can be called manually to trigger cancelling of dialog.
     */
    async cancelDialog() {
        this.icDialogCancelled.emit();
        this.open = false;
    }
    /**
     * Confirms the dialog. Used by the default 'Confirm' button or can be called manually to trigger confirming of dialog.
     */
    async confirmDialog() {
        this.icDialogConfirmed.emit();
    }
    loopNextFocusIndexIfLastElement() {
        if (this.focusedElementIndex > this.interactiveElementList.length - 1)
            this.focusedElementIndex = 0;
        else if (this.focusedElementIndex < 0) {
            this.focusedElementIndex = this.interactiveElementList.length - 1;
        }
    }
    setFocusIndexBasedOnShiftKey(shiftKey) {
        if (shiftKey) {
            this.focusedElementIndex -= 1;
        }
        else {
            this.focusedElementIndex += 1;
        }
    }
    render() {
        return (h(Host, { class: {
                ["hidden"]: !this.dialogRendered,
                ["fade-in"]: this.fadeIn,
                ["disable-height-constraint"]: this.disableHeightConstraint,
            } }, this.disableHeightConstraint ? (h("div", { class: "backdrop", ref: (el) => (this.backdropEl = el) }, this.renderDialog())) : (this.renderDialog())));
    }
    get el() { return this; }
    static get watchers() { return {
        "open": ["watchOpenHandler"],
        "buttonProps": ["watchPropHandler"]
    }; }
    static get style() { return icDialogCss; }
}, [1, "ic-dialog", {
        "alertHeading": [1, "alert-heading"],
        "alertMessage": [1, "alert-message"],
        "buttons": [4],
        "closeOnBackdropClick": [4, "close-on-backdrop-click"],
        "destructive": [4],
        "dismissLabel": [1, "dismiss-label"],
        "disableHeightConstraint": [4, "disable-height-constraint"],
        "disableWidthConstraint": [4, "disable-width-constraint"],
        "hideCloseButton": [4, "hide-close-button"],
        "heading": [1],
        "label": [1],
        "open": [1540],
        "size": [1],
        "status": [1],
        "buttonProps": [16],
        "dialogRendered": [32],
        "fadeIn": [32],
        "showDialog": [64],
        "hideDialog": [64],
        "cancelDialog": [64],
        "confirmDialog": [64]
    }, [[4, "keydown", "handleKeyboard"], [0, "click", "handleClick"]], {
        "open": ["watchOpenHandler"],
        "buttonProps": ["watchPropHandler"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-dialog", "ic-alert", "ic-button", "ic-loading-indicator", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-dialog":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Dialog);
            }
            break;
        case "ic-alert":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ic-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcDialog = Dialog;
const defineCustomElement = defineCustomElement$1;

export { IcDialog, defineCustomElement };

//# sourceMappingURL=ic-dialog.js.map