import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { n as getThemeForegroundColor } from './helpers.js';
import { I as IcThemeForegroundEnum } from './types.js';

const icDividerCss = "hr.sc-ic-divider{padding:0;margin:0;border:none;height:var(--ic-space-1px);background-color:var(--ic-keyline-darken-rgb)}hr.light.sc-ic-divider{background-color:var(--ic-keyline-lighten-rgb)}";

const Divider = /*@__PURE__*/ proxyCustomElement(class Divider extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.foregroundColor = getThemeForegroundColor();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    render() {
        return (h(Host, { "aria-hidden": "true" }, h("hr", { class: {
                ["light"]: this.foregroundColor === IcThemeForegroundEnum.Light,
            } })));
    }
    static get style() { return icDividerCss; }
}, [2, "ic-divider", {
        "foregroundColor": [32]
    }, [[4, "themeChange", "themeChangeHandler"]]]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-divider"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-divider":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Divider);
            }
            break;
    } });
}

export { Divider as D, defineCustomElement as d };

//# sourceMappingURL=ic-divider2.js.map