import { proxyCustomElement, HTMLElement, forceUpdate, h, Host } from '@stencil/core/internal/client';
import { f as checkSlotInChildMutations, i as isSlotUsed, o as onComponentRequiredPropUndefined } from './helpers.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icEmptyStateCss = ":host{gap:var(--ic-space-xs);padding:var(--ic-space-xs)}:host,.action-area{display:flex;flex-direction:column}.action-area{gap:var(--ic-space-md)}:host ::slotted(svg),:host ::slotted(img){border-radius:var(--ic-space-xxs)}:host(.right),:host(.right) .action-area{align-items:flex-end;text-align:right}:host(.center),:host(.center) .action-area{align-items:center;text-align:center}:host(.image-default) ::slotted(svg),:host(.image-default) ::slotted(img){height:calc(3 * var(--ic-space-lg)) !important;width:calc(3 * var(--ic-space-lg)) !important}:host(.image-small) ::slotted(svg),:host(.image-small) ::slotted(img){height:var(--ic-space-xxl) !important;width:var(--ic-space-xxl) !important}:host(.image-large) ::slotted(svg),:host(.image-large) ::slotted(img){height:calc(4 * var(--ic-space-xl)) !important;width:calc(4 * var(--ic-space-xl)) !important}";

const EmptyState = /*@__PURE__*/ proxyCustomElement(class EmptyState extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.hostMutationObserver = null;
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, [
                    "image",
                    "actions",
                ])
                : false)) {
                forceUpdate(this);
            }
        };
        this.aligned = "left";
        this.body = undefined;
        this.bodyMaxLines = undefined;
        this.heading = undefined;
        this.imageSize = "default";
        this.subheading = undefined;
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentDidLoad() {
        !isSlotUsed(this.el, "heading") &&
            onComponentRequiredPropUndefined([{ prop: this.heading, propName: "heading" }], "Empty State");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            childList: true,
        });
    }
    render() {
        const { aligned, body, bodyMaxLines, heading, imageSize, subheading } = this;
        return (h(Host, { class: {
                [`${aligned}`]: true,
                [`image-${imageSize}`]: isSlotUsed(this.el, "image"),
            } }, isSlotUsed(this.el, "image") && h("slot", { name: "image" }), h("div", null, h("slot", { name: "heading" }, h("ic-typography", { variant: "h4" }, heading)), h("slot", { name: "subheading" }, h("ic-typography", { variant: "subtitle-small" }, subheading)), h("slot", { name: "body" }, h("ic-typography", { maxLines: bodyMaxLines }, body))), isSlotUsed(this.el, "actions") && (h("div", { class: "action-area" }, h("slot", { name: "actions" })))));
    }
    get el() { return this; }
    static get style() { return icEmptyStateCss; }
}, [1, "ic-empty-state", {
        "aligned": [1],
        "body": [1],
        "bodyMaxLines": [2, "body-max-lines"],
        "heading": [1],
        "imageSize": [1, "image-size"],
        "subheading": [1]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-empty-state", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-empty-state":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, EmptyState);
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcEmptyState = EmptyState;
const defineCustomElement = defineCustomElement$1;

export { IcEmptyState, defineCustomElement };

//# sourceMappingURL=ic-empty-state.js.map