import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { D as DEVICE_SIZES, n as getThemeForegroundColor, o as onComponentRequiredPropUndefined } from './helpers.js';
import { d as defineCustomElement$3 } from './ic-section-container2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icFooterLinkGroupCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host(.footer-link-group-sparse){--footer-link-group-margin-right:5.938rem;--footer-link-group-border-bottom:0 solid transparent;--footer-link-group-title-margin-top:0;--footer-link-group-title-margin-bottom:var(--ic-space-md)}:host(.footer-link-group-small){--footer-link-group-margin-right:0;--footer-link-group-title-margin-top:var(--ic-space-md);--footer-link-group-title-margin-bottom:var(--ic-space-md);--footer-link-group-links-padding-left:var(--ic-space-md);--footer-link-group-links-padding-bottom:var(--ic-space-md)}:host(.footer-link-group-light.footer-link-group-small){--footer-link-group-border-bottom:var(--ic-keyline-lighten)}:host(.footer-link-group-dark.footer-link-group-small){--footer-link-group-border-bottom:var(--ic-keyline-darken)}:host(.footer-link-group){margin-right:var(--footer-link-group-margin-right);border-bottom:var(--footer-link-group-border-bottom)}:host(.footer-link-group-small.footer-link-group-light:hover){background-color:var(--ic-action-light-bg-hover);cursor:pointer}:host(.footer-link-group-small.footer-link-group-dark:hover){background-color:var(--ic-action-dark-bg-hover);cursor:pointer}:host(.footer-link-group-sparse:focus){box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);outline:var(--ic-hc-focus-outline);z-index:1}:host(.footer-link-group-small:focus){box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);outline:var(--ic-hc-focus-outline);z-index:1}:host(.footer-link-group-small.footer-link-group-light:active){background-color:var(--ic-action-light-bg-active)}:host(.footer-link-group-small.footer-link-group-dark:active){background-color:var(--ic-action-dark-bg-active)}.footer-link-group-title{margin-top:var(--footer-link-group-title-margin-top);margin-bottom:var(--footer-link-group-title-margin-bottom);flex-grow:1}.footer-link-group-toggle{fill:white !important}.footer-link-group-links{display:flex;flex-direction:column}.footer-link-group-header{display:flex;align-items:center}";

const FooterLinkGroup = /*@__PURE__*/ proxyCustomElement(class FooterLinkGroup extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.handleKeydown = (event) => {
            if (event.key === " " || event.key === "Enter") {
                this.toggleExpanded();
            }
        };
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
        };
        this.expanded = false;
        this.deviceSize = DEVICE_SIZES.XL;
        this.dropdownIconStyle = getThemeForegroundColor();
        this.small = false;
        this.groupTitle = undefined;
    }
    componentWillLoad() {
        this.small = this.isSmall(this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.groupTitle, propName: "group-title" }], "Footer Link Group");
    }
    footerResizeHandler() {
        this.small = this.isSmall(this.el);
    }
    footerThemeChangeHandler(ev) {
        const theme = ev.detail;
        this.dropdownIconStyle = theme.mode;
    }
    isSmall(e) {
        if (e.parentElement !== null) {
            if (e.parentElement.classList.contains("footer")) {
                return e.parentElement.classList.contains("footer-small");
            }
            else {
                return this.isSmall(e.parentElement);
            }
        }
        else {
            return false;
        }
    }
    render() {
        const { small, groupTitle } = this;
        return !small ? (h(Host, { class: {
                ["footer-link-group footer-link-group-sparse"]: true,
                [`footer-link-group-${this.dropdownIconStyle}`]: true,
            }, role: "listitem" }, h("div", { class: "footer-link-group-title" }, h("ic-typography", { variant: "subtitle-small" }, groupTitle)), h("div", { class: "footer-link-group-links", role: "list" }, h("slot", null)))) : (h(Host, { class: {
                ["footer-link-group footer-link-group-small"]: true,
                [`footer-link-group-${this.dropdownIconStyle}`]: true,
            }, tabIndex: "1", onClick: this.toggleExpanded, onKeydown: this.handleKeydown, "aria-expanded": this.expanded }, h("ic-section-container", { fullHeight: true }, h("div", { class: "footer-link-group-header" }, h("div", { class: "footer-link-group-title" }, h("ic-typography", { variant: "label" }, groupTitle)), this.expanded ? (h("svg", { class: "footer-link-group-toggle", xmlns: "http://www.w3.org/2000/svg", "aria-hidden": "true", role: "img", width: "1em", height: "1em", preserveAspectRatio: "xMidYMid meet", viewBox: "0 0 1200 1200" }, h("path", { fill: "currentColor", d: "M600.002 210.605L421.285 389.336L0 810.559l178.721 178.836l421.281-421.341l421.281 421.341L1200 810.559L778.733 389.336L600.002 210.605z" }))) : (h("svg", { class: "footer-link-group-toggle", xmlns: "http://www.w3.org/2000/svg", "aria-hidden": "true", role: "img", width: "1em", height: "1em", preserveAspectRatio: "xMidYMid meet", viewBox: "0 0 1200 1200" }, h("g", { transform: "translate(0 1200) scale(1 -1)" }, h("path", { fill: "currentColor", d: "M600.002 210.605L421.285 389.336L0 810.559l178.721 178.836l421.281-421.341l421.281 421.341L1200 810.559L778.733 389.336L600.002 210.605z" }))))), this.expanded && (h("div", { class: "footer-link-group-links", role: "list" }, h("slot", null))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return this; }
    static get style() { return icFooterLinkGroupCss; }
}, [17, "ic-footer-link-group", {
        "groupTitle": [1, "group-title"],
        "expanded": [32],
        "deviceSize": [32],
        "dropdownIconStyle": [32],
        "small": [32]
    }, [[4, "footerResized", "footerResizeHandler"], [4, "themeChange", "footerThemeChangeHandler"]]]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-footer-link-group", "ic-section-container", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-footer-link-group":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, FooterLinkGroup);
            }
            break;
        case "ic-section-container":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcFooterLinkGroup = FooterLinkGroup;
const defineCustomElement = defineCustomElement$1;

export { IcFooterLinkGroup, defineCustomElement };

//# sourceMappingURL=ic-footer-link-group.js.map