import { proxyCustomElement, HTMLElement, forceUpdate, h, Host } from '@stencil/core/internal/client';
import { a as IcInformationStatus } from './types.js';
import { f as checkSlotInChildMutations, C as slotHasContent, B as successIcon } from './helpers.js';

const icInputComponentContainerCss = "ic-input-component-container{display:flex;border:var(--ic-border-width) solid\n    var(--border-color, var(--ic-architectural-400));border-radius:var(--ic-border-radius);transition:var(--ic-easing-transition-slow);height:2.5rem;width:var(--input-width, 20rem);padding:var(--ic-space-1px);background-color:var(--ic-architectural-white);box-sizing:border-box;fill:var(--ic-architectural-400);outline:none}ic-input-component-container.fullwidth{width:100%}ic-input-component-container.disabled,ic-input-component-container.disabled:hover{border:var(--ic-border-width) dashed var(--ic-architectural-200)}ic-input-component-container.readonly,ic-input-component-container.readonly:hover{border:none;padding:0}ic-input-component-container.error{border:var(--ic-error-border-default);padding:0}ic-input-component-container.error:hover{border:var(--ic-error-border-hover)}ic-input-component-container.error:focus-within{border:var(--ic-error-border-pressed)}ic-input-component-container.warning{border:var(--ic-warning-border-default);padding:0}ic-input-component-container.warning:hover{border:var(--ic-warning-border-hover)}ic-input-component-container.warning:focus-within{border:var(--ic-warning-border-pressed)}ic-input-component-container.success{border:var(--ic-success-border-default);padding:0}ic-input-component-container.success:hover{border:var(--ic-success-border-hover)}ic-input-component-container.success:focus-within{border:var(--ic-success-border-pressed)}ic-input-component-container.small{height:var(--ic-space-xl)}ic-input-component-container.large{height:var(--ic-space-xxl)}ic-input-component-container.multiline{height:auto}ic-input-component-container .icon-container{margin-top:var(--ic-space-xxs);margin-left:0.438rem;display:flex;align-items:center}ic-input-component-container.multiline .icon-container,ic-input-component-container.multiline.small .icon-container{margin-top:0.375rem;display:block}ic-input-component-container.readonly .icon-container{margin-left:-0.313rem}ic-input-component-container.disabled ::-moz-placeholder{display:none}ic-input-component-container.disabled ::placeholder{display:none}ic-input-component-container .inline-success{margin:var(--ic-space-xs) 0.375rem;display:flex;align-items:center}ic-input-component-container.dark:hover{--border-color:var(--ic-architectural-400)}ic-input-component-container .inline-success>svg{fill:var(--ic-status-success);height:1.25rem;width:1.25rem}ic-input-component-container:hover{border:var(--ic-border-hover);color:var(--ic-action-dark-hover)}ic-input-component-container:focus{border:var(--ic-border-pressed)}.focus-indicator{display:flex;width:100%;margin:-0.125rem;padding:0.125rem;border-radius:var(--ic-border-radius);transition:var(--ic-easing-transition-fast)}.focus-indicator:focus-within,.focus-indicator-enabled{box-shadow:var(--ic-border-focus)}.focus-indicator.dark:focus-within{box-shadow:var(--ic-border-focus)}@media (forced-colors: active){ic-input-component-container,.focus-indicator{transition:none}ic-input-component-container:focus-within{border:var(--ic-border-width) solid Highlight;outline:0.125rem solid Highlight}ic-input-component-container.disabled,ic-input-component-container.disabled:hover{border:var(--ic-border-width) dashed GrayText}}";

const InputComponentContainer = /*@__PURE__*/ proxyCustomElement(class InputComponentContainer extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.hostMutationCallback = (mutationList) => {
            if (mutationList.some(({ type, addedNodes, removedNodes }) => type === "childList"
                ? checkSlotInChildMutations(addedNodes, removedNodes, "left-icon")
                : false)) {
                forceUpdate(this);
            }
        };
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.fullWidth = false;
        this.multiLine = false;
        this.readonly = false;
        this.size = "default";
        this.small = false;
        this.validationInline = false;
        this.validationStatus = "";
    }
    componentDidLoad() {
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, { childList: true });
    }
    render() {
        const { size, small, validationStatus, disabled, readonly, multiLine, fullWidth, dark, appearance, validationInline, } = this;
        const hasValidationStatus = this.validationStatus !== "" && !this.disabled && !this.readonly
            ? true
            : false;
        return (h(Host, { class: {
                small: small,
                [`${size}`]: true,
                [validationStatus]: hasValidationStatus,
                disabled: disabled,
                readonly: readonly,
                ["multiline"]: multiLine,
                ["fullwidth"]: fullWidth,
                ["dark"]: dark || appearance === "dark",
            }, "aria-disabled": disabled && `${disabled}` }, h("div", { class: {
                "focus-indicator": true,
                dark: dark || appearance === "dark",
            } }, slotHasContent(this.el, "left-icon") && (h("div", { class: {
                ["icon-container"]: true,
            } }, h("slot", { name: "left-icon" }))), h("slot", null), validationInline &&
            validationStatus === IcInformationStatus.Success && (h("span", { class: {
                ["inline-success"]: true,
            }, innerHTML: successIcon })))));
    }
    get el() { return this; }
    static get style() { return icInputComponentContainerCss; }
}, [4, "ic-input-component-container", {
        "appearance": [1],
        "dark": [4],
        "disabled": [4],
        "fullWidth": [4, "full-width"],
        "multiLine": [4, "multi-line"],
        "readonly": [4],
        "size": [1],
        "small": [4],
        "validationInline": [4, "validation-inline"],
        "validationStatus": [1, "validation-status"]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-input-component-container"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-input-component-container":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, InputComponentContainer);
            }
            break;
    } });
}

export { InputComponentContainer as I, defineCustomElement as d };

//# sourceMappingURL=ic-input-component-container2.js.map