import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const icInputContainerCss = "ic-input-container .component-container{display:flex;flex-direction:column}";

const InputContainer = /*@__PURE__*/ proxyCustomElement(class InputContainer extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.disabled = false;
        this.readonly = false;
    }
    render() {
        return (h(Host, null, h("div", { class: {
                ["component-container"]: true,
                ["disabled"]: this.disabled,
                ["readonly"]: this.readonly,
            } }, h("slot", null))));
    }
    static get style() { return icInputContainerCss; }
}, [4, "ic-input-container", {
        "disabled": [4],
        "readonly": [4]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-input-container"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-input-container":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, InputContainer);
            }
            break;
    } });
}

export { InputContainer as I, defineCustomElement as d };

//# sourceMappingURL=ic-input-container2.js.map