import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { o as onComponentRequiredPropUndefined, x as getInputHelperTextID } from './helpers.js';
import { d as defineCustomElement$1 } from './ic-typography2.js';

const icInputLabelCss = "ic-input-label{margin-bottom:var(--ic-space-xs)}ic-input-label.with-helper{margin-bottom:var(--ic-space-xxxs)}ic-input-label.readonly{color:var(--ic-color-tertiary-text)}ic-input-label .helpertext{margin-top:var(--ic-space-xxxs)}ic-input-label .helpertext-normal{color:var(--ic-color-secondary-text)}ic-input-label .helpertext-readonly{color:var(--ic-color-tertiary-text)}ic-input-label .readonly-label{color:var(--ic-color-secondary-text)}ic-input-label .error-label{color:var(--ic-status-error)}ic-input-label .dark{color:var(--ic-architectural-white)}";

const InputLabel = /*@__PURE__*/ proxyCustomElement(class InputLabel extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.error = false;
        this.for = undefined;
        this.helperText = "";
        this.label = undefined;
        this.readonly = false;
        this.required = false;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Input Label");
    }
    render() {
        const { disabled, readonly, label, required, helperText, error, dark, appearance, } = this;
        const labelText = required ? label + " *" : label;
        const labelContent = readonly ? (`${labelText}`) : (h("label", { htmlFor: this.for }, labelText));
        const id = getInputHelperTextID(this.for);
        return (h(Host, { class: {
                ["disabled"]: disabled,
                ["readonly"]: readonly,
                ["with-helper"]: helperText !== "",
            } }, h("ic-typography", { variant: "label", class: {
                ["readonly-label"]: readonly,
                ["error-label"]: error && !(readonly || disabled),
                ["dark"]: dark || appearance === "dark",
            } }, labelContent), helperText !== "" && (h("ic-typography", { variant: "caption", class: {
                ["helpertext"]: true,
                ["helpertext-normal"]: !disabled && !readonly,
                ["helpertext-readonly"]: readonly,
            } }, h("span", { id: id }, helperText)))));
    }
    static get style() { return icInputLabelCss; }
}, [0, "ic-input-label", {
        "appearance": [1],
        "dark": [4],
        "disabled": [4],
        "error": [4],
        "for": [1],
        "helperText": [1, "helper-text"],
        "label": [1],
        "readonly": [4],
        "required": [4]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-input-label", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-input-label":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, InputLabel);
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { InputLabel as I, defineCustomElement as d };

//# sourceMappingURL=ic-input-label2.js.map