import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { a as IcInformationStatus } from './types.js';
import { o as onComponentRequiredPropUndefined, y as getInputValidationTextID, z as warningIcon, A as errorIcon, B as successIcon } from './helpers.js';
import { d as defineCustomElement$1 } from './ic-typography2.js';

const icInputValidationCss = "ic-input-validation{width:var(--input-width, 20rem);margin-top:var(--ic-space-xs);display:flex}ic-input-validation.fullwidth{width:100%}ic-input-validation span.status-icon{padding-right:var(--ic-space-xxs)}ic-input-validation span.status-icon>svg{height:1.25rem;width:1.25rem}ic-input-validation span.icon-success>svg{fill:var(--ic-status-success)}ic-input-validation span.icon-error>svg{fill:var(--ic-status-error)}ic-input-validation span.icon-warning>svg{fill:var(--ic-status-warning)}ic-input-validation .statustext{flex-grow:1}";

const icon = {
    [IcInformationStatus.Warning]: warningIcon,
    [IcInformationStatus.Error]: errorIcon,
    [IcInformationStatus.Success]: successIcon,
};
const InputValidation = /*@__PURE__*/ proxyCustomElement(class InputValidation extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.ariaLiveMode = "polite";
        this.for = undefined;
        this.fullWidth = false;
        this.message = undefined;
        this.status = "";
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.message, propName: "message" }], "Input Validation");
    }
    render() {
        const displayIcon = this.status !== "" ? icon[this.status] : "";
        const id = getInputValidationTextID(this.for);
        return (h(Host, { class: {
                [this.status]: this.status !== "",
                ["fullwidth"]: this.fullWidth,
            } }, displayIcon !== "" && (h("span", { class: {
                ["status-icon"]: true,
                [`icon-${this.status}`]: true,
            }, innerHTML: displayIcon })), h("ic-typography", { variant: "caption", class: "statustext" }, h("span", { "aria-live": this.ariaLiveMode, id: id }, this.message)), h("slot", { name: "validation-message-adornment" })));
    }
    get el() { return this; }
    static get style() { return icInputValidationCss; }
}, [4, "ic-input-validation", {
        "ariaLiveMode": [1, "aria-live-mode"],
        "for": [1],
        "fullWidth": [4, "full-width"],
        "message": [1],
        "status": [1]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-input-validation", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-input-validation":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, InputValidation);
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { InputValidation as I, defineCustomElement as d };

//# sourceMappingURL=ic-input-validation2.js.map