import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { I as IcThemeForegroundEnum } from './types.js';
import { e as isPropDefined } from './helpers.js';
import { d as defineCustomElement$1 } from './ic-typography2.js';

const icLoadingIndicatorCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;--linear-border-radius:0.25rem;--inner-color:var(--ic-action-default);--outer-color:var(--ic-architectural-100);--label-color:var(--ic-color-primary-text);--margin:none;--linear-line-height:var(--ic-space-xs)}:host(.light){--inner-color:var(--ic-architectural-white);--outer-color:var(--ic-architectural-800);--label-color:var(--ic-architectural-white)}.ic-loading-container{display:flex;flex-direction:column;justify-content:center;align-items:center}:host([size=\"small\"]){--circular-diameter:2.5rem;--linear-line-height:var(--ic-space-xxs)}:host([size=\"default\"]){--circular-diameter:5rem}:host([size=\"large\"]){--circular-diameter:7.5rem}:host([size=\"icon\"]){display:inline-block;--margin:var(--ic-space-xxxs);--circular-diameter:1.25rem}:host(.label){--margin:0 0 var(--ic-space-xs) 0}.ic-loading-label{color:var(--label-color);margin-left:var(--label-margin-left)}.ic-loading-circular-outer{height:var(--circular-diameter);width:var(--circular-diameter)}.ic-loading-circular-outer.indeterminate{animation:circular-animation 1s linear;animation-iteration-count:infinite}@keyframes circular-animation{100%{transform:rotate(360deg)}}.ic-loading-circular-outer,.ic-loading-linear-outer{margin:var(--margin)}.ic-loading-linear-outer{background-color:var(--outer-color);height:var(--linear-line-height);width:100%;border-radius:var(--linear-border-radius);overflow:hidden}.ic-loading-linear-inner{position:relative;height:100%;background-color:var(--inner-color);border-radius:var(--linear-border-radius)}.indeterminate>.ic-loading-linear-inner{animation:linear-animation 2s infinite}.determinate>.ic-loading-linear-inner{transition:width 0.5s;width:var(--linear-width)}:host(.full-width){--linear-border-radius:none}@keyframes linear-animation{0%{width:0%;left:-1%}25%{width:0%;left:-1%}50%{width:101%;left:-1%}75%{width:0%;left:101%}100%{width:0%;left:101%}}.ic-loading-circular-svg{position:relative;width:100%;height:100%;transform:rotate(-90deg)}.ic-loading-circular-svg circle{width:100%;height:100%;fill:none;stroke:var(--compact-step-outer-color, var(--outer-color));stroke-width:var(--circular-line-width);stroke-linecap:round}.ic-loading-circular-svg circle:nth-child(2){--circular-indeterminate:calc(\n    (0.25 * var(--stroke-dasharray)) - var(--stroke-dasharray)\n  );stroke-dasharray:var(--stroke-dasharray), var(--stroke-dasharray);stroke-dashoffset:var(--stroke-dashoffset, var(--circular-indeterminate));stroke:var(--compact-step-inner-color, var(--inner-color))}:host(.inner-label) .ic-loading-circular-inner{display:grid}:host(.inner-label) .ic-loading-circular-svg,.inner-text{grid-column:1;grid-row:1}:host(.not-required.compact-step-progress-indicator) .ic-loading-circular-svg circle:nth-child(2){stroke:var(--ic-architectural-300)}.inner-text{display:flex;align-items:center;justify-content:center;width:var(--ic-space-lg);height:inherit;overflow:hidden;margin:auto;color:var(--compact-step-inner-color, var(--ic-status-info))}:host(.not-required.compact-step-progress-indicator) .inner-text{color:var(--ic-color-tertiary-text)}:host(.light.not-required.compact-step-progress-indicator) .inner-text{color:var(--ic-architectural-400)}@media (forced-colors: active){.indeterminate>.ic-loading-circular-inner{forced-color-adjust:none}.ic-loading-linear-outer{border:var(--ic-hc-border)}.ic-loading-linear-inner{background-color:canvastext}.ic-loading-circular-svg circle{stroke:Background}.ic-loading-circular-svg circle:nth-child(2){stroke:canvastext}:host(.not-required.compact-step-progress-indicator) .ic-loading-circular-svg circle:nth-child(2){stroke:GrayText}}";

const LoadingIndicator = /*@__PURE__*/ proxyCustomElement(class LoadingIndicator extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.updateCircularProgressMeter = () => {
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--progress-value", String(this.progress));
            }
        };
        this.getLabel = (labelIndex, setLabel) => {
            return new Promise(() => {
                this.interval = setInterval(() => {
                    if (labelIndex < this.labelList.length - 1) {
                        labelIndex++;
                    }
                    else {
                        labelIndex = 0;
                    }
                    setLabel(this.labelList[labelIndex]);
                }, this.labelDuration);
            });
        };
        this.getLabelVariant = () => {
            var _a;
            let variant = "h4";
            const width = (_a = this.outerElement) === null || _a === void 0 ? void 0 : _a.offsetWidth;
            if (this.size === "small" || (this.type === "circular" && width < 60)) {
                variant = "label";
            }
            else if (this.size === "large" ||
                (this.type === "circular" && width >= 120)) {
                variant = "h2";
            }
            return variant;
        };
        // Sets the circular indicator line width - accounting for the circle size being altered using the CSS custom property
        this.setCircleLineWidth = () => {
            const { offsetWidth: width } = this.outerElement;
            const compactStepCircularLineWidth = this.el.classList.contains("compact-step-progress-indicator")
                ? 40
                : 0;
            const toastDismissTimerCircularLineWidth = this.el.classList.contains("toast-dismiss-timer")
                ? 20
                : 0;
            if (width ||
                compactStepCircularLineWidth ||
                toastDismissTimerCircularLineWidth) {
                this.circularLineWidth =
                    (compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width) * 0.1;
                this.circularDiameter =
                    compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width;
                this.outerElement.style.setProperty("--circular-line-width", `${this.circularLineWidth}px`);
            }
        };
        this.setLinearDeterminateWidth = () => {
            if (!this.innerElement)
                return;
            // Ensure progress cannot be out of bounds
            const progress = Math.min(this.max, Math.max(this.min, this.progress));
            const proportion = (progress - this.min) / (this.max - this.min);
            this.showSecond = proportion > 0.5;
            if (this.showSecond) {
                this.innerElement.classList.remove("clip");
            }
            else {
                this.innerElement.classList.add("clip");
            }
            this.innerElement.style.setProperty("--linear-width", `${proportion * 100}%`);
        };
        this.calcOuterClass = () => {
            let cls = `ic-loading-${this.type}-outer`;
            cls += this.indeterminate ? " indeterminate" : " determinate";
            return cls;
        };
        this.updateLabel = () => {
            if (isPropDefined(this.label)) {
                this.labelList = this.label.split("/");
                const labelIndex = 0;
                this.indicatorLabel = this.labelList[labelIndex];
                if (this.labelList.length > 1) {
                    this.getLabel(labelIndex, (label) => {
                        this.indicatorLabel = label;
                    });
                }
            }
        };
        this.setCircleXY = () => {
            if (this.circularDiameter > 0) {
                const r = this.circularDiameter / 2;
                const x = r;
                const y = r;
                const nextRadius = r - this.circularLineWidth / 2;
                this.setDashSteps(nextRadius);
                return { x, y, r: nextRadius };
            }
            return { x: 0, y: 0, r: 0 };
        };
        this.setDashSteps = (radius) => {
            const dashArray = 2 * Math.PI * radius;
            const progress = Math.min(Math.max(this.progress, this.min), this.max);
            const proportion = -1 - (progress - this.min) / (this.max - this.min);
            this.circularMeter.style.setProperty("--stroke-dasharray", `${dashArray}px`);
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--circular-steps-max", String(this.max));
                this.circularMeter.style.setProperty("--stroke-dashoffset", `${proportion * dashArray}px`);
            }
        };
        this.circularDiameter = undefined;
        this.circularLineWidth = undefined;
        this.indeterminate = undefined;
        this.indicatorLabel = undefined;
        this.showSecond = false;
        this.appearance = "dark";
        this.description = "Loading";
        this.fullWidth = false;
        this.innerLabel = undefined;
        this.labelDuration = 8000;
        this.max = 100;
        this.min = 0;
        this.size = "default";
        this.type = "circular";
        this.label = undefined;
        this.progress = undefined;
    }
    watchPropHandler() {
        this.updateLabel();
    }
    watchProgressHandler() {
        if (this.type === "circular") {
            this.updateCircularProgressMeter();
        }
    }
    disconnectedCallback() {
        clearInterval(this.interval);
    }
    componentWillLoad() {
        this.indeterminate = this.progress === undefined;
        this.updateLabel();
        this.el.setAttribute("exportparts", "ic-loading-container");
    }
    componentDidLoad() {
        if (this.type === "circular") {
            this.setCircleLineWidth();
            this.circularMeter = this.el.shadowRoot.querySelector(".ic-loading-circular-svg circle:nth-child(2)");
            this.updateCircularProgressMeter();
        }
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    componentWillUpdate() {
        this.indeterminate = this.progress === undefined;
    }
    componentDidUpdate() {
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    render() {
        const { appearance, label, description, size, fullWidth, innerLabel } = this;
        const { x, y, r } = this.setCircleXY();
        return (h(Host, { class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["label"]: !!label,
                ["full-width"]: fullWidth,
                ["inner-label"]: !!innerLabel,
            } }, h("div", { class: "ic-loading-container", part: "ic-loading-container" }, h("div", { ref: (el) => (this.outerElement = el), class: this.calcOuterClass(), role: "progressbar", "aria-labelledby": this.label && this.size !== "icon" && "ic-loading-label", "aria-label": description, "aria-valuenow": this.progress, "aria-valuemin": this.min, "aria-valuemax": this.max }, h("div", { ref: (el) => (this.innerElement = el), class: `ic-loading-${this.type}-inner` }, this.innerLabel &&
            this.innerLabel !== undefined &&
            this.size === "small" && (h("ic-typography", { variant: "subtitle-small", class: "inner-text" }, this.innerLabel)), this.type === "circular" && (h("svg", { class: "ic-loading-circular-svg", viewBox: `0 0 ${this.circularDiameter || 0} ${this.circularDiameter || 0}` }, h("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }), h("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }))))), label && size !== "icon" && (h("ic-typography", { id: "ic-loading-label", class: "ic-loading-label", role: "status", variant: this.getLabelVariant() }, h("p", null, this.indicatorLabel))))));
    }
    get el() { return this; }
    static get watchers() { return {
        "label": ["watchPropHandler"],
        "progress": ["watchProgressHandler"]
    }; }
    static get style() { return icLoadingIndicatorCss; }
}, [1, "ic-loading-indicator", {
        "appearance": [1],
        "description": [1],
        "fullWidth": [516, "full-width"],
        "innerLabel": [2, "inner-label"],
        "labelDuration": [2, "label-duration"],
        "max": [2],
        "min": [2],
        "size": [513],
        "type": [513],
        "label": [1],
        "progress": [2],
        "circularDiameter": [32],
        "circularLineWidth": [32],
        "indeterminate": [32],
        "indicatorLabel": [32],
        "showSecond": [32]
    }, undefined, {
        "label": ["watchPropHandler"],
        "progress": ["watchProgressHandler"]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-loading-indicator", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, LoadingIndicator);
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { LoadingIndicator as L, defineCustomElement as d };

//# sourceMappingURL=ic-loading-indicator2.js.map