import { proxyCustomElement, HTMLElement, createEvent, h, Fragment, Host } from '@stencil/core/internal/client';
import { c as checkIcon } from './check-icon.js';
import { o as onComponentRequiredPropUndefined } from './helpers.js';
import { d as defineCustomElement$4 } from './ic-button2.js';
import { d as defineCustomElement$3 } from './ic-loading-indicator2.js';
import { c as createPopper, d as defineCustomElement$2 } from './ic-tooltip2.js';
import { d as defineCustomElement$1 } from './ic-typography2.js';

const icMenuCss = "html.sc-ic-menu{line-height:1.15;-webkit-text-size-adjust:100%}body.sc-ic-menu{margin:0}main.sc-ic-menu{display:block}h1.sc-ic-menu{font-size:2em;margin:0.67em 0}hr.sc-ic-menu{box-sizing:content-box;height:0;overflow:visible}pre.sc-ic-menu{font-family:monospace, monospace;font-size:1em}a.sc-ic-menu{background-color:transparent}abbr[title].sc-ic-menu{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}b.sc-ic-menu,strong.sc-ic-menu{font-weight:bolder}code.sc-ic-menu,kbd.sc-ic-menu,samp.sc-ic-menu{font-family:monospace, monospace;font-size:1em}small.sc-ic-menu{font-size:80%}sub.sc-ic-menu,sup.sc-ic-menu{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub.sc-ic-menu{bottom:-0.25em}sup.sc-ic-menu{top:-0.5em}img.sc-ic-menu{border-style:none}button.sc-ic-menu,input.sc-ic-menu,optgroup.sc-ic-menu,select.sc-ic-menu,textarea.sc-ic-menu{font-family:inherit;font-size:100%;line-height:1.15;margin:0}button.sc-ic-menu,input.sc-ic-menu{overflow:visible}button.sc-ic-menu,select.sc-ic-menu{text-transform:none}button.sc-ic-menu,[type=\"button\"].sc-ic-menu,[type=\"reset\"].sc-ic-menu,[type=\"submit\"].sc-ic-menu{-webkit-appearance:button}button.sc-ic-menu::-moz-focus-inner,[type=\"button\"].sc-ic-menu::-moz-focus-inner,[type=\"reset\"].sc-ic-menu::-moz-focus-inner,[type=\"submit\"].sc-ic-menu::-moz-focus-inner{border-style:none;padding:0}button.sc-ic-menu:-moz-focusring,[type=\"button\"].sc-ic-menu:-moz-focusring,[type=\"reset\"].sc-ic-menu:-moz-focusring,[type=\"submit\"].sc-ic-menu:-moz-focusring{outline:1px dotted ButtonText}fieldset.sc-ic-menu{padding:0.35em 0.75em 0.625em}legend.sc-ic-menu{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}progress.sc-ic-menu{vertical-align:baseline}textarea.sc-ic-menu{overflow:auto}[type=\"checkbox\"].sc-ic-menu,[type=\"radio\"].sc-ic-menu{box-sizing:border-box;padding:0}[type=\"number\"].sc-ic-menu::-webkit-inner-spin-button,[type=\"number\"].sc-ic-menu::-webkit-outer-spin-button{height:auto}[type=\"search\"].sc-ic-menu{-webkit-appearance:textfield;outline-offset:-2px}[type=\"search\"].sc-ic-menu::-webkit-search-decoration{-webkit-appearance:none}.sc-ic-menu::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}details.sc-ic-menu{display:block}summary.sc-ic-menu{display:list-item}template.sc-ic-menu{display:none}[hidden].sc-ic-menu{display:none}html.sc-ic-menu,body.sc-ic-menu,div.sc-ic-menu,span.sc-ic-menu,applet.sc-ic-menu,object.sc-ic-menu,iframe.sc-ic-menu,h1.sc-ic-menu,h2.sc-ic-menu,h3.sc-ic-menu,h4.sc-ic-menu,h5.sc-ic-menu,h6.sc-ic-menu,p.sc-ic-menu,blockquote.sc-ic-menu,pre.sc-ic-menu,a.sc-ic-menu,abbr.sc-ic-menu,acronym.sc-ic-menu,address.sc-ic-menu,big.sc-ic-menu,cite.sc-ic-menu,code.sc-ic-menu,del.sc-ic-menu,dfn.sc-ic-menu,em.sc-ic-menu,img.sc-ic-menu,ins.sc-ic-menu,kbd.sc-ic-menu,q.sc-ic-menu,s.sc-ic-menu,samp.sc-ic-menu,small.sc-ic-menu,strike.sc-ic-menu,strong.sc-ic-menu,sub.sc-ic-menu,sup.sc-ic-menu,tt.sc-ic-menu,var.sc-ic-menu,b.sc-ic-menu,u.sc-ic-menu,i.sc-ic-menu,center.sc-ic-menu,dl.sc-ic-menu,dt.sc-ic-menu,dd.sc-ic-menu,ol.sc-ic-menu,ul.sc-ic-menu,li.sc-ic-menu,fieldset.sc-ic-menu,form.sc-ic-menu,label.sc-ic-menu,legend.sc-ic-menu,table.sc-ic-menu,caption.sc-ic-menu,tbody.sc-ic-menu,tfoot.sc-ic-menu,thead.sc-ic-menu,tr.sc-ic-menu,th.sc-ic-menu,td.sc-ic-menu,article.sc-ic-menu,aside.sc-ic-menu,canvas.sc-ic-menu,details.sc-ic-menu,embed.sc-ic-menu,figure.sc-ic-menu,figcaption.sc-ic-menu,footer.sc-ic-menu,header.sc-ic-menu,hgroup.sc-ic-menu,menu.sc-ic-menu,nav.sc-ic-menu,output.sc-ic-menu,ruby.sc-ic-menu,section.sc-ic-menu,summary.sc-ic-menu,time.sc-ic-menu,mark.sc-ic-menu,audio.sc-ic-menu,video.sc-ic-menu{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}@media (prefers-reduced-motion: no-preference){.open.sc-ic-menu-h .menu.sc-ic-menu{transition:max-height var(--ic-transition-duration-slow)}}.sc-ic-menu-h{border-radius:var(--ic-border-radius);max-height:0;width:var(--input-width, 20rem);color:var(--ic-color-primary-text);background-color:var(--ic-architectural-white);position:relative;z-index:var(--ic-z-index-menu);box-sizing:border-box;box-shadow:var(--ic-elevation-overlay)}.sc-ic-menu-h:not(.no-focus):focus-within{box-shadow:var(--ic-border-focus)}#retry-button.sc-ic-menu::part(button){height:var(--ic-space-lg)}.small.sc-ic-menu #retry-button.sc-ic-menu::part(button){height:var(--ic-space-md)}.on-dialog.sc-ic-menu-h{inset:auto !important}.menu.sc-ic-menu{text-decoration:none;list-style-type:none;border:var(--ic-border-width) solid var(--ic-architectural-400);border-radius:var(--ic-border-radius);background-color:var(--ic-architectural-white);visibility:hidden;max-height:0;overflow-y:hidden}.menu-scroll.sc-ic-menu{overflow-y:auto}.menu.sc-ic-menu:focus-visible{outline:none}.open.sc-ic-menu-h{max-height:none;display:block}.open.sc-ic-menu-h .menu.sc-ic-menu{visibility:visible;max-height:calc(var(--ic-space-xl) * 10 + var(--ic-space-xxxs))}.full-width.sc-ic-menu-h{width:100%}.option.sc-ic-menu{padding:var(--ic-space-xs) calc(var(--ic-space-xs) - var(--ic-space-1px));cursor:pointer;display:flex;align-items:center;overflow-wrap:anywhere}.option.sc-ic-menu:not(.loading-option){justify-content:space-between}.small.sc-ic-menu-h .option.sc-ic-menu{padding:var(--ic-space-xxs) calc(var(--ic-space-xs) - var(--ic-space-1px))}.large.sc-ic-menu-h .option.sc-ic-menu{padding:var(--ic-space-sm) calc(var(--ic-space-xs) - var(--ic-space-1px))}.option.sc-ic-menu:last-child{border-radius:0 0 var(--ic-space-1px) var(--ic-space-1px)}.option.sc-ic-menu:first-child{border-radius:var(--ic-space-1px) var(--ic-space-1px) 0 0}.option.sc-ic-menu:not(.disabled-option):hover{background-color:var(--ic-action-dark-bg-hover)}.option.sc-ic-menu:not(.disabled-option):active{background-color:var(--ic-action-dark-bg-active)}.option.sc-ic-menu:focus-visible{outline:var(--ic-hc-focus-outline)}.option.sc-ic-menu:not(.disabled-option) .option-description.sc-ic-menu{color:var(--ic-color-secondary-text)}.option.sc-ic-menu .option-label.sc-ic-menu{display:flex;flex-direction:row;align-items:top}.option.sc-ic-menu .option-element.sc-ic-menu{margin-top:var(--ic-space-xxs)}.option.sc-ic-menu .option-icon.sc-ic-menu{height:var(--ic-space-md);width:var(--ic-space-md);margin-top:var(--ic-space-xxs);margin-right:var(--ic-space-xxxs)}.option-text-container.sc-ic-menu{pointer-events:none}.option.loading-option.sc-ic-menu .option-text-container.sc-ic-menu{margin-left:calc(var(--ic-space-xs) + var(--ic-space-xxxs));color:var(--ic-color-secondary-text)}.error-icon-svg.sc-ic-menu{height:var(--ic-space-md);width:var(--ic-space-md);fill:var(--ic-status-error);align-self:center;display:flex;margin-right:calc(var(--ic-space-xxs) * 1.2)}.loading-error-info.sc-ic-menu{display:flex}.check-icon.sc-ic-menu{height:var(--ic-space-lg);width:var(--ic-space-lg);margin-left:var(--ic-space-xs);pointer-events:none}.focused-option.sc-ic-menu .check-icon.sc-ic-menu *.sc-ic-menu{fill:currentcolor}.option-group-title.sc-ic-menu{padding:var(--ic-space-lg) calc(var(--ic-space-xs) - var(--ic-space-1px))\n    var(--ic-space-xs);color:var(--ic-color-tertiary-text)}.small.sc-ic-menu-h .option-group-title.sc-ic-menu{padding:var(--ic-space-sm) calc(var(--ic-space-xs) - var(--ic-space-1px))\n    var(--ic-space-xxs)}.last-recommended-option.sc-ic-menu{border-bottom:var(--ic-border-default)}.disabled-option.sc-ic-menu{color:var(--ic-architectural-200);cursor:default;pointer-events:none}.focused-option.sc-ic-menu,.focused-option.sc-ic-menu .option-description.sc-ic-menu{background-color:var(--ic-focus-blue) !important;color:var(--ic-color-white-text) !important}.no-results.sc-ic-menu-h li.sc-ic-menu{cursor:no-drop}.no-results.sc-ic-menu-h li.sc-ic-menu:hover{background-color:transparent}@media (forced-colors: active){.focused-option.sc-ic-menu:focus{outline:none;border:0.125rem solid transparent}}";

const Menu = /*@__PURE__*/ proxyCustomElement(class Menu extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.menuKeyPress = createEvent(this, "menuKeyPress", 7);
        this.menuOptionId = createEvent(this, "menuOptionId", 7);
        this.menuOptionSelect = createEvent(this, "menuOptionSelect", 7);
        this.menuStateChange = createEvent(this, "menuStateChange", 7);
        this.menuValueChange = createEvent(this, "menuValueChange", 7);
        this.retryButtonClicked = createEvent(this, "retryButtonClicked", 7);
        this.timeoutBlur = createEvent(this, "timeoutBlur", 7);
        this.ungroupedOptionsSet = createEvent(this, "ungroupedOptionsSet", 7);
        this.disabledOptionSelected = false;
        this.hasPreviouslyBlurred = false;
        this.hasTimedOut = false;
        this.isLoading = false;
        this.isSearchBar = false;
        this.isSearchableSelect = false;
        // Prevents menu re-opening immediately after it is closed on blur when clicking input.
        this.preventClickOpen = false;
        this.ungroupedOptions = [];
        this.handleClearListener = () => {
            this.optionHighlighted = "";
        };
        this.handleSubmitSearch = () => {
            const highlightedOptionIndex = this.options.findIndex((option) => option[this.valueField] === this.optionHighlighted);
            this.setInputValue(highlightedOptionIndex);
        };
        this.handleMenuChange = (open, focusInput) => {
            this.menuStateChange.emit({ open, focusInput });
            if (!open && focusInput !== false) {
                this.inputEl.focus();
                this.preventClickOpen = false;
            }
        };
        this.setNextOptionValue = (selectedOptionIndex) => {
            if (this.ungroupedOptions[selectedOptionIndex + 1]) {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[selectedOptionIndex + 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[selectedOptionIndex + 1][this.valueField]),
                });
            }
            else {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[0][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[0][this.valueField]),
                });
            }
        };
        this.setPreviousOptionValue = (selectedOptionIndex) => {
            if (this.ungroupedOptions[selectedOptionIndex - 1]) {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[selectedOptionIndex - 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[selectedOptionIndex - 1][this.valueField]),
                });
            }
            else {
                this.menuOptionSelect.emit({
                    value: this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField],
                    optionId: this.getOptionId(this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField]),
                });
            }
        };
        this.getParentEl = (parent) => {
            if (parent.tagName === "IC-SEARCH-BAR") {
                this.isSearchBar = true;
            }
            else if (parent.tagName === "IC-SELECT" &&
                parent.getAttribute("searchable") !== null &&
                parent.getAttribute("searchable") !== undefined) {
                this.isSearchableSelect = true;
            }
        };
        this.arrowBehaviour = (event) => {
            event.preventDefault();
            this.handleMenuChange(true);
        };
        this.setMenuOptions = () => this.isSearchBar ? this.options : this.ungroupedOptions;
        this.setHighlightedOption = (highlightedIndex) => {
            const menuOptions = this.setMenuOptions();
            menuOptions[highlightedIndex] &&
                !menuOptions[highlightedIndex].timedOut &&
                (this.optionHighlighted =
                    menuOptions[highlightedIndex][this.valueField] || undefined);
        };
        this.autoSetInputValueKeyboardOpen = (event) => {
            const selectedOptionIndex = this.ungroupedOptions.findIndex((option) => option[this.valueField] === this.value);
            this.keyboardNav = false;
            switch (event.key) {
                case "ArrowDown":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    this.setNextOptionValue(selectedOptionIndex);
                    break;
                case "ArrowUp":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    this.setPreviousOptionValue(selectedOptionIndex);
                    break;
                case " ":
                case "Enter":
                    if (event.target.id !== "clear-button") {
                        this.handleMenuChange(true);
                    }
                    break;
            }
        };
        this.manSetInputValueKeyboardOpen = (event) => {
            const menuOptions = this.setMenuOptions();
            const highlightedOptionIndex = menuOptions.findIndex((option) => option[this.valueField] === this.optionHighlighted);
            const getOptionId = (index) => { var _a; return (_a = Array.from(this.host.querySelectorAll("li"))[index]) === null || _a === void 0 ? void 0 : _a.id; };
            const isOpen = this.isSearchBar || this.isSearchableSelect || this.open;
            switch (event.key) {
                case "ArrowDown":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    if (highlightedOptionIndex < menuOptions.length - 1) {
                        this.setHighlightedOption(highlightedOptionIndex + 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(highlightedOptionIndex + 1),
                        });
                    }
                    else {
                        this.setHighlightedOption(0);
                        this.menuOptionId.emit({
                            optionId: getOptionId(0),
                        });
                    }
                    this.preventIncorrectTabOrder = false;
                    this.focusFromSearchKeypress = false;
                    break;
                case "ArrowUp":
                    this.keyboardNav = true;
                    this.arrowBehaviour(event);
                    if (highlightedOptionIndex <= 0 ||
                        highlightedOptionIndex > menuOptions.length + 1) {
                        this.setHighlightedOption(menuOptions.length - 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(menuOptions.length - 1),
                        });
                    }
                    else {
                        this.setHighlightedOption(highlightedOptionIndex - 1);
                        this.menuOptionId.emit({
                            optionId: getOptionId(highlightedOptionIndex - 1),
                        });
                    }
                    this.preventIncorrectTabOrder = false;
                    this.focusFromSearchKeypress = false;
                    break;
                case "Home":
                    this.keyboardNav = true;
                    event.preventDefault();
                    this.arrowBehaviour(event);
                    this.setHighlightedOption(0);
                    this.menuOptionId.emit({
                        optionId: getOptionId(0),
                    });
                    break;
                case "End":
                    this.keyboardNav = true;
                    event.preventDefault();
                    this.arrowBehaviour(event);
                    this.setHighlightedOption(menuOptions.length - 1);
                    this.menuOptionId.emit({
                        optionId: getOptionId(menuOptions.length - 1),
                    });
                    break;
                case " ":
                    this.keyboardNav = false;
                    if (this.isSearchBar || this.isSearchableSelect) {
                        break;
                    }
                    else {
                        if (event.target.id !== "clear-button") {
                            this.handleMenuChange(true);
                        }
                    }
                    break;
                case "Enter":
                    event.preventDefault();
                    this.keyboardNav = false;
                    if (isOpen) {
                        if (highlightedOptionIndex >= 0) {
                            if (menuOptions[highlightedOptionIndex] !== undefined) {
                                if (this.isSearchBar &&
                                    menuOptions[highlightedOptionIndex].disabled === true) {
                                    this.disabledOptionSelected = true;
                                }
                                else {
                                    this.setInputValue(highlightedOptionIndex);
                                    this.value =
                                        menuOptions[highlightedOptionIndex][this.valueField];
                                }
                            }
                        }
                        else {
                            this.setInputValue(highlightedOptionIndex);
                        }
                    }
                    else {
                        this.handleMenuChange(true);
                    }
                    break;
                case "Escape":
                    if (this.open) {
                        event.stopImmediatePropagation();
                    }
                    this.handleMenuChange(false);
                    this.menuOptionId.emit({ optionId: undefined });
                    break;
                case "Shift":
                case "Tab":
                    if (this.isSearchBar) {
                        this.keyboardNav = true;
                    }
                    this.preventIncorrectTabOrder = true;
                    break;
                default:
                    this.keyboardNav = false;
                    this.focusOnSearchOrSelectInput(menuOptions, highlightedOptionIndex);
                    break;
            }
        };
        this.setInputValue = (highlightedOptionIndex) => {
            const menuOptions = this.setMenuOptions();
            if (menuOptions[highlightedOptionIndex] !== undefined) {
                this.menuOptionSelect.emit({
                    value: menuOptions[highlightedOptionIndex][this.valueField],
                });
                this.optionHighlighted = undefined;
                this.menuOptionId.emit({ optionId: undefined });
            }
            if (!this.hasTimedOut)
                this.handleMenuChange(false);
            else
                this.parentEl.setFocus();
        };
        this.handleOptionClick = (event) => {
            const { value, label } = event.target.dataset;
            this.menuOptionSelect.emit({ value, label });
            this.handleMenuChange(false);
        };
        this.handleRetry = () => {
            this.retryButtonClicked.emit({ value: this.value });
        };
        this.handleRetryKeyDown = (ev) => {
            if (ev.key === "Enter" || ev.key === " ") {
                ev.preventDefault();
                this.retryButtonClicked.emit({ value: this.value, keyPressed: ev.key });
            }
        };
        this.handleBlur = (event) => {
            if (event.relatedTarget !== this.inputEl) {
                if (!this.menu.contains(event.relatedTarget)) {
                    this.handleMenuChange(false, this.hasPreviouslyBlurred);
                }
            }
            else {
                this.handleMenuChange(false);
                this.preventClickOpen = true;
            }
            if (!this.isSearchBar)
                this.hasPreviouslyBlurred = !!event.relatedTarget;
        };
        this.handleMouseDown = (event) => {
            event.preventDefault();
        };
        this.handleMenuKeyDown = (event) => {
            if (this.activationType === "automatic") {
                this.autoSetValueOnMenuKeyDown(event);
            }
            else if (this.activationType === "manual" && !this.isSearchBar) {
                this.manSetInputValueKeyboardOpen(event);
            }
        };
        this.emitMenuKeyPress = (isNavKey, key) => {
            this.menuKeyPress.emit({ isNavKey: isNavKey, key: key });
        };
        this.autoSetValueOnMenuKeyDown = (event) => {
            event.cancelBubble = true;
            const selectedOptionIndex = this.ungroupedOptions.findIndex((option) => option[this.valueField] === this.value);
            const isSearchableSelect = this.inputEl.tagName === "INPUT";
            this.keyboardNav = false;
            switch (event.key) {
                case " ":
                    event.preventDefault();
                    break;
                case "ArrowUp":
                    if (!this.hasTimedOut) {
                        event.preventDefault();
                        this.setPreviousOptionValue(selectedOptionIndex);
                        this.keyboardNav = true;
                    }
                    break;
                case "ArrowDown":
                    if (!this.hasTimedOut) {
                        event.preventDefault();
                        this.setNextOptionValue(selectedOptionIndex);
                        this.keyboardNav = true;
                    }
                    break;
                case "Home":
                    this.menuOptionSelect.emit({
                        value: this.ungroupedOptions[0][this.valueField],
                    });
                    this.keyboardNav = true;
                    break;
                case "End":
                    this.menuOptionSelect.emit({
                        value: this.ungroupedOptions[this.ungroupedOptions.length - 1][this.valueField],
                    });
                    this.keyboardNav = true;
                    break;
                case "Enter":
                    !this.hasTimedOut && this.handleMenuChange(false);
                    break;
                case "Escape":
                    this.handleMenuChange(false);
                    break;
                case "Backspace":
                    if (isSearchableSelect) {
                        this.inputEl.focus();
                    }
                    break;
                case "Shift":
                    break;
                default:
                    if (isSearchableSelect && event.key !== "Tab" && !this.hasTimedOut) {
                        this.inputEl.focus();
                    }
                    if (event.key.length === 1) {
                        this.keyboardNav = true;
                    }
                    break;
            }
            this.emitMenuKeyPress(this.keyboardNav, event.key);
        };
        this.handleMenuKeyUp = (event) => {
            if (event.key === "Tab" && event.shiftKey) {
                this.preventClickOpen = false;
            }
            if (event.key === "Enter" && this.disabledOptionSelected) {
                this.disabledOptionSelected = false;
                event.stopImmediatePropagation();
            }
        };
        this.getOptionId = (value) => {
            return `${this.menuId}-${value}`;
        };
        this.getOptionAriaLabel = (option, parentOption) => {
            let ariaLabel = option[this.labelField];
            if (option.description) {
                ariaLabel = `${ariaLabel}, ${option.description}`;
            }
            if (option.element) {
                ariaLabel = `${ariaLabel}, ${option.element.ariaLabel}`;
            }
            if (parentOption) {
                return `${ariaLabel}, ${parentOption[this.labelField]} group`;
            }
            else {
                return ariaLabel;
            }
        };
        this.getSortedOptions = (options) => {
            let sorted = [];
            if (options.sort) {
                sorted = options.sort((optionA, optionB) => optionA.recommended && !optionB.recommended ? -1 : 0);
            }
            return sorted;
        };
        this.isManualMode = this.activationType === "manual";
        this.scrollToSelected = (menu) => {
            const selectedOption = this.selectOnEnter
                ? this.host.querySelector(`li[data-value="${this.optionHighlighted}"]`)
                : menu.querySelector(".option[aria-selected='true']");
            if (selectedOption) {
                const elTop = selectedOption.offsetTop + selectedOption.offsetHeight;
                if (elTop > menu.scrollTop + menu.offsetHeight ||
                    elTop < menu.scrollTop + menu.offsetHeight) {
                    menu.scrollTop = selectedOption.offsetTop;
                }
                selectedOption.focus();
            }
        };
        this.loadUngroupedOptions = () => {
            if (this.options.length > 0 && this.options.map) {
                this.options.map((option) => {
                    if (option.children) {
                        option.children.map((option) => !option.disabled && this.ungroupedOptions.push(option));
                    }
                    else if (!option.disabled) {
                        this.ungroupedOptions.push(option);
                    }
                });
            }
            this.ungroupedOptions = this.getSortedOptions(this.ungroupedOptions);
            this.ungroupedOptionsSet.emit({ options: this.ungroupedOptions });
        };
        this.setMenuScrollbar = () => {
            let optionsHeight = 0;
            this.host
                .querySelectorAll(".option")
                .forEach((option) => (optionsHeight += option.clientHeight));
            if (optionsHeight >= 320) {
                this.menu.classList.add("menu-scroll");
            }
        };
        this.handleTimeoutBlur = (ev) => {
            this.timeoutBlur.emit({ ev });
        };
        this.optionContent = (option) => {
            var _a;
            return (h(Fragment, null, option.loading && h("ic-loading-indicator", { size: "icon" }), h("div", { class: "option-text-container" }, h("div", { class: "option-label" }, option.icon && (h("div", { class: "option-icon", innerHTML: option.icon, "aria-hidden": "true" })), h("ic-typography", { variant: "body", "aria-hidden": "true" }, option[this.labelField])), option.description && (h("ic-typography", { id: `${this.getOptionId(option[this.valueField])}-description`, class: "option-description", variant: "caption", "aria-hidden": "true" }, h("p", null, option.description))), option.element && (h("div", { class: "option-element", innerHTML: option.element.component, "aria-hidden": "true" }))), !!option[this.valueField] &&
                !!this.value &&
                option[this.valueField].toLowerCase() === ((_a = this.value) === null || _a === void 0 ? void 0 : _a.toLowerCase()) &&
                this.parentEl.tagName !== "IC-SEARCH-BAR" && (h("span", { class: "check-icon", innerHTML: checkIcon }))));
        };
        this.displayOption = (option, index, parentOption) => {
            const { open, value, keyboardNav, isManualMode, initialOptionsListRender, optionHighlighted, options, } = this;
            return (h("li", { id: this.getOptionId(option[this.valueField]), class: {
                    option: true,
                    "focused-option": isManualMode
                        ? (keyboardNav || initialOptionsListRender) &&
                            option[this.valueField] === optionHighlighted
                        : keyboardNav && option[this.valueField] === value,
                    "last-recommended-option": option.recommended &&
                        options[index + 1] &&
                        !options[index + 1].recommended,
                    "disabled-option": option.disabled,
                    "loading-option": option.loading,
                    timeout: option.timedOut,
                }, role: "option", tabindex: open &&
                    (option[this.valueField] === value ||
                        option[this.valueField] === optionHighlighted) &&
                    keyboardNav
                    ? "0"
                    : "-1", "aria-label": this.getOptionAriaLabel(option, parentOption), "aria-selected": `${option[this.valueField] === value}`, "aria-disabled": option.disabled ? "true" : "false", onClick: !option.timedOut && !option.loading && this.handleOptionClick, onBlur: this.handleBlur, onMouseDown: this.handleMouseDown, "data-value": option[this.valueField], "data-label": option[this.labelField] }, option.timedOut ? (h(Fragment, null, h("div", { class: "loading-error-info" }, h("svg", { class: "error-icon-svg", "aria-labelledby": "error-title", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", fill: "#000000" }, h("title", { id: "error-title" }, "Error"), h("g", { id: "close-octagon" }, h("path", { id: "Vector", d: "M8.77 3L3.5 8.27V15.73L8.77 21H16.23L21.5 15.73V8.27L16.23 3M8.91 7L12.5 10.59L16.09 7L17.5 8.41L13.91 12L17.5 15.59L16.09 17L12.5 13.41L8.91 17L7.5 15.59L11.09 12L7.5 8.41" }))), h("ic-typography", { variant: "label" }, option[this.labelField])), h("ic-button", { size: "small", variant: "tertiary", onClick: this.handleRetry, onKeyDown: this.handleRetryKeyDown, onBlur: this.handleTimeoutBlur, id: "retry-button" }, "Retry"))) : (this.optionContent(option))));
        };
        this.focusFromSearchKeypress = false;
        this.initialOptionsListRender = false;
        this.keyboardNav = false;
        this.optionHighlighted = undefined;
        this.preventIncorrectTabOrder = false;
        this.activationType = "automatic";
        this.anchorEl = undefined;
        this.autoFocusOnSelected = true;
        this.fullWidth = false;
        this.inputEl = undefined;
        this.inputLabel = undefined;
        this.labelField = "label";
        this.menuId = undefined;
        this.open = undefined;
        this.parentEl = undefined;
        this.searchMode = "navigation";
        this.selectOnEnter = false;
        this.size = "default";
        this.small = false;
        this.options = undefined;
        this.value = undefined;
        this.valueField = "value";
    }
    watchOpenHandler() {
        if (!this.open && this.popperInstance) {
            this.popperInstance.destroy();
            this.popperInstance = null;
        }
    }
    watchOptionsHandler(newOptions) {
        this.hasTimedOut = newOptions.some((opt) => opt.timedOut);
        this.isLoading = newOptions.some((opt) => opt.loading);
        this.ungroupedOptions = [];
        this.loadUngroupedOptions();
    }
    watchValueHandler() {
        this.menuValueChange.emit({ value: this.value });
    }
    connectedCallback() {
        this.getParentEl(this.parentEl);
        if (this.isSearchBar) {
            if (this.searchMode === "navigation")
                this.setHighlightedOption(0);
            this.initialOptionsListRender = true;
        }
    }
    disconnectedCallback() {
        if (this.popperInstance) {
            this.popperInstance.destroy();
        }
        this.parentEl.removeEventListener("icClear", this.handleClearListener);
        this.parentEl.removeEventListener("icSubmitSearch", this.handleSubmitSearch);
    }
    componentWillLoad() {
        var _a, _b;
        this.loadUngroupedOptions();
        this.parentEl.addEventListener("icClear", this.handleClearListener);
        this.parentEl.addEventListener("icSubmitSearch", this.handleSubmitSearch);
        this.hasTimedOut = (_a = this.options) === null || _a === void 0 ? void 0 : _a.some((opt) => opt.timedOut);
        this.isLoading = (_b = this.options) === null || _b === void 0 ? void 0 : _b.some((opt) => opt.loading);
    }
    componentDidLoad() {
        if (this.isSearchBar &&
            this.parentEl.disableFilter) {
            this.focusFromSearchKeypress = true;
        }
        onComponentRequiredPropUndefined([
            { prop: this.open, propName: "open" },
            { prop: this.options, propName: "options" },
            { prop: this.menuId, propName: "menu-id" },
            { prop: this.inputLabel, propName: "input-label" },
            //NOTE: no check for value, input-el or anchor-el as otherwise get console errors on first load of select component
        ], "Menu");
    }
    componentDidUpdate() {
        const inputValueInOptions = this.options.some((option) => option[this.valueField] === this.value);
        if (this.open && this.options.length !== 0) {
            if (this.value &&
                this.keyboardNav &&
                inputValueInOptions &&
                this.autoFocusOnSelected &&
                !this.isSearchableSelect) {
                this.scrollToSelected(this.menu);
            }
            else if (this.inputEl.tagName !== "IC-TEXT-FIELD" &&
                this.inputEl.tagName !== "INPUT") {
                this.menu.focus();
            }
            else if (!!this.optionHighlighted &&
                !this.focusFromSearchKeypress &&
                !this.preventIncorrectTabOrder) {
                const highlightedEl = this.host.querySelector(`li[data-value="${this.optionHighlighted}"]`);
                if (highlightedEl) {
                    highlightedEl.focus();
                }
            }
        }
        if (this.open && !this.value && this.selectOnEnter) {
            this.scrollToSelected(this.menu);
        }
    }
    componentDidRender() {
        if (this.open && !this.popperInstance && this.anchorEl) {
            this.initPopperJs(this.anchorEl);
        }
        if (this.open && !!this.options.length) {
            this.setMenuScrollbar();
        }
    }
    /**
     * @internal If menu is opened with the mouse, emit menuStateChange custom event.
     */
    async handleClickOpen() {
        if (!this.preventClickOpen) {
            this.menuStateChange.emit({ open: !this.open });
            this.keyboardNav = false;
        }
        this.preventClickOpen = false;
    }
    /**
     * Used alongside activationType
     * If menu is opened via keyboard navigation (i.e. Enter, ArrowUp or ArrowDown), emit optionSelect custom event.
     * @param {KeyboardEvent} event The keyboard event which is available when handleKeyboardOpen is invoked.
     */
    async handleKeyboardOpen(event) {
        if (this.activationType === "automatic") {
            this.autoSetInputValueKeyboardOpen(event);
        }
        else {
            this.manSetInputValueKeyboardOpen(event);
        }
    }
    /**
     * @internal Used to highlight the first option in the menu.
     */
    async handleSetFirstOption() {
        this.setHighlightedOption(0);
    }
    /**
     * @internal Used to initialize popperJS with an anchor element.
     * 5/12/2023: Tested with Floating UI, however, discovered inconsistent
     * boundary behaviour so sticking with PopperJS.
     */
    async initPopperJs(anchor) {
        this.popperInstance = createPopper(anchor, this.host, {
            placement: "bottom",
            modifiers: [
                {
                    name: "offset",
                    options: {
                        offset: [0, 7],
                    },
                },
                {
                    name: "flip",
                    options: {
                        fallbackPlacements: ["top"],
                        rootBoundary: "viewport",
                    },
                },
            ],
        });
    }
    focusOnSearchOrSelectInput(menuOptions, highlightedOptionIndex) {
        if (!menuOptions[highlightedOptionIndex])
            return;
        if (this.isSearchBar) {
            this.parentEl.setFocus();
            if (this.searchMode === "navigation")
                this.setHighlightedOption(0);
        }
        if (this.isSearchableSelect) {
            this.parentEl.setFocus();
        }
        this.focusFromSearchKeypress = true;
    }
    render() {
        const { inputLabel, options, menuId, value, fullWidth, hasTimedOut, isLoading, size, small, open, inputEl, keyboardNav, } = this;
        return (h(Host, { class: {
                "full-width": fullWidth,
                "no-focus": (inputEl === null || inputEl === void 0 ? void 0 : inputEl.tagName) === "INPUT" || hasTimedOut || isLoading,
                small: small,
                [size]: true,
                open: open,
            } }, options.length !== 0 && (h("ul", { id: menuId, class: "menu", role: "listbox", "aria-label": inputLabel, "aria-activedescendant": value != null && value !== "" ? this.getOptionId(value) : "", tabindex: open && !keyboardNav && (inputEl === null || inputEl === void 0 ? void 0 : inputEl.tagName) !== "INPUT" ? "0" : "-1", ref: (el) => (this.menu = el), onKeyDown: this.handleMenuKeyDown, onKeyUp: this.handleMenuKeyUp, onBlur: this.handleBlur }, this.getSortedOptions(options).map((option, index) => {
            if (option.children) {
                if (option.children.length > 0) {
                    return (h("div", null, h("ic-typography", { class: "option-group-title", role: "presentation", variant: "subtitle-small" }, h("p", null, option[this.labelField])), option.children.map((childOption) => this.displayOption(childOption, index, option))));
                }
                else {
                    return null;
                }
            }
            else {
                return this.displayOption(option, index);
            }
        })))));
    }
    get host() { return this; }
    static get watchers() { return {
        "open": ["watchOpenHandler"],
        "options": ["watchOptionsHandler"],
        "value": ["watchValueHandler"]
    }; }
    static get style() { return icMenuCss; }
}, [2, "ic-menu", {
        "activationType": [1, "activation-type"],
        "anchorEl": [16],
        "autoFocusOnSelected": [4, "auto-focus-on-selected"],
        "fullWidth": [4, "full-width"],
        "inputEl": [16],
        "inputLabel": [1, "input-label"],
        "labelField": [1, "label-field"],
        "menuId": [1, "menu-id"],
        "open": [516],
        "parentEl": [16],
        "searchMode": [1, "search-mode"],
        "selectOnEnter": [4, "select-on-enter"],
        "size": [1],
        "small": [4],
        "options": [16],
        "value": [1025],
        "valueField": [1, "value-field"],
        "focusFromSearchKeypress": [32],
        "initialOptionsListRender": [32],
        "keyboardNav": [32],
        "optionHighlighted": [32],
        "preventIncorrectTabOrder": [32],
        "handleClickOpen": [64],
        "handleKeyboardOpen": [64],
        "handleSetFirstOption": [64],
        "initPopperJs": [64]
    }, undefined, {
        "open": ["watchOpenHandler"],
        "options": ["watchOptionsHandler"],
        "value": ["watchValueHandler"]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-menu", "ic-button", "ic-loading-indicator", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-menu":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Menu);
            }
            break;
        case "ic-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { Menu as M, defineCustomElement as d };

//# sourceMappingURL=ic-menu2.js.map