import { proxyCustomElement, HTMLElement, forceUpdate, h, Host } from '@stencil/core/internal/client';
import { n as getThemeForegroundColor, b as inheritAttributes, o as onComponentRequiredPropUndefined, i as isSlotUsed, I as IC_INHERITED_ARIA } from './helpers.js';
import { I as IcThemeForegroundEnum } from './types.js';
import { d as defineCustomElement$5 } from './ic-button2.js';
import { d as defineCustomElement$4 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$3 } from './ic-tooltip2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icNavigationButtonCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;margin-right:var(--ic-space-xs);list-style:none}:host(.in-side-menu){margin-right:0}:host::part(button){height:100%;min-height:2.5rem}";

const MUTABLE_ATTRIBUTES = [...IC_INHERITED_ARIA, "title"];
const NavigationButton = /*@__PURE__*/ proxyCustomElement(class NavigationButton extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                if (MUTABLE_ATTRIBUTES.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.initialAppearance = getThemeForegroundColor();
        this.mode = "navbar";
        this.download = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.label = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.inheritedAttributes = inheritAttributes(this.el, MUTABLE_ATTRIBUTES);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Navigation Button");
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
        });
    }
    componentWillRender() {
        const iconEl = this.el.querySelector(`[slot="icon"]`);
        iconEl !== null && iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    navBarMenuOpenHandler() {
        this.mode = "menu";
    }
    navBarMenuCloseHandler() {
        this.mode = "navbar";
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.initialAppearance = theme.mode;
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        if (this.buttonEl) {
            this.buttonEl.focus();
        }
    }
    render() {
        const { href, target, rel, download, referrerpolicy } = this;
        let label = "";
        let className = "";
        let variant = "icon";
        let appearance = this.initialAppearance;
        let size = "large";
        let fullWidth = false;
        let disableTooltip = false;
        if (this.mode === "menu") {
            label = this.label;
            variant = "tertiary";
            appearance = IcThemeForegroundEnum.Default;
            size = "default";
            fullWidth = true;
            className = "popout-menu-button";
            disableTooltip = true;
        }
        const buttonProps = {
            variant,
            appearance,
            size,
            href,
            target,
            rel,
            download,
            referrerpolicy,
            fullWidth,
            disableTooltip,
        };
        return (h(Host, { class: { ["in-side-menu"]: this.mode === "menu" } }, h("ic-button", Object.assign({ class: className, "aria-label": variant == "icon" ? this.label : null, ref: (el) => (this.buttonEl = el) }, buttonProps, this.inheritedAttributes), label, h("slot", { slot: "left-icon", name: "icon" }), isSlotUsed(this.el, "badge") && variant === "icon" && (h("slot", { name: "badge" })))));
    }
    static get delegatesFocus() { return true; }
    get el() { return this; }
    static get style() { return icNavigationButtonCss; }
}, [17, "ic-navigation-button", {
        "download": [8],
        "href": [1],
        "hreflang": [1],
        "label": [1],
        "referrerpolicy": [1],
        "rel": [1],
        "target": [1],
        "initialAppearance": [32],
        "mode": [32],
        "setFocus": [64]
    }, [[4, "icNavigationMenuOpened", "navBarMenuOpenHandler"], [4, "icNavigationMenuClosed", "navBarMenuCloseHandler"], [4, "themeChange", "themeChangeHandler"]]]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-navigation-button", "ic-button", "ic-loading-indicator", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-navigation-button":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, NavigationButton);
            }
            break;
        case "ic-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcNavigationButton = NavigationButton;
const defineCustomElement = defineCustomElement$1;

export { IcNavigationButton, defineCustomElement };

//# sourceMappingURL=ic-navigation-button.js.map