import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { D as DEVICE_SIZES, n as getThemeForegroundColor, p as getCurrentDeviceSize, J as getNavItemParentDetails } from './helpers.js';
import { c as chevronIcon } from './chevron-icon.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icNavigationGroupCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block}:host(.in-side-menu){border-bottom:var(--ic-border-width) solid var(--ic-architectural-200);padding:var(--ic-space-md) 0}:host .navigation-group{height:100%;width:-moz-fit-content;width:fit-content;color:var(--ic-theme-text);display:flex;align-items:center;justify-content:center;padding:0 var(--ic-space-md);transition:var(--ic-easing-transition-slow);position:relative;background:none;border:none;white-space:nowrap}:host(.in-side-menu) .navigation-group{height:2.5rem;width:100%;text-align:left}:host(.in-side-menu) .navigation-group .ic-typography-label{width:11.875rem}:host(.in-side-menu) .navigation-group-side-menu{color:var(--ic-action-default);justify-content:flex-start;padding:0 var(--ic-space-md) 0 var(--ic-space-md)}:host(.in-side-menu) .navigation-group-side-menu-collapsed,:host(.in-side-menu) .navigation-group-side-menu-expanded{color:var(--ic-action-default);justify-content:flex-start;padding-left:var(--ic-space-md)}:host(.in-side-menu) .navigation-group-side-menu-expanded{margin-bottom:var(--ic-space-xs)}:host(.in-side-menu) .navigation-group-side-menu-collapsed::after,:host(.in-side-menu) .navigation-group-side-menu-expanded::after{border-style:solid;border-width:0.125em 0.125em 0 0;content:\"\";display:inline-block;height:0.45em;left:0.75em;position:relative;top:-0.1em;transform:rotate(135deg);vertical-align:top;width:0.45em}:host(.in-side-menu) .navigation-group-side-menu-expanded::after{top:0.15em;transform:rotate(-45deg)}:host .navigation-group:hover,:host .navigation-group:active,:host .selected{background-color:var(--ic-architectural-20);color:var(--ic-color-primary-text);outline:none;cursor:pointer}:host(:not(.in-side-menu)) .navigation-group:focus{box-shadow:var(--ic-border-focus);border-radius:var(--ic-border-radius);outline:var(--ic-hc-focus-outline);z-index:var(--ic-z-index-navigation-item);transition:box-shadow var(--ic-easing-transition-fast)}:host(.in-side-menu) .navigation-group-side-menu:hover,:host(.in-side-menu) .navigation-group-side-menu:active,:host(.in-side-menu) .navigation-group-side-menu:focus{background-color:var(--ic-architectural-20);color:var(--ic-action-default);cursor:auto;box-shadow:none;outline:none}:host(.in-side-menu) .navigation-group-side-menu:focus{outline:var(--ic-hc-focus-outline)}:host(.in-side-menu) .navigation-group-side-menu-expanded:hover:not(:focus),:host(.in-side-menu) .navigation-group-side-menu-collapsed:hover:not(:focus){background-color:var(--ic-action-dark-bg-hover);color:var(--ic-action-default);cursor:pointer}:host(.in-side-menu) .navigation-group-side-menu-expanded:active:not(:focus),:host(.in-side-menu) .navigation-group-side-menu-collapsed:active:not(:focus){background-color:var(--ic-action-dark-bg-active);color:var(--ic-action-default)}:host(.in-side-menu) .navigation-group-side-menu-expanded:focus,:host(.in-side-menu) .navigation-group-side-menu-collapsed:focus{color:var(--ic-action-default);box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);outline:var(--ic-hc-focus-outline)}:host .navigation-group-dropdown{background-color:var(--ic-architectural-20);border-bottom:var(--ic-border-default);position:absolute;left:0;right:0;padding:var(--ic-space-xs) var(--ic-space-md);box-shadow:0 0.375rem 0.5rem -0.375rem rgba(0 0 0 / 20%);z-index:calc(var(--ic-z-index-navigation-item) - 1)}:host .navigation-group-dropdown-items-list{list-style:none;display:flex;flex-flow:column wrap;align-content:flex-start;padding-left:var(--ic-space-md);max-height:16.5rem}:host .chevron-toggle-icon-wrapper{display:flex;align-items:center}:host .chevron-toggle-icon-wrapper svg{transform:rotate(90deg);height:var(--ic-space-lg);width:var(--ic-space-lg)}:host .chevron-toggle-icon-closed svg{transform:rotate(-90deg)}:host(.expanded) .grouped-links-wrapper{height:var(--navigation-child-items-height, auto) !important;transition:var(--ic-easing-transition-slow);overflow:hidden}:host(.navigation-group-side-nav) .link,:host(.navigation-group-side-nav) ::slotted(a){height:var(--navigation-child-items-height, auto)}:host(.collapsed) .grouped-links-wrapper{height:0;transition:var(--ic-easing-transition-slow);overflow:hidden}:host(.navigation-group-side-nav) .navigation-group{height:var(--navigation-group-height);width:var(--navigation-group-width);justify-content:var(--navigation-group-justify-content);padding-right:var(--navigation-group-expand-toggle-padding)}:host(.navigation-group-side-nav) .navigation-group:hover,:host(.navigation-group-side-nav) .navigation-group:active,:host(.navigation-group-side-nav) .selected{background-color:var(--navigation-group-hover);color:var(--navigation-group-text-hover)}:host(.navigation-group-side-nav) .navigation-group:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);background:none}:host(.navigation-group-side-nav) .ic-typography-caption{position:var(--navigation-group-title-position);left:var(--navigation-group-title-position-left);white-space:nowrap}";

const NavigationGroup = /*@__PURE__*/ proxyCustomElement(class NavigationGroup extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.allGroupedNavigationItems = [];
        this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS = 100;
        this.IC_NAVIGATION_ITEM = "ic-navigation-item";
        this.mouseGate = false;
        this.nodeName = "IC-NAVIGATION-GROUP";
        this.GROUPED_LINKS_WRAPPER_CLASS = ".grouped-links-wrapper";
        this.sideNavExpandHandler = (event) => {
            this.isSideNavExpanded = event.detail.sideNavExpanded;
            const linkWrapper = this.el.shadowRoot.querySelector(this.GROUPED_LINKS_WRAPPER_CLASS);
            if (!linkWrapper)
                return;
            if (this.isSideNavExpanded) {
                if (this.expanded && this.expandedNavItemsHeight) {
                    this.setGroupedLinksElementHeight(linkWrapper, this.expandedNavItemsHeight);
                }
                else if (this.expanded) {
                    setTimeout(() => {
                        this.expandedNavItemsHeight = this.getNavigationChildItemsHeight();
                        this.setGroupedLinksElementHeight(linkWrapper, this.expandedNavItemsHeight);
                    }, this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS);
                }
            }
            else {
                if (this.expanded && this.collapsedNavItemsHeight) {
                    this.setGroupedLinksElementHeight(linkWrapper, this.collapsedNavItemsHeight);
                }
                else if (this.expanded) {
                    setTimeout(() => {
                        this.collapsedNavItemsHeight = this.getNavigationChildItemsHeight();
                        this.setGroupedLinksElementHeight(linkWrapper, this.collapsedNavItemsHeight);
                    }, this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS);
                }
            }
        };
        this.topNavResizedHandler = ({ detail, }) => {
            var _a;
            const { size } = detail;
            if (size !== this.deviceSize) {
                this.deviceSize = size;
                this.inTopNavSideMenu =
                    size <=
                        (((_a = this.parentEl) === null || _a === void 0 ? void 0 : _a.customMobileBreakpoint) || DEVICE_SIZES.L);
            }
        };
        this.setGroupedNavItemTabIndex = (tabIndexValue) => {
            this.el
                .querySelectorAll(this.IC_NAVIGATION_ITEM)
                .forEach((navigationItem) => {
                const navItem = navigationItem.shadowRoot.querySelector("a") ||
                    navigationItem.querySelector("a");
                if (navItem) {
                    navItem.setAttribute("tabindex", tabIndexValue);
                }
            });
        };
        this.toggleGroupedLinkWrapperHeight = (wrapper, expanded) => {
            if (!wrapper)
                return;
            if (expanded) {
                if (this.isSideNavExpanded) {
                    this.setGroupedLinksElementHeight(wrapper, this.expandedNavItemsHeight);
                }
                else {
                    this.setGroupedLinksElementHeight(wrapper, this.collapsedNavItemsHeight);
                }
                this.setGroupedNavItemTabIndex("0");
            }
            else {
                wrapper.style.setProperty("--navigation-child-items-height", "0");
                this.setGroupedNavItemTabIndex("-1");
            }
        };
        this.toggleExpanded = () => {
            this.expanded = !this.expanded;
            const linkWrapper = this.el.shadowRoot.querySelector(this.GROUPED_LINKS_WRAPPER_CLASS);
            this.toggleGroupedLinkWrapperHeight(linkWrapper, this.expanded);
        };
        this.handleClick = (ev) => {
            if (this.navigationType === "top" && ev.detail) {
                this.toggleDropdown();
            }
            else {
                this.toggleExpanded();
            }
        };
        this.handleBlur = (ev) => {
            const target = ev.relatedTarget;
            if (!this.el.contains(target)) {
                this.hideDropdown();
            }
        };
        this.handleTopNavKeydown = (ev) => {
            if (ev.key === " " || ev.key === "Enter") {
                this.toggleDropdown();
            }
            else if (!this.inTopNavSideMenu && ev.key === "Escape") {
                this.hideDropdown();
            }
        };
        this.handleKeydown = (ev) => {
            if (ev.key === "Enter" || ev.key === " " || ev.key === "Escape") {
                switch (this.navigationType) {
                    case "top":
                        this.handleTopNavKeydown(ev);
                        break;
                    case "side":
                        this.toggleExpanded();
                        ev.preventDefault();
                        break;
                    default:
                        this.toggleExpanded();
                        break;
                }
            }
        };
        this.handleMouseLeave = (ev) => {
            const relTarget = ev.relatedTarget;
            this.mouseGate = false;
            if (!this.el.contains(relTarget) &&
                relTarget !== this.dropdown &&
                document.activeElement !== this.el &&
                !this.el.contains(document.activeElement) &&
                (relTarget === null || relTarget === void 0 ? void 0 : relTarget.nodeName) === this.nodeName &&
                this.dropdownOpen === true) {
                this.mouseGate = true;
                this.hideDropdown();
            }
            else if (!this.el.contains(relTarget) &&
                relTarget !== this.dropdown &&
                !this.el.contains(document.activeElement)) {
                this.mouseGate = false;
                setTimeout(() => {
                    this.dropdownOpen ? this.hideDropdown() : null;
                }, 500);
            }
        };
        this.handleMouseEnter = (ev) => {
            const relTarget = ev.relatedTarget;
            document.addEventListener("keydown", this.handleKeydown);
            if ((relTarget === null || relTarget === void 0 ? void 0 : relTarget.nodeName) === this.nodeName && this.mouseGate === true) {
                this.showDropdown();
            }
            else if (this.dropdownOpen === false &&
                relTarget !== null &&
                this.mouseGate === false) {
                this.mouseGate = true;
                setTimeout(() => {
                    this.mouseGate && this.showDropdown();
                }, 500);
            }
        };
        this.renderDropdownGroupedLinks = () => (h("div", { class: {
                ["navigation-group-dropdown"]: !this.inTopNavSideMenu,
                ["navigation-group-dropdown-side-menu"]: this.inTopNavSideMenu,
                ["selected"]: this.dropdownOpen && !this.inTopNavSideMenu,
            }, onMouseLeave: !this.inTopNavSideMenu ? this.handleMouseLeave : null, ref: (el) => (this.dropdown = el) }, h("nav", { class: {
                ["navigation-group-dropdown-items"]: !this.inTopNavSideMenu,
            } }, h("ul", null, h("slot", null)))));
        this.renderGroupedLinks = () => (h("ul", { class: "grouped-links-wrapper" }, h("slot", null)));
        /**
         * Gets the total height of navigation links to improve
         * smoothness of expand/collapse animations
         */
        this.getNavigationChildItemsHeight = () => {
            let navigationChildItemsHeight = 0;
            this.allGroupedNavigationItems.forEach((navItem) => {
                navigationChildItemsHeight += navItem.offsetHeight;
            });
            return `${navigationChildItemsHeight}px`;
        };
        this.setInitialGroupedLinksWrapperHeight = () => {
            const linkWrapper = this.el.shadowRoot.querySelector(this.GROUPED_LINKS_WRAPPER_CLASS);
            if (!linkWrapper)
                return;
            if (!this.isSideNavExpanded &&
                !this.collapsedNavItemsHeight &&
                this.expanded) {
                this.collapsedNavItemsHeight = this.getNavigationChildItemsHeight();
                this.setGroupedLinksElementHeight(linkWrapper, this.collapsedNavItemsHeight);
            }
            if (this.isSideNavExpanded && this.expanded) {
                this.expandedNavItemsHeight = this.getNavigationChildItemsHeight();
                this.setGroupedLinksElementHeight(linkWrapper, this.expandedNavItemsHeight);
            }
        };
        this.renderNavigationItems = () => {
            if (this.dropdownOpen || (this.inTopNavSideMenu && !this.expandable)) {
                return this.renderDropdownGroupedLinks();
            }
            if (this.navigationType !== "top") {
                return this.renderGroupedLinks();
            }
            return null;
        };
        this.deviceSize = DEVICE_SIZES.XL;
        this.dropdownOpen = false;
        this.expanded = true;
        this.focusStyle = getThemeForegroundColor();
        this.inTopNavSideMenu = false;
        this.navigationType = undefined;
        this.parentEl = undefined;
        this.expandable = false;
        this.label = undefined;
    }
    disconnectedCallback() {
        if (this.navigationType === "side") {
            this.parentEl.removeEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.removeEventListener("topNavResized", this.topNavResizedHandler);
        }
    }
    componentWillLoad() {
        this.deviceSize = getCurrentDeviceSize();
        const { navType, parent } = getNavItemParentDetails(this.el);
        this.navigationType = navType;
        this.parentEl = parent;
        if (this.navigationType === "side") {
            this.parentEl.addEventListener("sideNavExpanded", this.sideNavExpandHandler);
        }
        else if (this.navigationType === "top") {
            this.parentEl.addEventListener("topNavResized", this.topNavResizedHandler);
            if (this.deviceSize <=
                this.parentEl.customMobileBreakpoint)
                this.inTopNavSideMenu = true;
        }
    }
    componentDidLoad() {
        this.allGroupedNavigationItems = Array.from(this.el.querySelectorAll(this.IC_NAVIGATION_ITEM));
        /**
         * debounce is required as the incorrect height was retrieved instantly after
         * componentDidLoad is invoked.
         */
        setTimeout(() => this.setInitialGroupedLinksWrapperHeight(), this.DYNAMIC_GROUPED_LINKS_HEIGHT_MS);
    }
    childBlurHandler() {
        this.hideDropdown();
    }
    navItemClickHandler() {
        this.hideDropdown();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.focusStyle = theme.mode;
    }
    /**
     * Sets focus on the nav item.
     */
    async setFocus() {
        if (this.groupEl) {
            this.groupEl.focus();
        }
    }
    toggleDropdown() {
        this.dropdownOpen = !this.dropdownOpen;
    }
    showDropdown() {
        if (!this.dropdownOpen) {
            this.toggleDropdown();
        }
    }
    hideDropdown() {
        document.removeEventListener("keydown", this.handleKeydown);
        if (this.dropdownOpen) {
            this.toggleDropdown();
        }
    }
    setGroupedLinksElementHeight(groupedNavItemWrapper, height) {
        groupedNavItemWrapper.style.setProperty("--navigation-child-items-height", height);
    }
    render() {
        const { label, dropdownOpen, inTopNavSideMenu, expandable } = this;
        return (h(Host, { class: {
                ["in-side-menu"]: inTopNavSideMenu,
                expanded: this.expanded,
                collapsed: !this.expanded,
                ["navigation-group-side-nav"]: this.navigationType === "side",
            }, role: "listitem" }, h("button", { onMouseEnter: !inTopNavSideMenu &&
                this.navigationType === "top" &&
                this.handleMouseEnter, onMouseLeave: this.navigationType === "top" && this.handleMouseLeave, tabindex: inTopNavSideMenu && !expandable ? "-1" : "0", onBlur: this.handleBlur, onClick: expandable ? this.handleClick : null, onKeyDown: this.handleKeydown, class: {
                ["navigation-group"]: true,
                [this.focusStyle]: !inTopNavSideMenu,
                ["navigation-group-side-menu"]: inTopNavSideMenu && !expandable,
                ["navigation-group-side-menu-collapsed"]: inTopNavSideMenu && expandable && !dropdownOpen,
                ["navigation-group-side-menu-expanded"]: inTopNavSideMenu && expandable && dropdownOpen,
                ["selected"]: dropdownOpen && !inTopNavSideMenu,
            }, ref: (el) => (this.groupEl = el), "aria-expanded": `${dropdownOpen || this.expanded}`, "aria-haspopup": `${!inTopNavSideMenu && this.navigationType === "top"}` }, h("ic-typography", { variant: this.navigationType === "side" ? "caption" : "label" }, label), this.navigationType === "side" && expandable && (h("div", { class: {
                "chevron-toggle-icon-wrapper": true,
                "chevron-toggle-icon-closed": this.expanded,
            }, innerHTML: chevronIcon }))), this.renderNavigationItems()));
    }
    static get delegatesFocus() { return true; }
    get el() { return this; }
    static get style() { return icNavigationGroupCss; }
}, [17, "ic-navigation-group", {
        "expandable": [4],
        "label": [1],
        "deviceSize": [32],
        "dropdownOpen": [32],
        "expanded": [32],
        "focusStyle": [32],
        "inTopNavSideMenu": [32],
        "navigationType": [32],
        "parentEl": [32],
        "setFocus": [64]
    }, [[0, "childBlur", "childBlurHandler"], [0, "navItemClicked", "navItemClickHandler"], [4, "themeChange", "themeChangeHandler"]]]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-navigation-group", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-navigation-group":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, NavigationGroup);
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcNavigationGroup = NavigationGroup;
const defineCustomElement = defineCustomElement$1;

export { IcNavigationGroup, defineCustomElement };

//# sourceMappingURL=ic-navigation-group.js.map