import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { i as isSlotUsed, p as getCurrentDeviceSize, D as DEVICE_SIZES, c as checkResizeObserver } from './helpers.js';
import { d as defineCustomElement$7 } from './ic-button2.js';
import { d as defineCustomElement$6 } from './ic-horizontal-scroll2.js';
import { d as defineCustomElement$5 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$4 } from './ic-section-container2.js';
import { d as defineCustomElement$3 } from './ic-tooltip2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icPageHeaderCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;z-index:var(--ic-z-index-page-header)}:host(.sticky){position:sticky;top:0;box-shadow:var(--ic-elevation-overlay);z-index:var(--ic-z-index-sticky-page-header)}header{background-color:var(--ic-architectural-40)}header.border-bottom{border-bottom:var(--ic-border-default)}header.tabs{padding-top:var(--ic-space-md)}.breadcrumb-area{margin-bottom:var(--ic-space-md)}.main-content{display:grid;grid-template-columns:auto 1fr;grid-template-areas:\"title-area action-area\"\n    \"input-area action-area\";-moz-column-gap:var(--ic-space-md);column-gap:var(--ic-space-md);justify-content:space-between;width:100%}.title-area{display:flex;flex-direction:column;flex:1;min-width:19rem;grid-area:title-area}.header-content{display:flex;align-items:center;width:100%;flex-wrap:wrap;margin-bottom:var(--ic-space-xs);-moz-column-gap:var(--ic-space-md);column-gap:var(--ic-space-md)}.heading{display:inline-block;overflow-wrap:break-word;-webkit-hyphens:auto;hyphens:auto}.subheading.small{margin-top:var(--ic-space-xs)}.action-area{display:flex;gap:var(--ic-space-md);flex-flow:row wrap;justify-self:end;justify-content:flex-end;height:-moz-fit-content;height:fit-content;grid-area:action-area}.input-area,.navigation-area{margin-top:var(--ic-space-md);width:100%}.tabs-slot{display:flex;overflow-x:auto;padding:0.5rem;margin:-0.5rem}.tabs-slot::-webkit-scrollbar{display:none}.input-area{grid-area:input-area}@media screen and (max-width: 576px){::slotted(ic-text-field){--input-width:100%;max-width:20rem}.main-content{grid-template-areas:\"title-area\"\n      \"action-area\"\n      \"input-area\";justify-content:flex-start}.title-area{min-width:0}.action-area{min-width:100%;margin-top:var(--ic-space-md);justify-content:start}}@media screen and (min-width: 992px){:host(.sticky-desktop){position:sticky;top:0;box-shadow:var(--ic-elevation-overlay);z-index:var(--ic-z-index-sticky-page-header)}}";

const PageHeader = /*@__PURE__*/ proxyCustomElement(class PageHeader extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.resizeObserver = null;
        this.resizeObserverCallback = () => {
            if (this.reverseOrder && isSlotUsed(this.el, "actions")) {
                this.applyReverseOrder();
            }
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                this.resizeObserverCallback();
            });
            this.resizeObserver.observe(this.el);
        };
        this.applyReverseOrder = () => {
            const currSize = getCurrentDeviceSize();
            if (currSize !== this.deviceSize) {
                this.deviceSize = currSize;
            }
            const actionArea = this.el.shadowRoot.querySelector("div.action-area");
            const actionHeights = [];
            /* For each button in the actions slot, check the height of the button and push this number into the actionHeights array and then find the greatest number in this array (i.e. find the height of the tallest button) */
            for (let i = 0; i < this.actionContent.length; i++) {
                const action = this.actionContent[i];
                let actionHeight = action.offsetHeight;
                if (actionHeight === undefined) {
                    actionHeight = 0;
                }
                actionHeights.push(actionHeight);
            }
            const max = Math.max(...actionHeights);
            /* The smallest breakpoint displays buttons in the same order the user has slotted them in. When the device size is larger than the small breakpoint then the order of the button reverses due to best practice for reading patterns. If the device size is larger than the small breakpoint and the buttons have started to wrap then they follow the order the user has slotted them in. This logic is programmed based on the height of the action-area div that wraps the actions slot. If the height of the action-area div is taller than the height of the tallest button, then it is assumed that the taller height is caused by the buttons wrapping */
            let actionAreaHeight = actionArea.offsetHeight;
            if (actionAreaHeight === undefined) {
                actionAreaHeight = 0;
            }
            const appendActionContent = () => {
                this.actionContent = this.actionContent.reverse();
                this.actionContent.forEach((btn) => {
                    this.el.append(btn);
                });
                this.areButtonsReversed = !this.areButtonsReversed;
            };
            if ((this.deviceSize > DEVICE_SIZES.S &&
                actionAreaHeight <= max &&
                !this.areButtonsReversed) ||
                (((this.deviceSize > DEVICE_SIZES.S && actionAreaHeight > max) ||
                    this.deviceSize <= DEVICE_SIZES.S) &&
                    this.areButtonsReversed)) {
                appendActionContent();
            }
        };
        this.actionContent = undefined;
        this.areButtonsReversed = false;
        this.deviceSize = DEVICE_SIZES.XL;
        this.aligned = "left";
        this.border = true;
        this.heading = undefined;
        this.reverseOrder = false;
        this.size = "default";
        this.small = false;
        this.sticky = false;
        this.stickyDesktopOnly = false;
        this.subheading = undefined;
    }
    disconnectedCallback() {
        if (this.resizeObserver !== null) {
            this.resizeObserver.disconnect();
        }
    }
    componentWillLoad() {
        this.actionContent = Array.from(this.el.querySelectorAll(`[slot="actions"]`));
    }
    componentDidLoad() {
        checkResizeObserver(this.runResizeObserver);
    }
    render() {
        const { small, size, border, heading, subheading, aligned, sticky, stickyDesktopOnly, } = this;
        const navAriaLabel = heading
            ? `${heading} page sections`
            : "navigation-landmark-page-header";
        return (h(Host, { class: {
                ["sticky"]: sticky,
                ["sticky-desktop"]: !sticky && stickyDesktopOnly,
            }, "aria-label": this.el.ariaLabel || "page header" }, h("header", { class: {
                ["border-bottom"]: border,
                ["tabs"]: isSlotUsed(this.el, "tabs"),
            }, role: "presentation" }, h("ic-section-container", { aligned: aligned, fullHeight: isSlotUsed(this.el, "tabs") }, isSlotUsed(this.el, "breadcrumbs") && (h("div", { class: "breadcrumb-area" }, h("slot", { name: "breadcrumbs" }))), h("div", { class: "main-content" }, h("div", { class: "title-area" }, h("div", { class: "header-content" }, h("slot", { name: "heading" }, h("ic-typography", { variant: small || size === "small" ? "h4" : "h2", class: "heading" }, h("h2", null, heading))), h("slot", { name: "heading-adornment" })), h("div", null, h("slot", { name: "subheading" }, subheading && (h("ic-typography", { variant: "body", class: {
                ["subheading"]: true,
                ["small"]: small || size === "small",
            } }, subheading))))), isSlotUsed(this.el, "actions") && (h("div", { class: "action-area" }, h("slot", { name: "actions" }))), isSlotUsed(this.el, "input") && (h("div", { class: "input-area" }, h("slot", { name: "input" })))), (isSlotUsed(this.el, "stepper") ||
            isSlotUsed(this.el, "tabs")) && (h("div", { class: "navigation-area" }, isSlotUsed(this.el, "stepper") &&
            !isSlotUsed(this.el, "tabs") && h("slot", { name: "stepper" }), isSlotUsed(this.el, "tabs") && (h("nav", { "aria-label": navAriaLabel }, h("ic-horizontal-scroll", null, h("ul", { class: "tabs-slot" }, h("slot", { name: "tabs" })))))))))));
    }
    get el() { return this; }
    static get style() { return icPageHeaderCss; }
}, [1, "ic-page-header", {
        "aligned": [1],
        "border": [4],
        "heading": [1],
        "reverseOrder": [4, "reverse-order"],
        "size": [1],
        "small": [4],
        "sticky": [4],
        "stickyDesktopOnly": [4, "sticky-desktop-only"],
        "subheading": [1],
        "actionContent": [32],
        "areButtonsReversed": [32],
        "deviceSize": [32]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-page-header", "ic-button", "ic-horizontal-scroll", "ic-loading-indicator", "ic-section-container", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-page-header":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, PageHeader);
            }
            break;
        case "ic-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$7();
            }
            break;
        case "ic-horizontal-scroll":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ic-section-container":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcPageHeader = PageHeader;
const defineCustomElement = defineCustomElement$1;

export { IcPageHeader, defineCustomElement };

//# sourceMappingURL=ic-page-header.js.map