import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { c as closeIcon } from './close-icon.js';
import { c as chevronIcon } from './chevron-icon.js';
import { l as getCssProperty, i as isSlotUsed, D as DEVICE_SIZES, R as isEmptyString, p as getCurrentDeviceSize, n as getThemeForegroundColor, c as checkResizeObserver, o as onComponentRequiredPropUndefined, F as hasClassificationBanner, e as isPropDefined } from './helpers.js';
import { I as IcThemeForegroundEnum } from './types.js';
import { d as defineCustomElement$6 } from './ic-button2.js';
import { d as defineCustomElement$5 } from './ic-divider2.js';
import { d as defineCustomElement$4 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$3 } from './ic-tooltip2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const menuIcon = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
  <path d="M0 0h24v24H0V0z" fill="none" />
  <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z" />
  <title>menu icon</title>
</svg>
`;

const icSideNavigationCss = ":host{display:block;--side-navigation-position:fixed;--side-navigation-position-left:0;--side-navigation-position-top:var(--ic-space-xxl);--side-navigation-height:var(--ic-space-xxl);--sm-side-navigation-top-bar-height:3.5rem;--sm-side-navigation-collapsed-labels-width:6rem;--sm-side-navigation-expand-transition-duration:var(\n    --ic-transition-duration-slow\n  );--side-navigation-width:20rem;--sm-side-navigation-bottom-bar-height:3.5rem;z-index:var(--ic-z-index-side-navigation)}:host>*{box-sizing:border-box}.side-navigation{display:flex;flex-direction:column;width:var(--side-navigation-width);color:var(--ic-theme-text);position:var(--side-navigation-position);top:var(--side-navigation-position-top);left:calc(var(--side-navigation-width) * -1);bottom:0;background-color:var(--ic-theme-primary);z-index:var(--ic-z-index-side-navigation)}:host(.inline) .side-navigation{position:absolute;height:100%}:host(.anchor-right) .side-navigation{right:calc(var(--side-navigation-width) * -1)}.classification-spacing{margin-bottom:var(--ic-space-lg)}.navigation-list{padding:0;margin:0;list-style:none}.side-navigation-inner{background-color:var(--ic-theme-primary);display:flex;flex-direction:column;flex:1 1 0;overflow:auto}:host(.inline) .side-navigation-inner{flex:1}:host(.xs-menu-open) .side-navigation{transition:left var(--ic-easing-transition-slow);left:0}:host(:has(.xs-menu-open,.xs-menu-close)) ::slotted(ic-navigation-item){--navigation-item-side-nav-right:var(--ic-space-xl)}:host(.xs-menu-close) .side-navigation{left:calc(var(--side-navigation-width) * -1);transition:left var(--ic-easing-transition-slow)}:host(.xs-menu-close) .side-navigation>*{visibility:hidden}:host(.anchor-right.xs-menu-open) .side-navigation{right:0;left:auto}:host(.anchor-right.xs-menu-close) .side-navigation{right:calc(var(--side-navigation-width) * -1);left:auto;transition:right var(--ic-easing-transition-slow)}.bottom-wrapper{border-top:var(--ic-keyline-lighten);bottom:0;left:0;z-index:2;box-shadow:-0.188rem -0.188rem 0.5rem rgb(0 0 0 / 20%);background-color:var(--ic-theme-primary);display:flex;flex-direction:column}:host(.inline) .bottom-wrapper{position:sticky}:host(.dark) .bottom-wrapper{border-top:var(--ic-keyline-darken)}.top-bar{display:flex;flex-direction:row;align-items:center;min-height:var(--side-navigation-height);padding:var(--ic-space-xs);box-sizing:border-box;background-color:var(--ic-theme-primary);position:fixed;top:0;left:0;right:0;border-bottom:var(--ic-keyline-darken);box-shadow:var(--ic-elevation-overlay);z-index:2;overflow:hidden;visibility:visible}:host(.inline) .top-bar{position:absolute}.top-bar.dark a:focus{box-shadow:var(--ic-border-focus)}.top-bar.light{border-bottom:var(--ic-keyline-lighten)}.app-title-wrapper{display:flex;margin-left:var(--ic-space-xs);border-left:var(--ic-keyline-darken);padding-left:var(--ic-space-xxs);color:var(--ic-theme-text);align-items:center}.app-title-wrapper ic-typography h1{margin:0}@media screen and (min-width: 340px){.app-title-wrapper ic-typography{margin-left:var(--ic-space-xs)}}:host .title-link{display:flex;align-items:center;transition:box-shadow var(--ic-easing-transition-fast),\n    background-color var(--ic-easing-transition-fast);text-decoration:none;padding:var(--ic-space-xxs);color:var(--ic-theme-text)}:host .title-link:visited,:host .title-link:active{color:var(--ic-theme-text)}slot[name=\"app-title\"]::slotted(a),slot[name=\"app-icon\"]::slotted(a){color:var(--ic-theme-text);outline:none;text-decoration:none;display:flex}slot[name=\"app-title\"]::slotted(ic-typography),slot[name=\"app-title\"]::slotted(a){margin-left:var(--ic-space-xs) !important}slot[name=\"app-title\"]::slotted(a){font:var(--ic-font-subtitle-small)}@media screen and (min-width: 577px){:host(.sm-collapsed) slot[name=\"app-title\"]::slotted(ic-typography),:host(.sm-collapsed) slot[name=\"app-title\"]::slotted(a){position:absolute;left:-9999px;opacity:0;transition:opacity var(--ic-easing-transition-slow)}:host(.sm-expanded) slot[name=\"app-title\"]::slotted(a){font:var(--ic-font-h3) !important;font-weight:var(--ic-font-weight-semibold) !important;margin-left:var(--ic-space-xs) !important}}:host .title-link:hover{border-radius:var(--ic-border-radius);background-color:var(--ic-theme-hover)}:host .title-link:active{background-color:var(--ic-theme-active)}:host .title-link:focus,:host .title-link:focus-within{border-radius:var(--ic-border-radius);box-shadow:var(--ic-border-focus);outline:var(--ic-hc-focus-outline);background-color:transparent}:host .title-link ic-typography{display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden}.app-title-wrapper ::slotted(svg){fill:var(--ic-theme-text)}.app-icon-container{display:none}.button-label{display:flex;align-items:center}.mobile-top-bar-menu-icon{display:flex}.menu-button{width:6.5rem}.app-status-wrapper{inset:0 var(--ic-space-sm) 0 3.5rem;width:auto;display:flex;gap:var(--ic-space-xs);padding:var(--ic-space-sm) 0;justify-content:flex-end;align-items:flex-end;pointer-events:none;height:-moz-fit-content;height:fit-content;margin:0 var(--ic-space-xs)}.app-status-wrapper .app-version{display:flex;overflow-wrap:break-word;padding-bottom:var(--ic-space-xxs)}.app-status-wrapper .app-status{display:flex;border-radius:1rem;background-color:var(--ic-theme-text);color:var(--ic-color-primary-text);padding:var(--ic-space-xxs) var(--ic-space-lg);min-width:1rem}.app-status-wrapper .app-status-text{overflow-wrap:break-word}:host(.dark) .app-status-wrapper .app-status{color:var(--ic-color-white-text)}.navigation-landmark-title{position:absolute;width:var(--ic-space-1px);height:var(--ic-space-1px);padding:0;margin:calc(-1 * var(--ic-space-1px));overflow:hidden}::slotted(ic-navigation-group){--navigation-group-height:2.75rem;--navigation-group-width:100%;--navigation-group-justify-content:space-between;--navigation-group-hover:var(--ic-theme-hover);--navigation-group-text-hover:var(--ic-theme-text);--navigation-item-child-height:3.5rem;--navigation-item-child-active:var(--ic-action-dark-bg-active);--navigation-item-child-color:var(--ic-theme-text);--navigation-group-expand-toggle-padding:0.25rem}::slotted(ic-navigation-item),::slotted(ic-navigation-group){--navigation-item-justify-content:flex-start;--navigation-item-min-height:56px;--navigation-item-height:auto}.bottom-side-nav{position:relative;align-content:flex-end;min-height:var(--sm-side-navigation-top-bar-height)}.bottom-side-nav ic-divider{position:absolute;top:0;width:100%}.primary-navigation{flex:1;display:flex;flex-direction:column;overflow-y:auto;scrollbar-width:none}.primary-navigation::-webkit-scrollbar{display:none}.primary-navigation,.secondary-navigation{overflow-x:hidden}.bottom-side-nav .menu-expand-button{position:absolute;display:none}.menu-visibility-visible{visibility:visible;width:100%}.app-title-show{min-width:15.5rem}:host(.side-display){display:flex;flex-direction:column;height:100vh;position:var(--side-navigation-position);left:0;top:0;bottom:0}:host(.side-display) .app-icon-container{height:40px;display:flex;align-items:center}:host(.side-display) .top-bar{--side-navigation-height:var(--sm-side-navigation-top-bar-height);position:relative;padding:0;box-shadow:-0.188rem 0.188rem 0.5rem rgb(0 0 0 / 20%)}:host(.inline.side-display) .top-bar{position:sticky}:host(.anchor-right.side-display) .top-bar{box-shadow:0.188rem 0.188rem 0.5rem rgb(0 0 0 / 20%)}:host(.anchor-right.side-display) .bottom-wrapper{box-shadow:0.188rem -0.188rem 0.5rem rgb(0 0 0 / 20%)}:host(.side-display) .side-navigation,:host(.side-display) .top-bar{width:var(--sm-side-navigation-top-bar-height)}:host(.sm-collapsed.side-display){width:var(--sm-side-navigation-top-bar-height);transition:width var(--ic-easing-transition-slow)}:host(.sm-collapsed.collapsed-labels.side-display){width:var(--sm-side-navigation-collapsed-labels-width)}:host(.sm-expanded.side-display){width:var(--side-navigation-width);transition:width var(--ic-easing-transition-slow);box-shadow:var(--ic-elevation-overlay)}:host(.side-display) .side-navigation{--side-navigation-position-top:0;flex:1;position:relative;top:auto;left:auto;bottom:auto}:host(.inline.side-display) .side-navigation{position:relative}:host(.anchor-right.side-display) .side-navigation{left:auto;right:0}:host(.side-display) .app-title-wrapper{margin-left:0;border-left:none;padding:var(--ic-space-xs) var(--ic-space-sm)}:host(.side-display) .app-title-wrapper ::slotted(svg){height:var(--ic-space-lg);width:var(--ic-space-lg)}:host(.side-display) .app-title-wrapper ic-typography{font-weight:var(--ic-font-weight-semibold)}:host(.sm-collapsed.side-display) .app-title-wrapper ic-typography{position:absolute;left:-9999px;opacity:0;transition:opacity var(--ic-easing-transition-slow)}:host(.sm-expanded.side-display) ic-typography{position:relative;left:0}:host(.sm-expanded.side-display) :is(.side-navigation,.top-bar){width:var(--side-navigation-width);transition:width var(--ic-easing-transition-slow)}:host(.sm-collapsed.side-display) :is(.side-navigation,.top-bar){width:var(--sm-side-navigation-top-bar-height);transition:width var(--ic-easing-transition-slow)}:host(.anchor-right.sm-expanded.side-display) :is(.side-navigation,.top-bar){left:auto;right:0}:host(.side-display) .app-status-wrapper,:host(.sm-collapsed.side-display) .app-status-wrapper{display:none;margin-left:0}:host(.sm-expanded.side-display) .app-status-wrapper{display:flex;max-width:16rem;margin-right:calc(var(--ic-space-xxxs) + var(--ic-space-xs))}:host(.side-display) .bottom-side-nav{justify-items:flex-end;align-items:flex-end;justify-content:flex-end;display:flex;outline:none}:host(.side-display) .bottom-side-nav .menu-expand-button{padding-left:var(--ic-space-md);height:var(--sm-side-navigation-top-bar-height);width:100%;color:var(--ic-theme-text);background-color:transparent;outline:var(--ic-hc-focus-outline);border:none;cursor:pointer;display:flex;transition:var(--ic-easing-transition-fast)}:host(.sm-expanded.side-display) .bottom-side-nav .menu-expand-button{height:100%}:host(.side-display) .bottom-side-nav .menu-expand-button svg{justify-items:flex-start;align-self:center;display:inline-block;width:var(--ic-space-lg);height:var(--ic-space-lg)}:host(.side-display) .bottom-side-nav .menu-expand-button:hover{background-color:var(--ic-theme-hover)}:host(.side-display) .bottom-side-nav .menu-expand-button:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset);background-color:transparent}:host(.sm-collapsed.side-display) .bottom-side-nav .menu-expand-button svg{transform:scaleX(1);transition:transform var(--ic-easing-transition-slow)}:host(.sm-expanded.side-display) .bottom-side-nav .menu-expand-button svg{transform:scaleX(-1);transition:transform var(--ic-easing-transition-slow);align-self:flex-end;margin-bottom:0.875rem}:host(.anchor-right.sm-collapsed.side-display) .bottom-side-nav .menu-expand-button svg{transform:scaleX(-1)}:host(.anchor-right.sm-expanded.side-display) .bottom-side-nav .menu-expand-button svg{transform:scaleX(1)}:host(.sm-collapsed.side-display) ::slotted(ic-navigation-item){--navigation-item-label-opacity:1}:host(.sm-collapsed.side-display) ::slotted(ic-navigation-item),:host(.sm-collapsed.side-display) ::slotted(ic-navigation-group){--navigation-item-label-opacity:0;--navigation-item-min-height:56px;--navigation-item-height:56px}:host(.sm-expanded.side-display) ::slotted(ic-navigation-item),:host(.sm-expanded.side-display) ::slotted(ic-navigation-group){--navigation-item-label-opacity:1;--navigation-item-height:auto;--navigation-item-min-height:56px;--navigation-item-width:320px;--navigation-item-side-nav-right:var(--ic-space-xl)}:host(.sm-collapsed.side-display) ::slotted(ic-navigation-group){--navigation-group-title-position:absolute;--navigation-group-title-position-left:-9999px;--navigation-group-title-opacity:none}:host(.sm-expanded.side-display) ::slotted(ic-navigation-group){--navigation-group-title-position:relative;--navigation-group-title-position-left:0;--navigation-group-expand-toggle-padding:0.25rem;--navigation-group-title-opacity:flex}:host(.sm-collapsed.collapsed-labels.side-display) .side-navigation,:host(.sm-collapsed.collapsed-labels.side-display) .top-bar{width:var(--sm-side-navigation-collapsed-labels-width)}:host(.sm-collapsed.collapsed-labels.side-display) .menu-expand-button{padding:0}:host(.sm-collapsed.collapsed-labels.side-display) .app-title-wrapper{width:100%;justify-content:center}:host(.sm-collapsed.collapsed-labels.side-display) ::slotted(ic-navigation-group){--navigation-group-justify-content:center;--navigation-item-label-opacity:1;--navigation-group-item-min-width:100%;--navigation-group-expand-toggle-padding:1rem}:host(.collapsed-labels.side-display) .bottom-side-nav .menu-expand-button{justify-content:center}:host(.side-display) .collapsed-icon-labels-start{visibility:hidden;opacity:0}:host(.side-display) .collapsed-icon-labels-end{visibility:visible;opacity:1;transition:visibility 0s, opacity var(--ic-easing-transition-slow)}@media screen and (min-width: 340px){.app-icon-container{display:flex}}@media screen and (min-width: 993px){:host(.side-display){position:sticky;left:auto;top:0;bottom:0}:host(.sm-expanded.side-display){box-shadow:none}}@media (forced-colors: active){.side-navigation,.top-bar{border-right:var(--ic-hc-border)}.menu-expand-button{color:Highlight !important}slot[name=\"app-icon\"]::slotted(svg){fill:currentcolor}}";

const SideNavigation = /*@__PURE__*/ proxyCustomElement(class SideNavigation extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.sideNavExpanded = createEvent(this, "sideNavExpanded", 7);
        this.ANIMATION_DURATION = parseInt(getCssProperty("--ic-transition-duration-slow")) || 0;
        this.IC_NAVIGATION_ITEM = "ic-navigation-item";
        this.resizeObserver = null;
        this.COLLAPSED_ICON_LABELS_END = "collapsed-icon-labels-end";
        this.COLLAPSED_ICON_LABELS_START = "collapsed-icon-labels-start";
        this.menuButton = null;
        this.emitSideNavigationExpanded = (objDetails) => {
            this.sideNavExpanded.emit({
                sideNavExpanded: objDetails.sideNavExpanded,
                sideNavMobile: objDetails.sideNavMobile,
            });
        };
        this.toggleMenu = () => {
            this.menuOpen = !this.menuOpen;
            this.setMobileMenuAriaAttributes(this.menuOpen);
            this.arrangeSlottedNavigationItem(this.menuOpen);
            this.setToggleMenuFlyoutMenuVisibility(this.menuOpen);
            this.emitSideNavigationExpanded({
                sideNavExpanded: this.menuOpen,
                sideNavMobile: true,
            });
        };
        this.setToggleMenuFlyoutMenuVisibility = (menuOpen) => {
            const sideNav = this.el.shadowRoot.querySelector("#side-navigation");
            const sideNavInner = sideNav.querySelector(".side-navigation-inner");
            const bottomWrapper = sideNav.querySelector(".bottom-wrapper");
            const menuVisibilityVisible = "menu-visibility-visible";
            if (menuOpen) {
                bottomWrapper.classList.add(menuVisibilityVisible);
                sideNavInner.classList.add(menuVisibilityVisible);
            }
            else {
                setTimeout(() => {
                    sideNavInner.classList.remove(menuVisibilityVisible);
                    bottomWrapper.classList.remove(menuVisibilityVisible);
                }, this.ANIMATION_DURATION);
            }
        };
        this.setMobileMenuAriaAttributes = (menuOpen) => {
            if (this.menuButton !== null) {
                this.menuButton.setAttribute("aria-expanded", `${menuOpen}`);
                this.menuButton.setAttribute("aria-label", `${menuOpen ? "Close" : "Open"} navigation menu`);
            }
        };
        this.setAndRemoveNoWrapAfterMenuExpanded = () => {
            const appTitle = this.el.shadowRoot.querySelector(".title-link ic-typography") ||
                this.el.querySelector("[slot='app-title']");
            appTitle.classList.add("ic-typography-no-wrap");
            setTimeout(() => {
                appTitle.classList.remove("ic-typography-no-wrap");
            }, this.ANIMATION_DURATION);
        };
        this.toggleMenuExpanded = () => {
            this.menuExpanded = !this.menuExpanded;
            if (this.menuExpanded) {
                this.setAndRemoveNoWrapAfterMenuExpanded();
                this.el.shadowRoot
                    .querySelector(".app-title-inner-wrapper")
                    .classList.add("app-title-show");
            }
            else {
                this.el.style.setProperty("--navigation-item-width", "320px");
                this.el.shadowRoot
                    .querySelector(".app-title-inner-wrapper")
                    .classList.remove("app-title-show");
                this.el.addEventListener("transitionend", (e) => {
                    if (e.propertyName === "width") {
                        this.el.style.setProperty("--navigation-item-width", null);
                    }
                });
            }
            this.arrangeSlottedNavigationItem(this.menuExpanded);
            this.displayTooltipWithExpandedLongLabel(this.menuExpanded);
            if (this.collapsedIconLabels) {
                this.animateCollapsedIconLabels();
            }
            this.setExpandedButtonHeight();
            this.emitSideNavigationExpanded({ sideNavExpanded: this.menuExpanded });
        };
        /**
         * In order to style nested slotted elements (e.g. using React Router components), this method
         * rearranges the a tag and labels and adds inline styling expand/collapsed animations as external CSS classes are not
         * do not take affect.
         * @param menuExpanded boolean - true or false depending on side navigation state
         */
        this.arrangeSlottedNavigationItem = (menuExpanded) => {
            const navItems = this.el.querySelectorAll("ic-navigation-item");
            navItems.forEach((navItem) => {
                const isNamedSlot = isSlotUsed(navItem, "navigation-item");
                const isUnnamedSlot = navItem.children[0] && !navItem.children[0].getAttribute("slot");
                if (isNamedSlot || isUnnamedSlot) {
                    let navItemSlot;
                    if (isNamedSlot) {
                        navItemSlot = navItem.querySelector("[slot='navigation-item']");
                    }
                    else {
                        navItemSlot = navItem.children[0];
                    }
                    const iconWrapper = document.createElement("div");
                    const icon = navItemSlot.querySelector("svg");
                    const label = navItem.textContent.trim();
                    const icTypography = document.createElement("ic-typography");
                    icTypography.classList.add("ic-typography-label", "hydrated", "navigation-item-side-nav-slotted-text");
                    iconWrapper.style.height = "var(--ic-space-lg)";
                    iconWrapper.append(icon);
                    navItemSlot.textContent = "";
                    icTypography.textContent = label;
                    navItemSlot.append(iconWrapper);
                    navItemSlot.append(icTypography);
                    if (this.collapsedIconLabels) {
                        this.styleSlottedCollapsedIconLabels(menuExpanded, icTypography);
                    }
                    else {
                        this.styleSlottedIconLabels(menuExpanded, icTypography);
                    }
                }
            });
        };
        this.styleSlottedCollapsedIconLabels = (menuExpanded, icTypography) => {
            if (menuExpanded) {
                icTypography.style.marginTop = "0";
                icTypography.style.whiteSpace = "nowrap";
                icTypography.style.overflow = "hidden";
                icTypography.style.textOverflow = "ellipsis";
            }
            else {
                icTypography.style.marginTop = "10px";
                icTypography.style.whiteSpace = "nowrap";
                icTypography.style.overflow = "hidden";
                icTypography.style.textOverflow = "ellipsis";
            }
        };
        this.setExpandedButtonHeight = () => {
            const appStatusWrapper = this.el.shadowRoot.querySelector("#side-navigation > .bottom-wrapper > .bottom-side-nav > .app-status-wrapper");
            if (appStatusWrapper.offsetHeight !== 0) {
                this.el.style.setProperty("--sm-side-navigation-bottom-bar-height", `${appStatusWrapper.offsetHeight}px`);
            }
        };
        this.styleSlottedIconLabels = (menuExpanded, icTypography) => {
            if (menuExpanded) {
                icTypography.style.opacity = "1";
                icTypography.style.visibility = "visible";
                icTypography.style.transition =
                    "visibility 0s, opacity var(--ic-easing-transition-slow)";
            }
            else {
                icTypography.style.opacity = "0";
                icTypography.style.visibility = "hidden";
                icTypography.style.transition =
                    "visibility 0s, opacity var(--ic-easing-transition-slow)";
            }
        };
        this.transitionHandler = (type) => {
            const primaryNavigationWrapper = this.el.shadowRoot.querySelector(".primary-navigation");
            const secondaryNavigationWrapper = this.el.shadowRoot.querySelector(".bottom-wrapper > .secondary-navigation");
            const classToRemove = type === "start"
                ? this.COLLAPSED_ICON_LABELS_END
                : this.COLLAPSED_ICON_LABELS_START;
            const classToAdd = type === "start"
                ? this.COLLAPSED_ICON_LABELS_START
                : this.COLLAPSED_ICON_LABELS_END;
            if (primaryNavigationWrapper) {
                primaryNavigationWrapper.classList.remove(classToRemove);
                primaryNavigationWrapper.classList.add(classToAdd);
            }
            if (secondaryNavigationWrapper) {
                secondaryNavigationWrapper.classList.remove(classToRemove);
                secondaryNavigationWrapper.classList.add(classToAdd);
            }
        };
        this.transitionEndHandler = () => {
            this.transitionHandler("end");
        };
        this.animateCollapsedIconLabels = () => {
            this.transitionHandler("start");
            this.transitionEndHandler();
            this.el.addEventListener("transitionend", this.transitionEndHandler);
        };
        this.paddingIconWidth = (navItems) => {
            const navItemLink = (navItems[0].shadowRoot &&
                (navItems[0].shadowRoot.querySelector("ic-tooltip a") ||
                    navItems[0].shadowRoot.querySelector("ic-tooltip div"))) ||
                navItems[0].querySelector("a") ||
                navItems[0].querySelector("div");
            const navItemSVG = navItems[0].querySelector("svg");
            const navStyles = {
                gap: window.getComputedStyle(navItemLink).gap,
                iconWidth: window.getComputedStyle(navItemSVG).width,
                paddingLeft: window.getComputedStyle(navItemLink).paddingLeft,
            };
            return Object.values(navStyles).reduce((prev, curr) => {
                return (prev += parseInt(curr));
            }, 0);
        };
        this.displayTooltipWithExpandedLongLabel = (menuExpanded) => {
            let timer;
            if (menuExpanded) {
                timer = setTimeout(() => {
                    const sideNavWidth = this.el.clientWidth;
                    const navigationItems = Array.from(this.el.querySelectorAll(this.IC_NAVIGATION_ITEM));
                    const paddingIconDelta = navigationItems.length
                        ? this.paddingIconWidth(navigationItems)
                        : 0;
                    navigationItems.forEach((navigationItem) => {
                        var _a, _b;
                        const icTypographyScrollWidth = ((_a = (navigationItem.shadowRoot &&
                            navigationItem.shadowRoot.querySelector("ic-tooltip .link ic-typography.ic-typography-label"))) === null || _a === void 0 ? void 0 : _a.scrollWidth) ||
                            ((_b = navigationItem.querySelector("ic-typography.ic-typography-label")) === null || _b === void 0 ? void 0 : _b.scrollWidth);
                        if (icTypographyScrollWidth > sideNavWidth - paddingIconDelta) {
                            navigationItem.setAttribute("display-navigation-tooltip", "true");
                        }
                    });
                }, this.ANIMATION_DURATION);
            }
            else {
                clearTimeout(timer);
                const navigationItems = Array.from(this.el.querySelectorAll(this.IC_NAVIGATION_ITEM));
                navigationItems.forEach((navigationItem) => {
                    navigationItem.setAttribute("display-navigation-tooltip", "false");
                });
            }
        };
        this.setMenuExpanded = (expanded) => {
            this.menuExpanded = expanded;
        };
        /**
         * As the mobile top bar is fixed, a padding top is required
         * to push main content down the height of the mobile top bar
         * @param value - padding-top css value
         */
        this.setParentPaddingTop = (value) => {
            this.el.parentElement.style.setProperty("padding-top", value);
        };
        this.setParentPaddingLeft = (value) => {
            this.el.parentElement.style.setProperty("padding-left", value);
        };
        this.renderAppTitle = (isAppNameSubtitleVariant) => {
            const displayShortAppTitle = this.deviceSize <= DEVICE_SIZES.S && !isEmptyString(this.shortAppTitle);
            return (h("ic-typography", { variant: displayShortAppTitle || isAppNameSubtitleVariant
                    ? "subtitle-small"
                    : "h3", "aria-label": displayShortAppTitle
                    ? `${this.appTitle} (${this.shortAppTitle})`
                    : undefined }, h("h1", null, displayShortAppTitle ? this.shortAppTitle : this.appTitle)));
        };
        this.resizeObserverCallback = (currSize) => {
            var _a;
            this.deviceSize = currSize;
            const isSmallAndDisableTopBar = currSize === DEVICE_SIZES.S && !this.disableTopBarBehaviour;
            if (!this.disableAutoParentStyling) {
                const topBarHeight = (_a = this.el.shadowRoot.querySelector(".top-bar")) === null || _a === void 0 ? void 0 : _a.scrollHeight;
                this.setParentPaddingTop(isSmallAndDisableTopBar ? `${topBarHeight}px` : "0");
                if (isSmallAndDisableTopBar)
                    this.setParentPaddingLeft("0");
                if (isSmallAndDisableTopBar && this.inline) {
                    this.el.parentElement.style.setProperty("height", `calc(100% - ${topBarHeight}px)`);
                }
                else if (!isSmallAndDisableTopBar) {
                    this.el.parentElement.style.setProperty("height", "100%");
                }
            }
            if (!this.disableAutoParentStyling) {
                const paddingLeft = `calc(var(--ic-space-xxl) ${this.collapsedIconLabels ? "* 2" : "+ var(--ic-space-xs)"})`;
                if (currSize > DEVICE_SIZES.L) {
                    this.setParentPaddingTop("0");
                    this.setParentPaddingLeft("0");
                }
                else if ((currSize > DEVICE_SIZES.S || this.disableTopBarBehaviour) &&
                    currSize <= DEVICE_SIZES.M &&
                    this.static) {
                    this.setParentPaddingLeft(paddingLeft);
                }
                else if ((currSize > DEVICE_SIZES.S || this.disableTopBarBehaviour) &&
                    currSize <= DEVICE_SIZES.L) {
                    this.setParentPaddingLeft(this.static && this.menuExpanded
                        ? "calc(var(--ic-space-xl) * 10)"
                        : paddingLeft);
                }
            }
        };
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                const currSize = getCurrentDeviceSize();
                this.deviceSizeAppTitle = currSize;
                this.resizeObserverCallback(currSize);
            });
            this.resizeObserver.observe(document.body, { box: "content-box" });
        };
        this.setCollapsedIconLabels = () => {
            const navigationItems = Array.from(this.el.querySelectorAll(this.IC_NAVIGATION_ITEM));
            navigationItems.forEach((navigationItem) => {
                navigationItem.setAttribute("collapsed-icon-label", "true");
            });
        };
        this.styleSlottedCollapsedIconLabel = () => {
            const dynamicSlottedIcTypographyComps = Array.from(this.el.querySelectorAll(".navigation-item-side-nav-slotted-text"));
            dynamicSlottedIcTypographyComps.forEach((icTypography) => {
                var _a, _b;
                if ((_b = (_a = icTypography === null || icTypography === void 0 ? void 0 : icTypography.parentElement) === null || _a === void 0 ? void 0 : _a.parentElement) === null || _b === void 0 ? void 0 : _b.classList.contains("navigation-item-side-nav-collapsed-with-label")) {
                    icTypography.style.whiteSpace = "nowrap";
                    icTypography.style.overflow = "hidden";
                    icTypography.style.textOverflow = "ellipsis";
                    icTypography.style.marginTop = "10px";
                }
            });
        };
        this.renderTopBar = ({ isSDevice, foregroundColor, menuOpen, href, isAppNameSubtitleVariant, }) => {
            const hasTitle = this.appTitle !== "" && isPropDefined(this.appTitle);
            const Component = isSlotUsed(this.el, "app-title") ? "div" : "a";
            const attrs = Component == "a" && {
                href: href,
            };
            return (h("div", { class: {
                    "top-bar": true,
                    [this.foregroundColor]: true,
                } }, isSDevice && (h("nav", { "aria-labelledby": "menu-navigation-toggle-button-landmark", "aria-hidden": "false" }, h("ic-button", { "aria-label": "Open navigation menu", class: "menu-button", id: "menu-button", variant: "secondary", size: "small", "full-width": "true", appearance: foregroundColor, onClick: this.toggleMenu, ariaOwnsId: "side-navigation", "aria-haspopup": "true", "aria-expanded": "false", ref: (el) => (this.menuButton = el) }, h("span", { class: "mobile-top-bar-menu-icon", slot: "icon", innerHTML: menuOpen ? closeIcon : menuIcon }), menuOpen ? "Close" : "Menu"), h("span", { id: "menu-navigation-toggle-button-landmark", class: "navigation-landmark-title", "aria-hidden": "true" }, "Navigation menu toggle button"))), h("div", { class: "app-title-wrapper" }, (hasTitle || isSlotUsed(this.el, "app-title")) && (h(Component, Object.assign({}, attrs, { class: "title-link" }), h("div", { class: "app-icon-container", "aria-hidden": "true" }, h("slot", { name: "app-icon" })), h("div", { class: "app-title-inner-wrapper" }, isSlotUsed(this.el, "app-title") ? (h("slot", { name: "app-title" })) : (this.renderAppTitle(isAppNameSubtitleVariant))))))));
        };
        this.deviceSize = getCurrentDeviceSize();
        this.deviceSizeAppTitle = DEVICE_SIZES.S;
        this.foregroundColor = getThemeForegroundColor();
        this.hasSecondaryNavigation = false;
        this.menuExpanded = false;
        this.menuOpen = false;
        this.appTitle = undefined;
        this.collapsedIconLabels = false;
        this.disableAutoParentStyling = false;
        this.disableTopBarBehaviour = false;
        this.expanded = false;
        this.href = "/";
        this.inline = false;
        this.shortAppTitle = "";
        this.static = false;
        this.status = undefined;
        this.version = undefined;
    }
    watchExpandedHandler() {
        this.setMenuExpanded(this.expanded);
    }
    componentWillLoad() {
        this.setMenuExpanded(this.expanded);
        if (this.collapsedIconLabels) {
            this.setCollapsedIconLabels();
        }
        this.hasSecondaryNavigation = isSlotUsed(this.el, "secondary-navigation");
    }
    componentDidLoad() {
        this.emitSideNavigationExpanded({
            sideNavExpanded: this.menuExpanded,
            sideNavMobile: this.deviceSize === DEVICE_SIZES.S && !this.disableTopBarBehaviour,
        });
        checkResizeObserver(this.runResizeObserver);
        this.styleSlottedCollapsedIconLabel();
        this.arrangeSlottedNavigationItem(this.menuExpanded);
        this.displayTooltipWithExpandedLongLabel(this.menuExpanded);
        this.setExpandedButtonHeight();
        !isSlotUsed(this.el, "app-title") &&
            onComponentRequiredPropUndefined([{ prop: this.appTitle, propName: "app-title" }], "Side Navigation");
    }
    disconnectedCallback() {
        if (this.resizeObserver !== null) {
            this.resizeObserver.disconnect();
        }
        this.el.removeEventListener("transitionend", this.transitionEndHandler);
    }
    themeChangeHandler({ detail }) {
        this.foregroundColor = detail.mode;
    }
    render() {
        const { appTitle, menuOpen, foregroundColor, menuExpanded, href, status, version, collapsedIconLabels, inline, } = this;
        const isSDevice = !this.disableTopBarBehaviour && this.deviceSize === DEVICE_SIZES.S;
        const isMdDevice = this.deviceSize === DEVICE_SIZES.M;
        const isLgDevice = this.deviceSize >= DEVICE_SIZES.L;
        const isAppNameSubtitleVariant = this.deviceSizeAppTitle === DEVICE_SIZES.S;
        const displayExpandBtn = isMdDevice || this.disableTopBarBehaviour || (isLgDevice && !this.static);
        const topBarProps = {
            isSDevice,
            foregroundColor,
            menuOpen,
            href,
            isAppNameSubtitleVariant,
            appTitle,
        };
        return (h(Host, { class: {
                "xs-menu-open": menuOpen && isSDevice,
                "xs-menu-close": !menuOpen && isSDevice,
                "sm-collapsed": !isSDevice && !menuExpanded,
                "sm-expanded": !isSDevice && menuExpanded,
                "side-display": this.deviceSize > DEVICE_SIZES.S || this.disableTopBarBehaviour,
                [IcThemeForegroundEnum.Dark]: foregroundColor === IcThemeForegroundEnum.Dark,
                ["collapsed-labels"]: !isSDevice && !menuExpanded && collapsedIconLabels,
                ["inline"]: inline,
            } }, isSDevice && this.renderTopBar(Object.assign({}, topBarProps)), h("div", { class: "side-navigation", id: "side-navigation" }, !isSDevice && this.renderTopBar(Object.assign({}, topBarProps)), h("div", { class: "side-navigation-inner" }, isSlotUsed(this.el, "primary-navigation") && (h("nav", { class: "primary-navigation", "aria-labelledby": "primary-navigation-landmark" }, h("span", { "aria-hidden": "true", class: "navigation-landmark-title", id: "primary-navigation-landmark" }, "Primary"), h("ul", { class: "navigation-list" }, h("slot", { name: "primary-navigation" }))))), h("div", { class: {
                ["bottom-wrapper"]: true,
                ["classification-spacing"]: hasClassificationBanner(),
            } }, isSlotUsed(this.el, "secondary-navigation") && (h("nav", { class: "secondary-navigation", "aria-labelledby": "secondary-navigation-landmark" }, h("span", { "aria-hidden": "true", class: "navigation-landmark-title", id: "secondary-navigation-landmark" }, "Secondary"), h("ul", { class: "navigation-list" }, h("slot", { name: "secondary-navigation" })))), h("div", { class: "bottom-side-nav" }, this.hasSecondaryNavigation && h("ic-divider", null), displayExpandBtn && (h("button", { class: "menu-expand-button", innerHTML: chevronIcon, onClick: this.toggleMenuExpanded, "aria-label": `${menuExpanded ? "Collapse" : "Expand"} side navigation` })), h("div", { class: "app-status-wrapper" }, status !== "" && (h("div", { class: {
                ["app-status"]: true,
            } }, h("ic-typography", { "aria-label": "app tag", variant: "label-uppercase", class: "app-status-text" }, status))), version !== "" && (h("ic-typography", { variant: "label", class: "app-version", "aria-label": "app version" }, version))))))));
    }
    get el() { return this; }
    static get watchers() { return {
        "expanded": ["watchExpandedHandler"]
    }; }
    static get style() { return icSideNavigationCss; }
}, [1, "ic-side-navigation", {
        "appTitle": [1, "app-title"],
        "collapsedIconLabels": [4, "collapsed-icon-labels"],
        "disableAutoParentStyling": [4, "disable-auto-parent-styling"],
        "disableTopBarBehaviour": [4, "disable-top-bar-behaviour"],
        "expanded": [4],
        "href": [1],
        "inline": [4],
        "shortAppTitle": [1, "short-app-title"],
        "static": [4],
        "status": [1],
        "version": [1],
        "deviceSize": [32],
        "deviceSizeAppTitle": [32],
        "foregroundColor": [32],
        "hasSecondaryNavigation": [32],
        "menuExpanded": [32],
        "menuOpen": [32]
    }, [[4, "themeChange", "themeChangeHandler"]], {
        "expanded": ["watchExpandedHandler"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-side-navigation", "ic-button", "ic-divider", "ic-loading-indicator", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-side-navigation":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, SideNavigation);
            }
            break;
        case "ic-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ic-divider":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcSideNavigation = SideNavigation;
const defineCustomElement = defineCustomElement$1;

export { IcSideNavigation, defineCustomElement };

//# sourceMappingURL=ic-side-navigation.js.map