import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const icSkeletonCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}@keyframes loading{0%{background-color:var(--ic-architectural-100)}50%{background-color:var(--ic-architectural-200)}100%{background-color:var(--ic-architectural-100)}}@keyframes loading-light{0%{background-color:var(--ic-architectural-600)}50%{background-color:var(--ic-architectural-400)}100%{background-color:var(--ic-architectural-600)}}:host{display:inline-block}:host(.skeleton){background-color:var(--ic-architectural-100);border-radius:var(--ic-border-radius);animation:loading 1200ms infinite;display:inline-block}:host(.skeleton)>*{opacity:0;visibility:hidden}:host(.circle){border-radius:50%}:host(.light){background-color:var(--ic-architectural-600);animation:loading-light 1200ms infinite}@media (forced-colors: active){:host(.skeleton){-ms-high-contrast-adjust:none;forced-color-adjust:none;background:currentcolor}}";

const DEFAULT_HEIGHTS = {
    text: "1em",
    circle: "25px",
    rectangle: "93px",
};
const Skeleton = /*@__PURE__*/ proxyCustomElement(class Skeleton extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.appearance = "default";
        this.light = false;
        this.variant = "rectangle";
    }
    render() {
        const { variant, light, appearance, el } = this;
        const style = !el.firstElementChild
            ? {
                height: el.style.height || DEFAULT_HEIGHTS[variant],
                width: el.style.width || (variant === "circle" ? "25px" : "260px"),
            }
            : undefined;
        return (h(Host, { class: {
                skeleton: true,
                circle: variant === "circle",
                light: light || appearance === "light",
            }, style: style, "aria-disabled": "true" }, h("slot", null)));
    }
    get el() { return this; }
    static get style() { return icSkeletonCss; }
}, [1, "ic-skeleton", {
        "appearance": [1],
        "light": [4],
        "variant": [1]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-skeleton"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-skeleton":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Skeleton);
            }
            break;
    } });
}

const IcSkeleton = Skeleton;
const defineCustomElement = defineCustomElement$1;

export { IcSkeleton, defineCustomElement };

//# sourceMappingURL=ic-skeleton.js.map