import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { c as checkIcon } from './check-icon.js';
import { e as isPropDefined } from './helpers.js';
import { d as defineCustomElement$3 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const warningIcon = `<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.99935 4.32666L13.0193 13H2.97935L7.99935 4.32666ZM7.99935 1.66666L0.666016 14.3333H15.3327L7.99935 1.66666ZM8.66602 11H7.33268V12.3333H8.66602V11ZM8.66602 6.99999H7.33268V9.66666H8.66602V6.99999Z" fill="currentColor"/>
</svg>`;

const icStepCss = ":host{display:flex;flex:auto}.step{display:flex;flex:1 1 0}.step-icon{display:flex;justify-content:center}.step-title,.step-subtitle,.step-status,.next-step{white-space:pre-line}.visually-hidden{position:absolute;left:-625rem;top:auto;width:1px;height:1px;overflow:hidden}:host(.compact){-moz-column-gap:var(--ic-space-sm);column-gap:var(--ic-space-sm);--compact-step-inner-color:var(--ic-status-info);--compact-step-circular-line-width:var(--ic-space-xxs)}:host(.compact.light){--compact-step-inner-color:var(--ic-status-info-contrast);--compact-step-outer-color:var(--ic-architectural-600)}:host(.compact) .step{-moz-column-gap:var(--ic-space-sm);column-gap:var(--ic-space-sm)}:host(.compact) .step:not(.current){display:none;opacity:0;visibility:hidden}.compact-step-progress-indicator{margin:var(--ic-space-xs) 0 0}:host ic-loading-indicator::part(ic-loading-container){border-radius:50%}:host(:not(.light)) ic-loading-indicator::part(ic-loading-container){background-color:var(--ic-architectural-white)}:host(.compact) .step-title-area{display:flex;flex-direction:column;width:14.25rem}:host(.compact.light) .disabled .step-title-area{color:var(--ic-architectural-400)}.info-line{display:flex;-moz-column-gap:var(--ic-space-xs);column-gap:var(--ic-space-xs)}.step-status{display:flex;color:var(--ic-color-secondary-text);-moz-column-gap:var(--ic-space-xxxs);column-gap:var(--ic-space-xxxs)}.compact-step-completed .step-status{color:var(--ic-status-success)}:host(.light) .compact-step-completed .step-status{color:var(--ic-status-success-contrast)}.compact-step-disabled :is(.step-title,.step-status){color:var(--ic-color-tertiary-text)}:host(.light) .compact-step-disabled :is(.step-status){color:var(--ic-architectural-white)}.step-num{color:var(--ic-color-secondary-text);white-space:nowrap}:host(.light) .step-num{color:var(--ic-architectural-white)}:host(.compact) .step-icon{margin:var(--ic-space-xxxs)}:host(.compact) .step-icon svg{width:var(--ic-space-md);height:var(--ic-space-md)}:host(.default) .step{flex-direction:column}:host(.default.last-step){flex-grow:initial}.step-top{display:flex;width:100%;align-items:center;align-self:flex-start;height:2.5rem}:host(.default) .step-icon{border-radius:50%}:host(.default:not(.light)) .step-icon{background-color:var(--ic-architectural-white)}.step-icon-inner{width:var(--ic-space-xl);height:var(--ic-space-xl);display:flex;justify-content:center;align-items:center;border-radius:50%}:host(.default) .current{color:var(--ic-status-info)}:host(.default.light) .current,:host(.default.light) .current .step-title-area{color:var(--ic-status-info-contrast)}:host(.default) .step-title-area{margin:var(--ic-space-xs) 0;padding-right:var(--ic-space-xs);width:100%}:host(.light) .step-title-area{color:var(--ic-architectural-200)}:host(.compact.light) .step-title-area{color:var(--ic-architectural-white)}:host(.default) .step-title,.step-subtitle{width:-moz-fit-content;width:fit-content}.step-subtitle{color:var(--ic-color-tertiary-text)}:host(.light) .step-subtitle{color:var(--ic-architectural-white)}.current .step-subtitle{color:var(--ic-color-primary-text)}:host(.default) .completed{color:var(--ic-status-success)}:host(.default.light) .completed,:host(.default.light) .completed .step-title-area{color:var(--ic-status-success-contrast)}.active .step-icon-inner{box-shadow:inset var(--ic-architectural-200) 0 0 0 0.125rem}:host(.light) .active .step-icon-inner{color:var(--ic-architectural-white)}.current .step-icon-inner{background-color:var(--ic-status-info);color:white}:host(.light) .current .step-icon-inner{background-color:var(--ic-status-info-contrast)}.disabled{color:var(--ic-architectural-200)}:host(.default.light) .disabled,:host(.default.light) .disabled .step-title-area{color:var(--ic-architectural-400)}.disabled .step-icon-inner{border:var(--ic-border-width) dashed var(--ic-architectural-200);width:calc(var(--ic-space-xl) - var(--ic-space-xxxs));height:calc(var(--ic-space-xl) - var(--ic-space-xxxs))}:host(.light) .disabled .step-icon-inner{border:var(--ic-border-width) dashed var(--ic-architectural-400)}.disabled .step-title-area,:host(.default.light) .disabled .step-subtitle{color:var(--ic-color-tertiary-text)}.completed .step-icon-inner{background:var(--ic-status-success);box-shadow:inset var(--ic-status-success) 0 0 0 var(--ic-space-xxxs);border-radius:100%}:host(.light) .completed .step-icon-inner{background:var(--ic-status-success-contrast);box-shadow:inset var(--ic-status-success-contrast) 0 0 0 var(--ic-space-xxxs)}:host(.default) .current .step-icon{border:var(--ic-space-xxxs) solid var(--ic-status-info);padding:var(--ic-space-xxxs);margin:0 calc(-1 * var(--ic-space-xxxs));}:host(.default.light) .current .step-icon{border:var(--ic-space-xxxs) solid var(--ic-status-info-contrast)}.step-connect{height:var(--ic-space-xxxs);background-color:var(--ic-architectural-200);margin:0 var(--ic-space-xs);border-radius:var(--ic-space-xxs);width:100%}:host(.light) .step-connect{background-color:var(--ic-architectural-600)}.aligned-full-width.step-connect{min-width:6.25rem;width:100%}.disabled .step-connect{height:0;background-color:rgb(0 0 0 / 0%);border-top:0.125rem dashed var(--ic-architectural-200);border-radius:0}:host(.light) .disabled .step-connect{border-top:0.125rem dashed var(--ic-architectural-600)}.completed .step-connect{background-color:var(--ic-status-success)}:host(.light) .completed .step-connect{background-color:var(--ic-status-success-contrast)}.step-connect-inner{width:70%;display:flex;flex:auto;height:var(--ic-space-xxxs);border-radius:var(--ic-space-xxs);background-color:var(--ic-status-info)}:host(.light) .step-connect-inner{background-color:var(--ic-status-info-contrast)}.step-icon-inner .check-icon{padding-top:var(--ic-space-xxs)}.step-icon-inner .check-icon svg{width:var(--ic-space-md);height:auto}.step-icon-inner .check-icon>svg>path{fill:var(--ic-color-white-text)}@media (forced-colors: active){.compact-step-disabled :is(.step-title,.step-status){color:GrayText}.step-connect:not(.disabled .step-connect){border:var(--ic-hc-border)}.active .step-icon-inner,.completed .step-icon-inner,.current .step-icon-inner{forced-color-adjust:none;box-shadow:inset canvastext 0 0 0 0.125rem;background-color:transparent;color:canvastext}:host(.default) .current .step-icon{padding:0;border:none}.disabled,.disabled .step-title-area{color:GrayText}.step-connect-inner,.completed .step-connect{background-color:canvastext}.step-icon-inner .check-icon>svg>path{fill:canvastext}}";

const Step = /*@__PURE__*/ proxyCustomElement(class Step extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.compactStepStyling = undefined;
        this.current = false;
        this.lastStep = undefined;
        this.lastStepNum = undefined;
        this.nextStepTitle = undefined;
        this.progress = undefined;
        this.stepNum = undefined;
        this.stepStatus = undefined;
        this.stepSubtitle = undefined;
        this.stepTitle = undefined;
        this.variant = undefined;
        this.stepType = "active";
    }
    stepTypeChangeHandler() {
        if (this.variant === "compact" && this.stepType === "current") {
            this.current = true;
        }
        else {
            this.current = false;
        }
    }
    render() {
        var _a;
        // ARIA LABEL
        let ariaLabel = "";
        if (this.stepType === "completed") {
            ariaLabel = ". Completed step";
        }
        else if (this.stepType === "disabled") {
            ariaLabel = ". Non-required step";
        }
        else if (this.stepStatus === "required") {
            ariaLabel = ". Required step";
        }
        else if (this.stepStatus === "optional") {
            ariaLabel = ". Optional step";
        }
        // STEP STATUS
        let stepStatus;
        if (isPropDefined(this.stepStatus)) {
            stepStatus = this.stepStatus[0].toUpperCase() + this.stepStatus.slice(1);
        }
        // STEP TYPE
        let stepType;
        if (this.stepType === "disabled" ||
            this.compactStepStyling === "disabled") {
            stepType = "Not required";
        }
        else if (this.compactStepStyling === "completed") {
            stepType = "Completed";
        }
        // STATUS ICON FOR COMPACT STEP
        let statusIcon;
        if (this.stepType === "completed" ||
            this.compactStepStyling === "completed") {
            statusIcon = (h("span", { class: "check-icon step-icon", "aria-hidden": "true", innerHTML: checkIcon }));
        }
        else if (this.stepType === "disabled" ||
            this.compactStepStyling === "disabled") {
            statusIcon = (h("span", { class: "warning-icon step-icon", "aria-hidden": "true", innerHTML: warningIcon }));
        }
        // COMPACT STEP COMPONENT
        const compactStep = (h("div", { class: {
                ["step"]: true,
                ["current"]: this.current,
                [`compact-step-${this.compactStepStyling}`]: !!this.compactStepStyling,
            } }, h("ic-loading-indicator", { class: {
                "compact-step-progress-indicator": true,
                "not-required": this.stepType === "disabled" ||
                    this.compactStepStyling === "disabled",
            }, "aria-hidden": "true", size: "small", "inner-label": this.stepNum, progress: this.progress }), h("div", { class: "step-title-area" }, h("ic-typography", { variant: "h4", class: "step-title" }, this.stepTitle), h("div", { class: "info-line" }, h("ic-typography", { variant: "caption", class: "step-num" }, `${this.stepNum} of ${this.lastStepNum}`, h("span", { class: "visually-hidden" }, " steps")), (this.stepSubtitle ||
            this.stepType === "completed" ||
            this.stepType === "disabled" ||
            (this.variant === "compact" &&
                !!this.compactStepStyling &&
                this.compactStepStyling !== "active") ||
            !!this.stepStatus) && (h("div", { class: "step-status" }, statusIcon !== undefined && statusIcon, (this.stepSubtitle || stepType) && (h("ic-typography", { variant: "caption" }, this.stepSubtitle !== null &&
            isPropDefined(this.stepSubtitle)
            ? this.stepSubtitle
            : this.stepType === "disabled" ||
                (this.variant === "compact" &&
                    this.compactStepStyling === "disabled") ||
                this.stepType === "completed" ||
                (this.variant === "compact" &&
                    this.compactStepStyling === "completed")
                ? stepType
                : this.stepStatus && stepStatus))))), this.lastStep ? (h("ic-typography", { variant: "subtitle-small", class: "next-step" }, "Last step")) : (isPropDefined(this.nextStepTitle) && (h("ic-typography", { variant: "subtitle-small", class: "next-step" }, "Next", h("span", { class: "visually-hidden" }, " step is"), ":", " ", this.nextStepTitle))))));
        // ICON FOR DEFAULT STEP
        let icon;
        if (this.stepType !== "completed") {
            icon = (h("ic-typography", { variant: "subtitle-small" }, h("span", { class: "step-icon-inner", "aria-hidden": "true" }, this.stepNum)));
        }
        else {
            icon = (h("div", { class: "step-icon-inner", "aria-hidden": "true" }, h("span", { class: "check-icon", innerHTML: checkIcon })));
        }
        // STEP CONNECT FOR DEFAULT STEP
        const partialBar = this.stepType === "current" && (h("div", { class: "step-connect-inner" }));
        const finalStep = !this.lastStep && (h("div", { class: {
                ["step-connect"]: true,
                ["aligned-full-width"]: this.el.parentElement.classList.contains("default") &&
                    !this.el.parentElement.classList.contains("aligned-left"),
            } }, partialBar));
        // DEFAULT STEP COMPONENT
        const defaultStep = (h("div", { class: {
                ["step"]: true,
                [`${this.stepType}`]: true,
            } }, h("div", { class: "step-top" }, h("div", { class: "step-icon" }, icon), finalStep), (this.stepTitle || this.stepSubtitle || this.stepStatus) && (h("div", { class: "step-title-area" }, this.stepTitle && (h("ic-typography", { variant: "subtitle-large", class: "step-title" }, this.stepTitle)), this.stepTitle && (this.stepSubtitle || this.stepStatus) && (h("ic-typography", { variant: "caption", class: "step-subtitle" }, this.stepSubtitle !== null && isPropDefined(this.stepSubtitle)
            ? this.stepSubtitle
            : stepStatus))))));
        return (h(Host, { role: "listitem", "aria-label": `Step ${this.stepNum}${ariaLabel}`, "aria-current": (this.current || this.stepType === "current") && "step", class: {
                ["aligned-full-width"]: this.el.parentElement.classList.contains("default") &&
                    !this.el.parentElement.classList.contains("aligned-left"),
                [`${this.variant}`]: true,
                ["light"]: ((_a = this.el.parentElement) === null || _a === void 0 ? void 0 : _a.appearance) ===
                    "light",
            } }, this.variant === "compact" ? compactStep : defaultStep));
    }
    get el() { return this; }
    static get watchers() { return {
        "stepType": ["stepTypeChangeHandler"]
    }; }
    static get style() { return icStepCss; }
}, [1, "ic-step", {
        "compactStepStyling": [1, "compact-step-styling"],
        "current": [1028],
        "lastStep": [4, "last-step"],
        "lastStepNum": [2, "last-step-num"],
        "nextStepTitle": [1, "next-step-title"],
        "progress": [2],
        "stepNum": [2, "step-num"],
        "stepStatus": [1, "step-status"],
        "stepSubtitle": [1, "step-subtitle"],
        "stepTitle": [1, "step-title"],
        "variant": [1],
        "stepType": [1, "step-type"]
    }, undefined, {
        "stepType": ["stepTypeChangeHandler"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-step", "ic-loading-indicator", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-step":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Step);
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcStep = Step;
const defineCustomElement = defineCustomElement$1;

export { IcStep, defineCustomElement };

//# sourceMappingURL=ic-step.js.map