import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { o as onComponentRequiredPropUndefined } from './helpers.js';
import { I as IcThemeForegroundEnum } from './types.js';
import { d as defineCustomElement$6 } from './ic-button2.js';
import { d as defineCustomElement$5 } from './ic-horizontal-scroll2.js';
import { d as defineCustomElement$4 } from './ic-loading-indicator2.js';
import { d as defineCustomElement$3 } from './ic-tooltip2.js';
import { d as defineCustomElement$2 } from './ic-typography2.js';

const icTabGroupCss = ":host{--border-bottom-color:var(--ic-architectural-300);display:block;margin-bottom:var(--ic-space-md);border-bottom:var(--ic-border-default)}:host(.inline){margin-bottom:0;border-bottom:none}.light{border-bottom:var(--ic-border-width) solid var(--ic-architectural-white)}.tabs-container{display:flex;flex-direction:row}.tabs-container::-webkit-scrollbar{display:none}";

const TabGroup = /*@__PURE__*/ proxyCustomElement(class TabGroup extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.appearance = "dark";
        this.contextId = "default";
        this.inline = false;
        this.label = undefined;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Tab Group");
    }
    render() {
        const { appearance, label } = this;
        return (h(Host, { role: "tablist", "aria-label": label, class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["inline"]: this.inline,
            } }, h("ic-horizontal-scroll", { appearance: appearance === IcThemeForegroundEnum.Dark
                ? IcThemeForegroundEnum.Default
                : appearance, "focus-trigger": "tabFocus" }, h("div", { class: "tabs-container" }, h("slot", null)))));
    }
    static get delegatesFocus() { return true; }
    static get style() { return icTabGroupCss; }
}, [17, "ic-tab-group", {
        "appearance": [1],
        "contextId": [513, "context-id"],
        "inline": [516],
        "label": [1]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-tab-group", "ic-button", "ic-horizontal-scroll", "ic-loading-indicator", "ic-tooltip", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-tab-group":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, TabGroup);
            }
            break;
        case "ic-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ic-horizontal-scroll":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ic-loading-indicator":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IcTabGroup = TabGroup;
const defineCustomElement = defineCustomElement$1;

export { IcTabGroup, defineCustomElement };

//# sourceMappingURL=ic-tab-group.js.map