import { proxyCustomElement, HTMLElement, createEvent, forceUpdate, h, Host } from '@stencil/core/internal/client';
import { a as IcInformationStatus } from './types.js';
import { f as checkSlotInChildMutations, Q as debounceEvent, s as removeFormResetListener, b as inheritAttributes, q as addFormResetListener, r as removeDisabledFalse, o as onComponentRequiredPropUndefined, v as getInputDescribedByText, t as renderHiddenInput, i as isSlotUsed, R as isEmptyString, I as IC_INHERITED_ARIA } from './helpers.js';
import { d as defineCustomElement$5 } from './ic-input-component-container2.js';
import { d as defineCustomElement$4 } from './ic-input-container2.js';
import { d as defineCustomElement$3 } from './ic-input-label2.js';
import { d as defineCustomElement$2 } from './ic-input-validation2.js';
import { d as defineCustomElement$1 } from './ic-typography2.js';

const icTextFieldCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block}:host(.fullwidth){width:100%}::-moz-placeholder{color:var(--ic-color-tertiary-text);opacity:1}::placeholder{color:var(--ic-color-tertiary-text);opacity:1}input,textarea{border:0;border-radius:var(--ic-border-radius);background-color:var(--ic-architectural-white);line-height:1.5rem;letter-spacing:0.005rem;width:100%;padding-right:var(--ic-space-xs);padding-left:var(--ic-space-xs)}textarea{min-height:var(--ic-space-lg);resize:vertical;padding-top:0.375rem}input:focus,textarea:focus{border:0;outline:0}input:disabled,textarea:disabled{color:var(--ic-architectural-200)}input.readonly,textarea.readonly{color:var(--ic-color-primary-text)}input::-webkit-outer-spin-button,input::-webkit-inner-spin-button{-webkit-appearance:none;margin:0}input[type=\"number\"]{-moz-appearance:textfield}textarea.no-resize{resize:none}.maxlengthtext{color:var(--ic-color-secondary-text);padding-right:var(--ic-space-xxxs)}.no-left-pad{padding-left:0}::slotted([slot=\"icon\"]){fill:var(--ic-color-tertiary-text)}.has-value ::slotted([slot=\"icon\"]){fill:var(--ic-color-primary-text)}.charcount{margin-right:calc(-1 * var(--ic-space-xxxs))}input[type=\"search\"]::-webkit-search-cancel-button,input[type=\"search\"]::-webkit-search-decoration,input[type=\"search\"]::-webkit-search-results-button,input[type=\"search\"]::-webkit-search-results-decoration{display:none}input[type=\"search\"].truncate-value{width:100%;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}@media (forced-colors: active){input.readonly,textarea.readonly{color:canvastext}.has-value ::slotted([slot=\"icon\"]){fill:currentcolor}}";

let inputIds = 0;
const MUTABLE_ATTRIBUTES = [...IC_INHERITED_ARIA, "title"];
const TextField = /*@__PURE__*/ proxyCustomElement(class TextField extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.getValidationText = createEvent(this, "getValidationText", 7);
        this.icBlur = createEvent(this, "icBlur", 7);
        this.icChange = createEvent(this, "icChange", 7);
        this.icFocus = createEvent(this, "icFocus", 7);
        this.icInput = createEvent(this, "icInput", 7);
        this.icKeydown = createEvent(this, "icKeydown", 7);
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        this.getMaxLengthExceeded = (value) => {
            this.numChars = value.length;
            if (this.type === "number") {
                this.minValueUnattained = value && Number(value) < Number(this.min);
                this.maxValueExceeded = Number(value) > Number(this.max);
            }
            if (this.maxLength > 0) {
                this.maxLengthExceeded = this.numChars > this.maxLength;
            }
        };
        this.getMaxCharactersReached = (value) => {
            this.numChars = value.length;
            this.maxCharactersReached =
                this.maxCharacters > 0 ? this.numChars >= this.maxCharacters : false;
            if (this.maxCharactersError && !this.maxCharactersReached) {
                this.maxCharactersError = false;
            }
        };
        this.onInput = (ev) => {
            this.value = ev.target.value;
            this.icInput.emit({ value: this.value });
        };
        this.onBlur = (ev) => {
            const value = ev.target.value;
            this.numChars = value.length;
            this.minCharactersUnattained =
                this.minCharacters > 0 ? this.numChars < this.minCharacters : false;
            this.icBlur.emit({ value: value });
        };
        this.onFocus = (ev) => {
            this.icFocus.emit({ value: ev.target.value });
        };
        this.hasStatus = (status) => status !== "" && !this.disabled;
        this.handleFormReset = () => {
            this.value = this.initialValue;
        };
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName, type, addedNodes, removedNodes }) => {
                if (MUTABLE_ATTRIBUTES.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
                else if (type === "childList") {
                    forceComponentUpdate = checkSlotInChildMutations(addedNodes, removedNodes, "icon");
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.numChars = 0;
        this.maxCharactersReached = false;
        this.maxCharactersError = false;
        this.minCharactersUnattained = false;
        this.maxLengthExceeded = false;
        this.maxValueExceeded = false;
        this.minValueUnattained = false;
        this.ariaActiveDescendant = undefined;
        this.ariaAutocomplete = undefined;
        this.ariaExpanded = undefined;
        this.ariaOwns = undefined;
        this.autocapitalize = "off";
        this.autocomplete = "off";
        this.autocorrect = "off";
        this.autoFocus = false;
        this.disabled = false;
        this.fullWidth = false;
        this.helperText = "";
        this.hideLabel = false;
        this.hiddenInput = true;
        this.inputId = `ic-text-field-input-${inputIds++}`;
        this.inputmode = "text";
        this.label = undefined;
        this.max = undefined;
        this.maxCharacters = 0;
        this.maxLength = 0;
        this.maxLengthMessage = "Maximum length exceeded";
        this.min = undefined;
        this.minCharacters = 0;
        this.name = this.inputId;
        this.placeholder = "";
        this.readonly = false;
        this.required = false;
        this.resize = false;
        this.role = undefined;
        this.rows = 1;
        this.size = "default";
        this.small = false;
        this.spellcheck = false;
        this.truncateValue = undefined;
        this.type = "text";
        this.validationInline = false;
        this.validationInlineInternal = false;
        this.validationStatus = "";
        this.validationText = "";
        this.debounce = 0;
        this.value = "";
        this.initialValue = this.value;
    }
    debounceChanged() {
        this.icChange = debounceEvent(this.icChange, this.debounce);
    }
    watchValueHandler(newValue) {
        if (this.inputEl && this.inputEl.value !== newValue) {
            this.inputEl.value = newValue;
        }
        this.getMaxLengthExceeded(newValue);
        this.getMaxCharactersReached(newValue);
        this.icChange.emit({ value: newValue });
    }
    connectedCallback() {
        this.debounceChanged();
    }
    disconnectedCallback() {
        var _a;
        removeFormResetListener(this.el, this.handleFormReset);
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        if (this.value !== this.initialValue) {
            this.watchValueHandler(this.value);
        }
        this.getMaxLengthExceeded(this.value);
        this.getMaxCharactersReached(this.value);
        this.inheritedAttributes = inheritAttributes(this.el, MUTABLE_ATTRIBUTES);
        if (this.readonly) {
            this.maxLengthExceeded = false;
            this.maxValueExceeded = false;
            this.minValueUnattained = false;
        }
        addFormResetListener(this.el, this.handleFormReset);
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Text Field");
        if (this.validationInlineInternal) {
            this.getValidationText.emit({ value: this.validationText });
        }
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
            childList: true,
        });
    }
    handleKeyDown(ev) {
        this.icKeydown.emit({ event: ev });
        this.maxCharactersError = this.maxCharactersReached;
    }
    /**
     * Sets focus on the native `input`.
     */
    async setFocus() {
        var _a;
        (_a = this.inputEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { inputId, name, label, required, size, small, placeholder, helperText, rows, resize, disabled, value, min, max, maxLength, numChars, readonly, maxLengthExceeded, maxCharacters, maxCharactersError, maxCharactersReached, minCharacters, minCharactersUnattained, minValueUnattained, maxValueExceeded, validationStatus, validationText, validationInline, validationInlineInternal, spellcheck, inputmode, fullWidth, truncateValue, hiddenInput, } = this;
        const disabledMode = readonly || disabled;
        const currentStatus = maxLengthExceeded ||
            maxValueExceeded ||
            minValueUnattained ||
            minCharactersUnattained ||
            maxCharactersError
            ? maxCharactersError
                ? IcInformationStatus.Warning
                : IcInformationStatus.Error
            : validationStatus;
        const currentValidationText = maxLengthExceeded
            ? this.maxLengthMessage
            : maxCharactersError
                ? `Maximum input is ${maxCharacters} characters`
                : maxValueExceeded
                    ? `Maximum value of ${max} exceeded`
                    : minValueUnattained
                        ? `Minimum value of ${min} not met`
                        : minCharactersUnattained
                            ? `Minimum input is ${minCharacters} characters`
                            : validationText;
        const maxNumChars = readonly ? 0 : maxLength;
        const messageAriaLive = maxLengthExceeded ||
            maxCharactersError ||
            maxValueExceeded ||
            minValueUnattained ||
            (maxLength === 0 && currentStatus === IcInformationStatus.Error)
            ? "assertive"
            : "polite";
        const showStatusText = this.hasStatus(currentStatus) &&
            !(currentStatus == IcInformationStatus.Success && validationInline) &&
            !validationInlineInternal;
        const multiline = rows > 1;
        const hiddenCharCountDescId = maxLength > 0 ? `${inputId}-charcount-desc` : "";
        const describedBy = `${hiddenCharCountDescId} ${getInputDescribedByText(inputId, helperText !== "", showStatusText)}`.trim();
        const disabledText = disabledMode && !readonly;
        const showLeftIcon = !!this.el.querySelector(`[slot="icon"]`) && !disabledText;
        const invalid = `${currentStatus === IcInformationStatus.Error}`;
        if (hiddenInput) {
            renderHiddenInput(true, this.el, name, value, disabledMode);
        }
        return (h(Host, { class: { ["fullwidth"]: fullWidth } }, h("ic-input-container", { readonly: readonly, disabled: disabledMode }, !this.hideLabel && (h("ic-input-label", { for: inputId, label: label, helperText: helperText, required: required, disabled: disabledText, readonly: readonly })), h("ic-input-component-container", { size: small ? "small" : size, validationStatus: currentStatus, multiLine: multiline, disabled: disabledMode, readonly: readonly, validationInline: validationInline, fullWidth: fullWidth }, showLeftIcon && (h("span", { class: {
                ["readonly"]: readonly,
                ["has-value"]: value.length > 0,
            }, slot: "left-icon" }, h("slot", { name: "icon" }))), !multiline ? (h("input", Object.assign({ id: inputId, name: name, ref: (el) => (this.inputEl = el), type: this.type, min: min, max: max, value: value, class: {
                ["no-left-pad"]: !showLeftIcon && readonly,
                ["readonly"]: readonly,
                ["truncate-value"]: truncateValue,
            }, placeholder: placeholder ? placeholder : "", required: required, disabled: disabledMode, readonly: readonly, onInput: this.onInput, onBlur: this.onBlur, onFocus: this.onFocus, "aria-label": label, "aria-describedby": describedBy, "aria-invalid": invalid, "aria-activedescendant": this.ariaActiveDescendant, "aria-expanded": this.ariaExpanded, "aria-owns": this.ariaOwns, autocomplete: this.autocomplete, autocapitalize: this.autocapitalize, autoFocus: this.autoFocus, spellcheck: spellcheck, inputmode: inputmode, role: this.role, maxlength: maxCharactersReached ? maxCharacters : null, minlength: minCharactersUnattained ? minCharacters : null }, this.inheritedAttributes))) : (h("textarea", Object.assign({ id: inputId, class: {
                ["no-resize"]: resize === false || readonly,
                ["no-left-pad"]: !showLeftIcon && readonly,
                ["readonly"]: readonly,
            }, name: name, ref: (el) => (this.inputEl = el), value: value, rows: rows, required: required, disabled: disabledMode, placeholder: placeholder ? placeholder : "", readonly: readonly, onInput: this.onInput, onBlur: this.onBlur, onFocus: this.onFocus, "aria-label": label, "aria-describedby": describedBy, "aria-invalid": invalid, autocapitalize: this.autocapitalize, autoFocus: this.autoFocus, spellcheck: spellcheck, inputmode: inputmode, maxlength: maxCharactersReached ? maxCharacters : null, minlength: minCharactersUnattained ? minCharacters : null }, this.inheritedAttributes))), isSlotUsed(this.el, "clear-button") && (h("slot", { name: "clear-button" })), isSlotUsed(this.el, "search-submit-button") && (h("slot", { name: "search-submit-button" }))), isSlotUsed(this.el, "menu") && h("slot", { name: "menu" }), (!isEmptyString(validationStatus) ||
            !isEmptyString(validationText) ||
            maxNumChars > 0 ||
            maxValueExceeded ||
            maxCharactersError ||
            minCharactersUnattained ||
            minValueUnattained) &&
            !validationInlineInternal && (h("ic-input-validation", { status: this.hasStatus(currentStatus) === false ||
                (currentStatus === IcInformationStatus.Success &&
                    validationInline) ||
                validationInlineInternal
                ? ""
                : currentStatus, message: showStatusText ? currentValidationText : "", ariaLiveMode: messageAriaLive, for: inputId, fullWidth: fullWidth }, !readonly && maxNumChars > 0 && (h("div", { slot: "validation-message-adornment" }, h("ic-typography", { variant: "caption", class: {
                ["maxlengthtext"]: true,
                ["error"]: maxLengthExceeded,
                ["disabled"]: disabledText,
            } }, h("span", { "aria-live": "polite", id: `${inputId}-charcount`, class: "charcount" }, numChars, "/", maxNumChars), h("span", { hidden: true, id: hiddenCharCountDescId }, "Field can contain a maximum of ", maxNumChars, " characters.")))))))));
    }
    get el() { return this; }
    static get watchers() { return {
        "debounce": ["debounceChanged"],
        "value": ["watchValueHandler"]
    }; }
    static get style() { return icTextFieldCss; }
}, [1, "ic-text-field", {
        "ariaActiveDescendant": [1, "aria-active-descendant"],
        "ariaAutocomplete": [1, "aria-autocomplete"],
        "ariaExpanded": [1, "aria-expanded"],
        "ariaOwns": [1, "aria-owns"],
        "autocapitalize": [1],
        "autocomplete": [1],
        "autocorrect": [1],
        "autoFocus": [4, "auto-focus"],
        "disabled": [4],
        "fullWidth": [4, "full-width"],
        "helperText": [1, "helper-text"],
        "hideLabel": [4, "hide-label"],
        "hiddenInput": [4, "hidden-input"],
        "inputId": [1, "input-id"],
        "inputmode": [1],
        "label": [1],
        "max": [8],
        "maxCharacters": [2, "max-characters"],
        "maxLength": [2, "max-length"],
        "maxLengthMessage": [1, "max-length-message"],
        "min": [8],
        "minCharacters": [2, "min-characters"],
        "name": [1],
        "placeholder": [1],
        "readonly": [516],
        "required": [4],
        "resize": [4],
        "role": [1],
        "rows": [2],
        "size": [1],
        "small": [4],
        "spellcheck": [4],
        "truncateValue": [4, "truncate-value"],
        "type": [1],
        "validationInline": [4, "validation-inline"],
        "validationInlineInternal": [4, "validation-inline-internal"],
        "validationStatus": [1, "validation-status"],
        "validationText": [1, "validation-text"],
        "debounce": [2],
        "value": [1537],
        "numChars": [32],
        "maxCharactersReached": [32],
        "maxCharactersError": [32],
        "minCharactersUnattained": [32],
        "maxLengthExceeded": [32],
        "maxValueExceeded": [32],
        "minValueUnattained": [32],
        "initialValue": [32],
        "setFocus": [64]
    }, [[0, "keydown", "handleKeyDown"]], {
        "debounce": ["debounceChanged"],
        "value": ["watchValueHandler"]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-text-field", "ic-input-component-container", "ic-input-container", "ic-input-label", "ic-input-validation", "ic-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-text-field":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, TextField);
            }
            break;
        case "ic-input-component-container":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ic-input-container":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ic-input-label":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ic-input-validation":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
        case "ic-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { TextField as T, defineCustomElement as d };

//# sourceMappingURL=ic-text-field2.js.map