import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { U as getThemeColorBrightness, W as BLACK_MIN_COLOR_BRIGHTNESS, X as WHITE_MAX_COLOR_BRIGHTNESS, j as convertToRGBA, n as getThemeForegroundColor } from './helpers.js';

const Theme = /*@__PURE__*/ proxyCustomElement(class Theme extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.themeChange = createEvent(this, "themeChange", 7);
        this.checkThemeColorContrast = () => {
            if (getThemeColorBrightness() < BLACK_MIN_COLOR_BRIGHTNESS &&
                getThemeColorBrightness() > WHITE_MAX_COLOR_BRIGHTNESS) {
                console.warn(`The theme colour does not provide enough contrast with either of the ICDS black or white foreground colours. Consider choosing a colour with a different brightness to achieve sufficient colour contrast for good visibility. See https://www.w3.org/TR/AERT/#color-contrast for more information about colour contrast.`);
            }
        };
        this.setThemeColor = () => {
            const colorRGBA = convertToRGBA(this.color);
            if (colorRGBA) {
                const { r, g, b, a } = colorRGBA;
                const { style } = document.documentElement;
                style.setProperty("--ic-theme-primary-r", `${r}`);
                style.setProperty("--ic-theme-primary-g", `${g}`);
                style.setProperty("--ic-theme-primary-b", `${b}`);
                style.setProperty("--ic-theme-primary-a", `${a}`);
                this.checkThemeColorContrast();
                this.themeChange.emit({
                    mode: getThemeForegroundColor(),
                    color: colorRGBA,
                });
            }
        };
        this.color = null;
    }
    watchColorPropHandler() {
        this.setThemeColor();
    }
    componentWillLoad() {
        this.setThemeColor();
    }
    render() {
        return h(Host, null);
    }
    static get watchers() { return {
        "color": ["watchColorPropHandler"]
    }; }
}, [1, "ic-theme", {
        "color": [1]
    }, undefined, {
        "color": ["watchColorPropHandler"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ic-theme"];
    components.forEach(tagName => { switch (tagName) {
        case "ic-theme":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Theme);
            }
            break;
    } });
}

const IcTheme = Theme;
const defineCustomElement = defineCustomElement$1;

export { IcTheme, defineCustomElement };

//# sourceMappingURL=ic-theme.js.map