import { r as registerInstance, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { c as convertToRGBA, h as hexToRgba, g as getCssProperty, r as rgbaStrToObj, b as getThemeForegroundColor, d as isPropDefined, a as onComponentRequiredPropUndefined } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const icBadgeCss = "@media (prefers-reduced-motion: no-preference){:host(.show){animation:expand var(--ic-transition-duration-slow)}:host(.hide){animation:shrink var(--ic-transition-duration-slow)}}:host{display:flex;height:var(--ic-space-md);min-width:var(--ic-space-md);width:-moz-fit-content;width:fit-content;border-radius:calc(2 * var(--ic-space-xxl));position:absolute}:host(.neutral){background-color:var(--ic-architectural-500)}:host(.light){background-color:var(--ic-architectural-40)}:host(.info){background-color:var(--ic-status-info)}:host(.warning){background-color:var(--ic-status-warning-mid)}:host(.error){background-color:var(--ic-status-error)}:host(.success){background-color:var(--ic-status-success)}:host(.small){height:var(--ic-space-sm);min-width:var(--ic-space-sm)}:host(.large){height:calc(var(--ic-space-md) + var(--ic-space-xxs));min-width:calc(var(--ic-space-md) + var(--ic-space-xxs))}:host(.dot.default){height:var(--ic-space-xs);width:var(--ic-space-xs);min-width:var(--ic-space-xs)}:host(.dot.small){height:calc(var(--ic-space-xxs) + var(--ic-space-xxxs));width:calc(var(--ic-space-xxs) + var(--ic-space-xxxs));min-width:calc(var(--ic-space-xxs) + var(--ic-space-xxxs))}:host(.dot.large){height:var(--ic-space-sm);width:var(--ic-space-sm);min-width:var(--ic-space-sm)}:host(.foreground-dark) ::slotted(*){fill:var(--ic-color-primary-text)}:host(.foreground-light) ::slotted(*){fill:white}:host(.foreground-dark) ic-typography{color:var(--ic-color-primary-text)}:host(.foreground-light) ic-typography{color:white}:host(.text) ic-typography{align-self:center;padding:0 calc((var(--ic-space-xs) + var(--ic-space-1px)) / 2)\n    var(--ic-space-1px)}:host(.text.small) ic-typography{padding:0 0.2132rem}:host(.text.large) ic-typography{padding:0 calc((var(--ic-space-sm) + var(--ic-space-1px)) / 2)\n    var(--ic-space-1px)}:host(.icon) ::slotted(svg){width:var(--ic-space-sm);height:var(--ic-space-sm);padding:var(--ic-space-xxxs)}:host(.icon.small) ::slotted(svg){width:var(--ic-space-xs);height:var(--ic-space-xs)}:host(.icon.large) ::slotted(svg){width:calc(var(--ic-space-sm) + var(--ic-space-xxxs));height:calc(var(--ic-space-sm) + var(--ic-space-xxxs));padding:calc(var(--ic-space-xxxs) + var(--ic-space-1px))}:host(.far){top:calc(-1 * var(--ic-space-xs));right:calc(-1 * var(--ic-space-xs))}:host(.far.small),:host(.dot.far.large){top:calc(-1 * var(--ic-space-xxs));right:calc(-1 * var(--ic-space-xxs))}:host(.dot.far),:host(.dot.far.small){top:calc(-1 * var(--ic-space-xxxs));right:calc(-1 * var(--ic-space-xxxs))}:host(.near){top:calc(-1 * calc(var(--ic-space-xxs) + var(--ic-space-1px)));right:calc(-1 * calc(var(--ic-space-xxs) + var(--ic-space-1px)))}:host(.dot.near){top:calc(-1 * var(--ic-space-1px));right:calc(-1 * var(--ic-space-1px))}:host(.inline){position:static}:host(.hide){visibility:hidden !important;transition:visibility var(--ic-transition-duration-slow)}.sr-only{position:absolute;left:-9999px}@keyframes expand{from{opacity:0;transform:scale(0)}to{opacity:1;transform:scale(1)}}@keyframes shrink{from{opacity:1;transform:scale(1)}to{opacity:0;transform:scale(0)}}";

const Badge = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.ariaLabel = null;
        this.setBadgeColour = () => {
            const colorRGBA = convertToRGBA(this.customColor);
            if (colorRGBA) {
                this.customColorRGBA = colorRGBA;
                const { r, g, b, a } = colorRGBA;
                this.el.style.backgroundColor = `rgba(${r}, ${g}, ${b}, ${a})`;
            }
        };
        this.getBadgeRGB = () => {
            switch (this.variant) {
                case "custom":
                    return this.customColorRGBA;
                case "error":
                case "success":
                case "warning":
                case "info": {
                    return rgbaStrToObj(getCssProperty(`--ic-status-${this.variant}`));
                }
                case "neutral":
                case "light":
                    return hexToRgba(getCssProperty(`--ic-architectural-${this.variant === "neutral" ? 500 : 40}`));
            }
        };
        this.getBadgeForeground = () => {
            const { r, g, b } = this.getBadgeRGB();
            this.foregroundColour = getThemeForegroundColor((r * 299 + g * 587 + b * 114) / 1000);
        };
        this.getTextLabel = () => this.maxNumber && Number(this.textLabel) > this.maxNumber
            ? `${this.maxNumber}+`
            : this.textLabel;
        // Set aria-label on badge and / or parent element
        // Aria-describedby seems to not work, probably due to shadow DOM
        this.setAccessibleLabel = () => {
            const parentEl = this.el.parentElement;
            const defaultAriaLabel = this.isAccessibleLabelDefined()
                ? this.accessibleLabel
                : this.textLabel || "with badge being displayed";
            if (parentEl) {
                const { tagName } = parentEl;
                if (tagName !== "IC-CARD" &&
                    (tagName !== "IC-TAB" || (tagName === "IC-TAB" && this.parentAriaLabel))) {
                    const ariaLabelPrefix = this.parentAriaLabel
                        ? `${this.parentAriaLabel} ,`
                        : "";
                    parentEl.ariaLabel = this.visible
                        ? `${ariaLabelPrefix} ${defaultAriaLabel}`
                        : undefined;
                }
                else {
                    this.ariaLabel = `, ${defaultAriaLabel}`;
                }
            }
        };
        this.isAccessibleLabelDefined = () => isPropDefined(this.accessibleLabel) && this.accessibleLabel !== null;
        this.accessibleLabel = undefined;
        this.customColor = null;
        this.maxNumber = undefined;
        this.position = "far";
        this.size = "default";
        this.textLabel = undefined;
        this.type = "text";
        this.variant = "neutral";
        this.visible = true;
    }
    accessibleLabelHandler() {
        this.setAccessibleLabel();
    }
    customColorHandler() {
        this.variant === "custom" && this.setBadgeColour();
    }
    variantHandler() {
        this.getBadgeForeground();
    }
    visibleHandler() {
        this.setAccessibleLabel();
    }
    componentWillLoad() {
        var _a;
        this.variant === "custom" && this.setBadgeColour();
        this.getBadgeForeground();
        const ariaLabel = (_a = this.el.parentElement) === null || _a === void 0 ? void 0 : _a.ariaLabel;
        if (ariaLabel)
            this.parentAriaLabel = ariaLabel;
        this.setAccessibleLabel();
    }
    componentDidLoad() {
        this.type === "text" &&
            onComponentRequiredPropUndefined([{ prop: this.textLabel, propName: "text-label" }], "Badge");
    }
    /**
     * @deprecated This method should not be used anymore. Use visible prop to set badge visibility.
     */
    async showBadge() {
        this.visible = true;
    }
    /**
     * @deprecated This method should not be used anymore. Use visible prop to set badge visibility.
     */
    async hideBadge() {
        this.visible = false;
    }
    render() {
        const { ariaLabel, el, foregroundColour, getTextLabel, position, size, textLabel, type, variant, visible, } = this;
        return (h(Host, { class: {
                [`${position}`]: true,
                [`${size}`]: true,
                [`${variant}`]: true,
                [`${type}`]: true,
                [`foreground-${foregroundColour}`]: foregroundColour !== null,
                [`${visible ? "show" : "hide"}`]: true,
            }, id: el.id || null, "aria-label": ariaLabel, role: "status" }, type === "icon" && h("slot", { name: "badge-icon" }), type === "text" && textLabel && (h("ic-typography", { variant: size === "small" ? "badge-small" : "badge" }, getTextLabel())), type === "dot" && h("span", { class: "sr-only" }, "badge")));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "accessibleLabel": ["accessibleLabelHandler"],
        "customColor": ["customColorHandler"],
        "variant": ["variantHandler"],
        "visible": ["visibleHandler"]
    }; }
};
Badge.style = icBadgeCss;

export { Badge as ic_badge };

//# sourceMappingURL=ic-badge.entry.js.map