import { r as registerInstance, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { C as Chevron } from './chevron-icon-589e3b46.js';
import { i as isSlotUsed, d as isPropDefined } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const backIcon = `<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M20 11H7.83L13.42 5.41L12 4L4 12L12 20L13.41 18.59L7.83 13H20V11Z" fill="currentColor"/>
</svg>
`;

const icBreadcrumbCss = ":host{display:block;margin:var(--ic-space-xs) var(--ic-space-xs) var(--ic-space-xs) 0}:host .breadcrumb{display:flex;align-items:center;white-space:nowrap;gap:var(--ic-space-xs);min-height:var(--ic-space-lg)}:host .chevron{width:var(--ic-space-lg);height:var(--ic-space-lg)}:host .chevron svg{color:var(--ic-architectural-400)}:host(:first-child) .chevron{display:none}.back-icon svg{color:currentcolor}:host(.back){display:flex;align-items:center}:host(.back) .chevron{display:none}ic-link{--breadcrumb-link-display:inline-flex;--breadcrumb-link-align-items:center;--breadcrumb-link-gap:var(--ic-space-xs)}:host([aria-current=\"page\"]) .current-page-container{display:flex;align-items:center;gap:var(--ic-space-xs)}:host([aria-current=\"page\"]) .current-page-container.dark{color:var(--ic-color-primary-text)}:host([aria-current=\"page\"]) .current-page-container.light{color:var(--ic-color-white-text)}:host(.collapsed-breadcrumb-wrapper){margin-right:var(--ic-space-xs) !important;display:flex;align-items:center;gap:var(--ic-space-xs)}:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb){border:none;background-color:transparent;color:var(--ic-hyperlink);text-decoration:underline;font-weight:var(--ic-font-weight-bold);cursor:pointer}:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:hover),:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:focus){outline:var(--ic-hc-focus-outline);border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}.hide,:host(.collapsed-breadcrumb-wrapper) ::slotted(.hide){display:none}@media (forced-colors: active){.back-icon svg{color:currentcolor}}@supports (text-underline-offset: 25%){ic-link{--breadcrumb-link-display:flex}:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:hover),:host(.collapsed-breadcrumb-wrapper) ::slotted(.collapsed-breadcrumb:focus){text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:25%;border-bottom:0 !important;margin-bottom:0 !important}}";

const Breadcrumb = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.renderDefaultBreadcrumb = (current, pageTitle, describedById, href) => {
            const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
            if (current && hasPageTitle) {
                return (h("span", { class: {
                        "current-page-container": current,
                        [this.appearance]: true,
                    } }, isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), pageTitle));
            }
            return (h("ic-link", { appearance: this.appearance, href: href, class: "breadcrumb-link", "aria-describedby": this.showBackIcon && describedById && describedById }, this.showBackIcon && (h("div", { class: "back-icon", innerHTML: backIcon })), isSlotUsed(this.el, "icon") && h("slot", { name: "icon" }), pageTitle));
        };
        this.setSlottedCurrentPageClass = () => {
            const icLink = this.el.querySelector("ic-link");
            const currentPage = "current-page";
            if (icLink) {
                icLink.classList.remove(currentPage);
                if (this.current) {
                    const hasCurrentPageClass = icLink.classList.contains(currentPage);
                    if (!hasCurrentPageClass) {
                        icLink.classList.add("breadcrumb-link", currentPage);
                    }
                }
            }
        };
        this.appearance = "default";
        this.current = false;
        this.href = undefined;
        this.pageTitle = undefined;
        this.showBackIcon = false;
    }
    componentWillRender() {
        this.setSlottedCurrentPageClass();
    }
    /**
     * Sets focus on the breadcrumb.
     */
    async setFocus() {
        if (this.el.shadowRoot.querySelector("ic-link")) {
            this.el.shadowRoot.querySelector("ic-link").focus();
        }
    }
    render() {
        const { current, href, pageTitle } = this;
        const describedById = `${pageTitle && pageTitle.toLowerCase().replace(" ", "-")}-describedby`;
        const hasPageTitle = pageTitle !== null && isPropDefined(pageTitle) && pageTitle !== "";
        const hasHref = href !== null && isPropDefined(href) && href !== "";
        return (h(Host, { class: {
                back: this.showBackIcon,
            }, "aria-current": current && "page", role: "listitem" }, h("div", { class: "breadcrumb" }, h("span", { innerHTML: Chevron, class: "chevron", "aria-hidden": "true" }), this.showBackIcon && describedById && (h("span", { id: describedById, class: "hide" }, `Back to ${pageTitle}`)), hasPageTitle && hasHref ? (this.renderDefaultBreadcrumb(current, pageTitle, describedById, href)) : (h("slot", null)))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
};
Breadcrumb.style = icBreadcrumbCss;

export { Breadcrumb as ic_breadcrumb };

//# sourceMappingURL=ic-breadcrumb.entry.js.map