import { r as registerInstance, c as createEvent, f as forceUpdate, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { y as IC_INHERITED_ARIA, k as removeDisabledFalse, x as inheritAttributes, X as renderFileHiddenInput, l as getThemeFromContext, i as isSlotUsed, d as isPropDefined, a as onComponentRequiredPropUndefined } from './helpers-3905ccc4.js';
import { I as IcThemeForegroundEnum } from './types-6f6b41a5.js';
import { c as createPopper } from './popper-0fbeff6d.js';

const arrowDropdown = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M7 9.5L12 14.5L17 9.5H7Z" fill="currentColor"/>
</svg>`;

const icButtonCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:inline-block;position:relative;--button-default:var(--ic-action-default);--button-default-hover:var(--ic-action-default-hover);--button-default-active:var(--ic-action-default-active);--button-default-background-hover:var(--ic-action-default-bg-hover);--button-default-background-active:var(--ic-action-default-bg-active);--icon-width:100%;--icon-height:100%}.button,::slotted(a){font-family:var(--ic-font-body-family);text-decoration:none;font-weight:600;font-size:0.875rem;transition:var(--ic-easing-transition-fast);border-radius:var(--ic-border-radius);min-width:var(--min-width, 6.25rem);display:inline-flex;flex-direction:row;justify-content:center;align-items:center;background:none;border:none;box-sizing:border-box;white-space:nowrap;vertical-align:middle}:host(.with-badge) .button{border-radius:0.2188rem}.button:hover,::slotted(a:hover){cursor:pointer}.button:focus,::slotted(a:focus){box-shadow:var(--ic-border-focus)}.button:focus-visible,::slotted(a:focus-visible){outline:var(--ic-hc-focus-outline)}:host(.dark) .button,:host(.dark) ::slotted(a){--button-default:var(--ic-action-dark);--button-default-hover:var(--ic-action-dark);--button-default-active:var(--ic-action-dark);--button-default-background-hover:var(--ic-action-dark-bg-hover);--button-default-background-active:var(--ic-action-dark-bg-active)}:host(.light) .button,:host(.light) ::slotted(a){--button-default:var(--ic-action-light);--button-default-hover:var(--ic-action-light);--button-default-active:var(--ic-action-light);--button-default-background-hover:var(--ic-action-light-bg-hover);--button-default-background-active:var(--ic-action-light-bg-active)}:host(.white-background) .button,:host(.white-background) ::slotted(a){--button-default-background-hover:var(--ic-action-default-bg-hover-no-alpha);--button-default-background-active:var(\n    --ic-action-default-bg-active-no-alpha\n  );background-color:var(--ic-architectural-white)}:host(.white-background.dark) .button,:host(.white-background.dark) ::slotted(a){--button-default-background-hover:var(--ic-action-dark-bg-hover-no-alpha);--button-default-background-active:var(--ic-action-dark-bg-active-no-alpha)}:host(.button-variant-primary.light) .button,:host(.button-variant-primary.light) ::slotted(a){color:var(--ic-color-primary-text);--button-default-hover:var(--ic-action-light-hover);--button-default-active:var(--ic-action-light-active)}:host(.button-variant-primary.dark) .button,:host(.button-variant-primary.dark) ::slotted(a){--button-default-hover:var(--ic-action-dark-hover);--button-default-active:var(--ic-action-dark-active)}:host(.disabled),:host(.disabled) .button,:host(.disabled) ::slotted(a),:host(.loading),:host(.loading) .button{pointer-events:none}:host(.top-icon) .button{flex-direction:column;--height:fit-content}:host(.top-icon) .button .icon-container{margin-right:0}:host(.button-variant-primary) .button,:host(.button-variant-primary) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--button-default)}:host(.button-variant-primary) .button:hover{background-color:var(--button-default-hover)}:host(.button-variant-primary.loading) .button,:host(.button-variant-primary) .button:active{background-color:var(--button-default-active)}:host(.button-variant-primary.disabled) .button,:host(.button-variant-primary.disabled) ::slotted(a){background:var(--ic-architectural-200);color:var(--ic-architectural-300)}:host(.button-variant-primary.light.disabled) .button,:host(.button-variant-primary.light.disabled) ::slotted(a){background:var(--ic-architectural-600);color:var(--ic-architectural-500)}:host(.button-variant-secondary) .button,:host(.button-variant-secondary) ::slotted(a){border:var(--ic-border-width) solid var(--button-default);color:var(--button-default)}:host(.button-variant-secondary) .button:hover,:host(.button-variant-secondary) ::slotted(a:hover){background-color:var(--button-default-background-hover);border-color:var(--button-default-hover);color:var(--button-default-hover)}:host(.button-variant-secondary) .button:active,:host(.button-variant-secondary) ::slotted(a:active),:host(.button-variant-secondary.loading) .button{border-color:var(--button-default-active);background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-secondary.disabled) .button,:host(.button-variant-secondary.disabled) ::slotted(a){border-color:var(--ic-architectural-300);color:var(--ic-architectural-300);background:none}:host(.button-variant-secondary.light.disabled) .button,:host(.button-variant-secondary.light.disabled) ::slotted(a){border-color:var(--ic-architectural-500);color:var(--ic-architectural-500)}:host(.button-variant-tertiary) .button,:host(.button-variant-tertiary) ::slotted(a){color:var(--button-default)}:host(.button-variant-tertiary) .button:hover,:host(.button-variant-tertiary) ::slotted(a:hover){background-color:var(--button-default-background-hover);color:var(--button-default-hover)}:host(.button-variant-tertiary) .button:active,:host(.button-variant-tertiary) ::slotted(a:active),:host(.button-variant-tertiary.loading) .button{background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-tertiary.disabled) .button,:host(.button-variant-tertiary.disabled) ::slotted(a){color:var(--ic-architectural-300);background:none}:host(.button-variant-tertiary.light.disabled) .button,:host(.button-variant-tertiary.light.disabled) ::slotted(a){color:var(--ic-architectural-500)}:host(.button-variant-destructive) .button,:host(.button-variant-destructive) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--ic-action-destructive);text-transform:uppercase}:host(.button-variant-destructive) .button:hover{background-color:var(--ic-action-destructive-hover)}:host(.button-variant-destructive) .button:active,:host(.button-variant-destructive.loading) .button{background-color:var(--ic-action-destructive-active)}:host(.button-variant-destructive.disabled) .button,:host(.button-variant-destructive.disabled) ::slotted(a){background:var(--ic-architectural-200);color:var(--ic-architectural-300)}:host(.button-variant-icon) .button,:host(.button-variant-icon) ::slotted(a){color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon) .button:hover,:host(.button-variant-icon) ::slotted(a:hover){background-color:var(--button-default-background-hover);color:var(--button-default-hover)}:host(.button-variant-icon) .button:active:not(:focus),:host(.button-variant-icon) ::slotted(a:active:not(:focus)),:host(.button-variant-icon.loading) .button{background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-icon.disabled) .button,:host(.button-variant-icon.disabled) ::slotted(a){color:var(--ic-architectural-300);background:none}:host(.button-variant-icon-primary) .button,:host(.button-variant-icon-primary) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-primary) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-primary) .button:hover,:host(.button-variant-icon-primary) ::slotted(a:hover){background-color:var(--button-default-hover)}:host(.button-variant-icon-primary) .button:active,:host(.button-variant-icon-primary) ::slotted(a:active),:host(.button-variant-icon-primary.loading) .button{background:var(--button-default-active)}:host(.button-variant-icon-primary.loading) .button ic-loading-indicator{--inner-color:var(--ic-architectural-white)}:host(.button-variant-icon-primary.disabled) .button,:host(.button-variant-icon-primary.disabled) ::slotted(a){color:var(--ic-architectural-300);background:var(--ic-architectural-200)}:host(.button-variant-icon-primary.light) .button,:host(.button-variant-icon-primary.light) ::slotted(a){color:var(--ic-color-primary-text)}:host(.button-variant-icon-primary.light) .button:hover,:host(.button-variant-icon-primary.light) ::slotted(a:hover){background:var(--ic-action-light-hover)}:host(.button-variant-icon-primary.light) .button:active,:host(.button-variant-icon-primary.light) ::slotted(a:active),:host(.button-variant-icon-primary.light.loading) .button,:host(.button-variant-icon-primary.light.loading) ::slotted(a){background:var(--ic-action-light-active)}:host(.button-variant-icon-primary.dark) .button:hover,:host(.button-variant-icon-primary.dark) ::slotted(a:hover){background:var(--ic-action-dark-hover)}:host(.button-variant-icon-primary.dark) .button:active,:host(.button-variant-icon-primary.dark) ::slotted(a:active),:host(.button-variant-icon-primary.dark.loading) .button,:host(.button-variant-icon-primary.dark.loading) ::slotted(a){background:var(--ic-action-dark-active)}:host(.button-variant-icon-secondary) .button,:host(.button-variant-icon-secondary) ::slotted(a){border:var(--ic-border-width) solid var(--button-default);color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-secondary) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-secondary) .button:hover,:host(.button-variant-icon-secondary) ::slotted(a:hover){background-color:var(--button-default-background-hover);border-color:var(--button-default-hover);color:var(--button-default-hover)}:host(.button-variant-icon-secondary) .button:active,:host(.button-variant-icon-secondary) ::slotted(a:active),:host(.button-variant-icon-secondary.loading) .button{border-color:var(--button-default-active);background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-icon-secondary.disabled) .button,:host(.button-variant-icon-secondary.disabled) .button:hover,:host(.button-variant-icon-secondary.disabled) .button:active,:host(.button-variant-icon-secondary.disabled) ::slotted(a),:host(.button-variant-icon-secondary.disabled) ::slotted(a:hover),:host(.button-variant-icon-secondary.disabled) ::slotted(a:active){border-color:var(--ic-architectural-300);color:var(--ic-architectural-300);background:none}:host(.button-variant-icon-secondary.light.disabled) .button,:host(.button-variant-icon-secondary.light.disabled) .button:hover,:host(.button-variant-icon-secondary.light.disabled) .button:active,:host(.button-variant-icon-secondary.light.disabled) ::slotted(a),:host(.button-variant-icon-secondary.light.disabled) ::slotted(a:hover),:host(.button-variant-icon-secondary.light.disabled) ::slotted(a:active){border-color:var(--ic-architectural-500);color:var(--ic-architectural-500)}:host(.button-variant-icon-tertiary) .button,:host(.button-variant-icon-tertiary) ::slotted(a){color:var(--button-default);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-tertiary) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-tertiary) .button:hover,:host(.button-variant-icon-tertiary) ::slotted(a:hover){background-color:var(--button-default-background-hover);color:var(--button-default-hover)}:host(.button-variant-icon-tertiary) .button:active,:host(.button-variant-icon-tertiary) ::slotted(a:active),:host(.button-variant-icon-tertiary.loading) .button{background-color:var(--button-default-background-active);color:var(--button-default-active)}:host(.button-variant-icon-tertiary.disabled) .button,:host(.button-variant-icon-tertiary.disabled) .button:hover,:host(.button-variant-icon-tertiary.disabled) .button:active,:host(.button-variant-icon-tertiary.disabled) ::slotted(a),:host(.button-variant-icon-tertiary.disabled) ::slotted(a:hover),:host(.button-variant-icon-tertiary.disabled) ::slotted(a:active){color:var(--ic-architectural-300);background:none}:host(.button-variant-icon-destructive) .button,:host(.button-variant-icon-destructive) ::slotted(a){color:var(--ic-color-white-text);background-color:var(--ic-action-destructive);min-width:0;gap:var(--ic-space-xs);margin:var(--ic-space-1px) 0}:host(.button-variant-icon-destructive) .icon-container{width:var(--ic-space-lg) !important;height:var(--ic-space-lg) !important}:host(.button-variant-icon-destructive) .button:hover,:host(.button-variant-icon-destructive) ::slotted(a:hover){background-color:var(--ic-action-destructive-hover)}:host(.button-variant-icon-destructive) .button:active,:host(.button-variant-icon-destructive) ::slotted(a:active),:host(.button-variant-icon-destructive.loading) .button{background-color:var(--ic-action-destructive-active)}:host(.button-variant-icon-destructive.loading) .button ic-loading-indicator{--inner-color:var(--ic-architectural-white)}:host(.button-variant-icon-destructive.disabled) .button,:host(.button-variant-icon-destructive.disabled) .button:hover,:host(.button-variant-icon-destructive.disabled) .button:active,:host(.button-variant-icon-destructive.disabled) ::slotted(a),:host(.button-variant-icon-destructive.disabled) ::slotted(a:hover),:host(.button-variant-icon-destructive.disabled) ::slotted(a:active){background:var(--ic-architectural-200);color:var(--ic-architectural-300)}:host(.button-size-default) .button{height:var(--height, 2.5rem);padding:var(--ic-space-xs) var(--ic-space-md)}:host(.button-size-small) .button{height:var(--height, var(--ic-space-xl));padding:var(--ic-space-xxs) var(--ic-space-md)}:host(.button-size-large) .button{height:var(--height, var(--ic-space-xxl));padding:var(--ic-space-sm) var(--ic-space-md)}:host(.button-size-default.button-variant-icon) .button,:host(.button-size-default.button-variant-icon-primary) .button,:host(.button-size-default.button-variant-icon-secondary) .button,:host(.button-size-default.button-variant-icon-tertiary) .button,:host(.button-size-default.button-variant-icon-destructive) .button,:host(.button-size-default.button-variant-icon-primary) ::slotted(a),:host(.button-size-default.button-variant-icon-secondary) ::slotted(a),:host(.button-size-default.button-variant-icon-tertiary) ::slotted(a),:host(.button-size-default.button-variant-icon-destructive) ::slotted(a),:host(.button-size-default.button-variant-icon) ::slotted(a){height:var(--height, var(--ic-space-xl));width:var(--ic-space-xl);padding:0.375rem}:host(.button-size-small.button-variant-icon) .button,:host(.button-size-small.button-variant-icon-primary) .button,:host(.button-size-small.button-variant-icon-secondary) .button,:host(.button-size-small.button-variant-icon-tertiary) .button,:host(.button-size-small.button-variant-icon-destructive) .button,:host(.button-size-small.button-variant-icon-primary) ::slotted(a),:host(.button-size-small.button-variant-icon-secondary) ::slotted(a),:host(.button-size-small.button-variant-icon-tertiary) ::slotted(a),:host(.button-size-small.button-variant-icon-destructive) ::slotted(a),:host(.button-size-small.button-variant-icon) ::slotted(a){height:var(--height, var(--ic-space-lg));width:var(--ic-space-lg);padding:var(--ic-space-xxs)}:host(.button-size-large.button-variant-icon) .button,:host(.button-size-large.button-variant-icon-primary) .button,:host(.button-size-large.button-variant-icon-secondary) .button,:host(.button-size-large.button-variant-icon-tertiary) .button,:host(.button-size-large.button-variant-icon-destructive) .button,:host(.button-size-large.button-variant-icon-primary) ::slotted(a),:host(.button-size-large.button-variant-icon-secondary) ::slotted(a),:host(.button-size-large.button-variant-icon-tertiary) ::slotted(a),:host(.button-size-large.button-variant-icon-destructive) ::slotted(a),:host(.button-size-large.button-variant-icon) ::slotted(a){height:var(--height, 2.5rem);width:2.5rem;padding:var(--ic-space-xs)}:host(.full-width),:host(.full-width) .button,:host(.full-width) ::slotted(a){width:100%}div.loading-container{position:relative;align-items:center;width:100%}ic-loading-indicator{--outer-color:transparent}@keyframes loading-animation{0%{width:0%;left:0%}25%{width:0%;left:0%;opacity:0}50%{width:100%;left:0%;opacity:1}75%{width:0%;left:100%}100%{width:0%;left:100%;opacity:0}}div.icon-container{box-sizing:border-box;width:var(--ic-space-lg);height:var(--ic-space-lg);display:flex;justify-content:center;align-items:center;margin-right:var(--ic-space-xs)}div.right-icon{margin-right:auto;margin-left:var(--ic-space-xs)}:host(.full-width) .right-icon{margin-right:var(--ic-space-xs)}::slotted(:not(ic-badge)){width:var(--icon-width) !important;height:var(--icon-height) !important;fill:currentcolor !important;pointer-events:none}:host(.button-variant-icon) .button .icon-container{margin:0;pointer-events:none}:host(.search-submit-button) ::slotted(svg){--icon-height:1.25rem;--icon-width:1.25rem}:host(.search-submit-button-small) ::slotted(svg){--icon-height:1rem;--icon-width:1rem}:host(.clear-button){margin:0 var(--ic-space-xxs)}:host(.clear-button) .button:focus,:host(.calendar-button) .button:focus{box-shadow:none}:host(.search-submit-button) .button:focus{box-shadow:none}:host(.search-submit-button) .button:not(:active):focus{box-shadow:none;background-color:var(--ic-action-default-bg-hover)}:host(.search-submit-button){display:flex;align-items:center;margin:0 var(--ic-space-xxs)}:host(.menu-close-button) ::slotted(svg){--icon-height:0.875rem;--icon-width:0.875rem}:host(.popout-menu-button) .button{height:var(--height);justify-content:left;border-radius:0;white-space:pre-line;text-align:start}:host(.popout-menu-button) div.icon-container{flex:none}:host(.popout-menu-button) .button:focus{box-shadow:var(--ic-border-focus-inset);border-radius:var(--ic-border-radius-inset)}.ic-button-describedby{display:none}:host .ic-tooltip{display:block}:host .arrow-dropdown{margin-top:auto}:host .dropdown-expanded{transform:rotate(180deg);margin-bottom:var(--ic-space-xxxs)}:host(.dropdown-no-icon) .button{padding-right:var(--ic-space-xs)}slot[name=\"router-item\"]::slotted(a){pointer-events:all}::slotted(a){font-size:0.875rem !important;border:none !important;vertical-align:middle !important}:host(.white-background) ::slotted(a){background-color:var(--ic-architectural-white) !important}:host(.button-variant-primary) ::slotted(a){background-color:var(--button-default) !important}:host(.button-variant-primary) ::slotted(a:hover){background-color:var(--button-default-hover) !important}:host(.button-variant-primary) ::slotted(a:active){background-color:var(--button-default-active) !important}:host(.button-variant-primary.disabled) ::slotted(a),:host(.button-variant-destructive.disabled) ::slotted(a){background:var(--ic-architectural-200) !important}:host(.button-variant-primary.light.disabled) ::slotted(a){background:var(--ic-architectural-600) !important}:host(.button-variant-secondary) ::slotted(a){border:var(--ic-border-width) solid var(--button-default) !important}:host(.button-variant-secondary) ::slotted(a:hover){background-color:var(--button-default-background-hover) !important;border-color:var(--button-default-hover) !important}:host(.button-variant-secondary) ::slotted(a:active){border-color:var(--button-default-active) !important;background-color:var(--button-default-background-active) !important}:host(.button-variant-secondary.disabled) ::slotted(a),:host(.button-variant-secondary.disabled) ::slotted(a:hover),:host(.button-variant-secondary.disabled) ::slotted(a:active),:host(.button-variant-tertiary.disabled) ::slotted(a),:host(.button-variant-tertiary.disabled) ::slotted(a:hover),:host(.button-variant-tertiary.disabled) ::slotted(a:active){border-color:var(--ic-architectural-300) !important;background:none !important}:host(.button-variant-secondary.light.disabled) ::slotted(a),:host(.button-variant-secondary.light.disabled) ::slotted(a:hover),:host(.button-variant-secondary.light.disabled) ::slotted(a:active),:host(.button-variant-tertiary.light.disabled) ::slotted(a),:host(.button-variant-tertiary.light.disabled) ::slotted(a:hover),:host(.button-variant-tertiary.light.disabled) ::slotted(a:active){border-color:var(--ic-architectural-500) !important}:host(.button-variant-tertiary) ::slotted(a:hover),:host(.button-variant-icon) ::slotted(a:hover){background-color:var(--button-default-background-hover) !important}:host(.button-variant-tertiary) ::slotted(a:active:not(:focus)),:host(.button-variant-tertiary) ::slotted(a:active:focus),:host(.button-variant-tertiary) ::slotted(a:active),:host(.button-variant-icon) ::slotted(a:active:not(:focus)){background-color:var(--button-default-background-active) !important}:host(.button-variant-icon.disabled) ::slotted(a),:host(.button-variant-icon.disabled) ::slotted(a:hover),:host(.button-variant-icon.disabled) ::slotted(a:active){background:none !important}:host(.button-variant-destructive) ::slotted(a){background-color:var(--ic-action-destructive) !important}:host(.button-variant-destructive) ::slotted(a:hover){background-color:var(--ic-action-destructive-hover) !important}:host(.button-variant-destructive) ::slotted(a:active){background-color:var(--ic-action-destructive-active) !important}:host(.button-size-default) ::slotted(a){height:var(--height, 2.5rem) !important;padding:var(--ic-space-xs) var(--ic-space-md) !important}:host(.button-size-small) ::slotted(a){height:var(--height, var(--ic-space-xl)) !important;padding:var(--ic-space-xxs) var(--ic-space-md) !important}:host(.button-size-large) ::slotted(a){height:var(--height, var(--ic-space-xxl)) !important;padding:var(--ic-space-sm) var(--ic-space-md) !important}:host(.button-size-default.button-variant-icon) ::slotted(a){height:var(--height, var(--ic-space-xl)) !important;padding:0.375rem !important}:host(.button-size-small.button-variant-icon) ::slotted(a){padding:var(--ic-space-xxs) !important}:host(.button-size-large.button-variant-icon) ::slotted(a){padding:var(--ic-space-xs) !important}@media (forced-colors: active){.button,::slotted(a){border:0.125rem solid transparent !important}}:host(.flip) ::slotted(svg){transform:scaleX(-1)}";

var __rest = (undefined && undefined.__rest) || function (s, e) {
    var t = {};
    for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
let buttonIds = 0;
const Button = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icBlur = createEvent(this, "icBlur", 7);
        this.icFileSelection = createEvent(this, "icFileSelection", 7);
        this.icFocus = createEvent(this, "icFocus", 7);
        this.buttonIdNum = buttonIds++;
        this.hasTooltip = false;
        this.inheritedAttributes = {};
        this.describedbyEl = null;
        this.describedById = null;
        this.mutationObserver = null;
        this.hostMutationObserver = null;
        this.handleClick = () => {
            if ((this.el.type === "submit" || this.el.type === "reset") &&
                !this.hasRouterSlot() &&
                !!this.el.closest("FORM")) {
                const hiddenFormButton = document.createElement("button");
                hiddenFormButton.setAttribute("type", this.el.type);
                hiddenFormButton.style.display = "none";
                this.el.closest("FORM").appendChild(hiddenFormButton);
                hiddenFormButton.click();
                hiddenFormButton.remove();
            }
        };
        this.handleKeyDown = (ev) => {
            if (ev.key === "Escape" && this.hasTooltip) {
                this.closeButtonTooltip(ev);
            }
        };
        this.onFocus = () => {
            this.icFocus.emit();
        };
        this.onBlur = () => {
            this.icBlur.emit();
        };
        // triggered when text content of sibling element in light DOM changes
        this.mutationCallback = () => {
            this.describedByContent = this.describedbyEl.innerText;
        };
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                const attribute = this.el.getAttribute(attributeName);
                if (attributeName === "title")
                    this.title = attribute;
                else if (attributeName === "aria-label")
                    this.ariaLabel = attribute;
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] = attribute;
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.setHasTooltip = () => {
            this.hasTooltip =
                !this.disableTooltip && (!!this.title || this.isIconVariant());
        };
        this.isIconVariant = () => {
            return this.variant.startsWith("icon");
        };
        this.ariaLabel = null;
        this.describedByContent = null;
        this.title = null;
        this.accept = "*";
        this.appearance = "default";
        this.ariaControlsId = undefined;
        this.ariaOwnsId = undefined;
        this.disabled = false;
        this.disableTooltip = false;
        this.download = false;
        this.dropdown = false;
        this.dropdownExpanded = false;
        this.fileUpload = false;
        this.fileInputName = `ic-button-file-upload-input-${buttonIds++}`;
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.fullWidth = false;
        this.href = undefined;
        this.hreflang = undefined;
        this.loading = false;
        this.multiple = false;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.selectedFiles = undefined;
        this.size = "default";
        this.target = undefined;
        this.tooltipPlacement = "bottom";
        this.transparentBackground = true;
        this.type = "button";
        this.variant = "primary";
    }
    watchDisabledHandler() {
        removeDisabledFalse(this.disabled, this.el);
    }
    disconnectedCallback() {
        if (this.mutationObserver !== null && this.mutationObserver !== undefined) {
            this.mutationObserver.disconnect();
        }
        if (this.hostMutationObserver !== null &&
            this.hostMutationObserver !== undefined) {
            this.hostMutationObserver.disconnect();
        }
    }
    componentWillUpdate() {
        if (this.loading) {
            this.el.style.setProperty("--min-width", `${this.el.getBoundingClientRect().width}px`);
        }
        this.setHasTooltip();
    }
    componentWillLoad() {
        const _a = inheritAttributes(this.el, [...IC_INHERITED_ARIA, "title"]), { title, "aria-label": ariaLabel } = _a, restInheritedAttributes = __rest(_a, ["title", "aria-label"]);
        this.title = title;
        this.ariaLabel = ariaLabel;
        this.inheritedAttributes = restInheritedAttributes;
        removeDisabledFalse(this.disabled, this.el);
        this.el.setAttribute("exportparts", "button");
        this.id = this.el.id || null;
        this.setHasTooltip();
        if (!this.hasTooltip) {
            const describedById = this.inheritedAttributes["aria-describedby"];
            if (describedById !== undefined) {
                this.describedById = describedById;
                const el = this.el.parentElement.querySelector(`#${describedById}`);
                if (el) {
                    this.describedByContent = el.innerText;
                    this.describedbyEl = el;
                }
            }
        }
    }
    componentDidLoad() {
        this.updateTheme();
        if (typeof MutationObserver !== "undefined") {
            if (this.describedById) {
                this.mutationObserver = new MutationObserver(this.mutationCallback);
                this.mutationObserver.observe(this.describedbyEl, {
                    characterData: true,
                    childList: true,
                    subtree: true,
                });
            }
            this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
            this.hostMutationObserver.observe(this.el, {
                attributes: true,
            });
        }
    }
    componentWillRender() {
        const iconEl = this.hasIconSlot("left")
            ? this.el.querySelector(`[slot="left-icon"]`)
            : this.hasIconSlot("right")
                ? this.el.querySelector(`[slot="right-icon"]`)
                : null;
        iconEl === null || iconEl === void 0 ? void 0 : iconEl.setAttribute("viewBox", "0 0 24 24");
    }
    handleHostClick(event) {
        if (!this.hasRouterSlot()) {
            if (this.fileUpload) {
                renderFileHiddenInput(this.icFileSelection, this.el, this.multiple, this.fileInputName, this.selectedFiles, this.disabled, this.accept);
            }
            if (this.disabled || this.loading) {
                event.stopImmediatePropagation();
            }
            if (this.dropdown) {
                this.dropdownExpanded = !this.dropdownExpanded;
            }
        }
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the native `button`.
     */
    async setFocus() {
        var _a;
        (_a = this.buttonEl) === null || _a === void 0 ? void 0 : _a.focus();
    }
    async closeButtonTooltip(ev) {
        const tooltip = this.el.shadowRoot.querySelector("ic-tooltip");
        if (await tooltip.isTooltipVisible()) {
            tooltip.displayTooltip(false);
            ev.preventDefault();
            ev.stopImmediatePropagation();
        }
    }
    hasIconSlot(position) {
        const selectorPrefix = position ? `${position}-` : "";
        return this.el.querySelector(`[slot="${selectorPrefix}icon"]`) !== null;
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    updateTheme(newTheme = null) {
        const foregroundColor = getThemeFromContext(this.el, newTheme);
        if (foregroundColor !== IcThemeForegroundEnum.Default) {
            this.appearance = foregroundColor;
        }
    }
    render() {
        const TagType = (this.href && "a") || "button";
        const { title, ariaLabel, inheritedAttributes } = this;
        const buttonAttrs = TagType === "button"
            ? {
                type: this.type,
                disabled: this.disabled,
                form: this.form,
                formaction: this.formaction,
                formenctype: this.formenctype,
                formmethod: this.formmethod,
                formnovalidate: this.formnovalidate,
                formtarget: this.formtarget,
            }
            : {
                download: this.download !== false ? this.download : null,
                href: this.href,
                rel: this.rel,
                target: this.target,
                referrerpolicy: this.referrerpolicy,
                hreflang: this.hreflang,
            };
        let describedby = null;
        let buttonId = null;
        if (this.hasTooltip) {
            buttonId =
                this.id !== null
                    ? `ic-button-with-tooltip-${this.id}`
                    : `ic-button-with-tooltip-${this.buttonIdNum}`;
            describedby =
                this.variant === "icon" && !!ariaLabel
                    ? null
                    : `ic-tooltip-${buttonId}`;
        }
        else {
            describedby = this.describedById;
        }
        const ButtonContent = () => {
            return (h(TagType, Object.assign({ class: "button", "aria-disabled": this.loading || this.disabled ? "true" : null, "aria-label": this.loading ? "Loading" : ariaLabel, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, buttonAttrs, inheritedAttributes, { onFocus: this.onFocus, onBlur: this.onBlur, ref: (el) => (this.buttonEl = el), "aria-describedby": describedby, part: "button" }), this.hasIconSlot() && !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "icon" }))), this.hasIconSlot("left") && !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "left-icon" }))), this.hasIconSlot("top") &&
                !this.hasIconSlot("left") &&
                !this.hasIconSlot("right") &&
                !this.loading && (h("div", { class: "icon-container" }, h("slot", { name: "top-icon" }))), this.loading ? (h("div", { class: "loading-container" }, h("ic-loading-indicator", { type: "linear", appearance: this.variant === "primary" ||
                    this.variant === "destructive" ||
                    this.appearance === IcThemeForegroundEnum.Dark ||
                    this.appearance === IcThemeForegroundEnum.Light
                    ? "light"
                    : "dark" }))) : (h("slot", null)), this.hasIconSlot("right") && !this.loading && !this.dropdown && (h("div", { class: { "icon-container": true, "right-icon": true } }, h("slot", { name: "right-icon" }))), this.dropdown &&
                !this.loading &&
                this.variant !== "icon" &&
                this.variant !== "destructive" && (h("span", { class: {
                    ["arrow-dropdown"]: !this.dropdownExpanded,
                    ["dropdown-expanded"]: this.dropdownExpanded,
                }, innerHTML: arrowDropdown }))));
        };
        return (h(Host, { class: {
                ["disabled"]: this.disabled && !this.loading,
                [`button-variant-${this.variant}`]: true,
                [`button-size-${this.size}`]: true,
                ["loading"]: this.loading,
                ["dark"]: this.appearance === IcThemeForegroundEnum.Dark,
                ["light"]: this.appearance === IcThemeForegroundEnum.Light,
                ["full-width"]: this.fullWidth,
                ["with-badge"]: isSlotUsed(this.el, "badge"),
                ["dropdown-no-icon"]: this.dropdown &&
                    !isSlotUsed(this.el, "icon") &&
                    !isSlotUsed(this.el, "left-icon"),
                ["top-icon"]: isSlotUsed(this.el, "top-icon"),
                ["white-background"]: this.variant === "secondary" &&
                    !this.transparentBackground &&
                    this.appearance !== "light",
            }, onClick: this.handleClick, onKeyDown: this.handleKeyDown, "aria-owns": this.ariaOwnsId, "aria-controls": this.ariaControlsId, "aria-expanded": this.dropdown && `${this.dropdownExpanded}` }, this.hasTooltip && (h("ic-tooltip", { id: describedby, label: title || ariaLabel, target: buttonId, placement: this.tooltipPlacement, silent: this.isIconVariant() && !!ariaLabel }, this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h(ButtonContent, null)))), isSlotUsed(this.el, "badge") && h("slot", { name: "badge" }), !this.hasTooltip &&
            (this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h(ButtonContent, null))), this.describedByContent && (h("span", { id: describedby, class: "ic-button-describedby" }, this.describedByContent))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "disabled": ["watchDisabledHandler"]
    }; }
};
Button.style = icButtonCss;

const icLoadingIndicatorCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;--linear-border-radius:0.25rem;--inner-color:var(--ic-action-default);--outer-color:var(--ic-architectural-100);--label-color:var(--ic-color-primary-text);--margin:none;--linear-line-height:var(--ic-space-xs)}:host(.light){--inner-color:var(--ic-architectural-white);--outer-color:var(--ic-architectural-800);--label-color:var(--ic-architectural-white)}.ic-loading-container{display:flex;flex-direction:column;justify-content:center;align-items:center}:host([size=\"small\"]){--circular-diameter:2.5rem;--linear-line-height:var(--ic-space-xxs)}:host([size=\"default\"]){--circular-diameter:5rem}:host([size=\"large\"]){--circular-diameter:7.5rem}:host([size=\"icon\"]){display:inline-block;--margin:var(--ic-space-xxxs);--circular-diameter:1.25rem}:host(.label){--margin:0 0 var(--ic-space-xs) 0}.ic-loading-label{color:var(--label-color);margin-left:var(--label-margin-left)}.ic-loading-circular-outer{height:var(--circular-diameter);width:var(--circular-diameter)}.ic-loading-circular-outer.indeterminate{animation:circular-animation 1s linear;animation-iteration-count:infinite}@keyframes circular-animation{100%{transform:rotate(360deg)}}.ic-loading-circular-outer,.ic-loading-linear-outer{margin:var(--margin)}.ic-loading-linear-outer{background-color:var(--outer-color);height:var(--linear-line-height);width:100%;border-radius:var(--linear-border-radius);overflow:hidden}.ic-loading-linear-inner{position:relative;height:100%;background-color:var(--inner-color);border-radius:var(--linear-border-radius)}.indeterminate>.ic-loading-linear-inner{animation:linear-animation 2s infinite}.determinate>.ic-loading-linear-inner{transition:width 0.5s;width:var(--linear-width)}:host(.full-width){--linear-border-radius:none}@keyframes linear-animation{0%{width:0%;left:-1%}25%{width:0%;left:-1%}50%{width:101%;left:-1%}75%{width:0%;left:101%}100%{width:0%;left:101%}}.ic-loading-circular-svg{position:relative;width:100%;height:100%;transform:rotate(-90deg)}.ic-loading-circular-svg circle{width:100%;height:100%;fill:none;stroke:var(--compact-step-outer-color, var(--outer-color));stroke-width:var(--circular-line-width);stroke-linecap:round}.ic-loading-circular-svg circle:nth-child(2){--circular-indeterminate:calc(\n    (0.25 * var(--stroke-dasharray)) - var(--stroke-dasharray)\n  );stroke-dasharray:var(--stroke-dasharray), var(--stroke-dasharray);stroke-dashoffset:var(--stroke-dashoffset, var(--circular-indeterminate));stroke:var(--compact-step-inner-color, var(--inner-color))}:host(.inner-label) .ic-loading-circular-inner{display:grid}:host(.inner-label) .ic-loading-circular-svg,.inner-text{grid-column:1;grid-row:1}:host(.not-required.compact-step-progress-indicator) .ic-loading-circular-svg circle:nth-child(2){stroke:var(--ic-architectural-300)}.inner-text{display:flex;align-items:center;justify-content:center;width:var(--ic-space-lg);height:inherit;overflow:hidden;margin:auto;color:var(--compact-step-inner-color, var(--ic-status-info))}:host(.not-required.compact-step-progress-indicator) .inner-text{color:var(--ic-color-tertiary-text)}:host(.light.not-required.compact-step-progress-indicator) .inner-text{color:var(--ic-architectural-400)}@media (forced-colors: active){.indeterminate>.ic-loading-circular-inner{forced-color-adjust:none}.ic-loading-linear-outer{border:var(--ic-hc-border)}.ic-loading-linear-inner{background-color:canvastext}.ic-loading-circular-svg circle{stroke:Background}.ic-loading-circular-svg circle:nth-child(2){stroke:canvastext}:host(.not-required.compact-step-progress-indicator) .ic-loading-circular-svg circle:nth-child(2){stroke:GrayText}}";

const LoadingIndicator = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.updateCircularProgressMeter = () => {
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--progress-value", String(this.progress));
            }
        };
        this.getLabel = (labelIndex, setLabel) => {
            return new Promise(() => {
                this.interval = setInterval(() => {
                    if (labelIndex < this.labelList.length - 1) {
                        labelIndex++;
                    }
                    else {
                        labelIndex = 0;
                    }
                    setLabel(this.labelList[labelIndex]);
                }, this.labelDuration);
            });
        };
        this.getLabelVariant = () => {
            var _a;
            let variant = "h4";
            const width = (_a = this.outerElement) === null || _a === void 0 ? void 0 : _a.offsetWidth;
            if (this.size === "small" || (this.type === "circular" && width < 60)) {
                variant = "label";
            }
            else if (this.size === "large" ||
                (this.type === "circular" && width >= 120)) {
                variant = "h2";
            }
            return variant;
        };
        // Sets the circular indicator line width - accounting for the circle size being altered using the CSS custom property
        this.setCircleLineWidth = () => {
            const { offsetWidth: width } = this.outerElement;
            const compactStepCircularLineWidth = this.el.classList.contains("compact-step-progress-indicator")
                ? 40
                : 0;
            const toastDismissTimerCircularLineWidth = this.el.classList.contains("toast-dismiss-timer")
                ? 20
                : 0;
            if (width ||
                compactStepCircularLineWidth ||
                toastDismissTimerCircularLineWidth) {
                this.circularLineWidth =
                    (compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width) * 0.1;
                this.circularDiameter =
                    compactStepCircularLineWidth ||
                        toastDismissTimerCircularLineWidth ||
                        width;
                this.outerElement.style.setProperty("--circular-line-width", `${this.circularLineWidth}px`);
            }
        };
        this.setLinearDeterminateWidth = () => {
            if (!this.innerElement)
                return;
            // Ensure progress cannot be out of bounds
            const progress = Math.min(this.max, Math.max(this.min, this.progress));
            const proportion = (progress - this.min) / (this.max - this.min);
            this.showSecond = proportion > 0.5;
            if (this.showSecond) {
                this.innerElement.classList.remove("clip");
            }
            else {
                this.innerElement.classList.add("clip");
            }
            this.innerElement.style.setProperty("--linear-width", `${proportion * 100}%`);
        };
        this.calcOuterClass = () => {
            let cls = `ic-loading-${this.type}-outer`;
            cls += this.indeterminate ? " indeterminate" : " determinate";
            return cls;
        };
        this.updateLabel = () => {
            if (isPropDefined(this.label)) {
                this.labelList = this.label.split("/");
                const labelIndex = 0;
                this.indicatorLabel = this.labelList[labelIndex];
                if (this.labelList.length > 1) {
                    this.getLabel(labelIndex, (label) => {
                        this.indicatorLabel = label;
                    });
                }
            }
        };
        this.setCircleXY = () => {
            if (this.circularDiameter > 0) {
                const r = this.circularDiameter / 2;
                const x = r;
                const y = r;
                const nextRadius = r - this.circularLineWidth / 2;
                this.setDashSteps(nextRadius);
                return { x, y, r: nextRadius };
            }
            return { x: 0, y: 0, r: 0 };
        };
        this.setDashSteps = (radius) => {
            const dashArray = 2 * Math.PI * radius;
            const progress = Math.min(Math.max(this.progress, this.min), this.max);
            const proportion = -1 - (progress - this.min) / (this.max - this.min);
            this.circularMeter.style.setProperty("--stroke-dasharray", `${dashArray}px`);
            if (!this.indeterminate) {
                this.circularMeter.style.setProperty("--circular-steps-max", String(this.max));
                this.circularMeter.style.setProperty("--stroke-dashoffset", `${proportion * dashArray}px`);
            }
        };
        this.circularDiameter = undefined;
        this.circularLineWidth = undefined;
        this.indeterminate = undefined;
        this.indicatorLabel = undefined;
        this.showSecond = false;
        this.appearance = "dark";
        this.description = "Loading";
        this.fullWidth = false;
        this.innerLabel = undefined;
        this.labelDuration = 8000;
        this.max = 100;
        this.min = 0;
        this.size = "default";
        this.type = "circular";
        this.label = undefined;
        this.progress = undefined;
    }
    watchPropHandler() {
        this.updateLabel();
    }
    watchProgressHandler() {
        if (this.type === "circular") {
            this.updateCircularProgressMeter();
        }
    }
    disconnectedCallback() {
        clearInterval(this.interval);
    }
    componentWillLoad() {
        this.indeterminate = this.progress === undefined;
        this.updateLabel();
        this.el.setAttribute("exportparts", "ic-loading-container");
    }
    componentDidLoad() {
        if (this.type === "circular") {
            this.setCircleLineWidth();
            this.circularMeter = this.el.shadowRoot.querySelector(".ic-loading-circular-svg circle:nth-child(2)");
            this.updateCircularProgressMeter();
        }
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    componentWillUpdate() {
        this.indeterminate = this.progress === undefined;
    }
    componentDidUpdate() {
        if (Number(this.progress) >= 0 && this.type === "linear") {
            this.setLinearDeterminateWidth();
        }
    }
    render() {
        const { appearance, label, description, size, fullWidth, innerLabel } = this;
        const { x, y, r } = this.setCircleXY();
        return (h(Host, { class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["label"]: !!label,
                ["full-width"]: fullWidth,
                ["inner-label"]: !!innerLabel,
            } }, h("div", { class: "ic-loading-container", part: "ic-loading-container" }, h("div", { ref: (el) => (this.outerElement = el), class: this.calcOuterClass(), role: "progressbar", "aria-labelledby": this.label && this.size !== "icon" && "ic-loading-label", "aria-label": description, "aria-valuenow": this.progress, "aria-valuemin": this.min, "aria-valuemax": this.max }, h("div", { ref: (el) => (this.innerElement = el), class: `ic-loading-${this.type}-inner` }, this.innerLabel &&
            this.innerLabel !== undefined &&
            this.size === "small" && (h("ic-typography", { variant: "subtitle-small", class: "inner-text" }, this.innerLabel)), this.type === "circular" && (h("svg", { class: "ic-loading-circular-svg", viewBox: `0 0 ${this.circularDiameter || 0} ${this.circularDiameter || 0}` }, h("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }), h("circle", { cx: `${x}`, cy: `${y}`, r: `${r}` }))))), label && size !== "icon" && (h("ic-typography", { id: "ic-loading-label", class: "ic-loading-label", role: "status", variant: this.getLabelVariant() }, h("p", null, this.indicatorLabel))))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "label": ["watchPropHandler"],
        "progress": ["watchProgressHandler"]
    }; }
};
LoadingIndicator.style = icLoadingIndicatorCss;

const icTooltipCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host(.ic-tooltip){width:-moz-max-content;width:max-content;height:-moz-max-content;height:max-content}:host(.ic-tooltip) .ic-tooltip-container{background-color:var(--ic-architectural-800);color:#ffff;text-align:center;padding:var(--ic-space-xxxs) var(--ic-space-xs);border-radius:var(--ic-border-radius);border:var(--ic-border-width) solid var(--ic-architectural-40);position:absolute;max-width:20rem;display:none;z-index:var(--ic-z-index-tooltip);box-shadow:var(--ic-elevation-overlay)}:host(.tooltip-navigation-item:not(.tooltip-navigation-item-side-nav-collapsed)) .ic-tooltip-container,:host(.tooltip-disabled) .ic-tooltip-container{display:none !important}:host(.tooltip-long-label-navigation-item-side-nav-expanded) .ic-tooltip-container[data-show]{display:block !important}:host(.ic-tooltip) .ic-tooltip-arrow,:host(.ic-tooltip) .ic-tooltip-arrow::before{position:absolute;background:inherit}:host(.ic-tooltip) .ic-tooltip-arrow{visibility:hidden;width:var(--ic-space-md);height:var(--ic-space-md)}:host(.ic-tooltip) .ic-tooltip-arrow::before{visibility:visible;content:\"\";border:var(--ic-border-width) solid var(--ic-architectural-40);width:100%;height:100%}:host(.ic-tooltip) .ic-tooltip-container[data-show]{display:block}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"top\"]>.ic-tooltip-arrow{height:var(--ic-space-xxxs)}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"top\"]>.ic-tooltip-arrow::before{border-radius:0 0 var(--ic-border-radius) var(--ic-border-radius);left:0;top:var(--ic-space-xxxs);border-top:0;transform:translateX(var(--tooltip-arrow-translate))}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"bottom\"]>.ic-tooltip-arrow{top:calc(-1 * var(--ic-space-xxs));height:var(--ic-space-xxxs)}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"bottom\"]>.ic-tooltip-arrow::before{border-radius:var(--ic-border-radius) var(--ic-border-radius) 0 0;left:0;top:var(--ic-space-1px);border-bottom:0;transform:translateX(var(--tooltip-arrow-translate))}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"left\"]>.ic-tooltip-arrow{width:var(--ic-space-xxxs);right:calc(-1 * var(--ic-space-1px))}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"left\"]>.ic-tooltip-arrow::before{border-radius:0 var(--ic-border-radius) var(--ic-border-radius) 0;border-left:0;top:calc(-1 * var(--ic-space-1px))}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"right\"]>.ic-tooltip-arrow{width:var(--ic-space-xxxs);left:calc(-1 * var(--ic-space-xxs))}:host(.ic-tooltip) .ic-tooltip-container[data-popper-placement^=\"right\"]>.ic-tooltip-arrow::before{border-radius:var(--ic-border-radius) 0 0 var(--ic-border-radius);border-right:0;top:calc(-1 * var(--ic-space-1px))}:host(.on-dialog) .ic-tooltip-container{transform:translate(\n    var(--tooltip-translate-x),\n    var(--tooltip-translate-y)\n  ) !important}@media screen and (max-width: 576px){:host(.ic-tooltip) .ic-tooltip-container{max-width:18.875rem}}@media (forced-colors: active){:host(.ic-tooltip) .ic-tooltip-container,:host(.ic-tooltip) .ic-tooltip-arrow::before{border:var(--ic-hc-border)}}";

const Tooltip = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.delayedHideEvents = ["mouseleave"];
        this.dialogOverflow = false;
        this.instantHideEvents = ["focusout"];
        this.mouseOverTool = false;
        this.persistTooltip = false;
        this.onDialog = false;
        this.showEvents = [
            !this.disableHover && "mouseenter",
            !this.disableHover && "focusin",
            !this.disableClick && "click",
        ];
        this.getTooltipTranslate = (dialogEl) => {
            const child = this.el.children[0].getBoundingClientRect();
            let tooltipX;
            let tooltipY;
            switch (this.placement) {
                case "bottom":
                    tooltipX = child.left - dialogEl.left - 0.5 * child.width;
                    tooltipY = child.bottom - dialogEl.top;
                    break;
                case "bottom-start":
                    tooltipX = child.left - dialogEl.left;
                    tooltipY = child.bottom - dialogEl.top;
                    break;
                case "bottom-end":
                    tooltipX = child.right - dialogEl.right;
                    tooltipY = child.bottom - dialogEl.top;
                    break;
                case "top":
                    tooltipX = child.left - dialogEl.left - 0.5 * child.width;
                    tooltipY = child.top - dialogEl.bottom;
                    break;
                case "top-start":
                    tooltipX = child.left - dialogEl.left;
                    tooltipY = child.top - dialogEl.bottom;
                    break;
                case "top-end":
                    tooltipX = child.right - dialogEl.right;
                    tooltipY = child.top - dialogEl.bottom;
                    break;
                case "left":
                case "left-start":
                    tooltipX = child.right - dialogEl.right - child.width;
                    tooltipY = child.bottom - dialogEl.top - child.height;
                    break;
                case "left-end":
                    tooltipX = child.right - dialogEl.right - child.width;
                    tooltipY = child.top - dialogEl.bottom + child.height;
                    break;
                case "right":
                case "right-start":
                    tooltipX = child.left - dialogEl.left + child.width;
                    tooltipY = child.bottom - dialogEl.top - child.height;
                    break;
                case "right-end":
                    tooltipX = child.left - dialogEl.left + child.width;
                    tooltipY = child.top - dialogEl.bottom + child.height;
                    break;
            }
            if (this.dialogOverflow && tooltipX < 0) {
                if (this.placement.includes("top") || this.placement.includes("bottom")) {
                    this.toolTip.style.setProperty("--tooltip-arrow-translate", `${tooltipX}px`);
                    tooltipX = child.left - dialogEl.left;
                }
                if (this.placement.includes("left")) {
                    this.placement = "right";
                    tooltipX = child.left - dialogEl.left + child.width;
                }
            }
            this.toolTip.style.setProperty("--tooltip-translate-x", `${tooltipX}px`);
            this.toolTip.style.setProperty("--tooltip-translate-y", `${tooltipY}px`);
        };
        this.show = () => {
            if (this.label) {
                this.toolTip.setAttribute("data-show", "");
                if (this.onDialog) {
                    this.el.classList.add("on-dialog");
                    const dialogEl = this.icDialogEl.shadowRoot
                        .querySelector("dialog")
                        .getBoundingClientRect();
                    this.getTooltipTranslate(dialogEl);
                }
                this.popperInstance = createPopper(this.el, this.toolTip, Object.assign({ placement: this.placement, modifiers: [
                        {
                            name: "offset",
                            options: {
                                offset: [0, 10],
                            },
                        },
                        {
                            name: "arrow",
                            options: {
                                element: this.arrow,
                            },
                        },
                        {
                            name: "eventListeners",
                            options: { scroll: false, resize: false },
                        },
                    ] }, this.popperProps));
            }
            else {
                console.warn(`Tooltip can't display without prop 'label' set`);
            }
        };
        this.hide = () => {
            this.toolTip.removeAttribute("data-show");
            this.persistTooltip = false;
            if (this.popperInstance !== undefined) {
                this.popperInstance.destroy();
            }
        };
        this.checkCloseTooltip = () => {
            setTimeout(() => {
                if (!this.mouseOverTool && !this.persistTooltip) {
                    this.hide();
                }
            }, 100);
        };
        this.mouseEnterTooltip = () => {
            this.mouseOverTool = true;
        };
        this.mouseLeaveTooltip = () => {
            this.mouseOverTool = false;
            this.checkCloseTooltip();
        };
        this.handleKeyDown = (event) => {
            if (event.key === "Escape" && !this.persistTooltip) {
                this.hide();
            }
        };
        this.manageEventListeners = (action) => {
            const method = action === "add" ? "addEventListener" : "removeEventListener";
            this.showEvents.forEach((event) => {
                this.el[method](event, this.show);
                if (this.toolTip !== undefined) {
                    this.toolTip[method](event, this.mouseEnterTooltip);
                }
            });
            if (!this.persistTooltip) {
                this.instantHideEvents.forEach((event) => {
                    this.el[method](event, this.hide);
                });
            }
            this.delayedHideEvents.forEach((event) => {
                this.el[method](event, this.checkCloseTooltip);
                if (this.toolTip !== undefined) {
                    this.toolTip[method](event, this.mouseLeaveTooltip);
                }
            });
            document[method]("keydown", this.handleKeyDown);
        };
        this.disableClick = false;
        this.disableHover = false;
        this.maxLines = undefined;
        this.placement = "bottom";
        this.silent = false;
        this.target = undefined;
        this.label = undefined;
        this.popperProps = {};
    }
    /**
     * @internal This method allows props to be added to the PopperJS createPopper instance outside of tooltip
     * @param props object - createPopper props set externally
     */
    async setExternalPopperProps(props) {
        this.popperProps = props;
    }
    disconnectedCallback() {
        this.manageEventListeners("remove");
        if (this.popperInstance !== undefined) {
            this.popperInstance.destroy();
        }
    }
    componentDidLoad() {
        var _a;
        this.manageEventListeners("add");
        this.icDialogEl = this.el.closest("ic-dialog");
        this.dialogOverflow =
            ((_a = this.icDialogEl) === null || _a === void 0 ? void 0 : _a.getAttribute("data-overflow")) === "true";
        this.onDialog = this.icDialogEl !== null;
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Tooltip");
    }
    componentDidRender() {
        const typographyEl = this.el.shadowRoot.querySelector(".ic-tooltip-container > ic-typography");
        this.maxLines > 0 &&
            typographyEl.setAttribute("style", `--truncation-max-lines: ${this.maxLines}`);
    }
    /**
     * Method to programmatically show/hide the tooltip without needing to interact with an anchor element
     * @param show Whether to show or hide the tooltip
     * @param persistTooltip Whether the tooltip should stay on the screen when actions are performed that would previously dismiss the tooltip, such as on hover
     */
    async displayTooltip(show, persistTooltip) {
        this.persistTooltip = persistTooltip;
        show ? this.show() : this.hide();
    }
    /**
     * @internal Method to return if tooltip is currently visible.
     */
    async isTooltipVisible() {
        return Promise.resolve(this.toolTip.hasAttribute("data-show"));
    }
    render() {
        const { label, maxLines, silent } = this;
        return (h(Host, { class: { "ic-tooltip": true } }, h("div", { ref: (el) => (this.toolTip = el), role: "tooltip", class: "ic-tooltip-container", "aria-hidden": `${silent}` }, h("ic-typography", { maxLines: maxLines, variant: "caption" }, label), h("div", { ref: (el) => (this.arrow = el), class: "ic-tooltip-arrow" })), h("slot", null)));
    }
    get el() { return getElement(this); }
};
Tooltip.style = icTooltipCss;

export { Button as ic_button, LoadingIndicator as ic_loading_indicator, Tooltip as ic_tooltip };

//# sourceMappingURL=ic-button_3.entry.js.map