import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { k as removeDisabledFalse, a as onComponentRequiredPropUndefined, s as getInputDescribedByText, t as hasValidationStatus } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const icCheckboxGroupCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block}ic-input-label.error{color:var(--ic-status-error)}ic-input-label ic-typography{margin-bottom:var(--ic-space-sm)}:host(.small) ic-input-label ic-typography{margin-bottom:calc(var(--ic-space-sm) / 2)}ic-input-validation{margin-top:var(--ic-space-sm)}:host(.small) ic-input-validation{margin-top:calc(var(--ic-space-sm) / 2)}.checkboxes-container{margin-bottom:calc(-1 * var(--ic-space-xxs))}:host(.small) .checkboxes-container{margin-bottom:calc(-1 * var(--ic-space-xxxs))}.screen-reader-only-text{position:absolute;left:-9999px;background-color:#fff;color:#000;text-transform:none}";

const CheckboxGroup = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icChange = createEvent(this, "icChange", 7);
        this.disabled = false;
        this.helperText = "";
        this.hideLabel = false;
        this.label = undefined;
        this.name = undefined;
        this.required = false;
        this.size = "default";
        this.small = false;
        this.validationStatus = "";
        this.validationText = "";
    }
    labelNameHandler(newValue, oldValue, propName) {
        Array.from(this.el.querySelectorAll("ic-checkbox")).forEach((checkbox) => {
            if (propName === "label")
                checkbox.groupLabel = newValue;
            else if (checkbox.name === oldValue) {
                // If the checkbox name has been set by the parent, then override it
                checkbox.name = newValue;
            }
        });
    }
    handleChange(ev) {
        //don't pass on the event if it has come from slotted text field
        //otherwise any icChange handler bound to the checkbox group will also run
        if (ev.target.tagName === "IC-TEXT-FIELD") {
            ev.stopImmediatePropagation();
        }
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.name, propName: "name" },
        ], "Checkbox Group");
    }
    selectHandler({ target }) {
        const checkedOptions = Array.from(this.el.querySelectorAll("ic-checkbox")).filter(({ checked, disabled }) => checked && !disabled);
        this.icChange.emit({
            value: checkedOptions.map(({ value }) => value),
            checkedOptions: checkedOptions.map((opt) => {
                var _a;
                return ({
                    checkbox: opt,
                    textFieldValue: (_a = opt.querySelector("ic-text-field")) === null || _a === void 0 ? void 0 : _a.value,
                });
            }),
            selectedOption: target,
        });
    }
    render() {
        const { disabled, helperText, hideLabel, label, name, required, size, small, validationStatus, validationText, } = this;
        const describedBy = getInputDescribedByText(name, helperText !== "", validationStatus !== "");
        return (h(Host, { class: { ["small"]: small, [`${size}`]: true } }, (validationStatus === "error" || required || hideLabel) && (h("span", { id: "screenReaderOnlyText", class: "screen-reader-only-text", "aria-hidden": "true" }, label, " ", validationStatus === "error" ? "invalid data " : null, " ", required ? "required" : null)), h("fieldset", { id: name, "aria-labelledby": `${validationStatus === "error" || required || hideLabel
                ? "screenReaderOnlyText"
                : ""} ${describedBy}`.trim(), disabled: disabled }, !hideLabel && (h("legend", null, h("ic-input-label", { class: { [`${validationStatus}`]: true }, label: label, helperText: helperText, required: required, disabled: disabled, for: name }))), h("div", { class: "checkboxes-container" }, h("slot", null))), hasValidationStatus(validationStatus, disabled) && (h("ic-input-validation", { for: name, ariaLiveMode: "polite", status: validationStatus, message: validationText }))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "label": ["labelNameHandler"],
        "name": ["labelNameHandler"]
    }; }
};
CheckboxGroup.style = icCheckboxGroupCss;

export { CheckboxGroup as ic_checkbox_group };

//# sourceMappingURL=ic-checkbox-group.entry.js.map