import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { k as removeDisabledFalse, m as addFormResetListener, a as onComponentRequiredPropUndefined, n as removeFormResetListener, d as isPropDefined, p as renderHiddenInput, q as removeHiddenInput, i as isSlotUsed } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const icCheckboxCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host(.disabled){color:var(--ic-architectural-200);pointer-events:none}.container{display:flex;width:-moz-fit-content;width:fit-content;padding:var(--ic-space-xxs) 0 var(--ic-space-xxs) var(--ic-space-xxs);margin-bottom:var(--ic-space-xxs);align-items:center}:host(.small) .container{margin-bottom:var(--ic-space-xxxs)}.checkbox{-webkit-appearance:none;-moz-appearance:none;appearance:none;display:block;position:relative;top:0;left:0;height:var(--ic-space-lg);width:var(--ic-space-lg);background-color:var(--ic-architectural-white);border:var(--ic-border-width) solid var(--ic-architectural-400);border-radius:var(--ic-border-radius);outline:none;cursor:pointer;transition:var(--ic-easing-transition-fast);flex-shrink:0}:host(.small) .checkbox,:host(.small) .container svg{width:var(--ic-space-md);height:var(--ic-space-md)}:host(.large) .checkbox,:host(.large) .container svg{width:var(--ic-space-xl);height:var(--ic-space-xl)}.checkbox:checked{background-color:var(--ic-action-default);border:var(--ic-border-width) solid var(--ic-action-default);transition:var(--ic-easing-transition-slow)}.checkbox:checked:disabled{background-color:var(--ic-architectural-200)}.checkbox:indeterminate,.checkbox.indeterminate:checked{background-color:var(--ic-architectural-white);border:0.125rem solid var(--ic-action-default)}.checkbox:checked:hover{background-color:var(--ic-action-default-hover)}.checkbox:indeterminate:hover,.checkbox.indeterminate:checked:hover{background-color:var(--ic-action-default-bg-hover-no-alpha);border:0.125rem solid var(--ic-action-default-hover)}.checkbox:checked:active{background-color:var(--ic-action-default-active)}.checkbox:indeterminate:active,.checkbox.indeterminate:checked:active{background-color:var(--ic-action-default-bg-active-no-alpha);border:0.125rem solid var(--ic-action-default-active)}.checkbox:hover{background-color:var(--ic-action-default-bg-hover-no-alpha);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-hover);border:var(--ic-border-width) solid var(--ic-action-default-hover)}.checkbox:active{background-color:var(--ic-action-default-bg-active-no-alpha);box-shadow:0 0 0 0.25rem var(--ic-action-default-bg-active);border:var(--ic-border-width) solid var(--ic-action-default-active)}.checkbox:focus{box-shadow:var(--ic-border-focus)}.checkbox:disabled{border:var(--ic-border-width) dashed var(--ic-architectural-200)}.checkbox-label{padding-left:var(--ic-space-sm)}.checkbox-label:hover{cursor:pointer}.checkmark{position:relative;right:calc(-1 * var(--ic-space-lg));margin-left:calc(-1 * var(--ic-space-lg));fill:white;z-index:1;background-color:transparent;pointer-events:none;flex-shrink:0}:host(.small) .checkmark{margin-left:calc(-1 * var(--ic-space-md));right:calc(-1 * var(--ic-space-md))}:host(.large) .checkmark{margin-left:calc(-1 * var(--ic-space-xl));right:calc(-1 * var(--ic-space-xl))}.indeterminate-symbol{position:relative;width:0.875rem;height:var(--ic-space-xxxs);right:-1.188rem;margin-left:-0.875rem;z-index:1;background-color:var(--ic-action-default);pointer-events:none;flex-shrink:0}:host(.small) .indeterminate-symbol{width:0.6rem;right:-0.8rem;margin-left:-0.6rem}:host(.large) .indeterminate-symbol{width:1.25rem;right:-1.625rem;margin-left:-1.25rem}.container:hover .indeterminate-symbol{background-color:var(--ic-action-default-hover)}.container:active .indeterminate-symbol{background-color:var(--ic-action-default-active)}.additional-field-wrapper{margin-left:calc(var(--ic-space-md) + var(--ic-space-lg));margin-top:calc(var(--ic-space-sm) / 2)}.branch-corner{color:var(--ic-action-default);height:var(--ic-space-md);width:var(--ic-space-xl);border-radius:0 0 0 0.188rem;border-bottom:0.125rem solid var(--ic-action-default);border-left:0.125rem solid var(--ic-action-default)}.dynamic-container{display:flex;position:relative;margin:var(--ic-space-xxxs) 0 var(--ic-space-xxs) var(--ic-space-md);gap:var(--ic-space-xs)}.dynamic-text{color:var(--ic-action-default);margin-top:calc(var(--ic-space-sm) / 2);margin-bottom:var(--ic-space-xs);border-radius:2%}@media (max-width: 576px){::slotted(ic-text-field){--input-width:100%}}@media (forced-colors: active){.checkbox{-webkit-appearance:revert;-moz-appearance:revert;appearance:revert;transition:none}.checkbox:checked{transition:none}.checkbox:focus-visible{outline:0.125rem solid highlight}.checkbox:disabled:not(:checked){-webkit-appearance:none;-moz-appearance:none;appearance:none;border-color:GrayText}.checkmark{fill:none}.indeterminate-symbol{display:none}}";

const Checkbox = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.checkboxChecked = createEvent(this, "checkboxChecked", 7);
        this.icCheck = createEvent(this, "icCheck", 7);
        this.handleClick = () => {
            this.checked = !this.checked;
            this.displayIndeterminate = this.nativeIndeterminateBehaviour
                ? false
                : this.indeterminate && this.checked;
            this.icCheck.emit();
            this.checkboxChecked.emit();
        };
        this.handleFormReset = () => {
            this.checked = this.initiallyChecked;
        };
        this.additionalFieldDisplay = "static";
        this.checked = false;
        this.initiallyChecked = this.checked;
        this.disabled = false;
        this.dynamicText = "This selection requires additional answers";
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.groupLabel = undefined;
        this.indeterminate = false;
        this.displayIndeterminate = this.indeterminate;
        this.label = undefined;
        this.name = undefined;
        this.nativeIndeterminateBehaviour = false;
        this.size = undefined;
        this.small = false;
        this.value = undefined;
        this.hideLabel = false;
    }
    watchIndeterminateHandler() {
        this.displayIndeterminate = this.nativeIndeterminateBehaviour
            ? this.indeterminate
            : this.indeterminate && this.checked;
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        addFormResetListener(this.el, this.handleFormReset);
        const checkboxGroup = this.el.parentElement;
        if (checkboxGroup) {
            if (!this.name)
                this.name = checkboxGroup.name;
            this.groupLabel = checkboxGroup.label;
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.value, propName: "value" },
        ], "Checkbox");
    }
    componentDidRender() {
        if (this.additionalFieldDisplay === "static") {
            const textfield = this.el.querySelector("ic-text-field");
            if (!this.checked) {
                textfield === null || textfield === void 0 ? void 0 : textfield.setAttribute("disabled", "");
            }
            else {
                textfield === null || textfield === void 0 ? void 0 : textfield.removeAttribute("disabled");
            }
        }
        else if (this.additionalFieldContainer) {
            this.additionalFieldContainer.style.display = !this.checked
                ? "none"
                : "flex";
        }
    }
    disconnectedCallback() {
        removeFormResetListener(this.el, this.handleFormReset);
    }
    /**
     * Sets focus on the checkbox.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector(".checkbox")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    render() {
        const { additionalFieldDisplay, checked, disabled, dynamicText, el, form, formaction, formenctype, formmethod, formnovalidate, formtarget, displayIndeterminate, groupLabel, label, name, size, small, value, } = this;
        const id = `ic-checkbox-${isPropDefined(label) || value}-${groupLabel}`.replace(/ /g, "-");
        const parentElementSize = el.parentElement
            .size;
        checked
            ? renderHiddenInput(true, el, name, checked && value, disabled)
            : removeHiddenInput(el);
        return (h(Host, { class: {
                disabled,
                small,
                [`${size || parentElementSize}`]: true,
            } }, h("div", { class: "container" }, displayIndeterminate && h("div", { class: "indeterminate-symbol" }), !displayIndeterminate && checked && (h("svg", { class: "checkmark", width: "1.5rem", height: "1.5rem", viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg", "fill-rule": "evenodd", "clip-rule": "evenodd" }, h("title", null, "checkmark icon"), h("path", { d: "M21 6.285l-11.16 12.733-6.84-6.018 1.319-1.49 5.341 4.686 9.865-11.196 1.475 1.285z" }))), h("input", { role: "checkbox", class: {
                checkbox: true,
                checked,
                indeterminate: displayIndeterminate,
            }, type: "checkbox", name: name, id: id, value: value, disabled: disabled ? true : null, checked: checked, indeterminate: displayIndeterminate, onClick: this.handleClick, form: form, formaction: formaction, formenctype: formenctype, formmethod: formmethod, formnovalidate: formnovalidate, formtarget: formtarget, "aria-label": this.hideLabel ? this.label : undefined }), !this.hideLabel && (h("ic-typography", { class: "checkbox-label", variant: "body" }, h("label", { htmlFor: id }, label)))), isSlotUsed(el, "additional-field") && (h("div", { class: "dynamic-container", ref: (el) => (this.additionalFieldContainer = el) }, additionalFieldDisplay === "dynamic" && (h("div", { class: "branch-corner" })), h("div", null, additionalFieldDisplay === "dynamic" && (h("ic-typography", { variant: "caption" }, h("p", { class: "dynamic-text", "aria-live": "polite" }, dynamicText))), h("div", { class: {
                "additional-field-wrapper": additionalFieldDisplay === "static",
            } }, h("slot", { name: "additional-field" })))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "indeterminate": ["watchIndeterminateHandler"]
    }; }
};
Checkbox.style = icCheckboxCss;

export { Checkbox as ic_checkbox };

//# sourceMappingURL=ic-checkbox.entry.js.map