import { r as registerInstance, h, H as Host } from './index-d1d2c456.js';
import { b as getThemeForegroundColor } from './helpers-3905ccc4.js';
import { I as IcThemeForegroundEnum } from './types-6f6b41a5.js';

const icDividerCss = "hr.sc-ic-divider{padding:0;margin:0;border:none;height:var(--ic-space-1px);background-color:var(--ic-keyline-darken-rgb)}hr.light.sc-ic-divider{background-color:var(--ic-keyline-lighten-rgb)}";

const Divider = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.foregroundColor = getThemeForegroundColor();
    }
    themeChangeHandler(ev) {
        const theme = ev.detail;
        this.foregroundColor = theme.mode;
    }
    render() {
        return (h(Host, { "aria-hidden": "true" }, h("hr", { class: {
                ["light"]: this.foregroundColor === IcThemeForegroundEnum.Light,
            } })));
    }
};
Divider.style = icDividerCss;

export { Divider as ic_divider };

//# sourceMappingURL=ic-divider.entry.js.map